procedure WSWD (z:byte);
   label next;

   begin
   next:
      case z of

           $06      : (* Phantom-Leerschritt *)
                      (* wird nicht als Leerzeichen eingefgt *)
                      NeuZeil:=false;

           $0D      : (* es folgt neue Zeile, hart formatiert *)
                      begin
                        NeuZeil:=true;
                        Get (z); (* LF berspringen *)

                        (* nchstes Zeichen prfen *)
                        Get (z);
                        if (z=$0D) or (z=$8D) (* noch einmal CR-LF *)
                          then begin (* 2 x CR-LF *)
                             Get (z); (* LF holen *)
                             (* Absatz einfgen *)
                             Put ($0D); Put($0A) end
                          else begin (* nur ein einziges CR-LF *)
                             Put ($0B); (* Neue Zeile in WORD *)
                             Goto next
                          end
                      end;

           $8D      : (* weich formatiert *)
                      (* daher wird CR-LF entfernt *)
                      begin
                        NeuZeil:=true;
                        Get (z); (* berspringe LF *)
                        if not (z=$0A) or (z=$8A) then goto next
                      end;

           $1A      : (* Dateiende *)
                      begin
                        Put (z);
                        exit
                      end;

                      (* Einleitungszeichen fr Sondezeichen *)
           $1B ,      (* es folgt ein Zeichen <32 oder >127  *)
           $9B      : (* es folgt ein Zeichen <32 oder >127
                         am Ende eines Wortes *)
                 begin
                   NeuZeil:=false;
                   Get (z); (* hole eigentliches Zeichen *)
                   case z of
                     $00..$1A : ;
                     $1B      : (* Steuerzeichen folgt *)
                                 begin
                                   (* Eliminiere die folgenden Zeichen *)
                                   (* im Mittel 2 *)
                                   Get (z); Get (z)
                                 end;
                     $1C..$1F : ;
                     $20..$2D : Put (z);
                     $2E      : (* Eliminiere Punktkommandos *)
                                if NeuZeil then GetZeilW else Put (z);
                     $2F..$7E : Put (z);
                     $80..$FE : Put (z);
                   end;
                   Get (z); (* Eliminiert das folgende Steuerzeichen
                               $1C oder $9C *)
                 end;

           $1C      : (* normalerweise kommt das Programm hier nicht an,
                         da diese Zeichen bei $1B eliminiert wird *)
                      Fehler ('$1C');

           $1F      : (* Trennstelle wird eliminiert *)
                      NeuZeil:=false;

           $A0      : (* Fll-Leerzeichen *)
                      NeuZeil:=false;

           $20..$2D : begin (* gewhlicher Text *)
                        NeuZeil:=false;
                        Put (z)
                      end;

           $2D      : (* Bindestrich *)
                      (* entfernen wenn letztes Zeichen der Zeile *)
                      begin
                        Get (z);
                        if (z=$0D) or (z=$8D)
                           then goto next
                           else begin Put ($2D); Put (z) end
                      end;

           $2E      : (* Eliminiere Punktkommandos *)
                      if NeuZeil
                         then GetZeilW (* Zeile entfernen *)
                         else begin
                           NeuZeil:=false;
                           Put (z)
                         end;

           $2F..$7E : begin (* gewhnlicher Text *)
                        NeuZeil:=false;
                        Put (z)
                      end;

           $A1..$FF : (* Zeichen am Ende eines Wortes im Blocksatz *)
                      begin
                        NeuZeil:=false;
                        Put (z-128)
                      end;
      end (* case *)
   end; (* WSWD *)
