       IDENTIFICATION DIVISION.
       PROGRAM-ID.         KAVERW.
       AUTHOR.             KAINC_NORBERT.
       DATE-WRITTEN.       AUGUST_1987.
      *
      *    PROGRAMM ZUR VERWALTUNG DER DISKETTEN
      *    MIT LISTENDRUCK UND DRUCK VON
      *    KASSETTENRCKEN.
      *    COMPILER:  PROFESSIONAL COBOL
      *    DATEIORGANISATION : INDEXSEQUENTIELL
      *
       ENVIRONMENT DIVISION.
      *
       CONFIGURATION SECTION.
       SOURCE-COMPUTER.    PC-XT.
       OBJECT-COMPUTER.    PC-XT.
      *
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT KASSETTE ASSIGN TO "B:KASSETTE.DAT"
                  ORGANIZATION INDEXED
                  ACCESS MODE RANDOM
                  RECORD KEY IS KA-NR.
           SELECT DRUCK ASSIGN TO "PRN".
      *
      *
       DATA DIVISION.
      *
       FILE SECTION.
      *
       FD  KASSETTE LABEL RECORD STANDARD.
       01  KA-SATZ.
           05  KA-NR       PIC 999.
           05  TITEL       PIC X(30).
           05  SEITE-A     PIC X(31).
           05  SEITE-B     PIC X(31).
           05  STIL        PIC X.
           05  LENGE       PIC XX.
      *
       FD  DRUCK,
                           LINAGE IS 55 LINES,
                           WITH  FOOTING  55,
                           LINES AT TOP 7,
                           LINES AT BOTTOM 10.

       01  DRUCKZEILE      PIC X(130).
      /
       WORKING-STORAGE SECTION.
       77  JANO            PIC X.
       77  CHECK           PIC X.
      *     DRUCKERSTEUERZEICHEN FR DIE LISTE UND
      *     DIE KASSETTENRCKEN IN HEX-CODIERUNG
      *     ANPASSUNG FALLS ERFORDERLICH IN DEN FOLGENDEN
      *     ZEILEN MGLICH
       01  DOPPEL          PIC XX  VALUE X"1B47".
       01  SCH-E           PIC X   VALUE X"0F".
       01  SCH-A           PIC X   VALUE X"12".
       01  BRT-E           PIC X   VALUE X"0E".
       01  BRT-A           PIC X   VALUE X"14".
       01  H-E             PIC XXX VALUE X"1B5330".
       01  H-A             PIC XX  VALUE X"1B54".
       01  T-E             PIC XXX VALUE X"1B5331".
       01  ZAB1            PIC XXX VALUE X"1B3305".
       01  ZAB2            PIC XXX VALUE X"1B330A".
      *
       01  DRZSTZ.
           05 STZ          PIC XXX.
       01  DRZ1.
           05  LEER1       PIC X(38) VALUE SPACES.
           05  DSA         PIC X(31).
       01  DRZ2.
           05  STZ1        PIC X.
           05  DNR         PIC ZZ9.
           05  LEER3       PIC X VALUE " ".
           05  STZ2        PIC X.
           05  STZ3        PIC X.
           05  DTIT        PIC X(30).
       01  DRZ3.
           05  LEER2       PIC X(38) VALUE SPACES.
           05  DSB         PIC X(31).
       01  DRZTIT.
           05  LL0         PIC X(8) VALUE SPACES.
           05  DTNR        PIC ZZ9.
           05  LL1         PIC XX   VALUE SPACES.
           05  DTTIT       PIC X(30).
           05  LL2         PIC XX  VALUE SPACES.
           05  DTSA        PIC X(31).
           05  LL3         PIC XX  VALUE SPACES.
           05  DTSB        PIC X(31).
           05  LL4         PIC XX VALUE SPACES.
           05  DTST        PIC X.
           05  LL5         PIC XX VALUE SPACES.
           05  DTLEN       PIC XX.
      /
      *
       01  DRZUEB.
           05  LL00        PIC X(8) VALUE SPACES.
           05  DTNR0       PIC XXX  VALUE "Nr.".
           05  LL10        PIC XX   VALUE SPACES.
           05  DTTIT0      PIC X(30) VALUE "Titel".
           05  LL20        PIC XX  VALUE SPACES.
           05  DTSA0       PIC X(31) VALUE "Seite A".
           05  LL30        PIC XX  VALUE SPACES.
           05  DTSB0       PIC X(31) VALUE "Seite B".
           05  LL40        PIC XX VALUE SPACES.
           05  DTST0       PIC XX VALUE "St".
           05  LL50        PIC X  VALUE SPACES.
           05  DTLEN0      PIC XX VALUE "ln".
      *
       01  MASK1.
           05  FILLER      PIC X(20).
           05  UEB         PIC X(20) VALUE "KASSETTENVERWALTUNG".
           05  UEBVAR      PIC X(40) VALUE SPACES.
           05  FILLER      PIC X(80).
           05  NR          PIC XXX VALUE "NR.".
           05  FILLER      PIC XX.
           05  TIT         PIC X(5) VALUE "TITEL".
           05  FILLER      PIC X(230).
           05  SA          PIC X(7) VALUE "SEITE A".
           05  FILLER      PIC X(33).
           05  SB          PIC X(7) VALUE "SEITE B".
           05  FILLER      PIC X(193).
           05  ST          PIC XXXX VALUE "STIL".
           05  FILLER      PIC X(6).
           05  LEN         PIC X(5) VALUE "LNGE".
      *
       01  EING.
           05  ENR         PIC ZZZ.
           05  EIN-AEND.
               10  FILLER  PIC XX.
               10  ETITEL  PIC X(30).
               10  FILLER  PIC X(205).
               10  ESEITEA PIC X(31).
               10  FILLER  PIC X(9).
               10  ESEITEB PIC X(31).
               10  FILLER  PIC X(169).
               10  ESTIL   PIC X.
               10  FILLER  PIC X(9).
               10  ELEN    PIC XX.
      *
       01  LEER            PIC X(80) VALUE SPACES.
       01  NR-A            PIC 999 BLANK WHEN ZERO.
       01  NR-E            PIC 999 BLANK WHEN ZERO.
       01  NR-ZAL          PIC 999.
      *
      /
       PROCEDURE DIVISION.
      *
      *
       MENUE.
           DISPLAY SPACES UPON CRT.
           DISPLAY "KASSETTENVERWALTUNG" AT 0130.
           DISPLAY "===================" AT 0230.
           DISPLAY "DATEN NEUERFASSEN ..... 1" AT 0428.
           DISPLAY "DATEN NDERN .......... 2" AT 0628.
           DISPLAY "DATEN LSCHEN ......... 3" AT 0828.
           DISPLAY "LISTE DRUCKEN ......... 4" AT 1128.
           DISPLAY "KASSETTENRCKEN ....... 5" AT 1328.
           DISPLAY "ENDE .................. 9" AT 1628.
           DISPLAY "IHRE WAHL" AT 2428.
           MOVE " " TO JANO.
           ACCEPT JANO AT 2452.
       AUSWAHL.
           IF JANO = "1" PERFORM NEU THROUGH NEU-EX.
           IF JANO = "2" PERFORM AEND THROUGH AEND-EX.
           IF JANO = "3" PERFORM LOSCH THROUGH LOSCH-EX.
           IF JANO = "4" PERFORM LISTE THROUGH LISTE-EX.
           IF JANO = "5" PERFORM KARUCK THROUGH KARUCK-EX.
           IF JANO = "9" PERFORM ENDE THROUGH ENDE-EX.
           GO TO MENUE.
      *
      *
       NEU.
           OPEN I-O KASSETTE.
       WEITERNEU.
           DISPLAY SPACES UPON CRT.
           MOVE "DATEN NEU    " TO UEBVAR.
           DISPLAY MASK1 AT 0101.
           MOVE SPACES TO EING.
           MOVE 0 TO ENR.
           ACCEPT EING AT 0401.
           PERFORM WRZUW.
           IF ENR = 999 GO TO NEU-EX.
           MOVE " " TO JANO.
           WRITE KA-SATZ INVALID KEY DISPLAY
                 "SATZ SCHON VORHANDEN" AT 2401,
                 ACCEPT JANO AT 2440,
                 DISPLAY LEER AT 2401,
                 GO TO WEITERNEU.
           GO TO WEITERNEU.
       NEU-EX.
           CLOSE KASSETTE.
           EXIT.
      *
      /
      *
       AEND.
           OPEN I-O KASSETTE.
       AENDWEITER.
           DISPLAY SPACES UPON CRT.
           MOVE "DATEN NDERN" TO UEBVAR.
           DISPLAY MASK1 AT 0101.
           MOVE SPACES TO EING.
           MOVE 0 TO ENR.
           ACCEPT ENR AT 0401.
           IF ENR = 999 GO TO AEND-EX.
           MOVE ENR TO KA-NR.
           MOVE " " TO JANO.
           READ KASSETTE INTO KA-SATZ INVALID KEY DISPLAY

                "SATZ NICHT GEFUNDEN" AT 2401,
                ACCEPT JANO AT 2440,
                DISPLAY LEER AT 2401,
                GO TO AENDWEITER.
           PERFORM LESZUW.
           DISPLAY EING AT 0401.
           ACCEPT EIN-AEND AT 0404.
           PERFORM WRZUW.
           MOVE " " TO JANO.
           REWRITE KA-SATZ INVALID KEY DISPLAY
                "NDERUNG NICHT MGLICH" AT 2401,
                ACCEPT JANO AT 2440,
                DISPLAY LEER AT 2401,
                GO TO AENDWEITER.
           GO TO AENDWEITER.
       AEND-EX.
           CLOSE KASSETTE.
           EXIT.
      /
      *
       LOSCH.
           OPEN I-O KASSETTE.
       LOSCHWEITER.
           DISPLAY SPACES UPON CRT.
           MOVE "DATEN LSCHEN" TO UEBVAR.
           DISPLAY MASK1 AT 0101.
           MOVE SPACES TO EING.
           MOVE 0 TO ENR.
           ACCEPT ENR AT 0401.
           IF ENR = 999 GO TO LOSCH-EX.
           MOVE ENR TO KA-NR.
           MOVE " " TO JANO.
           READ KASSETTE INTO KA-SATZ INVALID KEY DISPLAY
                "SATZ NICHT GEFUNDEN" AT 2401,
                ACCEPT JANO AT 2440,
                DISPLAY LEER AT 2401,
                GO TO LOSCHWEITER.
           PERFORM LESZUW.
           DISPLAY EING AT 0401.
           DISPLAY "SATZ WIRKLICH LSCHEN" AT 2401.
           MOVE " " TO JANO.
           ACCEPT JANO AT 2440.
           IF JANO NOT EQUAL "J" GO TO LOSCHWEITER.
           MOVE " " TO JANO.
           DELETE KASSETTE INVALID KEY DISPLAY
                "LSCHEN NICHT MGLICH" AT 2401,
                ACCEPT JANO AT 2440,
                DISPLAY LEER AT 2401,
                GO TO LOSCHWEITER.
           GO TO LOSCHWEITER.
       LOSCH-EX.
           CLOSE KASSETTE.
           EXIT.
      /
      *
      *        DRUCK SECTION.
      *
       LISTE.
           OPEN OUTPUT DRUCK.
           OPEN I-O KASSETTE.
           MOVE SCH-E TO STZ.
           WRITE DRUCKZEILE FROM DRZSTZ.
           MOVE SPACES TO DRUCKZEILE.
       LIST-MENUE.
           DISPLAY SPACES UPON CRT.
           DISPLAY "LISTENAUSDRUCK DER KASSETTEN" AT 0425.
           DISPLAY "============================" AT 0525.
           DISPLAY "VON NUMMER"  AT 0825.
           DISPLAY "BIS NUMMER"  AT 0925.
           MOVE 0 TO NR-A.
           MOVE 0 TO NR-E.
           ACCEPT NR-A AT 0840.
           ACCEPT NR-E AT 0940.
           IF NR-A = 999 GO TO LISTE-EX.
           MOVE NR-A TO NR-ZAL.
           DISPLAY "ALLES OK J/N" AT 2425.
           MOVE "J" TO JANO.
           ACCEPT JANO AT 2440.
           IF JANO NOT EQUAL "J" GO TO LIST-MENUE.
       LIST-UEBER.
           MOVE SPACES TO DRUCKZEILE.
           WRITE DRUCKZEILE BEFORE PAGE.
           MOVE "        K A S S E T T E N V E R W A L T U N G" TO
                 DRUCKZEILE.
           WRITE DRUCKZEILE BEFORE ADVANCING 2 LINES.
           WRITE DRUCKZEILE FROM DRZUEB BEFORE ADVANCING 1 LINE.
       LIST-LESEN.
           IF NR-ZAL > NR-E GO TO LISTE-EX.
           MOVE NR-ZAL TO KA-NR.
           MOVE " " TO JANO.
           READ KASSETTE INVALID KEY DISPLAY
                "SATZ NICHT GEFUNDEN" AT 2401,
                ACCEPT JANO AT 2440,
                DISPLAY LEER AT 2401,
                GO TO LIST-MENUE.
           MOVE KA-NR TO DTNR.
           MOVE TITEL TO DTTIT.
           MOVE SEITE-A TO DTSA.
           MOVE SEITE-B TO DTSB.
           MOVE STIL TO DTST.
           MOVE LENGE TO DTLEN.
           WRITE DRUCKZEILE FROM DRZTIT AT END-OF-PAGE
                ADD 1 TO NR-ZAL GO TO LIST-UEBER.
           ADD 1 TO NR-ZAL.
           GO TO LIST-LESEN.
       LISTE-EX.
           MOVE SCH-A TO DRZSTZ.
           WRITE DRUCKZEILE FROM DRZSTZ.
           MOVE SPACES TO DRUCKZEILE.
           CLOSE DRUCK.
           CLOSE KASSETTE.
           EXIT.
      *
      /
       KARUCK.
           DISPLAY SPACES UPON CRT.
           OPEN OUTPUT DRUCK.
           OPEN I-O KASSETTE.
       KARUCK-MENUE.
           DISPLAY SPACES UPON CRT.
           DISPLAY "AUSDRUCK VON KASSETTENRCKEN" AT 0125.
           DISPLAY "============================" AT 0225.
           DISPLAY "AUSDRUCK WELCHER NUMMER" AT 0625.
           MOVE 0 TO NR-A.
           ACCEPT NR-A AT 0652.
           IF NR-A = 999 GO TO KARUCK-EX.
           MOVE NR-A TO KA-NR.
           MOVE " " TO JANO.
           READ KASSETTE INTO KA-SATZ INVALID KEY DISPLAY
                "SATZ NICHT VORHANDEN" AT 2401,
                ACCEPT JANO AT 2450,
                DISPLAY LEER AT 2401,
                GO TO KARUCK-MENUE.
           MOVE KA-NR TO DNR.
           MOVE TITEL TO DTIT.
           MOVE SEITE-A TO DSA.
           MOVE SEITE-B TO DSB.
           MOVE SPACES TO STZ.
           MOVE DOPPEL TO STZ.
           WRITE DRUCKZEILE FROM DRZSTZ.
           MOVE SPACES TO STZ.
           MOVE H-E TO STZ.
           WRITE DRUCKZEILE FROM DRZSTZ.
           MOVE SPACES TO STZ.
           MOVE SCH-E TO STZ.
           WRITE DRUCKZEILE FROM DRZSTZ.
           MOVE SPACES TO STZ.
           MOVE ZAB1 TO STZ.
           WRITE DRUCKZEILE FROM DRZSTZ.
           MOVE SPACES TO STZ.
           WRITE DRUCKZEILE FROM DRZ1 AFTER ADVANCING 2 LINES.
           MOVE H-A TO STZ.
           WRITE DRUCKZEILE FROM DRZSTZ.
           MOVE SPACES TO STZ.
           MOVE SCH-A TO STZ.
           WRITE DRUCKZEILE FROM DRZSTZ.
           MOVE SPACES TO STZ.
           MOVE ZAB2 TO STZ.
           WRITE DRUCKZEILE FROM DRZSTZ.
           MOVE BRT-E TO STZ1.
           MOVE BRT-A TO STZ2.
           MOVE SCH-E TO STZ3.
           WRITE DRUCKZEILE FROM DRZ2 AFTER ADVANCING 1 LINE.
           MOVE T-E TO STZ.
           WRITE DRUCKZEILE FROM DRZSTZ.
           WRITE DRUCKZEILE FROM DRZ3 AFTER ADVANCING 1 LINE.
           GO TO KARUCK-MENUE.
       KARUCK-EX.
           MOVE SPACES TO STZ.
           MOVE X"1B40" TO STZ.
           WRITE DRUCKZEILE FROM DRZSTZ.
           CLOSE DRUCK.
           CLOSE KASSETTE.
           EXIT.
      /
      *
       ENDE.
           DISPLAY SPACES UPON CRT.
           DISPLAY "ENDE PROGRAMM KASSETTENVERWALTUNG" AT 0101.
       ENDE-EX.
           STOP RUN.
      *
       WRZUW.
           MOVE ENR TO KA-NR.
           MOVE ETITEL TO TITEL.
           MOVE ESEITEA TO SEITE-A.
           MOVE ESEITEB TO SEITE-B.
           MOVE ESTIL TO STIL.
           MOVE ELEN TO LENGE.
      *
       LESZUW.
           MOVE KA-NR TO ENR.
           MOVE TITEL TO ETITEL.
           MOVE SEITE-A TO ESEITEA.
           MOVE SEITE-B TO ESEITEB.
           MOVE STIL TO ESTIL.
           MOVE LENGE TO ELEN.
