;Programmname: VIDEO			(c) 1987 by P.Kostal
;
;Dieses Programm ndert die Synchronimpulse des Video-Chip um die Bild-
;ausgabe am Monitor zu justiern. Die Werte fr HSync und VSync mssen
;mittles dem Programm TV_ADJUST ermittelt werden.
 
CSEG		SEGMENT
 
		ASSUME	CS:CSEG
		ORG	100h
 
HSync		EQU	87	;Hier Werte aus TV_ADJUST eintragen
VSync		EQU	28
 
Start:		JMP	Init
 
Table:
	;Die Reihenfolge der Bytes entspricht den Registern 0 - 15 des 6845
 
	;Mode 0,1 (40x25)
	DB	38h, 28h, HSync/2, 0Ah, 1Fh, 06h, 19h, VSync
	DB	02h, 07h, 06h, 07h, 00h, 00h, 00h, 00h
 
	;Mode 2,3 (80x25)
	DB	71h, 50h, HSync, 0Ah, 1Fh, 06h, 19h, VSync
	DB	02h, 07h, 06h, 07h, 00h, 00h, 00h, 00h
 
	;Mode 4,5,6 (Grafik)
	DB	38h, 28h, HSync/2, 0Ah, 7Fh, 06h, 64h, VSync*4
	DB	02h, 01h, 06h, 07h, 00h, 00h, 00h, 00h
 
	;Mode 7 (80x25 B&W)
	DB	61h, 50h, 52h, 0Fh, 19h, 06h, 19h, 19h
	DB	02h, 0Dh, 0Bh, 0Ch, 00h, 00h, 00h, 00h
 
 
Init:		;Zeiger auf Video-Parameter auf obige Tabelle ndern
		;Zeiger ist INT 1d. -> INT 1d ist kein ausfhrbarer
		;Interrupt, sondern sein Vektor zeigt nur auf die Video-
		;Parameter Tabelle.
		PUSH	CS		;DS=CS
		POP	DS
		MOV	DX,OFFSET Table
		MOV	AX,251Dh	;schreibe Int-Vektor, Video_Parms
		INT	21h
 
		MOV	AH,0Fh		;Get Video-Mode
		INT	10h		;Video-State in AL
		MOV	AH,0		;Set Video-Mode
		INT	10h		;schreiben der neuen Sync-Werte
 
		PUSH	CS		;DS=CS
		POP	DS
		MOV	DX,OFFSET Init
		INT	27h		;resident machen und Rckkehr zu DOS
 
CSEG		ENDS
		END	Start
 