program RDEMO;

(****************************************************************************)
(*                                                                          *)
(*      RDEMO.PAS: Roboter Demonstrationsprogramm                           *)
(*      -----------------------------------------                           *)
(*                                                                          *)
(*      Dieses Programm demonstriert die Verwendung des TURBOROBOT Unter-   *)
(*      programmpaketes fr den fischertechnik Trainingsroboter unter Ver-  *)
(*      wendung des PC INTERFACE V1.0.                                      *)
(*                                                                          *)
(*      Das Demonstrationsprogramm ermoeglicht die gleichzeitige Steuerung  *)
(*      der drei Roboterachsen durch Eingabe einer Absolutposition.         *)
(*                                                                          *)
(*      Zunaechst wird die Homeposition des Roboters angefahren. Danach kann*)
(*      eine Absolutposition fr den Roboterarm und fr die Zange angegeben *)
(*      werden.                                                             *)
(*                                                                          *)
(*      Nach jedem Bewegungschritt wird die aktuelle Position des Roboter-  *)
(*      armes und der Zange angezeigt.                                      *)
(*                                                                          *)
(*      Folgende Werte sind als Eingaben fr die Achsen gueltig :           *)
(*                                                                          *)
(*              -2000 <= X-POSITION <= 2000                                 *)
(*                  0 <= Y-POSITION <= 1000                                 *)
(*                  0 <= Z-POSITION <= 1000                                 *)
(*              -1000 <= ZANGENPOS. <= 250                                  *)
(*                                                                          *)
(****************************************************************************)

(****************************************************************************)
(*      INCLUDE FILES                                                       *)
(****************************************************************************)

(*$I VRIDEF.INC *)                      (* VRI Konstantendeklarationen *)
(*$I VRIPAS.INC *)                      (* VRI Unterprogramme *)
(*$I ROBOT.INC  *)                      (* Roboter Unterprogramme *)

(****************************************************************************)
(*      HAUPTPROGRAMM                                                       *)
(****************************************************************************)

VAR PosX,PosY,PosZ,PosG:integer; eop:boolean;

begin

  writeln;                              (* Text ausgeben                    *)
  writeln('TURBOROBOT Demonstrationsprogramm');
  writeln('---------------------------------');
  writeln;
  writeln('Einzugeben ist eine Absolutposition (X/Y/Z/ZANGE), die angefahren');
  writeln('werden soll. Ende durch Eingabe von 0/0/0/0');
  writeln('Details siehe File DEMO.PAS .');
  writeln;

  RobotInit;                            (* Robotersteuerung initialisieren  *)
  RobotMaxFehler(2);                    (* Maximalen Fehler beim Positio-   *)
                                        (* nieren setzen                    *)
  RobotHome; writeln('---> HOME');      (* Roboterarm & Zange in HOME Posi- *)
                                        (* tion bringen                     *)
  PosX:=0; PosY:=0; PosZ:=0; PosG:=0;   (* Position initialisieren          *)


  repeat                                (* Schleife bis Eingabe von 0/0/0/0 *)

    write('Nach Position :');           (* Position einlesen                *)
    write(' X-'); read(PosX);
    write(' Y-'); read(PosY);
    write(' Z-'); read(PosZ);
    write(' ZANGE-'); read(PosG);
    writeln;

    eop:=(PosX=0) and (PosY=0) and (PosZ=0) and (PosG=0);
    if not eop then                     (* wenn nicht ENDE gewnscht        *)
      begin
      RobotPos(PosX,PosY,PosZ,PosG);    (* Roboterposition holen & ausgeben *)
      writeln('--->',RobotPosition(X_ACHSE):6,
                     RobotPosition(Y_ACHSE):6,
                     RobotPosition(Z_ACHSE):6,
                     RobotPosition(ZANGE):6);
      end;
  until eop;                            (* bis Programmende                 *)

  RobotTerm;                            (* Robotersteuerung terminieren     *)
  end.

