
program teachme;

(***************************************************************************)
(*               Aufruf der Fischer-Technik Unterroutinen                  *)
(***************************************************************************)

(*$i vridef.inc*)
(*$i vripas.inc*)
(*$i robot.inc *)

type
      positionen = array [1..4,1..150] of integer;
      filename   = string [70];

var   wahl, laufwerk               : char;
      schrittw, cnt1, result, Achse: integer;
      posit                        : positionen;
      sw                           : string [03];
      dname                        : filename;
      name                         : string [08];

(***************************************************************************)
(*             title: procedure zur Erstellung des Titelbildes             *)
(***************************************************************************)

procedure title;

begin

  clrscr;

  write ('------------------------------------------------------------');
  writeln ('-------------------');
  write (' TEACH ME              TITLE              (w) by Ernst Huber');
  writeln ('          06-09 87 ');
  write ('-----------------------------------------------------------');
  writeln ('-------------------');

  write ('   TTTTTTTTTT     EEEEEEEEEE       AAAAAAA        CCCCCCCC ');
  writeln ('     HH        HH');
  write ('   TTTTTTTTTT     EEEEEEEEEE      AAAAAAAAA      CCCCCCCCCC');
  writeln ('     HH        HH');
  write ('       TT         EE              AA     AA      CC      CC');
  writeln ('     HH        HH');
  write ('       TT         EE              AA     AA      CC        ');
  writeln ('     HH        HH');
  write ('       TT         EEEEEE         AA       AA     CC        ');
  writeln ('     HHHHHHHHHHHH');
  write ('       TT         EE             AAAAAAAAAAA     CC        ');
  writeln ('     HH        HH');
  write ('       TT         EE             AA       AA     CC      CC');
  writeln ('     HH        HH');
  write ('       TT         EEEEEEEEEE     AA       AA     CCCCCCCCCC');
  writeln ('     HH        HH');
  write ('       TT         EEEEEEEEEE     AA       AA      CCCCCCCC ');
  writeln ('     HH        HH');
  writeln; writeln;
  writeln ('                        MM        MM     EEEEEEEEEE');
  writeln ('                        MMMM    MMMM     EEEEEEEEEE');
  writeln ('                        MM MM  MM MM     EE');
  writeln ('                        MM  MMMM  MM     EE');
  writeln ('                        MM   MM   MM     EEEEEE');
  writeln ('                        MM        MM     EE');
  writeln ('                        MM        MM     EE');
  writeln ('                        MM        MM     EEEEEEEEEE');
  writeln ('                        MM        MM     EEEEEEEEEE');
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  gotoxy (1,23)
end;

(***************************************************************************)
(*           mainmenue : Definition der Hauptmenue - Procedure             *)
(***************************************************************************)

procedure mainmenue;

begin

  clrscr;
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  write (' TEACH ME                Level 1                 (c) by eh  ');
  writeln ('   /      06-09 87 ');
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  writeln;
  writeln ('          Hauptmenue:');
  writeln ('          -----------');
  writeln; writeln;
  writeln ('          [a] ... Teach-in Modus');
  writeln;
  writeln ('          [b] ... Programmausfhrung');
  writeln;
  writeln ('          [c] ... Externer Speicherzugriff');
  writeln; writeln;
  writeln ('          ---------------------------------');
  writeln;
  writeln ('          [q] ... Ausstieg aus dem Programm');
  writeln;
  writeln ('          ---------------------------------');
  writeln;
  writeln ('          Ihre Wahl:');
  writeln;
  write ('------------------------------------------------------------');
  writeln ('-------------------')

end;

(***************************************************************************)
(*              Beginn der Routinen fr U-Prgr.teil:  TEACH-IN             *)
(***************************************************************************)

(***************************************************************************)
(*          teachinmenue: submenue, procedure fr teach-in-Modus           *)
(***************************************************************************)

procedure teachinmenue;

begin

  clrscr;
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  write (' TEACH ME                Level 2                /           ');
  writeln ('    Teach in Modus ');
  write ('------------------------------------------------------------');
  writeln ('--- Schritt ... ---');
  writeln;
  writeln ('     Steuern des Roboters mit:            weitere  Optionen:');
  writeln ('     -------------------------            ------------------');
  writeln;
  write ('  [s] ... links drehen              !  [ ] ... RETURN f. Bewegun');
  writeln ('gsablauf');
  writeln ('  [d] ... rechts drehen             ! ');
  writeln ('                                    ! ');
  writeln ('  [e] ... heben des Armes           !  [w] ... Schrittweite nd.');
  writeln ('  [x] ... senken des Armes          ! ');
  writeln ('                                    ! ');
  writeln ('  [r] ... Arm weg v. d. Hauptachse  ! ');
  writeln ('  [c] ... Arm zur Hauptachse        ! ');
  writeln ('                                    ! ');
  writeln ('  [f] ... Zange schlieen           !  [l] ... akt. Prg. lschen');
  writeln ('  [g] ... Zange ffnen              ! ');
  writeln ('                                    ! ');
  writeln ('  [.] ... HOME-Position anfahren    !  [q] ... Hauptmenue ');
  writeln ('                                    ! ');
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  writeln ('   Schrittweite  ( 1 -  500):       !    Steuerbefehl:')

end;

(***************************************************************************)
(*tireadschrittw: procedure zum Einlesen der Schrittweite in teachincontrol*)
(***************************************************************************)

procedure tireadschrittw;

var x, y: integer;
    help: char;

begin

  repeat
    gotoxy (32,23);
    write ('...');
    gotoxy (1,24); write ('      ');
    write ('   MSG: die CURSOR-Left-Taste kann als BACKSTEP verwendet werden');
    x:=0;
    gotoxy (32,23);
    write (sw);
    gotoxy (32,23);
    x:=length(sw);
    gotoxy (32+x,23);

    repeat

      repeat
        read (kbd,help)
      until ord(help) in [13,47..57,75];

      case ord(help) of

      13: begin
            for y:=x to 3 do
            begin
              gotoxy (32+y,23); write (' ')
            end;
            x:=3
          end;
      75: begin
            x:=x-1;
            if x<0 then x:=0
            else
            begin
              gotoxy (32+x,23);
              help:='.'; write (help);
              gotoxy (32+x,23);
              sw:=copy (sw,1,x)
            end;
          end;
      else
      begin
        if x=0 then delete (sw,1,3);
        x:=x+1;
        gotoxy (31+x,23);
        write (help);
        sw:=sw+help;
      end;
      end;  (* case *)
    until (x=3);
    val (sw,schrittw,result);
  until not((schrittw < 1)or(schrittw>500));
  gotoxy (1,24);
  write ('------------------------------------------------------------');
  writeln ('-------------------')

end;

(***************************************************************************)
(*      teachincontrol: procedure fr Robotersteuerprogrammerfassung       *)
(***************************************************************************)

procedure teachincontrol;

var   steuerbef         : char;
      x, y, z, g, stz,I : integer;
      counter1          : string [3];

begin
  x:=posit [1,cnt1];
  y:=posit [2,cnt1];
  z:=posit [3,cnt1];
  g:=posit [4,cnt1];

  str (cnt1,counter1);
  stz:=length (counter1);
  gotoxy (76-stz,3);
  write (cnt1);
  tireadschrittw;
  repeat
  steuerbef:='_';
  gotoxy (57,23);
  write (steuerbef);
  repeat
        gotoxy (57,23);
        read (kbd,steuerbef);
  until steuerbef in (.'e','x','s','d','r','c','f','g','.','w','l',' ','q',
                       'E','X','S','D','R','C','F','G','W','L','Q'.);
  write (steuerbef);

  case steuerbef of

  'e','E': begin
             z:=z-schrittw;
             if z < 0 then z:=0;
             RobotPos (x,y,z,g)
           end;

  'x','X': begin
             z:=z+schrittw;
             if z > 1300 then z:=1300;
             RobotPos (x,y,z,g)
           end;

  's','S': begin
             x:=x+schrittw;
             if x > 4000 then x:=4000;
             RobotPos (x,y,z,g)
           end;

  'd','D': begin
             x:=x-schrittw;
             if x < -4000 then x:=-4000;
             RobotPos (x,y,z,g)
           end;

  'r','R': begin
             y:=y+schrittw;
             if y > 1300 then y:=1300;
             RobotPos (x,y,z,g)
           end;

  'c','C': begin
             y:=y-schrittw;
             if y < 0 then y:=0;
             RobotPos (x,y,z,g)
           end;

  'f','F': begin
             g:=1500;
             RobotPos (x,y,z,g);
             cnt1:=cnt1+1;
             posit [1,cnt1]:=x;
             posit [2,cnt1]:=y;
             posit [3,cnt1]:=z;
             posit [4,cnt1]:=g;
             str (cnt1,counter1);
             stz:=length (counter1);
             gotoxy (76-stz,3);
             write (cnt1)
           end;

  'g','G': begin
             g:=-100;
             RobotPos (x,y,z,g);
             cnt1:=cnt1+1;
             posit [1,cnt1]:=x;
             posit [2,cnt1]:=y;
             posit [3,cnt1]:=z;
             posit [4,cnt1]:=g;
             str (cnt1,counter1);
             stz:=length (counter1);
             gotoxy (76-stz,3);
             write (cnt1)
           end;

  '.': begin
         robothome;
         x:=0; y:=0; z:=0; g:=0;
         cnt1:=cnt1+1;
         posit [1,cnt1]:=x;
         posit [2,cnt1]:=y;
         posit [3,cnt1]:=z;
         posit [4,cnt1]:=g;
         str (cnt1,counter1);
         stz:=length (counter1);
         gotoxy (76-stz,3);
         write (cnt1)
       end;

  ' ': begin
         cnt1:=cnt1+1;
         posit [1,cnt1]:=x;
         posit [2,cnt1]:=y;
         posit [3,cnt1]:=z;
         posit [4,cnt1]:=g;
         str (cnt1,counter1);
         stz:=length (counter1);
         gotoxy (76-stz,3);
         write (cnt1)
       end;

  'w','W': tireadschrittw;

  'l','L': begin
             for I:=1 to cnt1 do
             begin
               robothome;
               x:=0; y:=0; z:=0; g:=0;
               cnt1:=cnt1+1;
               posit [1,cnt1]:=x;
               posit [2,cnt1]:=y;
               posit [3,cnt1]:=z;
               posit [4,cnt1]:=g
             end;
             cnt1:=0
           end;
  end;  (** case **)

  until steuerbef in (.'q','Q'.)

end;

(***************************************************************************)
(*              Beginn der Routinen fr U-Prgr.teil:  PROGR-EXE            *)
(***************************************************************************)

(***************************************************************************)
(*         progrexemenue: submenue, procedure fr progr-exe-Modus          *)
(***************************************************************************)

procedure progrexemenu;

begin

  clrscr;
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  write (' TEACH ME                Level 2                /        Pro');
  writeln ('gram-execute Modus ');
  write ('-------------------------------------------------------- Sch');
  writeln ('ritt ... von ... --');
  writeln;
  writeln ('          Optionen:');
  writeln ('          ---------');
  writeln; writeln;
  writeln ('          [a] ... Programm dauernd ausfhren [bel. Taste->Break]');
  writeln;
  writeln ('          [b] ... Programm x-mal ausfhren');
  writeln;
  writeln ('          [c] ... Programm schrittweise durchfhren');
  writeln; writeln;
  writeln ('          ------------------------------------------------------');
  writeln;
  writeln ('          [q] ... Hauptmenue');
  writeln;
  writeln ('          ------------------------------------------------------');
  writeln;
  writeln ('          Ihre Wahl:');
  writeln;
  write ('------------------------------------------------------------');
  writeln ('-------------------')

end;

(***************************************************************************)
(*         pex-malmenu: submenue, procedure x-mal progr ausfhren          *)
(***************************************************************************)

procedure pexmalmenu;

begin

  clrscr;
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  write (' TEACH ME                Level 3                /       Prog');
  writeln ('ram-X-mal ausfhren');
  write ('------------------------------------------------------- Schr');
  writeln ('itt ... von ... ---');
  writeln; writeln;
  writeln ('          Wie oft soll das Programm ausgefhrt werden :');
  writeln;
  writeln ('          [ ___ ] - max. 100-mal ');
  writeln; writeln;
  writeln ('          ---------------------------------------------');
  writeln; writeln;
  writeln ('          bel. Taste -> Ausstieg aus dem aktuellen ');
  writeln ('                        Unterprogr.- Sprung nach Level2');
  writeln; writeln;
  writeln ('          ---------------------------------------------');
  writeln; writeln; writeln; writeln; writeln;
  write ('------------------------------------------------------------');
  writeln ('-------------------')

end;

(***************************************************************************)
(*   pe-step by step menu: submenue, schrittweises Programm durchfhren    *)
(***************************************************************************)

procedure pestepmenu;

begin

  clrscr;
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  write (' TEACH ME                Level 3      /      Programm schrit');
  writeln ('tweise durchfhren ');
  write ('-------------------------------------------------------- Sch');
  writeln ('ritt ... von ... --');
  writeln;
  writeln ('          Optionen:');
  writeln ('          ---------');
  writeln; writeln;
  writeln ('          [ ] ... nchster Schritt');
  writeln;
  writeln ('          [d] ... letzten Schritt lschen');
  writeln;
  writeln ('          [t] ... Sprung in teach-in-Modus -> Programm weiter-');
  writeln ('                  entwickeln ');
  writeln;
  writeln ('          ------------------------------------------------------');
  writeln;
  writeln ('          [q] ... Level 2 - Program-execute-Menu');
  writeln;
  writeln ('          ------------------------------------------------------');
  writeln;
  writeln ('          Ihre Wahl:');
  writeln;
  write ('------------------------------------------------------------');
  writeln ('-------------------')

end;

(***************************************************************************)
(*       progrexecontrol: procedure fr Roboterprogrammdurchfhrung        *)
(***************************************************************************)

procedure progrexecontrol;

var wahl1, break, wahl2           : char;
    cnt2, x, y, z, g, i, xmal, stz: integer;
    xm, counter1, counter2        : string [3];

begin

  repeat;

  progrexemenu;

  gotoxy (23,22);

  repeat
        read (kbd,wahl1);
  until wahl in (.'a','b','c','q','A','B','C','Q'.);

  case wahl1 of

       'a','A': begin
                  cnt2:=0;
                  str (cnt1,counter1);
                  stz:=length (counter1);
                  gotoxy (74,3); write ('...');
                  gotoxy (77-stz,3);
                  write (cnt1);

                  repeat
                    cnt2:=0;

                    repeat

                      str (cnt2+1,counter2);
                      stz:=length (counter2);
                      gotoxy (66,3); write ('...');
                      gotoxy (69-stz,3);
                      write (cnt2+1);
                      gotoxy (68,3);

                      cnt2:=cnt2+1;
                      x:=posit [1,cnt2];
                      y:=posit [2,cnt2];
                      z:=posit [3,cnt2];
                      g:=posit [4,cnt2];

                      RobotPos (x,y,z,g);
                      if (x=0)and(y=0)and(z=0)and(g=0) then RobotHomeA(ZANGE);

                    until (cnt2=cnt1) or keypressed;

                  until keypressed

                  end;

       'b','B': begin
                  cnt2:=0;
                  repeat
                    xm:=' ';
                    pexmalmenu;
                    gotoxy (13,8);
                    readln (xm);
                    val (xm,xmal,result);
                  until (xmal>=0) and (xmal<=100);

                  str (cnt1,counter1);
                  stz:=length (counter1);
                  gotoxy (73,3); write ('...');
                  gotoxy(76-stz,3);
                  write (cnt1);

                  for i:=1 to xmal do
                  begin
                    cnt2:=0;
                    repeat

                      str (cnt2+1,counter2);
                      stz:=length (counter2);
                      gotoxy (65,3); write ('...');
                      gotoxy (68-stz,3);
                      write (cnt2+1);
                      gotoxy (67,3);

                      cnt2:=cnt2+1;
                      x:=posit [1,cnt2];
                      y:=posit [2,cnt2];
                      z:=posit [3,cnt2];
                      g:=posit [4,cnt2];

                      RobotPos (x,y,z,g);
                      if (x=0)and(y=0)and(z=0)and(g=0) then RobotHomeA(ZANGE);

                    until (cnt2=cnt1) or keypressed;
                    if keypressed then i:=xmal
                  end;

                  end;

       'c','C': begin
                  cnt2:=0;
                  pestepmenu;
                  repeat;
                    cnt2:=0;
                    repeat
                      gotoxy (23,22);

                      repeat
                        read (kbd,wahl2);
                      until wahl2 in (.' ','d','t','q','D','T','Q'.);

                      str (cnt1,counter1);
                      stz:=length (counter1);
                      gotoxy (74,3); write ('...');
                      gotoxy (77-stz,3);
                      write (cnt1);
                      str (cnt2+1,counter2);
                      stz:=length (counter2);
                      gotoxy (66,3); write ('...');
                      gotoxy (69-stz,3);
                      write (cnt2+1);
                      gotoxy (68,3);

                      case wahl2 of
                       'D','d': begin
                                  cnt2:=cnt2-2;
                                  cnt1:=cnt2;
                                  if cnt1<0 then
                                  begin
                                    cnt1:=0; cnt2:=0
                                  end;
                                  str (cnt1,counter1);
                                  stz:=length (counter1);
                                  gotoxy (74,3); write ('...');
                                  gotoxy (77-stz,3);
                                  write (cnt1);
                                  str (cnt2,counter2);
                                  stz:=length (counter2);
                                  gotoxy (66,3); write ('...');
                                  gotoxy (69-stz,3);
                                  write (cnt2);
                                  gotoxy (68,3)
                                end;

                       't','T': begin
                                  cnt1:=cnt2;
                                  teachinmenue;
                                  teachincontrol;
                                  wahl2:='q';
                                  wahl1:='q'
                                end;

                      end;

                      cnt2:=cnt2+1;

                      if not (wahl2 in (.'q','Q'.)) then
                      begin

                        x:=posit [1,cnt2];
                        y:=posit [2,cnt2];
                        z:=posit [3,cnt2];
                        g:=posit [4,cnt2];

                        RobotPos (x,y,z,g);
                        if(x=0)and(y=0)and(z=0)and(g=0) then RobotHomeA(ZANGE);

                      end;

                    until (cnt2=cnt1) or (wahl2='q');

                  until (wahl2='q')

                end;

  end;

  until wahl1 in (.'q','Q'.)

end;

(***************************************************************************)
(*           Beginn der Routinen fr U-Prgr.teil: EXTERNER-SPEICHER        *)
(***************************************************************************)

(***************************************************************************)
(*         dnamemenu: Menu zum Einlesen des Dateinamens                    *)
(***************************************************************************)

procedure dnamemenu;

begin

  clrscr;
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  write (' TEACH ME                Level 3                /     Extern');
  writeln ('er Speicherzugriff ');
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  writeln; writeln;
  writeln ('          Welches Laufwerk soll verwendet werden:');
  writeln;
  writeln ('          [ _ ] ');
  writeln;
  writeln ('          ------------------------------------------------');
  writeln;
  writeln ('          Dateiname:');
  writeln;
  writeln ('          [ .............................. ]');
  writeln;
  writeln ('          ------------------------------------------------');
  writeln; writeln; writeln; writeln; writeln;
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  writeln;
  write ('------------------------------------------------------------');
  writeln ('-------------------')

end;

(***************************************************************************)
(*         dnameread: Routine zum Einlesen des Dateinamens                 *)
(***************************************************************************)

procedure dnameread;

var x, y: integer;
    help: char;

begin

  repeat
    gotoxy (13,8);
    read (kbd,laufwerk);
    gotoxy (13,8);
    write (laufwerk);
  until laufwerk in (.'a','A','b','B','c','C','d','D'.);

  gotoxy (1,23);
  write ('     MSG: die CURSOR-Left-Taste kann als BACKSTEP verwendet werden');
  x:=0;
  gotoxy (13,14);
  write (name);
  x:=length(name);
  gotoxy (13+x,14);

  repeat
    repeat
      read (kbd,help)
    until ord(help) in [13,40,41,43,45,47..57,65..122];

    case ord(help) of

    13: begin
          for y:=x to 30 do
          begin
            gotoxy (13+y,14); write (' ')
          end;
          x:=30
        end;
    75: begin
          x:=x-1;
          if x<0 then x:=0
          else
          begin
            gotoxy (13+x,14);
            help:='.'; write (help);
            gotoxy (13+x,14);
            name:=copy (name,1,x)
          end;
        end;
    else
    begin
      if x=0 then delete (name,1,8);
      x:=x+1;
      gotoxy (12+x,14);
      write (help);
      name:=name+help;
    end;
    end;  (* case *)
  until (x=30);
  dname:=laufwerk+':'+name+'.'+'dta';
  gotoxy (1,23);
  write ('                                                                  ');
end;

(***************************************************************************)
(*    extspmenu: Menu fr Auswahl EXTERNER SPEICHERZUGRIFF                 *)
(***************************************************************************)

procedure extspmenu;

begin

  clrscr;
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  write (' TEACH ME                Level 2                /     Extern');
  writeln ('er Speicherzugriff ');
  write ('------------------------------------------------------------');
  writeln ('-------------------');
  writeln;
  writeln ('          Optionen:');
  writeln ('          ---------');
  writeln; writeln;
  writeln ('          [a] ... Daten speichern');
  writeln;
  writeln ('          [b] ... Daten laden');
  writeln;
  writeln ('          [c] ... Datei lschen');
  writeln; writeln;
  writeln ('          ------------------------------------------------------');
  writeln;
  writeln ('          [q] ... Hauptmenue');
  writeln;
  writeln ('          ------------------------------------------------------');
  writeln;
  writeln ('          Ihre Wahl:');
  writeln;
  write ('------------------------------------------------------------');
  writeln ('-------------------')

end;

(***************************************************************************)
(*    exist: Function zum berprfen ob Datei vorhanden                    *)
(***************************************************************************)

function Exist (FileName: filename): boolean;

var fil: file;

begin
  (*$I-*)
  assign (fil,FileName);
  reset (fil);
  (*$I+*);
  if IOresult=0 then Exist:=true
  else
  begin
    Exist:=false
  end;
  close (fil)
end;

(***************************************************************************)
(*    extspcontrol: Procedure fr EXTERNER SPEICHERZUGRIFF steuern         *)
(***************************************************************************)

procedure extspcontrol;

type
     RobotPos = record
                x1, y1, z1, g1: integer;
                end;

var  wahl3, wahl4: char;
     RobotFile   : file of RobotPos;
     RobotRec    : RobotPos;
     I           : integer;

begin
  repeat
    laufwerk:=' ';
    extspmenu;

    repeat
      gotoxy (23,22);
      read (kbd,wahl3);
      gotoxy (23,22); write (wahl3);
    until wahl3 in (.'a','b','c','q','A','B','C','Q'.);

    if (wahl3<>'q')and(wahl3<>'Q') then
    begin
      dnamemenu;
      dnameread;
    end;

    if laufwerk in (.'a','A','b','B'.) then
    begin
      gotoxy (13,17);
      write ('Datendisk in Laufwerk ['+laufwerk+'] einlegen...');
      gotoxy (13,18);
      write ('weiter mit   < T A S T E >');
      gotoxy (11,19);
      write ('------------------------------------------------');
      gotoxy (50,18);
      repeat until keypressed
    end;

    if not(wahl3 in (.'q','Q'.)) then
    begin
      if (Exist(dname))or(wahl3 in (.'a','A'.)) then
      begin
        assign (RobotFile, dname);

        case wahl3 of

        'a','A': begin
                   if not(Exist(dname)) then
                   begin
                     gotoxy (13,20);
                     write ('Neue Datei wird erstellt');
                   end
                   else
                   begin
                     gotoxy (13,20);
                     write ('File ('+dname+') existiert bereits ');
                     gotoxy (13,21);
                     write ('berschreiben (j/n): ');
                     repeat
                       read (wahl4);
                     until wahl4 in (.'j','J','n','N'.)
                   end;

                   if (wahl4 in (.'j','J'.))or(not(Exist(dname))) then
                   begin
                     rewrite (RobotFile);

                     with RobotRec do
                     begin
                       x1:=cnt1; y1:=cnt1;
                       z1:=cnt1; g1:=cnt1;
                       write (RobotFile, RobotRec);

                       for I:=1 to cnt1 do
                       begin
                         x1:=posit [1,I];
                         y1:=posit [2,I];
                         z1:=posit [3,I];
                         g1:=posit [4,I];
                         write (RobotFile, RobotRec)
                       end;  (** for **)

                     end;  (** with **)
                     close (RobotFile)
                   end;  (** if **)

                 end;

        'b','B': begin
                   reset (RobotFile);
                   with RobotRec do
                   begin
                     read (RobotFile, RobotRec);
                     cnt1:=x1;
                     for I:=1 to cnt1 do
                     begin
                       read (RobotFile, RobotRec);
                       posit [1,I]:=x1;
                       posit [2,I]:=y1;
                       posit [3,I]:=z1;
                       posit [4,I]:=g1
                     end;
                   end;
                   close (RobotFile)
                 end;

        'c','C': begin
                   wahl4:=' ';
                   gotoxy (13,20);
                   write ('Sind Sie sicher (j,n): ');
                   gotoxy (13,40);
                   repeat
                     read (kbd,wahl4);
                   until wahl4 in (.'j','J','n','N'.);
                   if wahl4 in (.'j','J'.) then erase (RobotFile);
                 end;

        end;  (** case **)

      end
      else
      begin
        gotoxy (13,20);
        write ('File mit Namen ('+dname+') nicht auffindbar!');
        gotoxy (13,21);
        write ('weiter mit   < T A S T E >');
        gotoxy (60,21);
        repeat until keypressed
      end;  (** if **)
    end;  (** if **)

  until wahl3 in (.'q','Q'.)
end;

(***************************************************************************)
(*                       Beginn des Hauptprogramms                         *)
(***************************************************************************)

begin
  dname:=''; sw:=''; name:='';

  title;

  robotinit;
  robotmaxfehler (02);
  robothome;
  cnt1:=0;

  repeat
    mainmenue;
    gotoxy (23,22);

    repeat
          read (kbd,wahl);
    until wahl in (.'a','b','c','q','A','B','C','Q'.);

    case wahl of

         'a','A': begin
                    teachinmenue;
                    teachincontrol
                  end;

         'b','B': begin;
                    progrexecontrol
                  end;

         'c','C': begin;
                    extspcontrol
                  end;

    end;

  until wahl in (.'q','Q'.);
  clrscr

end.