(****************************************************************************)
(*                                                                          *)
(*      VRIPAS.INC : Prozedurdefinitionen V2.0 fuer TURBO PASCAL            *)
(*      --------------------------------------------------------            *)
(*                                                                          *)
(*         (c) Copyright 1986 by Professional Computer Software             *)
(*                                                                          *)
(*                                                                          *)
(*      Dieses INCLUDE File enthaelt die Prozedurdefinitionen zur An-       *)
(*      steuerung des PC INTERFACE V1.0 aus TURBO PASCAL.                   *)
(*                                                                          *)
(*                                                                          *)
(*      Folgende Anweisung wird im Quellprogramm benoetigt :                *)
(*                                                                          *)
(*                $I VRIPAS.INC                                             *)
(*                                                                          *)
(*                                                                          *)
(*                                                                          *)
(*      Folgende Prozeduren werden definiert :                              *)
(*      --------------------------------------                              *)
(*                                                                          *)
(*      r_init                  Initialisieren des Interfaces               *)
(*        procedure r_init;                                                 *)
(*      r_term                  Terminieren des Interfaces                  *)
(*        procedure r_term;                                                 *)
(*      r_selekt                Selektieren eines Interfaces                *)
(*        procedure r_selekt(n:integer);                                    *)
(*      r_auszeit               Auszeit (TIMEOUT) setzen                    *)
(*        procedure r_auszeit(z:integer);                                   *)
(*      r_selifs                Selektiertes Interface abfragen             *)
(*        function  r_selifs:integer;                                       *)
(*      r_syssta                Systemstatus abfragen                       *)
(*        procedure r_syssta(var i,n,d,c:integer);                          *)
(*      r_delay                 Verzoegerung in 1/10 Sekunden               *)
(*        procedure r_delay(d:integer);                                     *)
(*      r_dly1000               Verzoegerung in 1/1000 Sekunden             *)
(*        procedure r_dly1000(d:integer);                                   *)
(*                                                                          *)
(*      r_motor                 Motorsteuerung                              *)
(*        procedure r_motor(m,r:integer);                                   *)
(*      r_schalter              Schalter (Digitaleingang) einlesen          *)
(*        function  r_schalter(s:integer):boolean;                          *)
(*      r_poti                  Potentiometer (Analogeingang) einlesen      *)
(*        function  r_poti(p:integer):integer;                              *)
(*                                                                          *)
(*      r_drehzahl              Drehzahl fuer Motor setzen                  *)
(*        procedure r_drehzahl(m,d:integer);                                *)
(*      r_blinken               Automatisches Blinken fuer Motor setzen     *)
(*        procedure r_blinken(m,h,d:integer);                               *)
(*      r_motorw                Motorsteuerung nach Wartezeit setzen        *)
(*        procedure r_motorw(m,r,w:integer);                                *)
(*      r_motori                Motorsteuerung fuer Intervall setzen        *)
(*        procedure r_motori(m,r,w:integer);                                *)
(*      r_stop                  Alle Motoren anhalten                       *)
(*        procedure r_stop;                                                 *)
(*      r_status                Motorstatus abfragen                        *)
(*        procedure r_status(m:integer; var r,w,b,d:integer);               *)
(*                                                                          *)
(*      r_glsset                Schritte fuer Gabellichtschranke setzen     *)
(*        procedure r_glsset(m,s,d,n:integer);                              *)
(*      r_glsexe                Gabellichtschrankenkommando ausfuehren      *)
(*        procedure r_glsexe;                                               *)
(*      r_glsget                Ausgefuehrte Schritte nach Kommando holen   *)
(*        function  r_glsget(m:integer):integer;                            *)
(*      r_gabel                 Schritte fuer eine Gabellichtschranke ausf. *)
(*        function  r_gabel(m,s,d,n:integer):integer;                       *)
(*                                                                          *)
(****************************************************************************)


procedure r_call(fn:integer;var p1,p2,p3,p4,p5,p6,p7:integer);
        (* VRI Kommunikationsroutine *)
var rb:record ax,bx,cx,dx,bp,si,di,ds,es,fl: integer; end;
    pb:array[0..15] of integer;
begin
  pb[0]:=seg(fn);  pb[1]:=ofs(fn);  pb[2]:=seg(p1);  pb[3]:=ofs(p1);
  pb[4]:=seg(p2);  pb[5]:=ofs(p2);  pb[6]:=seg(p3);  pb[7]:=ofs(p3);
  pb[8]:=seg(p4);  pb[9]:=ofs(p4);  pb[10]:=seg(p5); pb[11]:=ofs(p5);
  pb[12]:=seg(p6); pb[13]:=ofs(p6); pb[14]:=seg(p7); pb[15]:=ofs(p7);
  rb.dx:=ofs(pb);  rb.ds:=seg(pb);  Intr($0071,rb);
end;


procedure r_init;
var d,s,o:integer;
begin
o:=MemW[0:448]; s:=MemW[0:450];
if ((s=0) and (o=0)) or (MemW[s:o+2]<>$1af3) or (MemW[s:o+4]<>$42e7) then
  begin
  writeln;
  writeln('!!!   ACHTUNG : Steuerprogramm SETVRI nicht geladen   !!!');
  writeln;
  Halt;
  end;
r_call(0,d,d,d,d,d,d,d)
end;

procedure r_term;
var d:integer;
begin r_call(1,d,d,d,d,d,d,d) end;

procedure r_selekt(n:integer);
begin r_call(2,n,n,n,n,n,n,n) end;

procedure r_auszeit(z:integer);
begin r_call(3,z,z,z,z,z,z,z) end;

procedure r_motor(m,r:integer);
begin r_call(4,m,r,r,r,r,r,r) end;

function r_schalter(s:integer):boolean;
var z:integer; begin r_call(5,s,z,s,s,s,s,s); r_schalter:= z<>0 end;

function r_poti(p:integer):integer;
var w:integer; begin r_call(6,p,w,w,w,w,w,w); r_poti:=w end;

procedure r_drehzahl(m,d:integer);
begin r_call(7,m,d,d,d,d,d,d) end;

procedure r_blinken(m,h,d:integer);
begin r_call(8,m,h,d,d,d,d,d) end;

procedure r_motorw(m,r,w:integer);
begin r_call(9,m,r,w,w,w,w,w) end;

procedure r_status(m:integer;var r,w,b,d:integer);
begin r_call(10,m,r,w,b,d,d,d) end;

procedure r_stop;
var d:integer;
begin r_call(11,d,d,d,d,d,d,d) end;

procedure r_motori(m,r,w:integer);
begin r_call(12,m,r,w,w,w,w,w) end;

function r_selifs:integer;
var i:integer; begin r_call(13,i,i,i,i,i,i,i); r_selifs:=i end;

procedure r_syssta(var i,n,t,c:integer);
begin r_call(14,i,n,t,c,c,c,c) end;

procedure r_glsset(m,s,d,n:integer);
begin r_call(15,m,s,d,n,n,n,n) end;

procedure r_glsexe;
var d:integer; begin r_call(16,d,d,d,d,d,d,d) end;

function r_glsget(m:integer):integer;
var n:integer; begin r_call(17,m,n,n,n,n,n,n); r_glsget:=n end;

function r_gabel(m,s,d,n:integer):integer;
var r:integer; begin r_call(18,m,s,d,n,r,r,r); r_gabel:=r end;

procedure r_delay(t:integer);
begin r_call(19,t,t,t,t,t,t,t) end;

procedure r_dly1000(t:integer);
begin r_call(20,t,t,t,t,t,t,t) end;

