%
%
%
%
%          ###########   ############  ####        #### ############
%         #############  #############  ##          ##  ############
%         ###       ###  ##        ###  ##          ##  ##         #
%         ##         ##  ##         ##  ##          ##  ##
%         ##         ##  ##        ###  ##          ##  ###
%         ##         ##  #############  ##          ##   ##########
%         ##         ##  ############   ##          ##   ###########
%         ##         ##  ##             ##          ##           ###
%         ##         ##  ##             ##          ##            ##
%         ##         ##  ##             ##          ##            ##
%         ###       ###  ##             ###        ###  #         ##
%         #############  ##             ##############  ############
%          ###########  ####             ############   ###########
%
%
%
%
%
%
%
%                             Sample Control File
%                             -------------------
%
%
%               The POLE's OPUS Computer-Based Conversation System
%            (c)Copyright, 1986; Wynn Wagner III; All Rights Reserved
%
%                                  4 Apr 1987
%
%
%
%
%
%
%                 "If you can't convince them, confuse them."
%
%                            -- Harry S. Truman
%
%
%
%
%
%
%
%
%
%
% 
%
% This is your best and most complete source of information on how to
% setup and customize an Opus system.
%
%
%
% ---------------------------------------------------------------------
% GENERAL INFORMATION ABOUT THE CONTROL FILE
% ---------------------------------------------------------------------
%
% A file like this is used by the Opus assembler (OPUS_CTL.EXE) to produce
% a data file for the Opus system.  This file is NOT used during the actual
% operation of the Opus system.  Opus itself will use the data file...
% called a "parameter file".
%
% Opus_Ctl.Exe takes a CTL file and assembles it to a PRM file.  The
% word PRM means "parameters."  To submit the control file to the
% assembler, type Opus_Ctl and the name of the control file.  For example
%
%                               Opus_Ctl Opus
%
% You can use the program OpusGraf to produce a chart from a PRM file.
%
%
%
% This is not exactly a free-form file.  Although leading spaces are
% normally ignored, commands appearing on one line MUST be kept on
% one line.  For example, the two words `Modem COM1' cannot be on
% separate lines.
%
% If the first non-space character is a percent sign (`%') the line
% is treated as a comment.
%
% In the following instructions, you will see the phrase "Uncomment the
% line if....".  The word "Uncomment" means remove the percent sign from
% the beginning of the line.  To "Comment Out" a line means put a percent
% sign at the beginning of a line.
%
%
%
% FOR ADVANCED USERS ONLY: The explanation of the comment character isn't
% exactly true but it's the simple way of saying it.  Actually, YOU control
% what the comment character is.  If the first non-space character is some
% kind of punctuation, then that character becomes the comment character
% for the entire file.  You can replace the percent signs with a semi-colon
% in you are inflicted by such a burning desire.
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% MODEMS AND EQUIPMENT
% ---------------------------------------------------------------------
%
%
%      * MAXIMUM BAUD FOR YOUR MODEM
%
%        How fast can YOUR system run?  You'll find additional commands
%        that deal with a caller's baud rate under "About Callers" (below).
%
% Baud 19200
% Baud 9600
% Baud 4800
Baud   2400                % The maximum speed of your modem
% Baud 1200
%
%
%
%
%
%
%      * INITIALIZATION
%
%        The line sent to your modem to set it up.
%
%
%        Special characters:   v (lowercase V) ... lower DTR
%
%                              ^ (caret) ......... raise DTR
%
%                              | (concatenate).... carraige return
%
%                              ~ (tilde).......... slight pause
%
%
%
%        Opus was written with a USR COURIER 2400 baud external modem
%        in mind.  That modem is considered "standard equipment."  If Opus
%        works with other modems, you should consider that a fortunate
%        coincidence.  There are no claims of compatibility between Opus
%        and any particular peripheral.
%
%        It is important that you make the modem send VERBAL responses
%        that include the baud rate.  Opus uses the modem response to
%        determine the caller's baud rate (eg. CONNECT 1200, CONNECT 2400).
%        On most Hayes-compatible modems, this is the "X" item in the
%        initialization string.  By itself, the word "CONNECT" tells the
%        system that there is a caller at 300 baud.
%
%        Opus uses DTR to drop carrier.  Usually there are DIP switches
%        on a modem to enable and disable DTR.  Your modem must be setup
%        to be sensitive to the DTR line.  If Opus "lowers DTR" (turns off
%        that signal), it expects the modem to disconnect a caller.
%
%        Because Opus uses DTR, it never needs to use "+++" to force
%        your modem into Command Mode.  For security, you can disable
%        "+++" recognition or use some other modem setting to make that
%        signal unusable.
%
%
%
%        Here is an explanation of the Courier initialization:
%
%                 AT       attention
%                 Q0       result messages are sent
%                 E0       commands sent to the modem are not echo'd
%                 H0       hang up (if on-hook for any reason)
%                 M0       speaker always off
%                 V1       send verbal responses, NOT NUMERIC
%                 S0=1     answer a call on the first ring
%                 X4       use EXTENDED verbal responses (never above 4!)
%
%        Here are the suggested DIP switch settings for the Courier 2400:
%
%                 1 DTR         up   normal (NOT the factory setting)
%                 2 Codes       up   verbal
%                 3 Display     down result codes displayed
%                 4 Echo        down commands not echo'd (NOT factory setting)
%                 5 AutoAnswer  up   on (NOT factory setting)
%                 6 Carrier     up   normal carrier (NOT factory setting)
%                 7 Single line ????
%                 8 Commands    down normal operation
%                 9 +++         up   ignore the plus signal
%
%        These are the modem result codes Opus understands:
%
%                 CONNECT      ... modem reports a 300 baud caller
%                 CONNECT 300  ... modem reports a 300 baud caller
%                 CONNECT 1200 ... modem reports a 1200 baud caller
%                 CONNECT 1275 ... modem reports a 1200 baud caller
%                 CONNECT 2400 ... modem reports a 2400 baud caller
%                 CONNECT 9600 ... modem reports a 9600 baud caller
%                 CONNECT FAST ... modem reports a 9600 baud caller
%                 OK           ... modem understood the last command
%                 BUSY         ... dialed number not available
%                 ERROR        ... last command not understood
%                 NO ANSWER    ... dialed number not available
%                 NO CARRIER   ... dialed number not available
%                 NO DIAL TONE ... dialed number not available
%                 VOICE        ... dialed number not available
%                 RING         ... [this response is ignored by Opus]
%                 RINGING      ... [this response is ignored by Opus]
%                 RRING        ... [this response is ignored by Opus]
%
%
%                 NOTES:   * Any other response is ignored by Opus.
%
%                          * Carraige returns and/or line feed characters
%                            are considered delimeters.  Leading delimeters
%                            are ignored, but each command must end with
%                            either a carraige return or line feed or both.
%
%
%
%
%        --- Telebit TrailBlazer 9600 ----------
% Modem init ~|ATS0=1S51=5S52=1S53=1S7=60S58=2S9=1S66=1S68=2Q0E0H0M0V1|
%
%
%            NOTE: With the TrailBlazer, use STEADY, CTS, and XON (see below).
%                  MaxBaud is 19200.
%
%                  There is a separate file with additional information on
%                  the TrailBlazer.  Look for TELEBIT.DOC.
%
%
%        --- USR Courier HST 9600 --------------
% Modem init |AT&F&H1&R2&B1&M4E0H0M0X7B1S0=1S2=255S7=45|
%
%            HST DIP switches:  3,5,8,10 down; all others up
%            NOTE: With the HST, use STEADY, CTS, and XON (see below).
%                  MaxBaud is 19200
%
%
%        --- USR Courier 2400 ------------------
% Modem init |ATQ0E0H0M0V1S0=1S2=255X4|
%
%            NOTE: Don't use anything higher than "X4" with a Courier modem.
%                  If somebody using a TrailBlazer 9600 calls, the Courier
%                  will mis-interpret its carrier signal as VOICE.
%
%
%        --- Microcom AX/9624c --------------
% Modem init |AT&F|~~~AT&D2&C1E0S0=1H0M0X4V1\N1&W|~~~AT|
%
%
%        --- Hayes 2400 ------------------------
% Modem init |AT&F&D2&C1E0S0=1H0M0X1V1|
%
%            NOTE: Some Hayes 2400 modems require need this added to
%                  the beginning of the above line: |~ATZ|
%
%
%        --- Hayes 1200 ------------------------
%        --- Hayes 1200B -----------------------
%        --- Anchor Internal -------------------
% Modem init |ATQ0E0S0=1H0M0X1V1|
%
%        --- AT&T 4024
% Modem init ATZ|ATE1H0M0Q0V1X4&C1&D1&G2&L&M&R1S0=1S7=60|
%
%        --- Anchor Mark XII -------------------
% Modem init ATE0V1S0=1|
%
%        --- MultiTech Multimodem 2400 (MNP) ---
% Modem init ATB0&Q0E0S0=1M0Q0X1V1|
%
%        --- Prometheus Promodem ---------------
% Modem init |ATQ0E0S0=1H0M0X1V1|
%
%        --- NetComm 2400, 123A, 1234A, etc ----
% Modem init |AT&D1&C1E0S0=2H0M0X1V1B15&W|
%
%        --- Capetronics & Avatex 1200HC
% Modem init |AT~Q0~E0~S0=1~H0~M0~X1~V1|
%
%        --- Hayes V-Series 9600 ---------------
% Modem init |ATM0&F&D2&C1E0S0=1H0M0X1V1|
%
%            NOTE: The Hayes V-Series modems are NOT
%                  recommended for use with Opus.
%
%
%
%
%
%      * COMPUTER-TO-MODEM INTERFACE
%
%        Some modems like to talk to computers at a constant speed.
%        This speed is maintained regardless of the baud rate of
%        a connection.  The modem worries about the connection's
%        baud rate.
%
%        To enable a constant baud rate for the computer-to-modem
%        interface, put this in your control file:
%
% Modem STEADY
%
%        With this feature enabled, Opus will always set the
%        communications port to the baud rate specified by the
%        baud statement in your control file.
%
%        Please refer to your modem manual.  Normally, using a
%        steady interface baud rate requires special handshaking
%        (eg. CTS).
%
%
%
%
%
%      * DIALING
%
%        When Opus needs to place a call, it will send three pieces of
%        information to your modem:  the dial "prefix", the phone number,
%        and the dial "suffix".
%
%        In most cases, the prefix is just the standard dial command:
%
Modem dial prefix ATDT,,
%
%        The commas are to allow enough time to get a dial tone.  You
%        may or may not need them.
%
%        And the suffix will normally be a carraige return:
%
Modem dial suffix |
%
%
%
%
%
%      * SETUP THE PORT
%
%        The command `keyboard' is practically useless because Opus lets
%        you get into keyboard mode ("test mode") at any time.
%
%        Please note that Opus uses a "FOSSIL" type program to talk to
%        your modem.  Not all FOSSILs support all 16 available ports.
%
%        If you leave all 17 of these items commented-out, then Opus
%        will use COM1:.
%
% Keyboard               % Use the sysop's keyboard instead of modem
Modem COM1               % Use Comm Port #1  <-- DEFAULT: used if all have `%'
% Modem COM2             % Use Comm Port #2
% Modem COM3             % Use Comm Port #3
% Modem COM4             % Use Comm Port #4
% Modem COM5             % Use Comm Port #5
% Modem COM6             % Use Comm Port #6
% Modem COM7             % Use Comm Port #7
% Modem COM8             % Use Comm Port #8
% Modem COM9             % Use Comm Port #9
% Modem COM10            % Use Comm Port #10
% Modem COM11            % Use Comm Port #11
% Modem COM12            % Use Comm Port #12
% Modem COM13            % Use Comm Port #13
% Modem COM14            % Use Comm Port #14
% Modem COM15            % Use Comm Port #15
% Modem COM16            % Use Comm Port #16
%
%
%
%
%
%
%      * LOOKING BUSY
%
%        Sometimes the system needs to appear busy to a caller.  Maybe
%        is automatically unpacking and tossing inbound echomail, or maybe
%        you are using the system in keyboard mode.
%
%        To look busy, Opus will send a command to your modem.  The
%        command can use the special characters (v,^,| and ~) listed
%        with the modem initialization sequences.
%
%        To stop looking busy, Opus will lower then raise DTR and send
%        the modem initialization sequence (above).
%
%        There are two ways to look busy:
%
%                 DROPPING
%                 DTR      The "official" way of doing things.  The modem
%                          is rendered incapable of answering the phone.
%                          A caller gets no answer.
Modem Busy v
%
%
%                 GOING
%                 OFFHOOK  Plan "B" is to take your modem off hook, which
%                          is like picking up a telephone handset and
%                          setting it on the table.  Callers get a busy
%                          signal.  Although this method is friendlier to
%                          callers (because they know the system is busy
%                          instead of broken), some telephone equipment
%                          prevents using this method.
%Modem Busy v~^~~ATH1M0|v
%
%                          Plan "B 1/2" is for modems (eg. TrailBlazer)
%                          that go OnHook when DTR is dropped.  If you
%                          have such a modem, use this:
%Modem Busy v~^~~ATH1M0|
%
%
%
%
%
%
%      * MASKS
%
%        A `mask' is a computer term.  Because this really isn't a
%        computer class, the term won't be explained.  Unless you have
%        a special circumstance or unusual equipment, you will NEVER
%        need to use a mask.
%
%        Opus supports two hardward masks:
%
%
%
%        CARRIER MASK
%
%        The default line mask for carrier detect is 128 (80h).  You can
%        set that to some other value if you need to.  Use one of the
%        following lines.  Note that all values are in base 10 (decimal).
%
% Mask CARRIER 1
% Mask CARRIER 2
% Mask CARRIER 4
% Mask CARRIER 8
% Mask CARRIER 16
% Mask CARRIER 32
% Mask CARRIER 64
Mask CARRIER 128           % <--- This is the default value
%
%
%
%
%        HANDSHAKING
%
%        Hardware handshaking is a way for your computer and your modem
%        to keep in sync with each other.  It's also used between remote
%        systems.  Most modems that run faster than 2400 baud require
%        CTS/RTS hardware handshaking.
%
%        You can use any combination of XON, CTS, and DSR (Data Set
%        Ready).  If you need to have more than one type, put several
%        handshaking declarations in the control file.  Do NOT put more
%        than one declaration on a single line!
%
%        IMPORTANT: This mask also effects the user's ability to use
%                   control-S and control-C.  If you have a modem that
%                   requires CTS or DSR, it would be a good idea to use
%                   both CTS (or DSR) *and* XON.
%
%        For high-speed modems, you MUST use CTS and XON.  In addition,
%        your FOSSIL program needs to support CTS/RTS.  The FOSSIL programs
%        currently known to support RTS as well as CTS are as follows:
%        X00, and DECCOMM.
%
Mask HANDSHAKING Xon       % (this is the default)
% Mask HANDSHAKING Cts
% Mask HANDSHAKING Dsr
%
%
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% GETTING ALONG WITH OTHER SYSTEMS
% ---------------------------------------------------------------------
%
%
%
%      * MULTI-TASKING SUPPORT
%
%        Opus needs to waste time for various reasons. One such case is
%        when it's sitting around waiting for a caller.  If you are running
%        one of the supported multitaskers, you can tell Opus to release
%        some time to the system instead of grinding out processor
%        instructions to waste time.  This way, other tasks should perk up
%        and come close to optimal speed for your computer ... when Opus
%        doesn't really need to have its share of the "time-slice."
%
%        DoubleDos note: Do not expect this feature to work unless you
%                        have a relatively new release of DoubleDos.
%
%        Important:      As of this writing, Opus has not been tested
%                        under all of the multitaskers listed.  Just because
%                        a piece of software is listed does NOT mean there
%                        is any kind of claim that Opus will work with it.
%
% Multitasker DoubleDOS
% Multitasker DesqView
% Multitasker TopView
% Multitasker TaskView
% Multitasker MsWindows    % <--- NOT IMPLEMENTED: for future use only
%
%
%
%
%
%
%
%
%
%      * TASK NUMBER
%
%        For logging purposes you can include a "task number."  This
%        number is noted in the log file, but has no other effect on
%        the operation of the system.
%
% Task 1
% Task 2
%
%
%
%
%
%
%
%
%
%      * OTHER<tm> PROGRAMS AS OPUS FRONT-ENDS
%
%        If some program other than Opus is responsible for establishing
%        the phone connection, you must use the baud rate command-line
%        switch (below).  Other items are optional.
%
%
%                 COMMAND-LINE OPTIONS:
%
%                 -b1200   ... a command-line option that says there is a
%                              caller connected at 1200 baud.  Opus considers
%                              it an error to use this option when there is
%                              nobody on-line.
%
%                 -t30     ... a command-line option that tells Opus how
%                              many minutes until the next event.  This is
%                              a general over-ride for events.  If Opus
%                              finds an event that would come sooner than
%                              the time given on the command-line, Opus
%                              ignores the command-line `-t' option and goes
%                              for the internal event.  In this example,
%                              you would be telling Opus that there is an
%                              event in 30 minutes.
%
%                 -p1      ... a command-line option that tells Opus which
%                              communications port to use.  Two are currently
%                              supported: 1 and 2.
%
%
%        You can make Opus exit after a caller hangs up by using the EXIT
%        command.  The word `exit' should be followed by a number from
%        0 to 255.  The number will be the DOS ERRORLEVEL set when
%        Opus exits.  You should be aware that Opus uses the very lowest
%        numbers. To avoid confusion, don't pick an ERRORLEVEL less than 5.
%
Exit 5
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% JUST FOR SYSOPS
% ---------------------------------------------------------------------
%
%
%      * SYSOP'S NAME
%
%        The sysop's name.  Don't put any COMMENT material on the
%        line.  Just put the word `sysop' then your name.
%
%        Examples: Sysop Adam Bomb
%                  Sysop Ralph
%
%         +-- Put your name here... instead of mine!
%         |
%         v
Sysop Sysop
%
%
%
%      * SYSTEM NAME
%
%        The name of your bulletin board. Don't put any COMMENT material
%        on the line.  Just put the word `system' then the system's name.
%        Lines over 50 characters aren't acceptable.  Lines over 40
%        characters get a nasty message but are saved.
%
%        If you are in the matrix, do *not* put your matrix addresss
%        on this line.  That is added automatically by Opus.
%
%        Examples: System NachtVille Opus: proud WOC member
%                  System Ralph's Opus
%
%         +-- Put your board's name here... instead of the question marks.
%         |
%         v
System Ralph's Opus
%
%
%
%
%
%      * SYSTEM LOG
%
%        If you don't specify a log file, then there will be NO log!
%        The word on the left ("Log") is the command that tells Opus_Ctl
%        to expect the log name.  The rest of the line is the name of
%        the file you want Opus to use for logging.  This can be a
%        fully qualified name (ie. Drive/Path/Name/Extension).
%
Log C:\Opus\Opus.Log
%
%
%
%
%
%      * FEEDBACK
%
%        On the sysop's monitor and in the log, you can control the
%        amount of information included.  If you leave of the following
%        words `commented-out' then you will get a normal log.  If you
%        remove the percent sign from VERBOSE, the log will be a total
%        audit trail requiring lots and lots of disk space on a busy
%        system.  The TERSE log will show you only major events (eg.
%        User name change and serious system errors).
%
%        For a regular log, leave ALL of these lines commented.
%
Trace All            % Gives painfully tedious details on everything
% Verbose              % Means put lots of information in the log
% Terse                % Means do a brief sysop log
%
%
%
%
%
%      * SYSOP'S MONITOR MODE
%
%        With SNOOP, you can watch everything.  If you don't ask for SNOOP,
%        then all you'll see is a status screen. A `%' in front of `snoop'
%        disables SnoopMode.
%
%        If you leave SNOOP off then Opus puts additional status information
%        on the monitor.  With it turned on, most of that information is
%        supressed.
%
%        The recommended mode is to leave snoop OFF unless you need it
%        in a special case.
%
%        Note: you can also turn SNOOP on/off using a keyboard command.
%
% Snoop
%
%
%
%
%      * SYSOP'S MONITOR TYPE
%
%        There are currently two video types supported by Opus: Dos and
%        fOssil.  This list will grow.
%
%        Although it will probably work, running video through FOSSIL on
%        an IBM will most likely slow down the output slightly.  This is
%        *NOT* a reflection on anybody's FOSSIL program.  It is simply
%        that running video through FOSSIL adds an extra layer of code...
%        and unless the hardware more than makes up for the extra code,
%        it will always be counterproductive.
%
%        Using "DOS" also assumes the presence of the BIOS video
%        interrupt (Int 10h) and the availability of GET/SET CURSOR
%        POSITION services through that interrupt.  If your computer's
%        BIOS doesn't support these services, you will have to run video
%        through the FOSSIL program.
%
%
%
%        --- For those with IBMs and true compatibles.
Video IBM
%
%        --- For those running PC-DOS or MS-DOS
% Video DOS
%
%        --- For those running DEC Rainbows and other computers with
%            some fast Ansi system available through the FOSSIL program:
% Video FOSSIL
%
%
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% THE MATRIX
% ---------------------------------------------------------------------
%
%
%
%
%
%
%      * ZONE
%
%        You don't have to specify a zone unless you plan on doing
%        international netmail.
%
% Zone 1          % North America
Zone 2          % Europe
% Zone 3          % Australasia
% Zone 113        % The oZone
%
%
%
%
%      * ADDRESS
%
%        Specify your net and node with the following line:
%
Matrix Address 1/-1
%
%            Example:      Matrix Address 123/456
%
%        Make sure your address has numbers instead of "{your_net}"
%        and "{your_node}".
%
%        Matrix addresses are assigned by NET HOSTS.  The method for
%        getting a number is outside the scope of this file, but if you
%        can contact your NET HOST it's ok to ask dumb questions.
%        Even Net Hosts were novices once.
%
%        PLEASE DON'T USE AN ADDRESS NOT "ASSIGNED" TO YOU.  That will
%        only cause chaos in the matrix.
%
%        You can have as many as fifteen (15) network addresses.
%        Outbound matrix traffic will carry your primary address...
%        the first one declared in the control file.
%
%        Other addresses are used for inbound traffic.  Any messages
%        to a net/node not in your list of addresses will be marked
%        as IN TRANSIT.
%
%
%
%
%
%
%
%      * INBOUND TRAFFIC: Paths
%
%        This information is the stuff that's kept in the "MAIL.SYS"
%        file in other<tm> programs.
%
%
%        --- The path for incomming messages.  This information is also
%            in one of your SYSTEM?.BBS files, but having it here keeps
%            Opus from having to look through all those files.
%
Matrix Messages C:\Opus\Netm\
%
%
%        --- The path for incomming files.  Anything (eg. archived
%            echomail) received from a remote system will be put here...
%
Matrix Files C:\Opus\Netf\
%
%
%
%
%
%
%      * OUTBOUND TRAFFIC: Hold area
%
%        --- Outbound message bundles (".OUT" and ".FLO" files) must
%            be in their own sub-directory.  You should not store other
%            material in this area because Opus may react badly if it
%            finds files it can't handle.  If you do not plan to offer
%            outbound matrix traffic, comment out this path declaration.
%
%            IMPORTANT:   If you are using oMMM, this hold area must be
%                         on the same drive and Opus and oMMM.
%
%            IMPORTANT:   IT IS YOUR RESPONSIBILITY TO MAKE SURE THE PATH
%                         YOU DECLARE ACTUALLY EXISTS.
%
Matrix Hold_Area C:\Opus\Packets\
%
%
%
%
%
%      * OUTBOUND TRAFFIC: Being prepared
%
%        --- There is no internal bundler (the thing that maintains
%            message bundles destined for some other system).  You can
%            exit Opus with a pre-set ErrorLevel to call the bundler
%            program when the contents of the matrix area changes.
%
%            For example, if you call and enter a message into your
%            network area, Opus will exit with an ErrorLevel of 11
%            *after* you have ended your regular session...
%
% Matrix After Edit Exit 11
%
%
%
%
%
%      * OUTBOUND TRAFFIC: Methods
%
%        --- If you want no outgoing phone calls to be made, include
%            the following:
%
% Matrix Send NOTHING
%
%
%
%        --- To restrict calls to those with zero cost, you can include
%            the following command.  You need to be aware that this zero
%            cost is based on the COST field in your node list.  Normally
%            you set up this information using a program such as XLatList.
%
% Matrix Send LOCAL
%
%
%
%
%
%
%      * AMATEUR EMAIL NETWORK
%
Path NetInfo  C:\Opus\     % location of the NODELIST files
%
%
%
%
%
%      * CONTINUOUS INCOMMING MAIL
%
%        --- If you DON'T want to accept crash mail (network mail
%            sent outside of regular schedules), `uncomment' this:
% MATRIX Refuse crashmail
%
%
%        --- After Opus receives mail, you can exit the program with a
%            DOS ERRORLEVEL set.  This is for those who need to do
%            special message/file processing after an incomming packet.
%            The most obvious use is EchoMail's Scan.  The use of the
%            term "crashmail" in this case is a little mis-leading...
%            if you tell Opus to unpack messages using the `-u' option
%            on the command line, it will also exit after unpacking
%            if you have the following line uncommented.
% MATRIX After crashmail exit 6
%
%
%
%
%
%
%      * IFNA<tm> kludge display
%
%        --- The International FidoNet<tm> Association has devised a
%            way for systems using their amateur e-mail network to
%            talk with other programs.  You can set the priv.level allowed
%            to see that inter-program communication...
%
% MATRIX Kludge HIDDEN
% MATRIX Kludge SYSOP
% MATRIX Kludge ASSTSYSOP
% MATRIX Kludge EXTRA
% MATRIX Kludge PRIVEL
MATRIX Kludge NORMAL
% MATRIX Kludge DISGRACE
% MATRIX Kludge TWIT
%
%
%
%
%
%
%
%
%      * LZ MAIL (also called "ArcMail")
%
%        "LZ" stands for LEMPEL-ZIV.  It is a method for data compression.
%
%        --- When ArcMail is "crashed" to your board, you can tell Opus
%            to automatically extract the compressed packets.  If you
%            use this feature, the program ARCE must be available on
%            your DOS path.  ARCE is not Opus software, and is not
%            supplied with this system.
MATRIX Extract ArcMail
%
%
%
%        --- For those who don't have the memory to run ARCE, we have a
%            way to exit Opus after incomming ARCmail.  This can be used
%            in combination with the command-line option `-u' which tells
%            Opus to immediately try to unpack/toss messages.  Here's an
%            excerpt from a batch file to handle this:
%
%                          :Start
%                          Opus %1 %2 %3 %4 %5
%
%                          :Conditions
%                          if ErrorLevel 10 goto DoArc
%                          if ErrorLevel  1 goto End
%                          Goto Start
%
%                          :DoArc
%                          ARCE C:\OPUS\NETF\*.SU?
%                          if ErrorLevel 1 goto Monday
%                          del C:\OPUS\NETF\*.SU?
%
%                          :Monday
%                          ARCE C:\OPUS\NETF\*.MO?
%                          if ErrorLevel 1 goto Tuesday
%                          del C:\OPUS\NETF\*.MO?
%
%                          :Tuesday
%                          ARCE C:\OPUS\NETF\*.TU?
%                          if ErrorLevel 1 goto Wednesday
%                          del C:\OPUS\NETF\*.TU?
%
%                          :Wednesday
%                          ARCE C:\OPUS\NETF\*.WE?
%                          if ErrorLevel 1 goto Thursday
%                          del C:\OPUS\NETF\*.WE?
%
%                          :Thursday
%                          ARCE C:\OPUS\NETF\*.TH?
%                          if ErrorLevel 1 goto Friday
%                          del C:\OPUS\NETF\*.TH?
%
%                          :Friday
%                          ARCE C:\OPUS\NETF\*.FR?
%                          if ErrorLevel 1 goto Saturday
%                          del C:\OPUS\NETF\*.FR?
%
%                          :Saturday
%                          ARCE C:\OPUS\NETF\*.SA?
%                          if ErrorLevel 1 goto Unpack
%                          del C:\OPUS\NETF\*.SA?
%
%                          :Unpack
%                          Opus %1 %2 %3 %4 %5 -u
%                          Goto Conditions
%
%                          :End
%
%            Here's the command to tell Opus to exit after incomming ARCmail:
%
% MATRIX After Arcmail exit 10
%
%
%
%
%
%
%
%      * ECHOMAIL SUPPORT
%
%        Direct support for Jeff Rush's Echomail system.  These commands
%        apply only to message areas declared as Echo Areas using the
%        sysop-only `1' command.
%
%        --- When incomming Echomail messages arrive, you can tell Opus
%            to "toss" them to the correct message areas as it unpacks
%            the messages.  This is roughly the same thing that Jeff Rush's
%            TOSSMAIL program does ... but it saves time by avoiding a
%            temporary stop-over in your regular matrix message area.
%
MATRIX Toss Echomail
%
%
%        --- After a batch of echomail is received and tossed, you can
%            tell Opus to scan (build outgoing bundles).  This feature
%            requires MATRIX TOSS ECHOMAIL to be in effect.  It also
%            will expect to find a scan control file ("ECHO.CTL") on the
%            current DEFAULT sub-directory.  See the Opus documentation
%            for details on the control file.
%MATRIX Scan Echomail
%
%
%        --- After echomail is received and tossed (and possibly scanned),
%            you can tell Opus to exit for some external processing.  The
%            value (below) will be the DOS ErrorLevel used when Opus exits.
%ECHO Exit 12
%
%
%
%        --- To disable the "SEEN-BY:" route audit information, set the
%            minimum priv allowed to see the line to HIDDEN.  To let
%            everybody see the lines, uncomment the TWIT line.
%
% Echo Seenby HIDDEN
% Echo Seenby SYSOP
% Echo Seenby ASSTSYSOP
% Echo Seenby EXTRA
% Echo Seenby PRIVEL
Echo Seenby NORMAL
% Echo Seenby DISGRACE
% Echo Seenby TWIT
%
%
%
%
%      * EXTERNAL ECHO UTILITY CONTROL FILE
%
%        Opus will keep track of areas affected by inbound echomail
%        if you want.  This is handy when you use an external echomail
%        program that can use a control file to decide which areas to
%        work on.
%
%        The theory is that if there has been no incomming traffic
%        in an area, there is no reason to make such a program
%        go through the area looking for messages.  It is an
%        optimization scheme designed primarily for systems that
%        do high-volume echomail.
%
%        To enable the interface, use this:
%
%Matrix Log EchoMail
%
%        If enabled, Opus will create (or append) a file called
%
%                 ECHOTOSS.LOG
%
%        in the current sub-directory.  After echomail is tossed,
%        this file will contain a list of the echomail areas affected
%        by the toss.  This is the echomail area name... not the
%        message area sub-directory.  The areas will be one-to-a-line.
%
%        NOTE: This file is appended.  It will grow and grow until you
%              (or your echomail scan program) deletes it.
%
%        NOTE: Not all echomail scan programs can use such a file.
%
%
%
%
%
%
%
%      * PRE-DEFINED BEHAVIOR OF MATRIX MESSAGES
%
%        --- To get Opus to make a network message behave the way
%            you want, uncomment any of the following.  Note that only
%            one attribute can appear on a line, but you can have as
%            many lines as you need.
%
%            The last item one the line is an access level.  It is the
%            minimum privilege for the assumption to take effect.  For
%            example, the line "MATRIX ASSUME CRASH NORMAL" means that
%            all network messages entered by callers who access is
%            normal or above will be entering a CrashMail message.
%
%            If you leave all items commented-out, Opus assumes they
%            are HIDDEN.  In other words, unless you call in with a
%            HIDDEN access level, there will be no assumption.
%
%
%
%        --- For use with "continuous mail"
% Matrix Assume Crash Twit
% Matrix Assume Crash Disgrace
% Matrix Assume Crash Normal
% Matrix Assume Crash Privil
% Matrix Assume Crash Extra
% Matrix Assume Crash AsstSysop
% Matrix Assume Crash Sysop
%
%        --- To attach a file to a message
% Matrix Assume FileAttach Twit
% Matrix Assume FileAttach Disgrace
% Matrix Assume FileAttach Normal
% Matrix Assume FileAttach Privil
% Matrix Assume FileAttach Extra
% Matrix Assume FileAttach AsstSysop
% Matrix Assume FileAttach Sysop
%
%        --- To kill the message after it's sent
%            Note that there is NO slash in KillSent
%Matrix Assume KillSent Twit
%Matrix Assume KillSent Disgrace
%Matrix Assume KillSent Normal
%Matrix Assume KillSent Privil
%Matrix Assume KillSent Extra
%Matrix Assume KillSent AsstSysop
%Matrix Assume KillSent Sysop
%
%
%
%
%
%
%
%
%        --- Opus will ask about various things, if you want it to.
%            The "Private?" question depends on how you have the setting
%            for the message area itself (See the documentation for the
%            sysop-only command `1' for information on the behavior of
%            message areas.)  You can, however, get Opus to ask about
%            other message attributes which deal with matrix messages.
%            Only one attribute can appear on a line, but you can have
%            as many lines as you need.
%
%
%        --- For use with "continuous mail"
% Matrix Ask Crash Twit
% Matrix Ask Crash Disgrace
% Matrix Ask Crash Normal
% Matrix Ask Crash Privil
Matrix Ask Crash Extra
Matrix Ask Crash AsstSysop
Matrix Ask Crash Sysop
%
%        --- To attach a file to a message
% Matrix Ask FileAttach Twit
% Matrix Ask FileAttach Disgrace
% Matrix Ask FileAttach Normal
% Matrix Ask FileAttach Privil
Matrix Ask FileAttach Extra
Matrix Ask FileAttach AsstSysop
Matrix Ask FileAttach Sysop
%
%        --- To kill the message after it's sent
%            Note that there is NO slash in KillSent
% Matrix Ask KillSent Twit
% Matrix Ask KillSent Disgrace
Matrix Ask KillSent Normal
Matrix Ask KillSent Privil
Matrix Ask KillSent Extra
Matrix Ask KillSent AsstSysop
Matrix Ask KillSent Sysop
%
%
%
%
%
%
%
%
%
%
%      * MATRIX FILE REQUESTS
%
%        The following items deal with both WaZOO and BARK file
%        request methods.
%
%                 NOTE:  Opus only initiates a WaZOO request, but
%                        it can respond to incomming requests of
%                        either method.
%
%        Although most will enable/disable requests with a Z-EVENT, you
%        can also do it like this:
%
Matrix allow requests
%
%        You will need a file containing a list of files approved for
%        file requests.  This is a standard, garden-variety text file.
%        It MAY include wildcards.  Declare the file like this
%
Matrix okfile c:\opus\okfile.lst
%
%        Another declaration will generalize your list of available
%        files.  In other words, if somebody wants to know what you have
%        on-line that is available for requesting, the standard Opus
%        method is to request a file called FILES.  When Opus receives
%        a request for FILES, it will automatically transmit the
%        file you declare like this:
%
Matrix avail c:\opus\filelist.arc
%
%        One other special kind of requestable file is the ABOUT file.
%        It's normally going to be a short description of your system:
%        hours, "rules," and on and on.  The ABOUT file will be sent if
%        the file ABOUT is requested.  This is important: it will also
%        be sent if there is a request for a file that cannot be
%        fulfilled.
%
Matrix about c:\opus\about_me.doc
%
%
%        Do NOT put comments on the `okfile', `avail' or `about' lines!
%
%
%        PLEASE don't use the file names "FileList.Arc" or "About_Me.Doc."
%        The words FILES and ABOUT are "wildcards" to help make these two
%        kinds of transactions easy.  You never have to know what file to
%        request to get a list of files.  But... if you don't come up with
%        some creative name for the files, the convention of using FILES and
%        ABOUT doesn't make any sense.  Here are some examples:
%
%                   IT_FILE.LST     A FILES list for Inside Track BBS
%                   01240108.INF    An ABOUT file for 124/108
%                   POLEINFO.DOC    An ABOUT file for The P.O.L.E.
%
%
%
%
%
%      * MAIL ONLY
%
%        To disallow human callers totally, use the following line in
%        the control file:
%
% Matrix allow mail only
%
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% ABOUT CALLERS: in general
% ---------------------------------------------------------------------
%
%
%
%      * GRAPHICS
%
%        Set the minimum baud allowed to use graphics.
%        To totally disable graphics, set the baud rate to 32700.  If it
%        were my system, I sure wouldn't allow graphics for 300 baud'ers!
%        But it's not my system... do what you want.
%
%        Note: Don't use a baud rate above 32700 !
%
%        Note: Using graphics requires that an Ansi device driver be
%              installed on YOUR computer.  This is a temporary limitation.
%              Callers have the OPTION of using graphics.
%
% Graphics 32000
% Graphics 19200
% Graphics 9600
% Graphics 4800
% Graphics 2400
% Graphics 1200
Graphics 300
%
%
%
%
%
%
%      * MINIMUM BAUD FOR CALLERS
%
%        Just because the following lines are available does not mean that
%        anybody associated with Opus recommends that you use them.  If
%        you configure your system to require a mimimum baud rate, you
%        should also be prepared to listen to complaints.
%
% Minimum 19200           % Nobody let on-line less than 19.2 kilobaud
% Minimum 9600            % Nobody let on-line less than 9600 baud
% Minimum 4800            % Nobody let on-line less than 4800 baud
% Minimum 2400            % Nobody let on-line less than 2400 baud
% Minimum 1200            % Nobody let on-line less than 1200 baud
Minimum 300
%
%
%
%
%
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% ABOUT CALLERS: newcommers
% ---------------------------------------------------------------------
%
%
%      * LOGON TIME LIMIT
%
%        This may be the most mis-usable feature in the entire system.
%        If you decide to use it, you will have to put up with complaints
%        from Opus.  The regular time limit for logons is 10 minutes.  If
%        there are reason why you need to change that, there is something
%        wrong with your system's setup.  Nobody, but nobody, likes logons
%        that last a long time.  That said, here's how to change the default.
% Logon time 10
%
%
%
%
%      * SETUP THE LOGON
%
%        Controls how the system treats first time callers.
%        If you don't say anything about new callers, they
%        will be allowed on-line with a DISGRACE access.  The
%        system will refuse to go on-line if you tell it to
%        let new users on with a level greater than EXTRA.
%
% Logon level TWIT         % New callers are let on as Twit
Logon level DISGRACE     % New callers are let on as Disgrace
% Logon level NORMAL       % New callers are let on as Normal
% Logon level PRIVEL       % New callers are let on as Privel (DANGEROUS)
% Logon level EXTRA        % New callers are let on as Extra  (DANGEROUS)
% Logon PRE-REGISTERED     % No new callers are let on
%
%
%        VARIETIES OF LOGONS:
%
%        Public system:        Declare the logon level to be NORMAL
%
%        Public system
%        with a new user
%        questionnaire:        Declare the logon level to be NORMAL
%                              (or DISGRACE), and include the "Uses
%                              application"  line from the Support Files
%                              section (below).
%
%        Semi-private where
%        all the user gets on
%        the first call is an
%        application:          Declare the logon level to be PRE-REGISTERED,
%                              and include the "Uses application" line from
%                              the Support Files section (below).
%
%
%        Private system:       Declare the logon level to be PRE-REGISTERED,
%                              and don't have an application.  In this case,
%                              unknown callers will get a "This is a private
%                              system" message a few seconds before he/she
%                              is ignomineously disconnected.
%
%
%
%
%
%
%
%
%
%
%
%
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% ABOUT CALLERS: privilege levels
% ---------------------------------------------------------------------
%
%
%
%        Maximum duration for one call
%
Define TWIT       time  5
Define DISGRACE   time  15
Define NORMAL     time  60
Define PRIVEL     time  90
Define EXTRA      time 120
Define ASSTSYSOP  time 180
Define SYSOP      time 999
%
%
%
%
%        Maximum cumulative time allowed for one day
%        Also see the LOGON SUPPORT FILE "daylimit" (below)
%
Define TWIT       cume  10
Define DISGRACE   cume  30
Define NORMAL     cume 120
Define PRIVEL     cume 180
Define EXTRA      cume 240
Define ASSTSYSOP  cume 360
Define SYSOP      cume 999
%
%
%
%
%        Minimum baud rates to get on-line
%        See the LOGON SUPPORT FILE "tooslow" (below)
%
Define TWIT       logon baud 300
Define DISGRACE   logon baud 300
Define NORMAL     logon baud 300
Define PRIVEL     logon baud 300
Define EXTRA      logon baud 300
Define ASSTSYSOP  logon baud 300
Define SYSOP      logon baud 300
%
%
%
%
%        Minimum baud rates for file transfer
%        Also, see the FILE SECTION SUPPORT FILE "xferbaud" (below)
%
Define TWIT       file baud  300
Define DISGRACE   file baud  300
Define NORMAL     file baud  300
Define PRIVEL     file baud  300
Define EXTRA      file baud  300
Define ASSTSYSOP  file baud  300
Define SYSOP      file baud  300
%
%
%
%
%
%
%        Maximum number of kilobytes downloadable in a single day
%
Define TWIT       file limit  000
Define DISGRACE   file limit  10
Define NORMAL     file limit  800
Define PRIVEL     file limit  900
Define EXTRA      file limit  900
Define ASSTSYSOP  file limit  900
Define SYSOP      file limit  900
%
%
%
%
%
%
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% SUPPORT FILES
% ---------------------------------------------------------------------
%
%        The format used for each line is "SHOW WHAT FILENAME"
%
%        Each line here must begin with "Uses" or "File".  The word "USES"
%        means the file is mandatory and the system won't continue without
%        it. The word "FILE" is less severe: no check is made to see if the
%        file exists.
%
%        The file name can include a drive and/or path.  Any file extension
%        will be ignored... so you might as well save time and not type one.
%
%        The system allocates memory for this information depending on the
%        length of the data.  That means, if you have a memory problem you
%        should probably run everything in the default drive and NOT use
%        a drive or path.  The extra path information is mainly for those
%        who have special cases or run their system from a RamDisk.
%
%        In general, we've put the support files which don't change very
%        often into a sub-directory called MISC.  With this idea in mind,
%        you would find your QUESTIONNAIRE and your QUOTES files in the
%        Opus\Misc sub-directory... while your USER and ANSWER files would
%        be in the Opus sub-directory itself.  We did this so (1)you don't
%        have a zillion files in the Opus sub-directory to look at and
%        (2)Dos doesn't have a zillion files to scan to find the one
%        it needs.  Feel free to change this arrangement to suit your own
%        needs.
%
%
%
%
%
%        * SYSTEM-LEVEL SUPPORT FILES
%
%                 --- Path to the SYSTEM?.BBS and ????PRIV.BBS files
%                     Note the final backslash: it is NOT optional
Path system       C:\Opus\
%
%
%                 --- Miscellaneous file path.  Files such as F1.BBS, F2.BBS,
%                     ... F10.BBS, and the WHY_?.BBS files should be on the
%                     path you specify here.
Path FPath        C:\Opus\Misc\
%
%
%                 --- User records (names, passwords, etc)
%                     Note that Opus CAN share this file with other<tm>
%                     systems.
Uses password     C:\Opus\User
%
%
%                 --- The Event file
Uses schedule     C:\Opus\Sched
%
%
%
%
%
%
%        * LOGON SUPPORT FILES
%
%                 --- File shown before callers are asked their name
Uses logo         C:\Opus\Misc\logo
%
%
%                 --- File shown after a caller is logged on.
%                     NOTE: In Opus, the files NEWUSER2 and ROOKIE can
%                           replace this file in certain circumstances.
Uses welcome      C:\Opus\Misc\welcome
%
%
%                 --- File shown after a caller is logged on
%                     if the caller has been on 7 or fewer times.
%                     This is a new type of file not found in other systems.
%                     If present, it REPLACES the Welcome file for callers
%                     who are still relatively new to the board.
Uses rookie       C:\Opus\Misc\Rookie
%
%
%                 --- File shown after Welcome2 and available on the main
%                     menu.
Uses bulletin     C:\Opus\Misc\bulletin
%
%                 NOTE: In addition to these, you can have a special logon
%                       message directed at an individual.  Just put a file
%                       on your Opus sub-directory with the user's record
%                       number (eg "120.BBS" or "136.GBS") and the caller
%                       will see that file instead of the WELCOME file.
%                       If you use this, it is important that you realize
%                       that Opus begins its numbering with ZERO instead of
%                       ONE.  Bernie Lawrence's REMSYSOP program will tell
%                       you the user's number correctly.  If you use some
%                       other method, you need to be sensitive to our 0-based
%                       numbering system.  ALSO... if you sort your user
%                       file, you will have to manually adjust any custom
%                       logon file names.
%
%
% --------------------------
%
% NOTE:  The old "File appanswers" item is now obsolete and must be removed.
%
% --------------------------
%
%
%                 --- File shown to new users
%
Uses application C:\Opus\Misc\Qnopwd.bbs
%
%
%
%                 --- File shown to new users before the system asks
%                     for a password.  This probably should explain what
%                     a password is ... and go through any House Rules.
Uses newuser1     C:\Opus\Misc\newuser1
%
%
%                 --- File shown to new users before the bulletin file.
%                     This file REPLACES the Welcome file for first-time
%                     callers.
Uses newuser2     C:\Opus\Misc\newuser2
%
%
%                 NOTE: The newuser2 file is used on PRIVATE systems, too.
%                       Unlike other systems, its use here is based solely
%                       on the number of calls a user has made.
%
%                 --- Shown to users just before they are given the old
%                     ignomineous toodle-ooo for being on-line too long.
%                     After this file is shown, the system displays the
%                     precise numbers involved for evidence.
Uses DayLimit     C:\Opus\Misc\daylimit
%
%
%                 --- If a user isn't fast enough (baudwise) to get on-line
Uses TooSlow      C:\Opus\Misc\TooSlow
%
%
%
%
%
%
%
%        * LOGOFF SUPPORT FILES
%
%                 --- Before the standard "Goodbye... please hang up",
%                     you can execute a GBS/BBS file to send additional
%                     logoff information.
Uses ByeBye     C:\Opus\Misc\ByeBye
%
%
%
%
%
%
%
%
%
%
%        * FILES USED IN AND AROUND THE MAIN MENU
%
%                 --- File shown when E is fondled on the main menu
Uses edtorial     C:\Opus\Misc\edtorial
%
%
%                 --- File used in A)nswer-questionnaire on main menu
Uses questionnaire C:\Opus\Misc\question
%
%
% --------------------------
%
% NOTE:  The old "File answers" item is now obsolete and must be removed.
%
% --------------------------
%
%
%
%
%
%        * LORE: The Line-Oriented Editor
%
%                 --- Novice users are presented with this file when they
%                     get into the message editor.  It's instructions on
%                     using the editor.
File edit         C:\Opus\Misc\Editor
%
%
%                 --- Extra help for novice users who pick R)EPLACE
%                     command in the message editor.
File replace      C:\Opus\Misc\Rep_Edit
%
%
%
%
%
%
%
%
%
%
%        * EXTERNAL MESSAGE EDITOR
%
%
%        Opus supports an external message editor.
%
%        System memory may be a problem because editors often want
%        lots of RAM.  In my tests, there isn't enough memory to
%        run BRIEF with DoubleDOS.
%
%        If you use an external message editor, it will be available
%        to anybody who is SYSOP or HIDDEN.
%
%        To declare an external message editor for use while in
%        keyboard mode, put this in your control file:
%
%                 Editor <doscommand> %s
%
%        The "<doscommand>" is the name of the program with any
%        parameters.  You cannot call a batch file here.
%
%        The "%s" is required.  Opus will substitute a file name
%        where it finds the percent-S.  For example, if your editor
%        takes a command line switch "-f" for filename... you could
%        put "-f%s" in the control file line...
%
% Editor C:\Brief\B -t -z -r -a -e -L43 %s
%
%
%        If you want to use your external message editor ON-LINE as
%        well as in keyboard mode, put an exclamation point in front
%        of the <doscommand>.
%
%                 EXAMPLE:
%
% Editor !D:\Myeditor %s
%
%
%        If you absolutely must use a batch file, you can do something
%        like this:
%
% Editor C:\COMMAND.COM editor.Bat %s
%
%
%
%                 TECHNICAL NOTE:  The "%s" isn't absolutely necessary.
%                                  Opus will look for a file called
%                                  "MSGTMP" in the default sub-directory.
%
%                                  The program flow looks like this:
%
%                                            1. execute the program named as
%                                               the external editor program.
%
%                                            2. convert MSGTMP to a message.
%
%                                  The point is that you don't actually
%                                  have to go to an editor.  You can execute
%                                  any program.  If MSGTMP exists when the
%                                  program finishes, Opus will turn it into
%                                  a message.
%
%
%
%
%
%
%        * MESSAGES CREATED FROM DISK FILES
%
%          --- You can enable a yes/no type question that says
%              "Create the message from a file?".  Answering YES will
%              let you type the name of a text file instead of going to
%              the message editor.  You cannot enable this question for
%              any priv lower than EXTRA
%
%              If you don't specify any item, Opus will set the question
%              to SYSOP.
%
% Matrix Ask FromFile Sysop
% Matrix Ask FromFile AsstSysop
% Matrix Ask FromFile Extra
%
%
%
%
%
%
%
%
%        * MESSAGE SECTION SUPPORT FILES
%
%                 --- Extra help for the message I)nquire command
Uses Inquire      C:\Opus\Misc\inquire
%
%                 --- When a user needs to list your message areas, Opus
%                     can get the list from one of 3 places: the subdirectory
%                     name (See "Show SubDirectory Name" below), from
%                     individual description files in each subdirectory
%                     ("Dir.Bbs" files), or from a single file.  To use the
%                     single file for message area listings, uncomment the
%                     following line and prepare a MSGAREA.BBS (or GBS)
%                     file.  Note that this does NOT do away with the
%                     need for a Dir.Bbs file.  Opus still needs that file
%                     for other reasons.  This single file is for listing
%                     speed/efficiency and for general creativity.
% Uses msgarea C:\Opus\Misc\MsgArea
%
%
%
%
%
%
%
%        * FILE SECTION SUPPORT FILES
%
%                 --- Extra help for the file L)ocate command
Uses Locate       C:\Opus\Misc\locate
%
%
%                 --- Extra help for the file C)ontents command
Uses Contents     C:\Opus\Misc\contents
%
%
%                 --- If a user isn't fast enough for file transfer
Uses XferBaud     C:\Opus\Misc\XferBaud
%
%                 --- The file area listing file looks like the following.
%                     It does for file areas what "msgarea" (above)
%                     does for message areas.
% Uses filearea C:\Opus\Misc\FileArea.Bbs
%
%
%
%
%
%
%        * MISCELLANEOUS
%
%                 --- A file containing pearls of wisdom.
%                     Material is used based on embedded characters in
%                     other BBS/GBS files.  There is no automatic display
%                     of a quote.  See the sysop docs for information on
%                     embedded control characters in BBS/GBS files.
Uses quotes       C:\Opus\Misc\quotes
%
%
%
%                 --- Warn the user that his/her time is almost gone
Uses TimeWarn     C:\Opus\Misc\timewarn
%
%
%
%
%
%
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% OUTSIDE AND THE ZERO COMMAND
% ---------------------------------------------------------------------
%
%        There are two ways outside of Opus: the O)utside command on the main
%        menu and the 0-command available to sysops on any menu.  Each of the
%        items below require additional information. EXIT needs an errorlevel.
%        DOS needs a Dos command of some sort.  CHAIN and RUN should have the
%        name of a program on your path with any optional parameters required.
%
%        NOTE: These are all risky and require lots of memory.
%              The preferred method is "run".
%
%        NOTE: Don't expect anything other than EXIT to work with DOS 2.
%
%
%                          EXIT  ... terminate Opus with a Dos ErrorLevel set
% Outside Exit  5
%
%                          CHAIN ... pass control to another program
% Outside Chain prgmname
%
%                          DOS   ... do any Dos command (uses Command.Com)
Outside Dos User.Bat
%
%                          RUN   ... "spawn" a child process then return
% Outside Run   prgmname
%
%
% Zero Exit     50
% Zero Chain    prgmname
Zero Dos Sysop.Bat
% Zero Run      prgmname
%
%
%
%
%
%
%        You can tell OPUS to setup your computer to reboot when the
%        carrier is lost while doing some outside function.  Do NOT
%        use this function when running under a multi-tasking operating
%        system or operating system enhancement (eg. DoubleDos).  This
%        funcionality is sometimes called "WatchDog".
%
% Reboot on carrier loss
%
%
%
%
%
%                 --- Displayed before a user goes O)utside
Uses Outside    C:\Opus\Misc\Leaving
%
%
%                 --- Displayed after a user returns from O)utside on the
%                     RUN and DOS methods of Outside.
Uses Return     C:\Opus\Misc\Return
%
%
%
%
%
%
%
%
%
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% MESSAGE SECTION: miscellaneous matters not covered elsewhere
% ---------------------------------------------------------------------
%
%      * MESSAGE AREA MAINTENANCE
%
%        If your disk drive is short on free space, you may want to
%        encourage or even force received private messages to be deleted.
%        These commands apply only to PRIVATE messages which have been
%        RECEIVED.  Only one of the following should be `uncommented.'
%
%        --- To force deletion of all private messages immediately after
%            the recipient reads the message:
% Kill Always
%
%
%        --- To get Opus to ask the user if it's okay to delete a private
%            message to him/her:  (A sender also gets this message after
%            reading a message already read by the recipient.)
Kill Ask
%
%
%        --- To avoid the whole issue:
% Kill Never
%
%
%
%
%
%      * MESSAGE SECTION OUTSIDE MAINTENANCE PROGRAM
%
%        This is the program used for the "o" command on the message
%        section menu.
%
% External Message_Management C:\OPUS\Msg_Mgt.Exe
%
%
%
%
%
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% FILE SECTION: miscellaneous matters not covered elsewhere
% ---------------------------------------------------------------------
%
%      * UPLOADED FILE DATES
%
%        Upload dates can be automatically handled by the system using
%        the file date.  If you want, you can tell Opus to physically
%        insert the upload date into FILES.BBS ... or totally ignore
%        the file date.
%
%        Automatic dating means that no date is in the FILES.BBS file.
%        Instead, Opus uses the file date from the DOS directory for
%        file listings.  This also enables the NEW FILES feature: an
%        asterisk by the date if the file was added since the caller's
%        last session.
%
%        To use automatic dating, do NOTHING here.  All statements should
%        be `commented out'.
%
%        To have Opus insert the upload date into FILES.BBS, uncomment
%        one of these lines.
%
% date yymmdd
% date mm/dd/yy
% date mm-dd-yy
% date dd mmm yy
% date dd mmm yyyy
%
%
%        If you want to completely ignore file dates (no display, nothing
%        in FILES.BBS, uncomment the following:
%
% date none
%
%
%
%
%      * EXTERNAL FILE TRANSFER PROGRAMS
%
%        The current version of Opus uses some stand-alone programs for
%        some file transfer protocols.
%
%        If you do not care to support these protocols, make sure the
%        lines are commented out.
%
%        Opus itself comes with absolutely no guarantee or warranty, and
%        the use of any stand-alone program has even less of a guarantee.
%        These programs cannot be expected to operate correctly on all
%        computers.
%
%        Do NOT put comments after the program name!
%
External Protocol C:\Opus\CKermit.Exe
%
External Protocol C:\Opus\WXmodem.Com
%
External Protocol C:\Opus\Dsz.Com
%
%
%
%
%      * FILE SECTION OUTSIDE MAINTENCE PROGRAM
%
%        This is the program used for the "o" command on the file
%        section menu.
%
% External File_Management C:\Opus\File_Mgt.Exe
%
%
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% TIME AND DATE
% ---------------------------------------------------------------------
%
%        When OPUS needs to display a time or date, you have control
%        over its appearance.  The method will be familiar to "C"
%        programmers.  It should be fairly easy for everybody else.
%
%        CURRENTLY ONLY MESSAGE DATES USE THIS METHOD, but Opus will
%        be using the date and time "control strings" more and more.
%
%
%                 TO "C" PROGRAMMERS: This just *looks* similar to
%                                     `printf()' commands.  It isn't.
%                                     Do not use `%' commands other
%                                     than the ones listed.
%
%
%        In a nutshell, you will give Opus a "control string" to use
%        in displaying the time and date.  Each piece of a time or date
%        is represented by a two character control command.
%
%        All control commands begin with the percent sign.
%
%        These control strings CAN contain almost any other text type
%        information.  Anything other than the control commands will
%        be used verbatim.
%
%        ALL CONTROL COMMANDS MUST BE UPPERCASE CHARACTERS.
%        --------------------------------------------------
%
%        Here is a list of the available commands:
%
%                 %A ... display "am" or "pm" as appropriate
%
%                 %B ... display the month as a digit
%
%                 %C ... display the month as a 3-character abbreviation
%
%                 %D ... display the day
%
%                 %E ... display the hour (12-hour clock)
%
%                 %H ... display the hour (24-hour clock)
%
%                 %M ... display the minutes
%
%                 %S ... display the seconds
%
%                 %Y ... display the year (2-digits)
%
%                 %% ... display a percent sign
%
%        EXAMPLES:
%
%                 Control string             Sample output     Notes
%                 ------------------------------------------------------------
%                 %D-%C-%Y                   09-Mar-87         garden variety
%
%                 %Y%B%D                     870309            scientific
%
%                 %D/%B/%Y                   09-03-87          European
%
%                 %D:%B:%Y                   09:03:87          Japanese
%
%                 %H:%Mcst                   14:30cst          24-hour clock
%
%                 %E:%M%A                    02:30PM           12-hour clock
%
%                                                              no date wanted!
%
%
Format DATE %D-%C-%Y
%
Format TIME %E:%M%A
%
%
%
%
%
%
%
%
%
%
%
%
%
%
% ---------------------------------------------------------------------
% TRULY MISCELLANEOUS: no other spot
% ---------------------------------------------------------------------
%
%      * MESSAGE/FILE AREA LISTINGS
%
%        There are three methods Opus can use when a user wants a listing
%        of your message or file areas:
%
%                 1. Show a single file.  See MESSAGE SUPPORT FILES and
%                    FILE SUPPORT FILES (above)
%                 2. Individual DIR.BBS files like Fido<tm> 11w uses.
%                    This is the method Opus uses when you don't ask for
%                    one of the other methods.
%                 3. Sub-directory names.
%
%        If the next line has no percent sign, then message
%        and file areas will be shown using the name of the
%        sub-directory.  If this line is `commented out' then
%        the system will display the file DIR.BBS located in
%        each sub-directory as the description of the area.
%        (See also "Uses MsgArea" and "Uses FileArea" above)
%
% Show subdirectory names
%
%
%
%
%      * PATH FOR TEMPORARY STORAGE
%
%        This is a path for Opus to use to store temporary files.  If you
%        have a RAM disk, it's a good idea to point TEMP to it.
%
%        The TEMP path is fairly important if you allow such things as
%        uploading messages.  Because of the nature of uploads, you should
%        make this a path that doesn't contain anything sensitive.  In other
%        words, this sub-directory is "fair game."
%
%        NOTE: It is YOUR responsibility to make sure that the sub-directory
%              exists.  On a RAM disk, this would mean a "MD" command in
%              your AutoExec.Bat file.
%
Path temp C:\Junk\
%
%        ...or...
%
% Path temp d:\stuff\
%
%
%
%
%
%
% ---------------------------------------------------------------------
%
%    "Any philosophy that can be put `in a nutshell' belongs there."
%
%                                                   - Harris's Law
%                                                     The Book Of Rules
%
%
%                                     ###
 
