#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include "legible.h"


#define bit unsigned
   
#define  MAXLREAD  0x0a    /* Number of msg area pointers to maintain       */


/*--------------------------------------------------------------------------*/
/* The USER Structure                                                       */
/*--------------------------------------------------------------------------*/
struct   _usr
   begin
      char name[36];       /* Caller's first and last names                 */
      char city[36];       /* Caller's location                             */

      struct {             /* Last message read for the prior 10 areas      */
        word area;
        word msg;
      } lastmsg[MAXLREAD];

      char pwd[16];        /* Password                                      */
      word times;          /* Number of previous calls to this system       */
      int  help;           /* Help level (see below)                        */
      word tabs;           /* 0=transmit <sp> instead of <tab>              */
      word nulls;          /* Number of Nulls (delays) after <cr>           */
      word msg;            /* Last message area visited                     */
      bit  filler   : 3;
      bit  use_lore : 1;   /* Use the line-oriented editor */
      bit  more     : 1;   /* Wants the "MORE?" prompt                      */
      bit  ansi     : 1;   /* OPUS: set=wants Ansi                          */
      bit  kludge   : 1;   /* OPUS: set=used Opus before                    */
      bit  formfeed : 1;   /* OPUS: set=transmit <ff>, clear=ignore <ff>    */
      int  priv;           /* Access level (see below)                      */
      char ldate[20];      /* Date of previous date (AsciiZ string)         */
      int  time;           /* Time on-line so-far today                     */
      word flag;           /* Used to hold baud rate on O)utside command    */
      int  upld;           /* K-bytes uploaded, all calls                   */
      int  dnld;           /* K-bytes downloaded, all calls                 */
      int  dnldl;          /* K-bytes downloaded, today                     */
      word files;          /* Last file area visited                        */
      byte width;          /* Width of the caller's monitor                 */
      byte len;            /* Height of the caller's */
      int  credit;
      int  debit;
   end;



/*--------------------------------------------------------------------------*/
/* Access levels                                                            */
/* For information on how these are used in Opus, read the TechRef pamphlet */
/* called REF_PRIV.DOC and the sample control file called OPUS.CTL          */
/*--------------------------------------------------------------------------*/
#define  TWIT        0xFFFE
#define  DISGRACE    0x0000
#define  NORMAL      0x0002
#define  PRIVEL      0x0004
#define  EXTRA       0x0006
#define  ASSTSYSOP   0x0008
#define  SYSOP       0x000A
#define  HIDDEN      0x000B




/*--------------------------------------------------------------------------*/
/* User help levels                                                         */
/*--------------------------------------------------------------------------*/
#define  EXPERT      0x02  /* grizzled veteran, no menus at all             */
#define  REGULAR     0x04  /* experienced user, brief menus                 */
#define  NOVICE      0x06  /* Full menus plus additional hand-holding       */



extern int errno;

#include <ctype.h>




/*--------------------------------------------------------------------------*/
/* FANCY STR                                                                */
/* Standardize the case of a character string                               */
/*--------------------------------------------------------------------------*/
byte *fancy_str( value )
   byte *value;
   begin
      register byte *sptr;
      byte           lower      = 0;

      sptr = value;

      if (sptr) /* don't touch any NULL pointers */
         while ( *sptr )
            begin
               if (lower) *sptr = tolower( *sptr );
               else *sptr = toupper( *sptr );

               lower = ( isalnum( *sptr++ ) );
            end

      return( value );
   end /* fancystr */




/*--------------------------------------------------------------------------*/
/* MK_USER: main                                                            */
/*--------------------------------------------------------------------------*/
main(argc,argv)
   int    argc;
   char **argv;
   begin

      int         fh;
      struct _usr usr;

      cputs("MK_USER. Creates a User.Bbs file.\r\n");

      if (argc!=4)
         begin
            cputs("ERROR.  Usage: MK_USER firstname lastname password\r\n");
            exit(1);
         end

      memset( (char *)&usr, 0, sizeof(struct _usr) );

      sprintf( usr.name, "%s %s", argv[1], argv[2] );
      if (strlen(usr.name)>35)
         begin
            cputs("FIRST+LAST names must be 35 chars. or shorter.");
            exit(1);
         end
      fancy_str(usr.name);

      strcpy( usr.pwd, argv[3] );
      if (strlen(usr.pwd)>15)
         begin
         	cputs("PASSWORD must be 15 chars. or shorter.");
            exit(1);
         end
      fancy_str(usr.pwd);

      usr.help = NOVICE;
      usr.priv = SYSOP;
      usr.len  = 23;
      usr.width= 79;


      errno = 0;
      fh    = open("USER.BBS",O_CREAT|O_EXCL|O_BINARY|O_WRONLY,S_IREAD|S_IWRITE);
      if ((errno) or (fh<0))
         begin
         	perror("Can't create USER.BBS");
            exit(1);
         end


      write(fh, (char *)&usr, sizeof(struct _usr) );
      if (errno)
         begin
         	perror("Error writing USER.BBS");
            exit(1);
         end

      close(fh);
      if (errno)
         begin
         	perror("Error closing USER.BBS");
            exit(1);
         end

      cputs("USER.BBS created.\r\n");
      cprintf("Hello, %s.  Welcome to Opus-CBCS.\r\n", argv[1] );

   end


