
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "opusnode.h"
#include "onodesup.h"
#include "onode_v5.h"
#include "onodepwd.h"

#define BBSBUFSIZE 10
#define SYSBUFSIZE 10
#define IDXBUFSIZE 5

static struct _node node;

/*--------------------------------------------------------------------------*/
/* V5PARSEIT								    */
/*--------------------------------------------------------------------------*/

void v5parseit()

  {
   char *p;
   int i;
   char *pwdp;

   for (p = &buf[0];*p != '\0' && !isdigit(*p);p = stpblk(p))
     {

       for (i = 0;!isspace(*p);i++,p++)
	 special[i] = toupper(*p);
       special[i] = '\0';

       if (!strcmp(special,"HOST"))
	 is_host = true;

       else if (!strcmp(special,"REGION"))
	 is_region = true;

       else if (!strcmp(special,"COUNTRY"))
	 is_country = true;

       else if (!strcmp(special,"HUB") ||
		!strcmp(special,"IGATE") ||
		!strcmp(special,"OGATE") ||
		!strcmp(special,"GATE"))
	 {
	  if (!is_hub)
	    {
	     is_hub = true;
	     hub_count++;
	     skip_it = skip_it || skiphubs;
	    }
	 }

       else
	 {
	  cprintf("`%s'\n",special);
	  message("figure out meaning - skipping entry");
	  skip_it = true;
	 }

     }

   if (!skip_it)
     {
      sscanf(p,"%d %d %d %s %s %s",
	       &node.number,
	       &node.cost,
	       &node.rate,
	       name,
	       phone,
	       city );

      stccpy( node.name,   name,    19 );
      stccpy( node.phone,  phone,   39 );
      stccpy( node.city,   city,    39 );

      if (is_host)
	{
	  host	= node.net    = node.number;
	  node.number = 0;
	  net_count++;
	  strcpy( hostphone, node.phone );
	  cprintf("Network %d \r", node.net );
	}

      else if (is_region)
	{
	  host	 = node.net    = node.number;
	  node.number = -1;
	  region_count++;
	  strcpy( hostphone, node.phone );
	  cprintf("Region  %d \r", node.net );
	}

      else if (is_country)
	{
	  host = node.net    = node.number;
	  node.number = -2;
	  country_count++;
	  strcpy( hostphone, node.phone );
	  cprintf("Country %d \r", node.net );
	}

      /* insert node's password in city field */

      if ((pwdp = find_pwd(node.net,(node.number < 0 ? 0 : node.number))) 
	       != NULL)
	{

	 char *p1,*p2;

	 if (strlen(node.city) + strlen(pwdp) + 3 > sizeof(node.city))
	   /* city is too long */
	   {

	    if (!strcmp(pwdp,"="))
	      {
	       p1 = node.city + sizeof(node.city) - 1;
	       *p1-- = '=';
	       *p1 = '\0';
	      }
	    else
	      {
	       p1 = node.city + sizeof(node.city) - 1;
	       *p1-- = '\0';
	       p2 = pwdp + strlen(pwdp) - 1;
	       while (p2 >= pwdp)
		 *p1-- = *p2--;
	       *p1-- = '!';
	       *p1 = '\0';
	      }

	   }
	 else
	   {
	    if (!strcmp(pwdp,"="))
	      {
	       p1 = node.city + strlen(node.city) + 1;
	       *p1++ = '=';
	       *p1 = '\0';
	      }
	    else
	      {
	       p1 = node.city + strlen(node.city) + 1;
	       *p1++ = '!';
	       for (p2 = pwdp;(*p1 = *p2) != '\0';p1++,p2++)
		 ;
	      }

	   }
	}


     }

  }

/*--------------------------------------------------------------------------*/
/* MAKEV5								    */
/*--------------------------------------------------------------------------*/

void makev5()
  {

      char *bbs_buffer; /* for file i/o */
      char *idx_buffer;
      char *sys_buffer;

      errno = 0;
      bbs = fopen( bbsname, "r" );
      if ((!bbs) || (errno)) fatal("OPEN Nodelist.Bbs");

      bbs_buffer  = malloc(1024*BBSBUFSIZE);
      if (!bbs_buffer) fatal("allocate BBS buffer");
      setvbuf(bbs,bbs_buffer,_IOFBF,1024*BBSBUFSIZE);



      if (fixing)
         {

	    errno = 0;
            idx = fopen(idxname,"wb" );
            if ((!idx) || (errno)) fatal("CREATE Index");

	    idx_buffer	= malloc(1024*IDXBUFSIZE);
            if (!idx_buffer) fatal("allocate IDX buffer");
	    setvbuf(idx,idx_buffer,_IOFBF,1024*IDXBUFSIZE);

	    errno = 0;
            sys = fopen(sysname,"wb" );
            if ((!sys) || (errno)) fatal("CREATE .Sys file");

	    sys_buffer	= malloc(1024*SYSBUFSIZE);
            if (!sys_buffer) fatal("allocate SYS buffer");
	    setvbuf(sys,sys_buffer,_IOFBF,1024*SYSBUFSIZE);

	 }


      if (fixing)
	{

            node.number =  5;
            node.net    = host = -1;
            node.cost   =  0;
            node.rate   =  0;
            strcpy( node.name,  "Opus"                    );
            strcpy( node.phone, "! Rev.5"                 );
            strcpy( node.city,  "from The POLE of Dallas" );

	    errno = 0;
            fwrite(  (char *)&node.number,  2, 1, idx );
            fwrite(  (char *)&node.net,     2, 1, idx );

            fwrite(  (char *)&node,  sizeof(struct _node), 1, sys );
            if (errno) fatal("write your files");

	}


      while(!feof(bbs))
         {
            buf[0] = 0;

	    errno = 0;
	    fgets(buf,254,bbs);
            if (errno) fatal("read Nodelist.Bbs");

	    skip_it =
	    is_country =
	    is_region =
	    is_host =
            is_hub = false;

            memset( (char *)&node, 0, sizeof(struct _node) );
            node.net = host;

	    v5parseit();

	    if (!skip_it)
	      {
	       fix_underscore(node.name);
	       fix_underscore(node.phone);
	       fix_underscore(node.city);

	       if (phone_ok(node.phone))
		 {
		   node_count++;
		   if (fixing)
                     {
		      errno = 0;
		      fwrite(  (char *)&node.number,  2, 1, idx );
		      fwrite(  (char *)&node.net,     2, 1, idx );
		      fwrite(  (char *)&node,sizeof(struct _node),1,sys);
		      if (errno) fatal("write your files");
                     }
		   else printf("%3d/%-4d $%-3d %4d %s, %s, %s\n",
                               node.net,
                               node.number,
                               node.cost,
                               node.rate,
                               node.name,
                               node.phone,
                               node.city);
		 }

               else 
		 skipped++;

	      }

	    else
	      skipped++;
         }

      if (bbs)
         {
            fclose(bbs);
            chgfa(bbsname,0);
         }

      if (idx)
         {
            fclose(idx);
            chgfa(idxname,0);
         }

      if (sys)
         {
            fclose(sys);
            chgfa(sysname,0);
         }


  }

