/*--------------------------------------------------------------------------*/
/*               The Opus Computer-Based Conversation System                */
/*                                                                          */
/*       (c) Copyright 1987, Wynn Wagner III, All Rights Reserved           */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/* OPUSNODE: Node list compiler for Opus-Cbcs, v0.00                        */
/*                                                                          */
/* COMPILER: MicroSoft C, v4.00                                             */
/* Modified to use Lattice C, v.3.1 (3/10/87 Wes Cowley)		    */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/* NOTICES/WARNINGS/THREATS:                                                */
/*                                                                          */
/* This source code is NOT public domain.  It has a copyright.  You are     */
/* hereby given a limited license (permission) to use this source code in   */
/* any manner you see fit as long as you do not get any consideration other */
/* than goodwill from your efforts.  In other words, this material is not   */
/* available for use in any product that is sold (including so-called       */
/* ShareWare).	If you use this source code in any manner, then your end    */
/* result must be freely available.                                         */
/*                                                                          */
/* Also, you may not make money from the transfer of this source code.      */
/* In other words, you may not charge others for access to the material.    */
/* This includes transfer by diskette.  It also means that BBS's and other  */
/* systems which charge a fee are not allowed to keep this material on-line */
/* for download.                                                            */
/*                                                                          */
/* OPUS software is always free.  Period.  No exceptions.                   */
/*                                                                          */
/* Nothing in this file is warranted or guaranteed to do anything except    */
/* take up disk space.  If you cannot live without some warranty and/or     */
/* guarantee, them please don't use this material.                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/*==========================================================================*/
/*  U P D A T E   H I S T O R Y 					    */
/*--------------------------------------------------------------------------*/
/* 03/10/87: Modified to use Lattice C v3.1.				    */
/*	     Allowed processing of HUB entries. 			    */
/*	     Added -h option to prevent HUB entries from being written	    */
/*		    to output files.					    */
/*	     Released version 1.3.0 for testing.			    */
/*									    */
/* 03/28/87: Allowed handling (read ignoring) of IGATE, OGATE, and GATE     */
/*	     entries.	They are treated just like HUB entries at this	    */
/*	     point.							    */
/*	     Invalid node flags are no longer fatal.   This includes the    */
/*	     semicolon some people were complaining about...		    */
/*	     Code to parse the nodelist entries was moved out of main() to  */
/*	     parseit(). 						    */
/*	     Multiple node designators (a hub which is also a gate) are no  */
/*	     longer poison.						    */
/*	     Released version 1.3.1.					    */
/* 04/05/87: Added version 6 nodelist.sys support.			    */
/*	     Not all new fields are supported.				    */
/*	     Added -v option to select version of nodelist.		    */
/*	     Sent version 1.4.0 to Wynn & others for testing.		    */
/* 07/03/87: Added node level passwords.				    */
/*	     Sent version 1.4.2 to Vince				    */
/* 07/11/87: Fixed node level passwords.				    */
/*	     Sent version 1.4.3 to Vince				    */
/* 07/12/87: Added '=' password macro.                                      */
/*	     Sent version 1.4.4 to Vince				    */
/*==========================================================================*/

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "opusnode.h"
#include "onodesup.h"

#define version "1.4.4"

char  buf[255];

char pwd_name[80] = "OPUSNODE.PWD";
char        *bbsname       = "NODELIST.BBS";
char        *idxname       = "NODELIST.IDX";
char	    *sysname	   = "NODELIST.SYS";

char        *osidxname     = "OVERSEAS.IDX";
char	    *ossysname	   = "OVERSEAS.SYS";

int listversion = 5;

/*--------------------------------------------------------------------------*/
/* USAGE                                                                    */
/*--------------------------------------------------------------------------*/
void usage()
   {

      cprintf("Takes the file NODELIST.BBS and creates NODELIST.SYS and NODELIST.IDX.\n");
      cprintf("This program does NOT replace utilities such as `XLatlist'.  It is the\n");
      cprintf("Opus version of Fido<tm>'s or SEAdog<tm>'s `Compiling the Nodelist.'\n");
      cprintf("Those programs `compile' when you bring them up after changing the\n");
      cprintf("nodelist.  With Opus, it is a separate program.\n\n");

      cprintf("No guarantee of compatibility with other systems is made.\n\n");

      cprintf("Options:    -f ... fix the SYS/IDX files.\n");
      cprintf("                   Files are created only when you use this option.\n");
      cprintf("            -d ... display only\n");
      cprintf("            -s ... brief, only use systems with phone numbers that\n");
      cprintf("                   don't look `international'.\n");
      cprintf("            -o ... overseas only. Output=OVERSEAS.SYS/IDX\n");
      cprintf("            -h ... Do not output HUB entries.\n");
/*
      cprintf("            -v <n> Select nodelist version number\n");
      cprintf("                   Valid numbers are 5 and 6.\n");
      cprintf("                   Eg. -v 6 selects version 6\n");
      cprintf("                   Version 5 [default] is for Opus 0.00.\n");
      cprintf("                   Version 6 is for Opus 1.00.\n");
*/
      cprintf("\nNote:       The `-s' and `-o' options in OPUSnode are not\n");
      cprintf("            compatible with the XLatList `NODASH' option.\n");
      exit(1);

   }



/*--------------------------------------------------------------------------*/
/* PHONE OK                                                                 */
/*--------------------------------------------------------------------------*/
int phone_ok(p)
   char *p;
   {
      register int i;
      char *tp;

      if ((tp = strchr(p,'u')) != NULL || (tp = strchr(p,'U')) != NULL)
	{
	 tp = strlwr(strdup(tp));
	 if (strcmp(tp,"unpublished"))
	   strcpy(p,hostphone);
	 free(tp);
	}

        if (brief)
         {
	    i = strlen(p);
            if (i==8) /* local */
               {
		  if (	(isdigit(*(p+0))) &&
			(isdigit(*(p+1))) &&
			(isdigit(*(p+2))) &&
                        (isHYPHN(*(p+3))) &&
                        (isdigit(*(p+4))) &&
                        (isdigit(*(p+5))) &&
                        (isdigit(*(p+6))) &&
                        (isdigit(*(p+7))) )
                     return(1);
               }
            else if (i=14) /* long distance */
               {
                  if (  (isdigit(*(p+0))) &&
                        (isHYPHN(*(p+1))) &&
                        (isdigit(*(p+2))) &&
                        (isdigit(*(p+3))) &&
                        (isdigit(*(p+4))) &&
                        (isHYPHN(*(p+5))) &&
                        (isdigit(*(p+6))) &&
                        (isdigit(*(p+7))) &&
                        (isdigit(*(p+8))) &&
                        (isHYPHN(*(p+9))) &&
                        (isdigit(*(p+10))) &&
                        (isdigit(*(p+11))) &&
                        (isdigit(*(p+12))) &&
                        (isdigit(*(p+13))) )
                     return(1);
               	
               }
            else if (i=12) /* long distance */
               {
                  if (
                        (isdigit(*(p+0))) &&
                        (isdigit(*(p+1))) &&
                        (isdigit(*(p+2))) &&
                        (isHYPHN(*(p+3))) &&
                        (isdigit(*(p+4))) &&
                        (isdigit(*(p+5))) &&
                        (isdigit(*(p+6))) &&
                        (isHYPHN(*(p+7))) &&
                        (isdigit(*(p+8))) &&
                        (isdigit(*(p+9))) &&
                        (isdigit(*(p+10))) &&
                        (isdigit(*(p+11)))
                     )
                     return(1);
               }
            return(0);
         }
   	else if (overseas)
         {
	    i = strlen(p);
            if (i==8) /* u.s. local */
               {
                  if (  (!isdigit(*(p+0))) ||
                        (!isdigit(*(p+1))) ||
                        (!isdigit(*(p+2))) ||
                        (!isHYPHN(*(p+3))) ||
                        (!isdigit(*(p+4))) ||
                        (!isdigit(*(p+5))) ||
                        (!isdigit(*(p+6))) ||
                        (!isdigit(*(p+7))) )
                     return(1);
               }
            else if (i=14) /* u.s. long distance */
               {
                  if (  (!isdigit(*(p+0))) ||
                        (!isHYPHN(*(p+1))) ||
                        (!isdigit(*(p+2))) ||
                        (!isdigit(*(p+3))) ||
                        (!isdigit(*(p+4))) ||
                        (!isHYPHN(*(p+5))) ||
                        (!isdigit(*(p+6))) ||
                        (!isdigit(*(p+7))) ||
                        (!isdigit(*(p+8))) ||
                        (!isHYPHN(*(p+9))) ||
                        (!isdigit(*(p+10))) ||
                        (!isdigit(*(p+11))) ||
                        (!isdigit(*(p+12))) ||
                        (!isdigit(*(p+13))) )
                     return(1);
                 }
            else if (i=12) /* long distance */
               {
                  if (
                        (!isdigit(*(p+0))) &&
                        (!isdigit(*(p+1))) &&
                        (!isdigit(*(p+2))) &&
                        (!isHYPHN(*(p+3))) &&
                        (!isdigit(*(p+4))) &&
                        (!isdigit(*(p+5))) &&
                        (!isdigit(*(p+6))) &&
                        (!isHYPHN(*(p+7))) &&
                        (!isdigit(*(p+8))) &&
                        (!isdigit(*(p+9))) &&
                        (!isdigit(*(p+10))) &&
                        (!isdigit(*(p+11)))
                     )
                     return(1);
               }
            else return(1);
            return(0);
          } /* overseas */
 
     return(1);

   } /* phone ok */

/*--------------------------------------------------------------------------*/
/* MAIN                                                                     */
/*--------------------------------------------------------------------------*/
void main( argc, argv )
   int   argc;
   char *argv[];
   {

      int i;

      bbs            =
      idx            =
      sys            =  NULL;

      overseas       =
      brief          =
      fixing         =
      skipped        =
      net_count      =
      hub_count      =
      region_count   =
      country_count  =
      node_count     =  0;

      cprintf("OPUSnode [%s]  (c)Copyright 1986, Wynn Wagner III, All rights reserved.\n",version);
      if (argc<2) usage();

      for(i=0;i<argc;i++)
         {
	    char *sptr = argv[i];
            if (sptr[0]=='-')
               switch( toupper(sptr[1]) )
                {
			case 'F'  : fixing   = 1; break;
			case 'O'  : overseas = 1; break;
			case 'S'  : brief    = 1; break;
			case 'D'  :               break;
			case 'H'  : skiphubs = 1; break;
		      /*  case 'V'  : listversion = atoi(argv[++i]); break; */
               		default   : usage();
                } /* switch */
         }



      if ( (brief) && (overseas) ) 
	brief = overseas = 0;
      else if (overseas)
         {
         	
            idxname = osidxname;
            sysname = ossysname;

         }

      if (fixing)
	cprintf("Compiling version %d nodelist\n",listversion);

      if (brief)
	cprintf("Processing only national nodes\n");

      if (overseas)
	cprintf("Processing only international nodes\n");

      if (skiphubs)
	cprintf("Skipping hub entries\n");

      load_pwd(pwd_name);

      switch (listversion)
	{
	 case 5 : makev5(); break;
	 case 6 : makev6(); break;
         default : fatal("bad nodelist version!");
	}

      if (bbs)
         {
            fclose(bbs);
            chgfa(bbsname,0);
         }

      if (idx)
         {
            fclose(idx);
            chgfa(idxname,0);
         }

      if (sys)
         {
            fclose(sys);
            chgfa(sysname,0);
         }

      cprintf("Entries     %5d\n", node_count     );
      cprintf("Hubs        %5d\n", hub_count      );
      cprintf("Nets        %5d\n", net_count      );
      cprintf("Regions     %5d\n", region_count   );
      cprintf("Countries   %5d\n", country_count  );
      cprintf("Skipped     %5d\n", skipped        );
   }

