; Sample routing control file for a three-tiered mail network.
;
; This file is intended as a SAMPLE ONLY!  It is actually rather unlikely 
; that any real-world network actually matches this idealized structure.
;
; Examples will be given of the major routing structures, including the use 
; of conditional structures to allow one route file to serve for any node
; in the network.

Node 107/6                             ;Net address to create files for
SEAdog                                 ;Use SEAdog or Fido, as appropriate

; Define the major routing spots

define outbound 16                     ;Our outbound host

define NYChub 100                      ;New York City hub
define LIhub  200                      ;Long Island hub
define CNJhub 300                      ;Central New Jersey hub
define NNJhub 500                      ;Northern New Jersey hub

define hubs NYChub LIhub CNJhub NNJhub

; Define routing areas

define NYC hub-100                     ;New York City
define LI  hub-200                     ;Long Island
define CNJ hub-300                     ;Central New Jersey
define NNJ hub-500                     ;Northern New Jersey

; Define where we fit into the net

if node NYC
    define myhub NYChub
    define myarea NYC
else if node LI
    define myhub LIhub
    define myarea LI
else if node CNJ
    define myhub CNJhub
    define myarea CNJ
else if node NNJ
    define myhub NNJhub
    define myarea NNJ
endif


; Define global routing for all mail events.  WARNING: This only works with
; SEAdog.  Fido users should not have any routing statements before the
; first SCHEDULE statement.  Accordingly, we will make it conditional on
; being in SEAdog mode.

if SEAdog
    Pickup ALL
    Give-to ALL
endif


; Define routing for individual events.  We define five mail events, as follows:
;
;   Event H - 0300 to 0330 - Locals upload to hubs
;   Event G - 0330 to 0400 - Hubs upload to outbound gateway
;   Event T - 0400 to 0500 - National Mail Hour
;   Event V - 0500 to 0530 - Inbound gateway downloads to hubs
;   Event W - 0530 to 0600 - Hubs download to locals
;
; The definition presented here reflects the default routing already 
; understood for these route tags by SEAdog.  In other words, SEAdog 
; users don't need any of this, as it is already built into the SEAdog
; mail routing logic.


Schedule H                             ;Upload to hubs
    Send-to myhub
    if ogate
         Route-to myhub myarea
    else
         Route-to myhub ALL
    endif

Schedule G                             ;Upload to outbound gateway
    if hub
         Send-to outbound
         Route-to outbound ALL except myarea
    else if not ogate
         Send-to outbound
         Route-to outbound ALL
    endif

Schedule T                             ;National Mail Hour
    Send-to ALL
    if ogate
         Accept-from OURNET
    else if hub
         Accept-from myarea
    endif

Schedule V                             ;Download to hubs
    Send-to hubs
    Route-to NYChub NYC
    Route-to LIhub LI
    Route-to CNJhub CNJ
    Route-to NNJhub NNJ
    if ogate
         Accept-from OURNET
    else if host
         Accept-from ALL
    else if hub
         Accept-from myarea
    endif

Schedule W                             ;Download to locals
    Send-to OURNET
    No-route ALL
    if ogate
         Accept-from OURNET
    else if host
         Accept-from ALL
    else if hub
         Accept-from ALL
    endif


; That concludes default routing as understood by SEAdog.  Now we'll try a 
; few exotic examples, just to flex our muscles a bit.
;
; First we'll pull in a set of definitions to define a macro called LOCAL
; which contains a list of all nodes which are a local call.

include local                          ;Nodes in local calling radius


; Now we will conditionally define a schedule B in which we call direct any
; node which is a local call.

if any local
    Schedule B
         Send-to local
         No-route local
endif


; Now let's modify that a bit.  We'll define a Schedule C just like 
; Schedule B, but if any of our echomail partners are a local call,
; we'll poll them.

if any local
    Schedule C
         Send-to local
         No-route local

         if any local and list-AREAS.BBS
              poll local and list-AREAS.BBS
         endif
endif


; Here's a nifty alternative for nets with busy hubs.  Nodes that can do 
; continuous mail don't have to be called during Event W.  So we replace
; it with two events, as follows:
;
;   Event D - 0530 to 0600 - Hubs download to locals without continuous mail
;   Event E - 0600 to 1200 - Hubs download to locals with continuous mail
;
; Nodes with continuous mail can go back to BBS operation at 0530.  Others
; observe event D and go back to BBS operation at 0600.  Hosts and hubs
; observe both events.

define cmable net-107 and flag-#CM     ;Our guys with continuous mail ability

Schedule D
    Send-to net-107 except cmable
    No-route ALL
    if ogate
         Accept-from OURNET
    else if host
         Accept-from ALL
    else if hub
         Accept-from ALL
    endif

Schedule E
    Send-to cmable
    No-route ALL
    if ogate
         Accept-from OURNET
    else if host
         Accept-from ALL
    else if hub
         Accept-from ALL
    endif


; Here's a way to deal with all that echomail.  We define an event F during
; which we'll hold packets for any of our echopartners who have continuous 
; mail ability, and hence might call.  Meanwhile we'll go ahead and send to
; those which are a local call.

define contecho list-AREAS.BBS and flag-#CM

if any contecho
    Schedule F
         Send-to contecho
         No-route contecho
         Hold contecho except local
endif

