/* Consulair Mac C 1.0 for Apple Macintosh */

/* The open function WILL create a file if it is called with a write or 
   update mode. This causes CREIDX and CREDAT to fail because they test for 
   an existing file with the open function.  Therefore, in CREDAT & CREIDX 
   (CTKEYF.C) change the following:

   In CREDAT() change the two lines

	    if ((ctnum->vfd = mbopen(ctnum,filmod)) >= 0) {
		mbclos(ctnum,filmod);
	to
	    if ((ctnum->vfd = open(ctnum->flname,0)) >= 0) {
		close(ctnum->vfd);

   and in CREIDX() change the two lines

	    if ((knum->kfd = mbopen(knum,filmod)) >= 0) {
		mbclos(knum,filmod);
	to
	    if ((knum->kfd = open(knum->flname,0)) >= 0) {
		close(knum->kfd);

   **************************************************************************
   *** NOTE THAT THE ABOVE MODIFICATION DISABLES THE VIRTUAL FILE PROCESS ***
   *** DURING FILE CREATION. IF THIS IS A PROBLEM, THEN:                  ***
   ***                                                                    ***

	1) If you use the ISAM routines, change CTISMC.C so that each file is
	   closed (via CLSFIL) after it is created. Then CLISAM is not used 
	   after CREISAM.

	2) If you directly call CREDAT and CREIDX, then call CLSFIL after
	   each call to a create; unless a call to CREIDX is followed by
	   calls to CREMEM. In this case do not call CLSFIL until CREMEM
	   has been used for all additional members.

   ***                                                                    ***
   **************************************************************************


*/

/* In CTPORT.H change
			#define LOCAL static
   to
			#define LOCAL GLOBAL

   and change
			typedef unsigned VRLEN,UCOUNT;
   to
			typedef unsigned short VRLEN,UCOUNT;

** In CTSTDR.H change
			#define NULL ((char *) 0)
   to
			#define NULL 0L

** In CTOPTN.H change
			#define VARI_LEN ((sizeof(VRLEN) + sizof(LONG))
   to
			#define VARI_LEN 6

   and make sure
			#define HIGH_LOW
   is selected.

*/

#define MC
#define BUPDATE		2
#define BCREATE		0x70
#define C255		-1
