/*
 *	add key
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/

#ifdef VARLDATA
#include "ctvrec.h"
#endif

COUNT uerr(),putnod(),LOCK(),UNLOCK();

/* --------------------------------------------------------------------
   ADDKEY enters the key value pointed to by target into the index file
   specified by keyno and associates the value of recbyt with the key value.
   if successful, ADDKEY returns a value of zero. if the index already
   contains the key value, then a value of 2 (two) is returned and no
   change is made to the index file. values greater than 2 indicate an error 
   has occurred.
 */
   
COUNT ADDKEY(keyno,target,recbyt,typadd)

COUNT   keyno;
TEXT   *target;
POINTER recbyt;
COUNT   typadd;

{
	TEXT *idxval;
	FAST KEYFILE *knum;
	FAST TREEBUFF *buffer;
	COUNT npoint;
	LOCAL NODEPTR node;

	VOID stpntr(),prpdup();
	TEXT *valpnt();
	COUNT nodser(),insert(),adroot(),tstupd(),hdrupd();
	KEYFILE *tstknm();
	TREEBUFF *getnod(),*movrgt();
	NODEPTR gtroot(),nodpnt();

	uerr_cod = 0;	/* set user error cod to zero */
	if ((knum = tstknm(keyno)) == NULL) /* test for leagl keyno */
		return(uerr_cod);
	if (!recbyt)
		return(uerr(ZDRN_ERR));

	cpybuf((idxval = dupkey),target,knum->length);
	if (knum->autodup == DUPKEY)
		prpdup(idxval,knum,&recbyt);

	lnode = btlev = 0;

	if (!(node = gtroot(knum))) {	/* tree may be empty or gtroot err */
		if (uerr_cod || tstupd(knum) ||
		    adroot(knum,recbyt,DRNZERO,idxval) ||
		    hdrupd(knum,(POINTER) 1))
			return(uerr_cod);
		return(NO_ERROR);
	}

	while (node) {	/* walk down or across tree until leaf node found */
		lnode = node;
		if ((buffer = getnod(node,knum)) == NULL)
			return(uerr_cod);
		if (buffer->leaf == LEAF)
			break;

		if ((npoint = nodser(buffer,idxval,'L')) != -1) {
			if (npoint == -2)
				terr(218);
			npath[++btlev] = node;
			node = nodpnt(buffer,npoint);
		} else
			node = buffer->sucesr;
	}

	if (!node)	/* => no leaf node found */
		terr(219);

	if (LOCK(node,knum) ||
	    (buffer = movrgt(idxval,knum,getnod(node,knum))) == NULL)
		return(uerr_cod);
	if (!tstkey) {
		if (UNLOCK(buffer->nodeid,knum))
			return(uerr_cod);
		return(uerr(KDUP_ERR)); /* key already exists */
	}

	if (tstupd(knum) || insert(buffer,knum,idxval,recbyt,typadd) ||
	    hdrupd(knum,(POINTER) 1))
		return(uerr_cod);
	return(NO_ERROR);
}

/* --------------------------------------------------------------------
   insert key value & backtrack as necessary
*/

COUNT insert(buffer,knum,idxval,pntr,typadd)

PFAST TREEBUFF *buffer;
PFAST KEYFILE  *knum;
TEXT           *idxval;
POINTER         pntr;
COUNT           typadd;

{
	LOCAL COUNT     temp,spltel;
	LOCAL NODEPTR   node,oldnode;
	FAST TREEBUFF  *new;
	
	TREEBUFF *getnod(),*movrgt(),*newnod();
	COUNT     adroot();
	TEXT     *valpnt();
	NODEPTR   nodpnt();

again:
	temp = buffer->nkv + 1;

	/* for leaf nodes, if node already full, then must save high key.
	   (note that leaf holds maxkv-1 keys (besides high key))
	*/

	if (buffer->leaf == LEAF && temp == buffer->maxkv) /* move high key */
		cpybuf(valpnt(buffer,temp + 1),valpnt(buffer,temp), 
			knum->length);

	if (!elemnt) { /* then insert at end of node */
		cpybuf(valpnt(buffer,temp),idxval,knum->length);
		stpntr(buffer,temp,pntr);
	} else {
		updnod(buffer,buffer,0,elemnt+1,temp,-1);
		cpybuf(valpnt(buffer,elemnt),idxval,knum->length);
		stpntr(buffer,elemnt,pntr);
	}
	
	if (temp < buffer->maxkv || 
	    (temp == buffer->maxkv && buffer->leaf == NOLEAF)) {
		node = buffer->nodeid;
		if (putnod(buffer,temp) || UNLOCK(node,knum))
			return(uerr_cod);
		return(NO_ERROR);
	}

	if ((new = newnod(knum,&nwnod)) == NULL)
		return(uerr_cod);
	if (buffer->leaf == LEAF) {
		new->maxkv  = knum->maxkvl;
		if (knum->autodup == DUPKEY)
			new->confg = DUPLEAF;
		else
			new->confg = REGULAR;
	} else {
		new->maxkv = knum->maxkvn;
		new->confg = REGULAR;
	}
	if (typadd == REGADD)
		spltel = temp / 2;
	else if (typadd == INCADD)
		spltel = 6 * temp / 7;
	else
		spltel = temp / 7 + 1;
	cpybuf(spkey,valpnt(buffer,spltel),knum->length);
	updnod(buffer,new,1,1,temp - spltel,spltel);

	if (buffer->leaf == LEAF) { /* set high keys */

		/* copy over high key for new node */

		cpybuf(valpnt(new,temp),valpnt(buffer,temp + 1), 
			knum->length);

		/* spkey holds the high key for the oldnode */

		cpybuf(valpnt(buffer,temp),spkey,knum->length);
	}

	new->sucesr = buffer->sucesr;
	oldnode = buffer->nodeid;
	if ((new->leaf = buffer->leaf) == LEAF)
		new->predsr = oldnode;

	buffer->sucesr = nwnod;
	if (putnod(new,temp - spltel) || putnod(buffer,spltel))
		return(uerr_cod);
	if (new->sucesr && new->leaf == LEAF) {
		if (LOCK(new->sucesr,knum) ||
		    (buffer = getnod(new->sucesr,knum)) == NULL)
			return(uerr_cod);
		buffer->predsr = nwnod;
		if (putnod(buffer,buffer->nkv) || UNLOCK(new->sucesr,knum))
			return(uerr_cod);
	}

	idxval = spkey;
	pntr = oldnode;
	if (node = npath[btlev--]) { /* parent node exists, repeat process */
		if (LOCK(node,knum) ||
		    (buffer = movrgt(idxval,knum,getnod(node,knum))) == NULL)
			return(uerr_cod);
		if (nodpnt(buffer,elemnt) != oldnode)
			/*
			 * apparently we have encountered a prematurely
			 * terminated node split. parent does not have
			 * complete set of pointers. move right strategy
			 * avoids crash.
			 */
			pntr = nodpnt(buffer,elemnt);
			
		if (UNLOCK(oldnode,knum))
			return(uerr_cod);
		stpntr(buffer,elemnt,(POINTER) nwnod);
		goto again;
	} else { /* create new non-leaf root */
		if (UNLOCK(oldnode,knum) ||
		    adroot(knum,pntr,(POINTER) nwnod,spkey))
			return(uerr_cod);
	}
	return(NO_ERROR);
}


/* --------------------------------------------------------------------
   add new root to b-tree pointed to by knum. lpntr & rpntr are the left
   and right pointers associated with the key value pointed to by idxval.
 */

COUNT adroot(knum,lpntr,rpntr,idxval)

PFAST KEYFILE *knum;
POINTER lpntr,rpntr;
TEXT *idxval;

{
	FAST TEXT *tp;	
	FAST TREEBUFF *new;
	LOCAL COUNT i;

	VOID stpntr();
	TREEBUFF *newnod();
	TEXT *valpnt();
	COUNT redhdr(),wrthdr();

	if ((new = newnod(knum,&nwnod)) == NULL)
		return(uerr_cod);

	if (rpntr) { /* then non-leaf root; add adjacent max high key */
		new->leaf  = NOLEAF;
		new->maxkv = knum->maxkvn;
		new->confg = REGULAR;
		tp = valpnt(new,2);
		stpntr(new,2,rpntr);
	} else { /* leaf root (virgin tree) */
		new->leaf  = LEAF;
		new->maxkv = knum->maxkvl;
		if (knum->autodup == DUPKEY)
			new->confg = DUPLEAF;
		else
			new->confg = REGULAR;
		tp = valpnt(new,knum->maxkvl);
	}

	cpybuf(valpnt(new,1),idxval,knum->length);
	stpntr(new,1,lpntr);

/*
 * if additional key types are added to c-tree, then the following two
 * lines of code must be expanded to properly construct the highest
 * possible key value for each type of key, starting at the byte 
 * pointed to by tp.
 *
 */ 
	for (i = knum->length; i > 0; i--)
		*tp++ = 0xff;		/* create high key in new root */

	if (rpntr)
		i = 2;
	else
		i = 1;
	if (putnod(new,i))
		return(uerr_cod);

#ifdef FPUTFGET
	if (LOCK(NODEZERO,knum) || redhdr(knum - knum->kmem))
		return(uerr_cod);
#endif

	knum->root = nwnod;

#ifdef NOTFORCE
	/* no action needed */
#else
	if (wrthdr(knum))
		return(uerr_cod);
#ifdef FPUTFGET
	if (UNLOCK(NODEZERO,knum))
		return(uerr_cod);
#endif
#endif

	return(NO_ERROR);
}


/* --------------------------------------------------------------------
   routine to get next available node. 
*/

TREEBUFF *newnod(knum,pnode)

PFAST KEYFILE *knum;
NODEPTR *pnode;

{
	FAST TREEBUFF *buf;

	TREEBUFF *lrubuf();
	COUNT     redhdr(),wrthdr();
	NODEPTR   extfil();

#ifdef VARLDATA
	VHDR	  vrhdr;
	COUNT     putvhdr();
#endif


#ifdef FPUTFGET
	if (LOCK(NODEZERO,knum) || redhdr(knum - knum->kmem))
		return(NULL);
#endif

#ifndef VARLDATA
	/* no variable length data routine support */
	if (knum->clstyp == VAT_CLOSE)
		terr(225);
	else if (!(*pnode = extfil(knum,knum->recsiz))) {
#ifdef FPUTFGET
		UNLOCK(NODEZERO,knum);
#endif
		return(NULL);
	}
#else
	/* variable length data routines supported */
	if (knum->clstyp == VAT_CLOSE) {
		if (*pnode = extfil(knum,knum->recsiz + SIZVHDR)) {
			*pnode += SIZVHDR;
			vrhdr.recmrk = VNOD_FLAG;
			vrhdr.trclen = vrhdr.urclen = knum->recsiz;
			if (putvhdr(knum,*pnode,&vrhdr)) {
#ifdef FPUTFGET
				UNLOCK(NODEZERO,knum);
#endif
				return(NULL);
			}
		} else {
#ifdef FPUTFGET
			UNLOCK(NODEZERO,knum);
#endif
			return(NULL);
		}
	} else if (!(*pnode = extfil(knum,knum->recsiz))) {
#ifdef FPUTFGET
		UNLOCK(NODEZERO,knum);
#endif
		return(NULL);
	}
#endif

#ifdef NOTFORCE
	/* no action */
#else
	if (wrthdr(knum))
		return(NULL);
#ifdef FPUTFGET
	if (UNLOCK(NODEZERO,knum))
		return(NULL);
#endif
#endif

	if ((buf    = lrubuf(NULL)) == NULL)
		return(NULL);
	buf->nkv    = 0;
	buf->keyid  = knum->keynum;
	buf->klen   = knum->length;
	buf->nodeid = *pnode;
	buf->update = 'y';
	buf->predsr = buf->sucesr = NODEZERO;
	buf->bmem   = knum->kmem;
	return(buf);
}


/*
 *	add key
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
