/*
 *	build c-tree ISAM/REBUILD parameter file
 *
 *      Copyright (c) 1985 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

/*
 * Note that this version of CTBLDP does NOT allow you to change the
 * number of indices per data file when reviewing an existing parameter
 * file.
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/
#include "ctisam.h"		/* c-tree isam header		*/

TEXT inpbuf[128];

COUNT    getidxr(),getintr(),getdatr(),ierr(),getambr();
FILE    *fopen();
TEXT    *gets();

#define  OLD	0
#define  NEW	1


FILE    *efp,*nfp;
COUNT	 nbufs,idxs,old_idxs,nsecs,old_dats,dats,keycnt;

typedef struct ir {
	COUNT	idxn;
	TEXT	idxname[MAX_NAME];
	COUNT	idxl;
	COUNT	idxt;
	COUNT	idxd;
	COUNT	idxadd;
	UCOUNT	idxext;
	COUNT	idxmod;
	COUNT	idxnlf;
	COUNT	idxnlc;
	COUNT	idxseg;
	COUNT	segp[MAX_KEY_SEG];
	COUNT	segl[MAX_KEY_SEG];
	COUNT	segm[MAX_KEY_SEG];
	} IREC;

typedef struct dr {
	IREC   *datip;
	COUNT	datn;
	TEXT	datname[MAX_NAME];
	UCOUNT	datl;
	UCOUNT  datext;
	COUNT	datmod;
	COUNT	datidx;
	} DREC;

DREC ndv[MAXFIL],*d;
DREC odv[MAXFIL],*od;
IREC nxv[MAXFIL],*x,*y;
IREC oxv[MAXFIL],*ox,*oy;

COUNT getnum(pi)	/* returns YES for #, or NO for RETURN 	*/
UCOUNT     *pi;		/* assumes no negative numbers		*/
{
	FAST TEXT *tp;

	gets(inpbuf);
	if (inpbuf[0] == '\0')
		return(NO);

	*pi = 0;
	tp  = inpbuf;
	do {
		if (*tp >= '0' && *tp <= '9') {
			*pi *= 10;
			*pi += (*tp - '0');
		}
		tp++;
	} while (*tp);

	return(YES);
}	

main (argc,argv)
int   argc;
TEXT *argv[];
{
	COUNT yesno(),getparms();

	COUNT efile,all_parm;
	TEXT  ename[MAX_NAME];
	TEXT *em;

	printf("\n\nc-tree Parameter File Utility\n(c) 1985 FairCom\n");
	printf("\nVersion 4.1 Release C\n");

	if (argc > 1) {
		cpybuf(ename,*++argv,MAX_NAME);
		printf("\n\nExisting parameter file >> %s\n",ename);
		efile = YES;
	} else {
		printf(
"\n\nDo you wish to start with an existing parameter file? (y/n) >> ");
		efile = yesno();
	}
	if (efile) {
		do {
		    if (argc > 1)
			argc = 0;
		    else {
			printf(
"\n\nEnter name of existing parameter file >> ");
			gets(inpbuf);
			cpybuf(ename,inpbuf,MAX_NAME);
		    }
		    if ((efp = fopen(ename,"r")) == NULL)
			printf("\nCould not open %s.\n",ename);
		} while (efp == NULL);
		printf(
"\nDo you wish to examine the entire parameter file? (y/n) >> ");
		all_parm = yesno();
	} else
		all_parm = YES;
	printf("\n\n");

	getparms(efile,all_parm);
	printf("\n\nEnd of Parameter File Data");
	if (isam_err) {
		printf(" - Error #%d (%d).\n",isam_err,isam_fil);
		switch (isam_err) {
case IGIN_ERR:
			em = 
"Could not read first record of existing parameter file.\nSEE STARTUP GUIDE.";
			break;
case IFIL_ERR:
			em = 
"Too many data files and indices.\nIncrease MAXFIL in CTOPTN.H and recompile.";
			break;
case IDRI_ERR:
			em =
"Could not read Data Description record of exisiting parameter file.";
			break;
case IDRK_ERR:
			em =
"Too many indices defined for data file.\nIncrease MAX_DAT_KEY in CTOPTN.H and recompile.";
			break;
case IMKY_ERR:
			em =
"keyno parameter for Index Member does not equal host keyno + member number.";
			break;
case IKRS_ERR:
			em =
"Too many segments defined.\nIncrease MAX_KEY_SEG in CTOPTN.H and recompile.";
			break;
case ISRC_ERR:
			em =
"Could not read Segment Description record of exisiting parameter file.";
			break;
case IKRI_ERR:
			em =
"Could not read Index File Description record of existing parameter file.";
			break;
case ISLN_ERR:
			em =
"Sum of segment lengths does not match key length in existing parameter file.";
			break;
case IMRI_ERR:
			em =
"Could not read Index Member record of existing parameter file.";
			break;
default:
			em = "";
		}
		printf("\n%s\n",em);
		exit(0);
	} else
		printf(".\n");
	repparms();
}

COUNT yesno()
{
	for (;;) {
		gets(inpbuf);
		switch (inpbuf[0]) {
case 'y':
case 'Y':
			return(YES);
case 'n':
case 'N':
			return(NO);
default:
			inpbuf[0] = '\0';
		}
		printf("\nImproper choice. Try again (y or n)>> ");
	}
}


VOID iparm(ip,imin,imax,tp)
UCOUNT    *ip,imin,imax;
TEXT                   *tp;
{
	UCOUNT dflt,t;
	TEXT   c;

	dflt = *ip;
	t = 0;
	do {
		if (t)
			printf("*** Value must be between %u and %u ***\n",
				imin,imax);
		printf("%25s: default %8u : enter new value >> ",tp,dflt);
		if (getnum(ip) == NO) {
			*ip = dflt;
			break;
		}
		t++;
	} while (*ip < imin || *ip > imax);
}

VOID tparm(ip, tp)
TEXT      *ip,*tp;
{
	TEXT c;

	printf("%25s: [%14s] : enter new value >> ",tp,ip);
	gets(inpbuf);
	if (inpbuf[0])
		cpybuf(ip,inpbuf,MAX_NAME);
}

VOID repparms()
{
	COUNT i,j,k,l;
	TEXT pname[MAX_NAME];

	do {
		printf("\n\nEnter name for new parameter file >>");
		gets(inpbuf);
		cpybuf(pname,inpbuf,MAX_NAME);
		if ((nfp = fopen(pname,"w")) == NULL)
			printf("\nCould not open %s.\n",pname);
	} while (nfp == NULL);

	fprintf(nfp,"%d %d %d %d\n",nbufs,idxs,nsecs,dats);
	for (i = 0; i < dats; i++) {
		d = ndv + i;
		fprintf(nfp,"\n\n%2d %14s %5u %5u %2d %2d\n",d->datn,
		    d->datname,d->datl,d->datext,d->datmod,d->datidx);
		for (j = 0; j < d->datidx; j++) {
			x = d->datip + j;
			fprintf(nfp,
"\n\t%2d %14s %3d %d %d %2d %5u %2d %d %3d %2d\n",
x->idxn,x->idxname,x->idxl,x->idxt,x->idxd,x->idxadd,x->idxext,x->idxmod,
x->idxnlf,x->idxnlc,x->idxseg);
			for (k = 0; k < x->idxseg; k++)
				fprintf(nfp,"\t\t%3d %3d %d\n",x->segp[k],
				    x->segl[k],x->segm[k]);
			for (k = 1; k <= x->idxadd; k++) {
				y = x + k;
				fprintf(nfp,
"\t%2d                %3d %d %d             %d %3d %2d\n",x->idxn + k,y->idxl,
				    y->idxt,y->idxd,y->idxnlf,y->idxnlc,
				    y->idxseg);
				for (l = 0; l < y->idxseg; l++)
					fprintf(nfp,"\t\t%3d %3d %d\n",
					    y->segp[l],y->segl[l],y->segm[l]);
			}
			j += x->idxadd;
		}
	}
	fprintf(nfp,"\n\n");
	fclose(nfp);
}

VOID cpydat(dp, sp, len)
TEXT       *dp,*sp;
COUNT               len;
{

	while (len-- > 0)
		*dp++ = *sp++;
}

COUNT getparms(ef,ap)
COUNT          ef,ap;
{
    COUNT chk,datno,i,j,k,l,old_key;

    if (ef) {
	maxfil = MAXFIL;
	if (getintr(efp,&nbufs,&old_idxs,&nsecs,&old_dats))
		return(isam_err);
	for (i = 0; i < maxfil; ) {
		datmap[i]      = NO;
		keymap[i++][0] = -1;
	}
	keycnt = 0;
	for (i = 0; i < old_dats; i++) {
		d = odv + i;
		if (getdatr(efp,&d->datn,d->datname,
		    &d->datl,&d->datidx,&d->datext,&d->datmod))
			return(isam_err);
		d->datip = oxv + keycnt;
	
		for (j = 0; j < d->datidx; j++) {
			x = oxv + keycnt++;
			if (getidxr(efp,d->datn,j,&x->idxn,x->idxname,
			    &x->idxl,&x->idxt,&x->idxd,&x->idxadd,
			    &x->idxext,&x->idxmod))
				return(isam_err);
			old_key   = x->idxn;
			x->idxnlf = nulkey[old_key];
			x->idxnlc = nulchr[old_key];
			x->idxseg = MAX_KEY_SEG;
			for (k = 0; k < MAX_KEY_SEG; k++)
				if (segpos[old_key][k] < 0) {
					x->idxseg = k;
					break;
				} else {
					x->segp[k] = segpos[old_key][k];
					x->segl[k] = seglen[old_key][k];
					x->segm[k] = segmod[old_key][k];
				}

			for (k = 1; k <= x->idxadd; k++) {
				y = oxv + keycnt++;
				if (getambr(efp,d->datn,j + k,old_key + k,
				    &y->idxl,&y->idxt,&y->idxd))
					return(isam_err);
				y->idxname[0] = '\0';
				y->idxn       = old_key + k;
				y->idxnlf     = nulkey[old_key + k];
				y->idxnlc     = nulchr[old_key + k];
				y->idxseg     = MAX_KEY_SEG;
				y->idxext     = y->idxmod = 0;
				for (l = 0; l < MAX_KEY_SEG; l++)
					if (segpos[old_key + k][l] < 0) {
					   y->idxseg = l;
					   break;
					} else {
					   y->segp[l] = segpos[old_key + k][l];
					   y->segl[l] = seglen[old_key + k][l];
					   y->segm[l] = segmod[old_key + k][l];
					}
			}

			j += x->idxadd;

		}
	}
	fclose(efp);
    } else {
	nbufs    = 12;
	nsecs    = 4;
	old_dats = keycnt = 0;
    }

    keycnt = 0;

    for (i = 0,d = ndv, x = nxv; i++ < MAXFIL; d++,x++) {
		x->idxname[0] = d->datname[0] = '\0';
		x->idxn       = d->datn       = 0;
		x->idxl       = d->datl       = 0;
		x->idxext     = d->datext     = 0;
		x->idxmod     = d->datmod     = 2;
		x->idxt       = x->idxd       = 0;
		x->idxadd     = x->idxnlf     = x->idxnlc = 0;
		x->idxseg     = 1;
		for (j = 0; j < MAX_KEY_SEG; j++)
			x->segp[j] = x->segl[j] = x->segm[j] = 0;
    }
    if (ef) {
	for (i = 0,x = nxv,ox = oxv; i++ < old_idxs; x++, ox++)
		cpydat(x,ox,sizeof(IREC));
	for (i = 0,d = ndv,od = odv; i++ < old_dats; d++, od++)
		cpydat(d,od,sizeof(DREC));
    }

    dats = old_dats;
    if (ap) {
	dointr(NEW);
	for (i = 0; i < dats; i++)
		dodatr(i,NEW);
	printf("\n\nDo you wish to check your parameter file data? (y/n) >> ");
	chk = yesno();
    }
    
    if (!ap || chk) {
	dointr(OLD);
	do {
		for (i = 0, d = ndv; i++ < dats; d++)
			printf("\nData file #%2d: %14s  - has %2d indice(s)",
			    d->datn,d->datname,d->datidx);
		printf(
"\n\nEnter data file number (press RETURN to create new parameter file) >> ");
		if (getnum(&datno) == NO)
			datno = -1;
		if (datno > -1)
			for (i = 0, d = ndv; i < dats; i++,d++)
				if (d->datn == datno) {
					dodatr(i,OLD);
					break;
				}				
	} while (datno > -1);
    }

    for (i = idxs = 0; i < dats; i++)
	idxs += (ndv + i)->datidx;
    return(ierr(0,0));
}

VOID dointr(mode)
COUNT       mode;
{

/*
 * Note that the maximum values for buffers and node size given
 * below are arbitary, but reasonable.
 */
	printf("\n\n\t*** Press RETURN to accept the default values ***\n");

	printf("\nParameter File Initialization record:\n");
	iparm(&nbufs,3,256,"number of index buffers");
	iparm(&nsecs,1,32,"number of node sectors");
	iparm(&dats,1,MAXFIL,"number of data files");
}

COUNT tstseg(x,t)
IREC        *x;
COUNT         *t;
{
	COUNT len,k;

	for (k = 0,len = 0; k < x->idxseg; k++)
		len += x->segl[k];
	if (!x->idxd) {
		k = x->idxl;
		if (len == k)
			return(NO_ERROR);
	} else {
		k = x->idxl - sizeof(POINTER);
		if (len == k)
			return(NO_ERROR);
	}

	if (++(*t) > 4) {
		printf("\nSegment length(s) still do not match, but go on.\n");
		return(NO_ERROR);
	} else if (*t > 1)
		printf("\nSegment length(s) still do not match.\n");
	else
		printf(
"\nSegment length(s) do not match key length.\nLength(s) should add to %d.\n",
			k);
	return(YES);
}
	

VOID dodatr(i,mode)
COUNT       i,mode;
{
	COUNT j,k,l,tries;
	TEXT *fmode3,*fmode7,*smode;

	fmode3 =
"0 Excl  Virt Fixed\n1 Share Virt Fixed\n2 Excl  Perm Fixed\n3 Share Perm Fixed\n";
	fmode7 =
"4 Excl  Virt Var\n5 Share Virt Var\n6 Excl  Perm Var\n7 Share Perm Var\n";
	smode =
"0 No Transformation\n1 Reverse Bytes\n2 Upper Case\n3 Reverse & Upper\n";
	

	printf("\n\nData File Description:\n");
	d  = ndv + i;
	od = odv + i;
	if (i < old_dats && mode == NEW)
		cpydat(d,od,sizeof(DREC));
	iparm(&d->datn,0,MAXFIL,"data file number");
	tparm(d->datname,"data file name");
	iparm(&d->datl,0,0xfff9,"record length");
	iparm(&d->datext,0,0xffff,"file extension size");
	printf("%s%s",fmode3,fmode7);
	iparm(&d->datmod,0,7,"file mode");
	if (mode == NEW)
		iparm(&d->datidx,0,MAX_DAT_KEY,"number of indices");
	
	ox       = od->datip;
	if (mode == NEW)
		d->datip = nxv + keycnt;
	for (j = 0; j < d->datidx; j++) {
		if (mode == NEW)
			x = nxv  +  keycnt++;
		else
			x = d->datip + j;
		if (i < old_dats && j < od->datidx && mode == NEW) {
			cpydat(x,ox,sizeof(IREC));
			ox++;
		}
		printf("\n\nIndex File Description for Data File #%d:\n",
			d->datn);
		iparm(&x->idxn,0,MAXFIL,"index number");
		tparm(x->idxname,"index file name");
		iparm(&x->idxl,2,MAXLEN,"key length");
		iparm(&x->idxt,0,1,"key type");
		iparm(&x->idxd,0,1,"auto duplicate flag");
		iparm(&x->idxadd,0,d->datidx - j - 1,
		    "additional index members");
		iparm(&x->idxext,0,0xffff,"file extension size");
		printf("%s",fmode3);
		iparm(&x->idxmod,0,3,"file mode");
		iparm(&x->idxnlf,0,1,"missing key value flag");
		iparm(&x->idxnlc,0,255,"empty character (decimal)");
		iparm(&x->idxseg,1,MAX_KEY_SEG,"number of key segments");

		printf("\n\nKey Segment Description(s) for Index File #%d:\n",
			x->idxn);
		tries = 0;
		do {
		    for (k = 0; k < x->idxseg; k++) {
			printf("\n");
			iparm(&x->segp[k],0,d->datl - 1,"segment offset");
			iparm(&x->segl[k],1,x->idxl,"segment length");
			printf("%s",smode);
			iparm(&x->segm[k],0,3,"segment mode");
		    }
		} while (tstseg(x,&tries));

		for (k = 1; k <= x->idxadd; k++) {
		    if (mode == NEW)
			y = nxv + keycnt++;
		    else
			y = d->datip + j + k;
		    if (i < old_dats && (j + k) < od->datidx &&
		      mode == NEW) {
			cpydat(y,ox,sizeof(IREC));
			ox++;
		    }

		    printf(
"\n\nIndex Member Description for Index File #%d - Member %d:\n",x->idxn,k);
		    iparm(&y->idxl,2,MAXLEN,"key length");
		    iparm(&y->idxt,0,1,"key type");
		    iparm(&y->idxd,0,1,"auto duplicate flag");
		    iparm(&y->idxnlf,0,1,"missing key value flag");
		    iparm(&y->idxnlc,0,255,
			"empty character (decimal)");
		    iparm(&y->idxseg,1,MAX_KEY_SEG,
			"number of key segments");

		    printf(
"\n\nKey Segment Description(s) for Index File #%d - Member %d:\n",x->idxn,k);
		    tries = 0;
		    do {
		      for (l = 0; l < y->idxseg; l++) {
			printf("\n");
			iparm(&y->segp[l],0,d->datl - 1,
			    "segment offset");
			iparm(&y->segl[l],1,y->idxl,"segment length");
		        printf("%s",smode);
		        iparm(&y->segm[l],0,3,"segment mode");
		      }
		    } while (tstseg(y,&tries));
		}
		j += x->idxadd;

	}
}


/*
 *	build c-tree ISAM/REBUILD parameter file
 *
 *      Copyright (c) 1985 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
