/*
 *	low level support routines
 *	all calls to standard C library originate here
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#undef   EXTERN
#define  EXTERN /* */
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/
   
RNDFILE mbopen(ctnum,opmode)

PFAST CTFILE *ctnum;
COUNT opmode;	/* EXCLUSIVE or SHARED */

{
	RNDFILE retval;

	COUNT vtclose();

	if (!(opmode & PERMANENT) && numvfil >= MAXVFIL)
		vtclose();

	if ((retval = open(ctnum->flname,BUPDATE)) < 0)
		if (vtclose() == YES)
			retval = open(ctnum->flname,BUPDATE);

	if (!(opmode & PERMANENT) && retval >= 0)
		numvfil++;

	return(retval);
}

/* ------------------------------------------------------------ */

RNDFILE mbcrat(ctnum)

PFAST CTFILE *ctnum;

{
	RNDFILE retval;

	COUNT vtclose();

	if (!(ctnum->flmode & PERMANENT) && numvfil >= MAXVFIL)
		vtclose();

	if ((retval = creat(ctnum->flname,BCREATE)) < 0)
		if (vtclose() == YES)
			retval = creat(ctnum->flname,BCREATE);

	if (!(ctnum->flmode & PERMANENT) && retval >= 0)
		numvfil++;

	return(retval);
}


/* ------------------------------------------------------------ */

COUNT ctio(op_code,ctnum,recbyt,bufadr,iosize)

COUNT	op_code;	/* CTREAD or CTWRITE */
CTFILE *ctnum;
LONG	recbyt;
TEXT   *bufadr;
UCOUNT	iosize;

{
	COUNT uerr();
	LONG  lseek();

	if (lseek(ctnum->fd,recbyt,0) < 0L)
		return(uerr(SEEK_ERR));

	if (!iosize)
		iosize = ctnum->reclen;
	if (op_code == CTREAD) {
		if (read(ctnum->fd,bufadr,iosize) < iosize)
			return(uerr(READ_ERR));
	} else {
		if (write(ctnum->fd,bufadr,iosize) != iosize)
			return(uerr(WRITE_ERR));
	}
	return(NO_ERROR);
}


/* ------------------------------------------------------------ */

COUNT mbclos(ctnum,clmode)

PFAST CTFILE *ctnum;
COUNT clmode;	/* COMPLETE or PARTIAL */

{
	if (!(ctnum->flmode & PERMANENT))
		numvfil--;
	return((COUNT) close(ctnum->fd));
}


/* ------------------------------------------------------------ */

COUNT mbsave(ctnum)

PFAST CTFILE *ctnum;

{
	COUNT   uerr(),mbclos();
	RNDFILE mbopen();

	if (mbclos(ctnum,ctnum->flmode))
		return(uerr(FSAV_ERR));
	else if ((ctnum->fd = mbopen(ctnum,ctnum->flmode)) < 0)
		return(uerr(FSAV_ERR));
	else
		return(NO_ERROR);
}

/* ------------------------------------------------------------ */

TEXT *mballc(numobj,sizobj)

COUNT numobj,sizobj;

{
	TEXT *calloc();

	return(calloc(numobj,sizobj));
}

/* ------------------------------------------------------------ */

VOID mbfree(objptr)
TEXT       *objptr;

{
	free(objptr);
}

/* --------------------------------------------------------------------
   LOCK index node
 */

COUNT LOCK(node,knum)	/* node == 0  => header */

NODEPTR node;
PFAST KEYFILE *knum;

{

#ifdef FPUTFGET
	knum -= knum->kmem;	/* adjust for member # */
	/* then execute a LOCKing procedure */

	/* if lock is successful, increment lock count used by vtclose */
	knum->lokcnt++;
	return(NO_ERROR);
#else
	return(NO_ERROR);
#endif

}

/* --------------------------------------------------------------------
   UNLOCK index file node
*/

COUNT UNLOCK(node,knum)

NODEPTR node;
PFAST KEYFILE *knum;

{

#ifdef FPUTFGET
	knum -= knum->kmem;	/* adjust for member # */
	if (knum->lokcnt)
		knum->lokcnt--;
	/* UNLOCK node */

	return(NO_ERROR);
#else
	return(NO_ERROR);
#endif

}


/* --------------------------------------------------------------------
   LOCK data record
 */

COUNT DLOCK(recbyt,dnum)

POINTER		recbyt;
PFAST DATFILE  *dnum;

{
	COUNT uerr();

#ifdef FPUTFGET

	/*  then execute a LOCKing procedure: if lock fails, 
	 *  return uerr(DLOK_ERR) else return NO_ERROR;
	 */

	/* if successful, increment lokcnt */
	dnum->lokcnt++;
	return(NO_ERROR);
#else

	return(NO_ERROR);

#endif

}

/* --------------------------------------------------------------------
   UNLOCK data record
*/

COUNT UDLOCK(recbyt,dnum)

POINTER		recbyt;
PFAST DATFILE  *dnum;

{

#ifdef FPUTFGET
	if (dnum->lokcnt)
		dnum->lokcnt--;

	/* UNLOCK record */

	return(NO_ERROR);
#else
	return(NO_ERROR);
#endif

}

/*
 *	low level support routines
 *	all calls to standard C library originate here
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
