/*
 *	compact file
 *
 *      Copyright (c) 1985 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 26, 1985 11:16
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */


#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/
#include "ctisam.h"		/* isam header info		*/
#include "ctvrec.h"		/* variable length header	*/

#define TMP_NAME "CTREE.TMP"
#define OLDFIL	 0
#define NEWFIL	 1

POINTER FRSKEY(),NXTKEY(),NEWREC(),NEWVREC();
COUNT   getvhdr(),putvhdr(),REDREC(),REDVREC(),WRTREC(),WRTVREC();
COUNT   INTREE(),OPNFIL(),CLSFIL(),CREDAT(),CREIDX(),mbclos(),wrthdr();
TEXT   *mballc();

main (argc,argv)
int   argc;
TEXT *argv[];
{
	TEXT fname[MAX_NAME];

	printf("\n\nc-tree file compaction utility\nVersion 4.1 Release C\n");
	printf("Copyright 1985 FairCom\n");
	printf(
"\nThe compacted file will be named %s. Any existing file with this\n",TMP_NAME);
	printf("\tname will first be deleted!\n");
	if (argc > 1)
		cpybuf(fname,*++argv,MAX_NAME);
	else {
		printf("\nEnter file name >> ");
		fscanf(stdin,"%s",fname);
	}
	printf("\n\n\t*** Please wait while %s is compacted ***\n",fname);
	compact(fname);
	printf("\n\nEnd of File Compaction");
	if (uerr_cod)
		printf(" - Error Code %d\n\n",uerr_cod);
	else
		printf(".\n\n");
	exit(0);
}

VOID compact(fname)
TEXT *fname;
{
	if (INTREE(15,2 * (MAXMEMB + 1),4)) {
		printf("\nNot enough memory space for INTREE\n");
		return;
	}

	if (OPNFIL(OLDFIL,fname,(EXCLUSIVE | PERMANENT))) {
		printf("\nCould not properly open %s\n",fname);
		return;
	}

	unlink(TMP_NAME);

	switch (key->clstyp) {
case DAT_CLOSE:
		comdat();
		break;
case IDX_CLOSE:
		comidx();
		break;
case VAT_CLOSE:
		comvat();
		break;
default:
		printf("\nUnknown file type (%d)\nCall FairCom\n",key->clstyp);
	}
}

VOID comdat()
{
	COUNT   filemd,datlen;
	LONG    delrec;
	TEXT   *recbuf;
	POINTER recbyt,newbyt;
	CTFILE *ctnum;

	filemd = (key->flmode & ~VLENGTH);
	datlen = key->reclen;
	ctnum  = key + NEWFIL;
	delrec = 0L;

	if (CREDAT(NEWFIL,TMP_NAME,datlen,0,filemd)) {
		printf("\nCould not create data file %s\n",TMP_NAME);
		return;
	}

	recbyt = ((SECSIZ + datlen - 1) / datlen) * datlen;
	while (REDREC(OLDFIL,recbyt,recbuf) == NO_ERROR) {
		if (recbuf[0] != DELFLG) {
			if ((newbyt = NEWREC(NEWFIL)) == DRNZERO) {
				printf("\nCould not get new record\n");
				return;
			}
			if (WRTREC(NEWFIL,newbyt,recbuf)) {
				printf("\nCould not write new record\n");
				return;
			}
		} else
			delrec++;
		recbyt += datlen;
	}

	if (delrec)
		ctnum->updflg = COMPACT;
	else
		ctnum->updflg = NO;
	uerr_cod = 0;
	if (wrthdr(ctnum)) {
		printf("\nCould write new header record at close\n");
		return;
	}
	if (mbclos(ctnum,COMPLETE)) {
		printf("\nCould not close temporary file\n");
		return;
	}
	if (delrec)
		printf(
"\n\n%ld deleted records were removed.\nBe sure to rebuild indices.\n",
			delrec);
	else
		printf("\n\nNo deleted records were encountered.\n");
		
}


VOID comvat()
{
	COUNT   filemd,datlen;
	LONG    delrec;
	TEXT   *recbuf;
	POINTER recbyt,newbyt;
	CTFILE *ctnum;
	VRLEN   bufsiz;
	VHDR    vrhdr;

	filemd = (key->flmode | VLENGTH);
	datlen = key->reclen;
	bufsiz = datlen;
	ctnum  = key + NEWFIL;
	delrec = 0L;


	if ((recbuf = mballc(1,datlen)) == NULL) {
		printf("\nCould not allocate space for record buffer\n");
		return;
	}

	if (CREDAT(NEWFIL,TMP_NAME,datlen,0,filemd)) {
		printf("\nCould not create variable length data file %s\n",
		    TMP_NAME);
		return;
	}

	recbyt   = key->recsiz + SIZVHDR;
	while (getvhdr(key,recbyt,&vrhdr) == NO_ERROR) {
		if (vrhdr.recmrk == VACT_FLAG) {
			if (bufsiz < vrhdr.urclen) {
				mbfree(recbuf);
				bufsiz = vrhdr.urclen;
				if ((recbuf = mballc(1,bufsiz)) == NULL) {
					printf(
"\nCould not allocate %d bytes for record buffer\n",bufsiz);
					return;
				}
			}
			cur_recno[OLDFIL] = recbyt;
			if (REDVREC(OLDFIL,recbuf,bufsiz)) {
				printf("\nCould not read existing record\n");
				return;
			}
			if ((newbyt = NEWVREC(NEWFIL,vrhdr.urclen)) ==
			    DRNZERO) {
				printf("\nCould not get new record\n");
				return;
			}
			if (WRTVREC(NEWFIL,newbyt,recbuf,vrhdr.urclen)) {
				printf("\nCould not write new record\n");
				return;
			}
		} else
			delrec += (vrhdr.trclen + SIZVHDR);
		recbyt += (vrhdr.trclen + SIZVHDR);
	}

	if (delrec)
		ctnum->updflg = COMPACT;
	else
		ctnum->updflg = NO;
	uerr_cod = 0;
	if (wrthdr(ctnum)) {
		printf("\nCould write new header record at close\n");
		return;
	}
	if (mbclos(ctnum,COMPLETE)) {
		printf("\nCould not close temporary file\n");
		return;
	}
	if (delrec)
		printf(
"\n\n%ld deleted bytes were removed.\nBe sure to rebuild indices.\n",
			delrec);
	else
		printf("\n\nNo deleted records were encountered.\n");
		
}


VOID comidx()
{
	POINTER recbyt,keycnt;
	COUNT   filemd,nomemb,oldidx,newidx,k;
	TEXT    keybuf[MAXLEN];
	CTFILE *knum;

	filemd = (key->flmode & ~VLENGTH);
	newidx = (oldidx = OLDFIL) + (nomemb = key->nmem) + 1;
	if (CREIDX(newidx,TMP_NAME,key->length,key->ktype,key->autodup,
	    nomemb,0,filemd)) {
		printf("\nCould not create index file %s\n",TMP_NAME);
		return;
	}
	for (k = 1,knum = key + 1; k <= nomemb; k++,knum++)
		if (CREMEM(newidx,knum->length,knum->ktype,knum->autodup,
		    k)) {
			printf("\nCould not initialize additional index #%d\n",
			    k);
			return;
		}

	for (k = 0; k <= nomemb; k++,oldidx++,newidx++) {
	    keycnt = DRNZERO;
	    recbyt = FRSKEY(oldidx,keybuf);
	    while (recbyt)
		if (ADDKEY(newidx,keybuf,recbyt,INCADD)) {
			printf("\nCould not add key to new index (%d)\n",k);
			return;
		} else {
			keycnt++;
			recbyt = NXTKEY(oldidx,keybuf);
		}
	    printf("\n%ld key values in %s (%d).\n",keycnt,TMP_NAME,k);
	}


	if (CLSFIL(OLDFIL + nomemb + 1,COMPLETE)) {
		printf("\nCould not close temporary file\n");
		return;
	}
}


/*
 *	compact file
 *
 *      Copyright (c) 1985 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 26, 1985 11:16
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
