/*
 * c-tree(TM) Version 4.1 Release C 07/09/85 09:35
 *
 * Public domain header file which defines which compiler is to be used,
 * and three compiler dependent constants.  This header file is automatically 
 * included by the CTSTDR.H header file.
 *
 * 	The first define statement specifies a symbolic constant which is 
 * tested in CTSTDR.H to determine which stdio.h file to include.  We have
 * informally adopted the following convention (which you can easily change
 * in CTSTDR.H or extend):
 *
 *	LC	Lattice C compiler
 *	DR	Digital Research C compiler
 *	CI	Computer Innovations C compiler
 *	AZ	Manx Aztec C compiler (CP/M, MS-DOS & Macintosh)
 *	DS	DeSmet C compiler
 *	MC	Consulair Macintosh C compiler
 *	MW	Mark Williams C
 *	MS	Microsoft V3.0 C
 *	AT	AT&T UNIX V Release 2.0 C
 *
 * To date, the above compilers have been tested with c-tree.
 *
 *
 * 	The second define statement specifies BUPDATE.  BUPDATE corresponds 
 * to the mode parameter in the standard library "open" function. Usually, 
 * but not always, BUPDATE will be 2.  BUPDATE should be set to indicate the 
 * file is read and write, and binary.
 *
 *	The third define statement specifies BCREATE.  BCREATE corresponds 
 * to the mode parameter in the standard library * "creat" function.  It is 
 * either almost always ignored or set to the same value as BUPDATE in single 
 * user systems.  In UNIX-like systems, BCREATE determines the user protection
 * mode of the file.
 *
 *
 * 	The last define statement specifies C255.  C255 should be set to 
 * either '\377' or -1 depending on how the compiler to be used treats a 
 * char variable containing ff (hex). CTTEST.C can be used to determine
 * this as well as other compiler characteristics.
 *
 * The following shows the setup for release 2.15 of the Lattice C compiler
 * for the IBM-PC:
 *
 */

#define LC
#define BUPDATE 0x8000 | 2
#define	BCREATE	BUPDATE
#define C255	'\377'

/*
 * The files COMPILER.xy (xy = AZ, LC, CI, DR, etc.) contain these four
 * define statements for each of the test compilers as well as details
 * of any changes that are required to adapt c-tree to the compiler. If
 * your compiler is the same as one of our test compilers, be sure to list 
 * the corresponding COMPILER.xy file!
 *
 * Further, we have added a file COMPILER.DC which provides some details
 * relevant to DEC based equipment as reported by customer sites.
 *
 */
