/*
 *	data file routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/

COUNT  uerr(),ctio(),DLOCK(),UDLOCK();

POINTER NEWREC(datno)

COUNT datno;

{
	FAST DATFILE *dnum;
	LOCAL POINTER pntr;

	DATFILE *tstdnm();
	COUNT    tstdup(),wrtdhd(),reddhd();
	POINTER  extfil();

	uerr_cod = 0;
	if ((dnum = tstdnm(datno)) == NULL)
		return(DRNZERO);
	if (dnum->clstyp != DAT_CLOSE) {
		uerr(FMOD_ERR);
		return(DRNZERO);
	}

#ifdef FPUTFGET
	if (DLOCK(DRNZERO,dnum) || reddhd(dnum))
		return(DRNZERO);
#endif

	if (!(pntr = dnum->delstk)) {
		if (!(pntr = extfil(dnum,dnum->reclen))) {
			/* could not extend file */
#ifdef FPUTFGET
			UDLOCK(DRNZERO,dnum);
#endif
			return(DRNZERO);
		}
	} else {
		if (ctio(CTREAD,dnum,pntr,ct_buf,sizeof(POINTER) + 1)) {
#ifdef FPUTFGET
			UDLOCK(DRNZERO,dnum);
#endif
			return(DRNZERO);
		}
		if (ct_buf[0] != DELFLG) {
#ifdef FPUTFGET
			UDLOCK(DRNZERO,dnum);
#endif
			uerr(DELFLG_ERR);
			return(DRNZERO);
		}
		cpybuf(&dnum->delstk,ct_buf + 1,sizeof(POINTER));
	}

#ifdef FPUTFGET
	if (DLOCK(pntr,dnum)) {
		UDLOCK(DRNZERO,dnum);
		return(DRNZERO);
	}
#endif

#ifdef NOTFORCE
	if (tstdup(dnum))
		return(DRNZERO);
#else
	if (wrtdhd(dnum)) {
#ifdef FPUTFGET
		UDLOCK(DRNZERO,dnum);
#endif
		return(DRNZERO);
	}

#ifdef FPUTFGET
	if (UDLOCK(DRNZERO,dnum))
		return(DRNZERO);
#endif
#endif
	return(pntr);
}

COUNT RETREC(datno,recbyt)

COUNT   datno;
POINTER recbyt;
	
{
	FAST DATFILE *dnum;
	LOCAL POINTER pntr;

	DATFILE *tstdnm();
	COUNT    tstdup(),tstrec(),wrtdhd(),reddhd();

	uerr_cod = 0;
	if ((dnum = tstdnm(datno)) == NULL || tstrec(dnum,recbyt))
		return(uerr_cod);
	if (dnum->clstyp != DAT_CLOSE)
		return(uerr(FMOD_ERR));
	

#ifdef FPUTFGET
	if (DLOCK(DRNZERO,dnum) || reddhd(dnum))
		return(uerr_cod);
#endif

	pntr = dnum->delstk;
	if (pntr == recbyt) {

#ifdef FPUTFGET
		UDLOCK(DRNZERO,dnum);
#endif
		return(uerr(DDRN_ERR));
	}
	dnum->delstk = recbyt;
	ct_buf[0] = DELFLG;
	cpybuf(ct_buf + 1,&pntr,sizeof(POINTER));

	if (ctio(CTWRITE,dnum,recbyt,ct_buf,sizeof(POINTER) + 1)) {
#ifdef FPUTFGET
		UDLOCK(DRNZERO,dnum);
#endif
		return(uerr_cod);
	}

#ifdef FPUTFGET
	UDLOCK(recbyt,dnum);	/* assumes no error if recbyt not locked */
	uerr_cod = 0;
#endif

#ifdef NOTFORCE
	if (tstdup(dnum))
		return(uerr_cod);
#else
	if (wrtdhd(dnum)) {
#ifdef FPUTFGET
		UDLOCK(DRNZERO,dnum);
#endif
		return(uerr_cod);
	}
#ifdef FPUTFGET
	if (UDLOCK(DRNZERO,dnum))
		return(uerr_cod);
#endif
#endif

	return(NO_ERROR);
}	



/* --------------------------------------------------------------------
   read data record
*/

COUNT REDREC(datno,recbyt,recptr)

COUNT	datno;
POINTER	recbyt;
TEXT   *recptr;

{
	FAST DATFILE *dnum;

	DATFILE *tstdnm();
	COUNT    tstrec();

	uerr_cod = 0;
	if ((dnum = tstdnm(datno)) == NULL || tstrec(dnum,recbyt))
		return(uerr_cod);
	if (recptr == NULL)
		return(uerr(DNUL_ERR));
	return(ctio(CTREAD,dnum,recbyt,recptr,0));
}

COUNT WRTREC(datno,recbyt,recptr)

COUNT	datno;
POINTER	recbyt;
TEXT   *recptr;

{
	FAST DATFILE *dnum;

	DATFILE *tstdnm();
	COUNT    tstdup(),tstrec();

	uerr_cod = 0;
	if ((dnum = tstdnm(datno)) == NULL || 
	    tstrec(dnum,recbyt) || tstdup(dnum))
		return(uerr_cod);
	if (recptr == NULL)
		return(uerr(DNUL_ERR));
	return(ctio(CTWRITE,dnum,recbyt,recptr,0));
}

COUNT tstrec(dnum,recbyt)

PFAST DATFILE  *dnum;
POINTER		recbyt;

{
	if (!recbyt)
		return(uerr(ZREC_ERR));
	if (recbyt > dnum->numrec)
#ifndef FPUTFGET
		return(uerr(LEOF_ERR));
#else
		if (reddhd(dnum))
			return(uerr_cod);
		else if (recbyt > dnum->numrec)
			return(uerr(LEOF_ERR));
#endif
	return(NO_ERROR);
}

/*
 *	data file routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
