/*
 *	c-tree file header debug help
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* global variable definitions	*/

CTFILE *tstfnm();

COUNT prthdr(filno)
COUNT        filno;
{
	CTFILE *ctnum;

	if ((ctnum = tstfnm(filno)) == NULL) {
		printf("\nfile number %d is not active (error %d)\n",
			filno,uerr_cod);
		return(uerr_cod);
	}
	if (key != dat || key != vat) {
		printf(
"\npointers to base of file control structures are clobbered.\n");
		return(-1);
	}

printf("\nheader info for file #%d  [%s]:\n",filno,ctnum->flname);
printf("\n    configuration version: %6xx\t           index root ptr: %lxx", 
	ctnum->verson,  ctnum->root);    
printf("\n                node size: %6u \t           node stack ptr: %lxx", 
	ctnum->recsiz,  ctnum->nodstk);  
printf("\n       data record length: %6u \t max values per leaf node: %d",  
	ctnum->reclen,  ctnum->maxkvl);  
printf("\n         extend file size: %6u \t  max values per non-leaf: %d",  
	ctnum->extsiz,  ctnum->maxkvn);  
printf("\n                file mode: %6d \t               key length: %d",  
	ctnum->flmode,  ctnum->length);  
printf("\n                file type: %6d \t  # of additional members: %d",  
	ctnum->clstyp,  ctnum->nmem);    
printf("\n              update flag: %6xx\t      index member number: %d",  
	ctnum->updflg,  ctnum->kmem);    
printf("\n                 key type: %6d \t          file descriptor: %d",  
	ctnum->ktype,   ctnum->fd);      
printf("\n           duplicate flag: %6d \t          lru age counter: %u",  
	ctnum->autodup, ctnum->usecnt);  
printf("\n       # of index entries: %6ld \t         current node ptr: %lxx", 
	ctnum->nument,  ctnum->retnod);  
printf("\n         delete stack ptr: %6lxx\t  current element in node: %d",  
	ctnum->delstk,  ctnum->retelm);  
printf("\n           last byte used: %6lxx\t      channel active flag: %c",  
	ctnum->numrec + 1L,  ctnum->chnacs);  
printf("\n       last physical byte: %6lxx\t              file number: %d",  
	ctnum->phyrec + 1L,  ctnum->filnum);  

       return(NO_ERROR);
}

/*
 *	c-tree file header debug help
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
