/*
 *	delete key
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/

COUNT uerr(),putnod(),LOCK(),UNLOCK();


/* --------------------------------------------------------------------
   routine to delete index entry checking that associated recbyt agrees
   with recbyt

   if pointers agree, DELCHK returns a 0; if not, it returns a 3 and
   no deletion is performed

   if the key value is not found, then a 4 is returned
 */

COUNT DELCHK(keyno,target,recbyt)

COUNT   keyno;
TEXT   *target;
POINTER recbyt;

{
	VOID prpdup();
	COUNT DELKEY();
	KEYFILE *tstknm();

	FAST KEYFILE *knum;
	TEXT *idxval;

	uerr_cod = 0;
	if ((knum = tstknm(keyno)) == NULL)
		return(uerr_cod);

	cpybuf((idxval = dupkey),target,knum->length);
	if (knum->autodup == DUPKEY)
		prpdup(idxval,knum,&recbyt);

	return(DELKEY(knum,idxval,recbyt));
}
	
/* --------------------------------------------------------------------
   routine to delete index entry "blind" (ie, without checking
   associated pointer for agreement); and return the associated pointer
   found in the index. cannot be used with DUPKEY.

   if error or no target is found, then return a zero
 */

POINTER DELBLD(keyno,target)

COUNT keyno;
TEXT *target;

{
	LOCAL POINTER test;
	POINTER fndkey();
	COUNT DELKEY();
	FAST KEYFILE *knum;
	KEYFILE *tstknm();

	uerr_cod = 0;
	if ((knum = tstknm(keyno)) == NULL)
		return(0);
	if (knum->autodup == DUPKEY) {
		uerr(KBLD_ERR);
		return(0);
	}

	if (!(test = fndkey(knum,target,'E'))) {
		uerr(KDEL_ERR);
		return(0);
	} else {
		if (DELKEY(knum,target,test))
			return(0);
		return(test);
	}
}


/* --------------------------------------------------------------------
   utility routine to delete key value from leaf node. Note that to
   support concurrent node updates, underflowed nodes (i.e., nodes
   less than half-full are not removed from the tree.  A node may even
   become empty.  Such under utilized nodes will be reused when key
   values from the same range of values are added back into the index.

   If key values are systematically removed from one end of the index,
   and replacements are added to the other end of the index; it will be
   necessary to rebuild the index periodically to avoid wasted disk
   space. 
 */

COUNT DELKEY(knum,idxval,pntr)

PFAST KEYFILE *knum;
TEXT *idxval;
POINTER pntr;

{
	LOCAL COUNT npoint;
	FAST TREEBUFF *buffer;
	LOCAL NODEPTR node;

	NODEPTR gtroot(),nodpnt();
	POINTER drnpnt();
	COUNT nodser(),hdrupd(),tstupd();
	TREEBUFF *getnod(),*movrgt();

	uerr_cod = 0;
	if (!(node = gtroot(knum))) /* tree may be empty or gtroot err */
		if (uerr_cod)
			return(uerr_cod);
		else
			return(uerr(KDEL_ERR));

	while (node) {	/* walk down or across tree until leaf node found */
		lnode = node;
		if ((buffer = getnod(node,knum)) == NULL)
			return(uerr_cod);
		if (buffer->leaf == LEAF)
			break;

		if ((npoint = nodser(buffer,idxval,'L')) != -1) {
			if (npoint == -2)
				terr(220);
			node = nodpnt(buffer,npoint);
		} else
			node = buffer->sucesr;
	}

	if (!node)	/* then no leaf node found */
		terr(221);

	if (LOCK(node,knum) ||
	    (buffer = movrgt(idxval,knum,getnod(node,knum))) == NULL)
		return(uerr_cod);

	if (tstkey) {
		if (UNLOCK(buffer->nodeid,knum))
			return(uerr_cod);
		return(uerr(KDEL_ERR)); /* key does not exist */
	}

	if (drnpnt(buffer,elemnt) != pntr) {
		if (UNLOCK(buffer->nodeid,knum))
			return(uerr_cod);
		return(uerr(KMAT_ERR));
	}

	if (tstupd(knum))
		return(uerr_cod);
		
	if (elemnt != buffer->nkv--)
		updnod(buffer,buffer,1,elemnt,buffer->nkv,1);

	node = buffer->nodeid; /* save for unlock */
	if (putnod(buffer,buffer->nkv) || UNLOCK(node,knum) ||
	    hdrupd(knum,(POINTER) -1))
		return(uerr_cod);
	return(NO_ERROR);
}

/*
 *	delete key
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
