/*
 * public domain example Ver 4.1 Release C 08/03/85 08:14	
 *
 * ISAM Parameter File named CTEXAM.P
 *
 */

#include "ctstdr.h"
				/* automatically includes necessary
				 * header files (including compiler's
				 * "stdio.h")
				 */
#include "ctoptn.h"
#include "ctstrc.h"

COUNT OPNISAM(),CLISAM(),ADDREC(),GTEREC(),NXTREC(),PRVREC(),RWTREC(),DELREC();
				
EXTERN COUNT   isam_err,isam_fil;	/* ISAM error code variables */
EXTERN CTFILE *key;

#define	CUSTDAT	0		/* customer data file		*/
#define	NAMEKEY 1		/* name key			*/
#define	NUMBKEY	2		/* customer number key		*/
#define	ZIPCKEY	3		/* zip code key			*/

#define NO_FLD	7		/* number of data record fields */
#define INTFLD	'\1'		/* integer field designator     */
#define CHRFLD	'\0'		/* character field designator	*/

#define NEW	0		/* new versus old record image	*/
#define OLD	1

#define NEXT	2		/* scan direction indicators	*/
#define PREV	3


TEXT *fldnam[NO_FLD];		/* field descriptions		*/
TEXT  fldtyp[NO_FLD];		/* field type: INTFLD or CHRFLD	*/
COUNT fldlen[NO_FLD];		/* field length			*/
TEXT *fldptr[NO_FLD];		/* new image field pointer	*/
TEXT *oldptr[NO_FLD];		/* old image field pointer	*/
TEXT  inpbuf[128];		/* general purpose input buffer */


#define CNUML	4		/* field lengths in bytes	*/
#define LNAML	24
#define FNAML	24
#define ADRSL	32
#define CITYL	24
#define STATL	2
#define ZIPCL	9

LONG  numtar;			/* input variable for integer key value */
TEXT  namtar[LNAML + 1];	/* input variable for character key	*/

struct CUSTOMER {		/* data record format			*/
	COUNT	delete_flag;	/* delete flag byte			*/
	LONG	cnum;		/* customer number			*/
	TEXT	lnam[LNAML];	/* last name				*/
	TEXT	fnam[FNAML];	/* first name				*/
	TEXT	adrs[ADRSL];	/* street address			*/
	TEXT	city[CITYL];	/* city					*/
	TEXT	stat[STATL];	/* state abreviation			*/
	TEXT	zipc[ZIPCL];	/* zip code				*/
	TEXT	padding[7];	/* unused padding			*/
	} cust,old_cust;	
				/* old_cust is the record buffer for
				 * existing data. cust is the record buffer
				 * for new and/or updated data
				 */
/*
 * IF YOUR SYSTEM FORCES DOUBLE WORD ALIGNMENT OF LONG INTEGERS, THEN THE 
 * SEGMENT OFFSETS IN CTEXAM.P MUST BE CHANGED TO REFLECT ANY HOLES WHICH 
 * ARISE IN CUSTOMER AS A RESULT OF THE ALIGNMENT OF THE CNUM MEMBER.
 */

/* ************************************************************************* */
/* ************************************************************************* */

main () {
	if (OPNISAM("CTEXAM.P")) {
		printf("\n\nCould not open isam. Error codes %d %d",
			isam_err,isam_fil);
		exit(0);
	} else
		printf("\nc-tree(TM) V4.1 Release C\n\nDatabase Example\n\n");

/*
 * assign field characteristics
 */

	fldnam[0] = "Number";
	fldtyp[0] = INTFLD;
	fldlen[0] = CNUML;
	fldptr[0] = (TEXT *) &cust.cnum;
	oldptr[0] = (TEXT *) &old_cust.cnum;

	fldnam[1] = "Last Name";
	fldtyp[1] = CHRFLD;
	fldlen[1] = LNAML;
	fldptr[1] = cust.lnam;
	oldptr[1] = old_cust.lnam;
	
	fldnam[2] = "First Name";
	fldtyp[2] = CHRFLD;
	fldlen[2] = FNAML;
	fldptr[2] = cust.fnam;
	oldptr[2] = old_cust.fnam;

	fldnam[3] = "Address";
	fldtyp[3] = CHRFLD;
	fldlen[3] = ADRSL;
	fldptr[3] = cust.adrs;
	oldptr[3] = old_cust.adrs;

	fldnam[4] = "City";
	fldtyp[4] = CHRFLD;
	fldlen[4] = CITYL;
	fldptr[4] = cust.city;
	oldptr[4] = old_cust.city;

	fldnam[5] = "State Abrev";
	fldtyp[5] = CHRFLD;
	fldlen[5] = STATL;
	fldptr[5] = cust.stat;
	oldptr[5] = old_cust.stat;

	fldnam[6] = "Zip Code";
	fldtyp[6] = CHRFLD;
	fldlen[6] = ZIPCL;
	fldptr[6] = cust.zipc;
	oldptr[6] = old_cust.zipc;

/*
 * clear the delete flag
 */

	cust.delete_flag = 0;

/*
 * call the main database routine
 */

	database();

/*
 * close the ISAM files
 */

	if (CLISAM())
		printf("\n\nCould not close isam. Error codes %d %d",
			isam_err,isam_fil);
	exit(0);
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * main data base routine
 */
		
VOID database()

{
    TEXT choice[2];

    choice[0] = '\0';

    while (choice[0] != 'q' && choice[0] != 'Q') {
	printf("\n\nA)dd  U)pdate  Q)uit:");
	gets(inpbuf);
	choice[0] = inpbuf[0];
	switch (choice[0]) {

case 'A':
case 'a':
		datadd();	/* add new entry to customer data base */
		break;

case 'U':
case 'u':
		datscan();	/* scan/update existing entries */
		break;

default:
		break;
	}
    }
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to add new customer
 */

VOID datadd()

{
	COUNT i;

	printf("\nADD NEW DATA\n\n");

/*
 * enter data for each field
 */

	for (i = 0; i < NO_FLD; i++)
		getfld(i,NEW);			

/*
 * enable locks and add data
 */
 
	if (LKISAM(ENABLE) || ADDREC(CUSTDAT,&cust))
		printf("\n\nError during addition. Codes %d %d",isam_err,
			isam_fil);
	else
		printf("\nSuccessful Addition.");
	LKISAM(FREE);
}


/* ************************************************************************* */
/* ************************************************************************* */

/*
 * print field name and get field input
 */

VOID getfld(fldno,typ)

COUNT fldno,typ;

{
	COUNT i;

	i = fldno + 1;
	if (typ == OLD) {
		printf("\n\nCurrent value for %-15s: ",fldnam[fldno]);
		putfld(fldno);
		printf("\nEnter new value   %-15s: ","");
		inpfld(fldno);
	} else {
		printf("\n%d. %-15s :",i,fldnam[fldno]);
		inpfld(fldno);
	}
}


/* ************************************************************************* */
/* ************************************************************************* */

LONG getnum(tp)
TEXT *tp;
{
	LONG retval;

	retval = 0L;
	do {
		if (*tp >= '0' && *tp <= '9') {
			retval *= 10;
			retval += (*tp - '0');
		}
	} while (*tp++);
	return(retval);
}

/*
 * field input routine handles character and (long) integer fields
 */

VOID inpfld(fldno)

COUNT fldno;

{
	LONG *intdat;

	if (fldtyp[fldno] == INTFLD) {
		intdat = (LONG *) fldptr[fldno];
		gets(inpbuf);
		*intdat = getnum(inpbuf);
	} else {
		gets(inpbuf);
		cpychr(fldptr[fldno],inpbuf,fldlen[fldno]);
	}
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to scan existing customers
 */

VOID datscan()

{
	COUNT update();

	COUNT i,action,keyno,fldno;
	TEXT *tarval;		/* pointer to target key value	*/
	TEXT  choice[2];

	printf("\nSCAN DATA\n");
	keyno = -1;

/*
 * select which key to order scan by  and  starting key value
 */

	while (keyno < NAMEKEY || keyno > ZIPCKEY) {
		printf("\nScan by  N)ame  #(number)  Z)ip Code   or Q)uit>> ");
		gets(inpbuf);
		choice[0] = inpbuf[0];
		switch (choice[0]) {
case 'n':
case 'N':
			keyno = NAMEKEY;
			fldno = 1;
			break;
case '#':
			keyno = NUMBKEY;
			fldno = 0;
			break;

case 'z':
case 'Z':
			keyno = ZIPCKEY;
			fldno = 6;
			break;

case 'q':
case 'Q':
			return;
default:
			printf("\nImproper selection (%.1s). Try again.\n",
				choice);
		}
	}

	printf("\nEnter %s: ",fldnam[fldno]);
	for (i = 0; i++ < 128; )
		inpbuf[i] = '\0';
	gets(inpbuf);
	if (keyno != NUMBKEY) {
		zrosfx(inpbuf,(key + keyno)->length - 4);
		tarval = inpbuf;
	} else {
		numtar = getnum(inpbuf);
		tarval = (TEXT *) &numtar;
	}

/*
 * scan data acquiring a lock on each record and then freeing lock before
 * going on to next record
 */
		
	action = 0;
	if (LKISAM(ENABLE) || GTEREC(keyno,tarval,&old_cust)) {
		printf("\n\nSCAN failed at start with codes %d %d",isam_err,
			isam_fil);
		LKISAM(FREE);
		return;
	}
	while (action > -1 && !isam_err) {
		action = update();	/* update data and determine 
					 * direction of scan
					 */
		LKISAM(RESET);
		if (action == NEXT)
			NXTREC(keyno,&old_cust);
		else if (action == PREV)
			PRVREC(keyno,&old_cust);
	}
	if (isam_err)
		printf("\n\nScan ending (code %d  file %d).",isam_err,
			isam_fil);
	LKISAM(FREE);
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to update customer records. note that the scan routine reads the
 * customer records into the "old_cust" buffer and this routine creates
 * an updated version in the "cust" buffer.
 */

COUNT update()

{
	COUNT i;
	TEXT  choice[2];

	for (i = 0; i < NO_FLD; i++) {
		cpydat(fldptr[i],oldptr[i],fldlen[i]);
		printf("\n%d. %-15s: ",i + 1,fldnam[i]);
		putfld(i);
	}

	for(;;) {
		printf(
"\n\nEnter field # to change data or N)ext, P)revious D)elete or E)nd scan>> ");
		gets(inpbuf);
		choice[0] = inpbuf[0];
		switch (choice[0]) {

/*
 * since this data base has only one data file defined in the ISAM parameter
 * file CTEXAM.P, all the data file references are to file number zero
 */

case 'n':
case 'N':
			if (RWTREC(CUSTDAT,&cust))
				return(-1);
			else
				return(NEXT);
			
case 'p':
case 'P':
			if (RWTREC(CUSTDAT,&cust))
				return(-1);
			else
				return(PREV);

case 'e':
case 'E':
			RWTREC(CUSTDAT,&cust);
			return(-1);
case 'd':
case 'D':
			if(!DELREC(CUSTDAT))
				printf("\nSuccessful Deletion.");
			return(NEXT);

case '1':
case '2':
case '3':
case '4':
case '5':
case '6':
case '7':
			getfld((choice[0] - '1'),OLD);
			break;
default:
			printf("\nImproper selection (%.1s). Try again.\n",
				choice);
		}
	}
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to output customer field
 */

VOID putfld(fldno)

COUNT fldno;

{
	LONG      *intdat;
	FAST COUNT i;
	FAST TEXT *tp;

	if (fldtyp[fldno] == INTFLD) {
		intdat = (LONG *) fldptr[fldno];
		printf("%ld",*intdat);
	} else
		for (i = 0, tp = fldptr[fldno]; i++ < fldlen[fldno];)
			printf("%c",*tp++);
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to copy character data, padding with blanks
 * if the data does not fill the field
 */

VOID cpychr(dp,sp,len)

PFAST TEXT *dp,*sp;
PFAST COUNT len;

{
	while (*sp && len-- > 0 )	/* loop terminates either when 
					 * complete field filled in, or
					 * when a null termination byte
					 * encountered
					 */
		*dp++ = *sp++;

	while (len-- > 0)		/* if field not filled in, pad
					 * with blanks
					 */
		*dp++ = ' ';
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to copy data without padding
 */

VOID cpydat(dp,sp,len)

PFAST TEXT *dp,*sp;
PFAST COUNT len;

{
	while (len-- > 0)
		*dp++ = *sp++;
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to pad, set to upper case & set duplicate suffix to zero
 */

VOID zrosfx(tp,kl)
PFAST TEXT *tp;
PFAST COUNT    kl;
{
	for ( ; kl-- > 0; tp++)
		if (*tp >= 'a' && *tp <= 'z')
			*tp = *tp + 'A' - 'a';
		else if (*tp == '\0')
			*tp = ' ';
	for (kl = 0; kl++ < sizeof(LONG); )
		*tp++  = '\0';
}


/*
 * end of CTEXMG.C example program
 */

/* ************************************************************************* */
/* ************************************************************************* */
