/*
 *	global variables
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

                       /* Global Variables */

/*
 * Some compilers require one and only one module to be compiled
 * with global variables initialized.  If this applies to your
 * compiler, then you must create another module similar to this
 * which includes the appropriate initialization syntax. Set all 
 * of these globals to zero.  Use this new module when compiling
 * CT-CLIB.C.
 */


EXTERN TREEBUFF *btree;		/* ptr to beg of b-tree buffers		*/
EXTERN KEYFILE  *key;		/* ptr to beg of key file structures	*/
EXTERN DATFILE  *dat;		/* ptr to beg of data file structures	*/
EXTERN VATFILE  *vat;		/* ptr to beg of var data file struc	*/
EXTERN TEXT	*origin;	/* ptr to main index buffer area	*/

EXTERN NODEPTR npath[MAXLEV];	/* array to trace path down B-tree. Assumes
				   maximum of MAXLEV - 1 levels in B-tree. */
					
EXTERN TEXT indkey[MAXLEN+1];	/* storage for key values found during
				      indexing operations */
EXTERN TEXT dupkey[MAXLEN+1];	/* for searches of duplicate keys */
EXTERN TEXT spkey[MAXLEN+1];	/* temporary storage for key values during
				    node updates */

EXTERN COUNT elemnt;		/* position within B-Tree node	*/
EXTERN COUNT tstkey;		/* result of comparison between target
				   value and index entry.
				   tstkey < 0 => target < index entry
				          = 0 => target = index entry
				          > 0 => target > index entry */
EXTERN COUNT maxfil;		/* maximum files specified in intree. */
EXTERN COUNT maxbuf;		/* maximum buffers specified in intree */
EXTERN COUNT nodsec;		/* # of sectors per node specified in intree */
EXTERN COUNT numvfil;		/* number of virtual files open	*/

EXTERN NODEPTR lnode;		/* last node found during walk down tree */
EXTERN NODEPTR fnode;		/* node found during search/retrieval */
EXTERN UCOUNT  lstacs;		/* counter to determine relative age of
				   buffer activity. each time buffer is
				   used, nodacs for buffer is set to lstacs++
				 */
EXTERN UCOUNT  lstfil;		/* counter to track lru file for virtual
				   opens and closes
				 */

EXTERN NODEPTR nwnod;		/* pointer to new node */
EXTERN COUNT   btlev;		/* b-tree level counter. used as index of
				   npath
				 */
EXTERN COUNT uerr_cod;		/* user error cod */
EXTERN TEXT  ct_buf[SECSIZ];	/* temporary io buffer */
EXTERN COUNT ct_ver;		/* defines configuration options */

/* ******************************************************************** */
/* ******************************************************************** */
/* ******************************************************************** */
