/*
 *	common utility routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */


#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/

RNDFILE mbopen();
COUNT   mbclos();

/* --------------------------------------------------------------------
   routine to initialize buffer space and status variables
 */

COUNT INTREE(bufs,fils,sect)

COUNT bufs,fils,sect;

{
	FAST COUNT i;
	TREEBUFF  *buf;
	CTFILE    *ctnum;
	COUNT      valsiz;
	TEXT      *buforg,*valoff;

	TEXT      *mballc();
	COUNT	   uerr();

	/*   
	 *	be sure that one and only one of each mutually 
	 *	exclusive choice has been selected and compose
	 *	version byte for header records.
	 */


#ifndef LOW_HIGH
	ct_ver = (HL_VER | CT_V4);
#ifndef HIGH_LOW
	terr(200);
#endif
#else
	ct_ver = (LH_VER | CT_V4);
#ifdef  HIGH_LOW
	terr(201);
#endif
#endif

/* ******************** */

#ifndef NOTFORCE
#ifndef FPUTFGET
#ifndef FPUTONLY
	terr(202);
#endif
#endif
#endif

#ifdef  NOTFORCE
#ifdef  FPUTFGET
	terr(203);
#endif
#ifdef  FPUTONLY
	terr(203);
#endif
#else
#ifdef  FPUTFGET
#ifdef  FPUTONLY
	terr(203);
#endif
#endif
#endif


/* ******************** */

	uerr_cod = 0;
	if (bufs < 3 || sect < 1 || fils < 0)
		return(uerr(SPRM_ERR));

	if (!(btree = (TREEBUFF *) mballc(bufs,sizeof(TREEBUFF))))
		return(uerr(SPAC_ERR));
	if (!(key = (CTFILE *) mballc(fils,sizeof(CTFILE)))) {
		mbfree(btree);
		return(uerr(SPAC_ERR));
	}
	dat = key;
	vat = key;

	valsiz = sect * SECSIZ + MAXLEN + sizeof(POINTER);
	if (!(origin = (TEXT *) mballc(bufs,valsiz))) {
		mbfree(key);
		mbfree(btree);
		return(uerr(SPAC_ERR));
	}
	valoff = (buforg = origin) + STATUS;

	maxbuf = bufs;
	maxfil = fils;
	nodsec = sect;
	lstacs = lstfil = numvfil = npath[0] = 0;

	for (i = 0,buf = btree; i++ < maxbuf; buf++) {
		buf->keyid = -1;
		buf->update = 'n';
		buf->nodacs = 0;
		buf->nodorg = buforg;
		buf->keyval = valoff;
		buforg += valsiz;
		valoff += valsiz;
	}

	for (i = 0,ctnum = key; i++ < maxfil; ctnum++) {
		ctnum->usecnt = 0;
		ctnum->chnacs = 'n';
	}

	return(NO_ERROR);
}


/* ------------------------------------------------------------------
   extend file size
*/

POINTER extfil(ctnum,rsize)
PFAST CTFILE  *ctnum;
UCOUNT               rsize;

{
	POINTER retval,oldval;

	COUNT   uerr();

	ctnum         -= ctnum->kmem;
	retval         = (oldval = ctnum->numrec) + 1;
	ctnum->numrec += rsize;
	if (oldval > ctnum->numrec) {
		uerr(FULL_ERR);
		return(DRNZERO);
	} else if (ctnum->numrec <= ctnum->phyrec)
		return(retval);
	else if (ctnum->extsiz <= rsize) {
		ctnum->phyrec = ctnum->numrec;
		return(retval);
	} else { /* extend file by chunk and save directory contents */
		if (ctnum->phyrec < (ctnum->extsiz - 1))
			ctnum->phyrec  = ctnum->extsiz - 1;
		else
			ctnum->phyrec += ctnum->extsiz;

		if (ctnum->phyrec < ctnum->numrec) {
			/* overflow */
			ctnum->phyrec = ctnum->numrec;
			return(retval);
		}
		ct_buf[0] = DELFLG;
		if (ctio(CTWRITE,ctnum,ctnum->phyrec,ct_buf,1)) {
			/* couldn't extend by a chunk */
			uerr_cod = 0;
			ctnum->phyrec = ctnum->numrec;
			return(retval);
		}
		if (ctnum->clstyp == DAT_CLOSE) /* fill-in delete flags */
			for (oldval = retval; oldval < ctnum->phyrec;
			    oldval += ctnum->reclen)
				if (ctio(CTWRITE,ctnum,oldval,ct_buf,1))
					terr(227);
		if (mbsave(ctnum))
			return(DRNZERO);
		return(retval);
	}
}


/* --------------------------------------------------------------------
   utility to test for valid file number and determine if file
   corresponding to ctnum has been activated. returns NULL ptr if error.
 */

CTFILE *tstfnm(filno)
COUNT          filno;

{
	FAST CTFILE *retval,*ctnum;
	COUNT        nomemb;

	COUNT        uerr();
	UCOUNT	     inrfil();

	if (filno < 0 || maxfil <= filno) { /* filno out of range */
		uerr(FNUM_ERR);
		return(NULL);
	} else
		retval = key + filno;

	switch (retval->chnacs) {
case 'n':
		uerr(FACS_ERR);
		return(NULL);
case 'y':
		retval->usecnt = inrfil(retval);
		return(retval);
case 'v':
		ctnum          = retval - retval->kmem;
		nomemb         = ctnum->nmem;
		ctnum->usecnt  = 0;
		if ((ctnum->fd = mbopen(ctnum,ctnum->flmode)) < 0){
			uerr(VRTO_ERR);
			return(NULL);
		} else {
			ctnum->usecnt = inrfil(retval);
			for (filno = 0; filno++ <= nomemb; ctnum++)
				ctnum->chnacs = 'y';
			return(retval);
		}
default:
		terr(222);
	}
}


/* ------------------------------------------------------------ */

COUNT vtclose()

{
	FAST CTFILE *ctnum;
	CTFILE      *fndnum;
	FAST COUNT   i;
	UCOUNT       lstusd;

	COUNT CLSFIL();

	for (i = 0, ctnum = key, fndnum = NULL, lstusd = MAXAGE;
	    i++ < maxfil; ctnum++)
		if (ctnum->usecnt && ctnum->usecnt <= lstusd &&
		    ctnum->chnacs == 'y' && ctnum->kmem < 1 &&
		    !(ctnum->flmode & PERMANENT) && !ctnum->lokcnt)
			lstusd = (fndnum = ctnum)->usecnt;

	if ((ctnum = fndnum) == NULL)
		return(NO);
	else {
		if (CLSFIL(ctnum->filnum,ctnum->flmode))
				return(NO);

		ctnum->usecnt = 0;
		for (i = 0; i++ <= fndnum->nmem; ctnum++)
			ctnum->chnacs = 'v';
		return(YES);
	}
}


/* ---------------------------------------------------------------- */

UCOUNT inrfil(ctnum)
PFAST CTFILE *ctnum;

{
	CTFILE      *calnum;
	FAST COUNT   i;
	UCOUNT       minage;

	ctnum -= (calnum = ctnum)->kmem;
	if (ctnum->flmode & PERMANENT) /* not a virtual file */
		return(0);
	else if (++lstfil)		/* then file age did not rollover */
		return(calnum->usecnt = lstfil);

	for (i = 0, ctnum = key, minage = MAXAGE; i++ < maxfil; ctnum++)
		if (ctnum->usecnt && ctnum->usecnt <= minage &&
		    ctnum->kmem < 1)
			minage = ctnum->usecnt;

	lstfil = MAXAGE - (--minage) + 1;
	for (i = 0, ctnum = key; i++ < maxfil; ctnum++)
		if (ctnum->usecnt)
			ctnum->usecnt -= minage;
	return(calnum->usecnt = lstfil);
}


/* --------------------------------------------------------------------
   routine to copy tree buffer contents. it does not terminate on null
   byte.
 */


VOID cpybuf(dp,sp,n)

PFAST TEXT *dp,*sp;
PFAST COUNT n;

{
	while (n-- > 0)
		*dp++ = *sp++;
}

COUNT uerr(err_no)

COUNT err_no;

{
	return(uerr_cod = err_no);
}

VOID terr(err_no)

COUNT err_no;

{
	printf("\nc-tree fatal error #%d.",err_no);
	exit(0);
}


/* --------------------------------------------------------------------
   test to see if update flag is set. if not, set it.
 */

COUNT  tstupd(ctnum)
PFAST CTFILE *ctnum;

{
#ifdef NOTFORCE

	COUNT wrthdr();

	ctnum -= ctnum->kmem;
	if (!(ctnum->updflg)) {
		ctnum->updflg = UPDATED;
		if (wrthdr(ctnum))
			return(uerr_cod);
	}
#endif
	return(NO_ERROR);
}


/* --------------------------------------------------------------------
   read file header record
*/

COUNT  redhdr(ctnum)
PFAST CTFILE *ctnum;

{
	FAST COUNT	i;
	COUNT		nomemb;
	POINTER		recbyt;

	if (ctio(CTREAD,ctnum,recbyt = DRNZERO,ctnum,HDRSIZ))
		return(uerr_cod);
	if (ctnum->clstyp == IDX_CLOSE) {
		nomemb = ctnum->nmem;
		for (i = 1; i <= nomemb; i++) {
			recbyt += HDRSIZ;
			if (ctio(CTREAD,ctnum,recbyt,ctnum + i,HDRSIZ))
				return(uerr_cod);
		}
	}
	return(NO_ERROR);
}


/* --------------------------------------------------------------------
   write file header record
 */

COUNT  wrthdr(ctnum)
PFAST CTFILE *ctnum;

{
	FAST COUNT	i;
	COUNT		nomemb;
	POINTER		recbyt;

	ctnum -= ctnum->kmem;
	nomemb = ctnum->nmem;
	for (i = 0,recbyt = 0; i <= nomemb; i++,recbyt += HDRSIZ)
		if (ctio(CTWRITE,ctnum,recbyt,ctnum + i,HDRSIZ))
			return(uerr_cod);
	return(NO_ERROR);
}


COUNT OPNFIL(filno,filnam,filmod)

COUNT filno;  /* data number temporary assigned to file */
TEXT *filnam; /* pointer to file name */
COUNT filmod; /* EXCLUSIVE or SHARED / VIRTUAL or PERMANENT */

{
	FAST CTFILE *ctnum,*knum;
	COUNT        opnflg;

	COUNT        wrthdr(),redhdr();

	uerr_cod = opnflg = NO;
	ctnum = key + filno;
	if (filno < 0 || maxfil <= filno)
		uerr_cod = FNUM_ERR;
	else if (ctnum->chnacs != 'n')
		uerr_cod = FUSE_ERR;
	else {
		cpybuf(ctnum->flname,filnam,MAX_NAME);
		ctnum->usecnt = 0;
		if ((ctnum->fd = mbopen(ctnum,filmod)) < 0)
			/* does not exist */
			uerr_cod = FNOP_ERR;
		else {
		    opnflg = YES;
		    if (redhdr(ctnum))
			/* no further action */ ;
		    else if (ctnum->clstyp < DAT_CLOSE ||
		      ctnum->clstyp > VAT_CLOSE)
			uerr_cod = FUNK_ERR;
		    else if (ctnum->recsiz > (nodsec * SECSIZ))
			uerr_cod = KSIZ_ERR;
		    else if (ctnum->kversn != ct_ver)
			uerr_cod = FVER_ERR;
		    else if (ctnum->length > MAXLEN)
			uerr_cod = KLEN_ERR;
		    else if (ctnum->updflg == COMPACT)
			uerr_cod = FCMP_ERR;
		    else if (ctnum->nmem > MAXMEMB || ctnum->kmem > 0)
			uerr_cod = KMEM_ERR;
		    else if (ctnum->updflg)
			uerr_cod = FCRP_ERR;
		}
	}

	if (uerr_cod) {
		if (opnflg)
			mbclos(ctnum,COMPLETE);
		return(uerr_cod);
	} else {
		if (ctnum->clstyp == VAT_CLOSE)
			filmod |= VLENGTH;
		if (ctnum->flmode != filmod) {
			ctnum->flmode = filmod;
			if (wrthdr(ctnum)) {
				opnflg = uerr_cod;
				mbclos(ctnum,COMPLETE);
				return(uerr(opnflg));
			}
		}
		ctnum->datnum = filno;
		ctnum->usecnt = inrfil(ctnum);
		for (knum = ctnum; filno <= (ctnum->datnum + ctnum->nmem); 
		    filno++,knum++) {
			if (knum->datacs != 'n') {
				mbclos(ctnum,COMPLETE);
				return(uerr(FUSE_ERR));
			}
			knum->datnum = filno;
			knum->datacs = 'y';
			knum->retelm = knum->lokcnt = 0;
			knum->retnod = NODEZERO;
			if (filno > ctnum->datnum)
				knum->fd = -1;
		}
		return(NO_ERROR);
	}
}


/* --------------------------------------------------------------------
   write node contained in buffer to disk file. returns non-zero value if
   error.
 */

COUNT wrtnod(buffer)

PFAST TREEBUFF *buffer; 	/* pointer to buffer containing node to be 
			           written to disk */

{
	FAST KEYFILE *knum; /* key number pointer */
	FAST TEXT *sp,*dp;
	COUNT i,membno;

	COUNT uerr();

/* set file pointer & member # */

	membno = (knum = key + buffer->keyid)->kmem;
	if (membno > 0)
		knum -= membno;

/* check member number */

	if (buffer->bmem != membno)
		terr(230);

/* move node status info to i/o buffer */

	for (i = 0, sp = (TEXT *) &buffer->sucesr, dp = buffer->nodorg;
	    i++ < STATUS ; )
		*dp++ = *sp++;

/* write node to disk */

	if (ctio(CTWRITE,knum,buffer->nodeid,buffer->nodorg,knum->recsiz))
		return(uerr_cod);

	buffer->update = 'n';

#ifdef FPUTFGET

/* clobber buffer status information so that subsequent calls to getnod
   will not think that buffer contains a valid node
 */

	buffer->keyid = -1;
	buffer->nodeid = -1;
#endif

	return(NO_ERROR);
}


/* --------------------------------------------------------------------
   routine to close files
 */

COUNT CLSFIL(filno,filmod)
COUNT filno;
COUNT filmod;	/* COMPLETE or PARTIAL */ 

{
	FAST           i;
	FAST CTFILE   *ctnum;
	FAST TREEBUFF *buf;
	CTFILE        *knum;
	COUNT          lowi,hghi;

	COUNT wrthdr(),wrtnod();

	uerr_cod = 0;
	ctnum = key + filno;
	if (filno < 0 || maxfil <= filno)
		return(uerr(FNUM_ERR));
	else if (ctnum->chnacs == 'n')
		return(uerr(FACS_ERR));
	else if (ctnum->kmem > 0)
		return(uerr(KMEM_ERR));
	else if (ctnum->chnacs == 'v') {
		ctnum->chnacs = 'n';
		return(NO_ERROR);
	}


	if (ctnum->clstyp != DAT_CLOSE) {
	    lowi = ctnum->filnum;
	    hghi = lowi + ctnum->nmem;
	    for (i = 0, buf = btree; i < maxbuf; i++, buf++) {
		if (buf->keyid >= lowi && buf->keyid <= hghi) {
			if (buf->update == 'y') {
				if (ctnum->updflg) {
					if (wrtnod(buf))
						return(uerr_cod);
				} else
					terr(206);
			}
			buf->keyid = -1;
		}
	    }
	}

	for (i = 0,knum = ctnum; i++ <= ctnum->nmem; knum++)
		knum->chnacs = 'n';

	if (ctnum->updflg) {
		ctnum->updflg = NO;
		if (wrthdr(ctnum))
			return(uerr_cod);
	}
	
	if (mbclos(ctnum,filmod) < 0)
		return(uerr(FCLS_ERR));
	return(NO_ERROR);
}

/*
 *	common utility routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
