/*
 *	isam routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 26, 1985 16:28
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/
#include "ctisam.h"		/* c-tree isam header		*/

POINTER  NEWREC(),EQLKEY(),GTEKEY(),NXTKEY(),PRVKEY(),FRSKEY();
POINTER  LSTKEY(),GTKEY(),LTKEY();
COUNT    compar(),ADDKEY();
COUNT    DELCHK(),REDREC(),WRTREC(),RETREC(),frmkey();
COUNT    ierr(),addlok();
DATFILE *tstdnm();

COUNT ismred(datno,keyno,pntr,recptr)

COUNT   datno,keyno;
POINTER pntr;
TEXT   *recptr;
{
#ifdef FPUTFGET
	TEXT chkkey[MAXLEN];
#endif

	if (REDREC(datno,pntr,recptr))
		return(ierr(uerr_cod,datno));

	if (*recptr == DELFLG)
#ifndef FPUTFGET
		return(ierr(IRED_ERR,datno));
#else
		return(ierr(ITIM_ERR,datno));

	frmkey(keyno,recptr,chkkey,pntr);
	if (compar(chkkey,fndval,key+keyno))
		return(ierr(ITIM_ERR,datno));
#endif

	cur_recno[datno] = pntr;
	cur_image[datno] = recptr;
	return(ierr(NO_ERROR,0));
}

COUNT revmap(keyno)

COUNT keyno;

{
	FAST COUNT datno,j;
	COUNT	   i;

	for (i = 0; i < maxdat; i++) {
		datno = i;
		for (j = 0; j < MAX_DAT_KEY; j++)
			if (keymap[datno][j] == keyno)
				return(datno);
			else if (keymap[datno][j] < 0)
				break;
	}
	return(-1);
}

COUNT reset_cur(keyno,pntr,recptr)

PFAST COUNT keyno;
POINTER     pntr;
TEXT       *recptr;
{
	FAST COUNT datno;

	if (!pntr)
		if (uerr_cod)
			return(ierr(uerr_cod,keyno));
		else
			return(ierr(INOT_ERR,keyno)); /* target not found */

	datno = revmap(keyno);
	if (addlok(pntr,datno))
		return(isam_err);
	else
		return(ismred(datno,keyno,pntr,recptr));
}


COUNT LKISAM(lokmod)

COUNT lokmod; /* FREE(0)  RESET(1)  ENABLE(2) */

{
	FAST COUNT i;
	FAST LOKS *lp;

	COUNT UDLOCK();

	for (i = 0, lp = locks; i < MAX_LOCKS; i++,lp++)
		if (lp->datfnm >= 0) {
			if (lokmod != ENABLE) {
				UDLOCK(lp->recnum,dat + lp->datfnm);
				lp->datfnm = -1;
			} else
				return(ierr(IPND_ERR,0));
		}
	if (lokmod == FREE)
		isam_lok = NO;
	else
		isam_lok = YES;
	return(isam_err = NO_ERROR);
}
	
COUNT ADDREC(datno,recptr)

PFAST COUNT datno;
TEXT       *recptr;

{
	POINTER    pntr;
	FAST COUNT i,keyno;
	DATFILE   *dnum;

	isam_err = NO_ERROR;
	if ((dnum = tstdnm(datno)) == NULL)
		return(ierr(uerr_cod,datno));
	else if (dnum->clstyp != DAT_CLOSE)
		return(ierr(FMOD_ERR,datno));
	else if ((pntr = NEWREC(datno)) == DRNZERO)
		return(ierr(uerr_cod,datno));

	nwrcfg = YES;
	if (addlok(pntr,datno))
		return(isam_err);

	if (WRTREC(datno,pntr,recptr)) {
		ierr(uerr_cod,datno);
		undo(ISADD,datno,0,recptr,pntr);
		return(isam_err);
	}

	for (i = 0; i < MAX_DAT_KEY; i++) {
		if ((keyno = keymap[datno][i]) < 0 )
			break;
		if (frmkey(keyno,recptr,keyval,DRNZERO))
			if (ADDKEY(keyno,keyval,pntr,REGADD)) {
				ierr(uerr_cod,keyno);
				undo(ISADD,datno,i,recptr,pntr);
				return(isam_err);
			}
	}

	cur_recno[datno] = pntr;
	cur_image[datno] = recptr;
	return(NO_ERROR);
}

POINTER chkism(datno)
COUNT datno;

{
	DATFILE *dnum;
	POINTER  pntr;

	isam_err = NO_ERROR;

	if ((dnum = tstdnm(datno)) == NULL)
		ierr(uerr_cod,datno);
	else if (dnum->clstyp != DAT_CLOSE)
		ierr(FMOD_ERR,datno);
	else if (!(pntr = cur_recno[datno]))
		ierr(ICUR_ERR,datno);
	else
		addlok(pntr,datno);

	if (!isam_err)
		return(pntr);
	else
		return(0);
}
	


COUNT RWTREC(datno,recptr) /* assumes that current record for datno is old
			      version to be rewritten by recptr */
PFAST COUNT datno;
TEXT       *recptr;

{
	POINTER    pntr;
	FAST COUNT i,keyno;
	COUNT      new_flg,old_flg;

	if (!(pntr = chkism(datno)))
		return(isam_err);

	for (i = 0; i < MAX_DAT_KEY; i++) {
		if ((keyno = keymap[datno][i]) < 0 )
			break;
		old_flg = frmkey(keyno,cur_image[datno],fndval,pntr);
		new_flg = frmkey(keyno,recptr,keyval,pntr);           /* new key */
		if (compar(fndval,keyval,key + keyno))  { /* old <> new */
			if (old_flg && DELCHK(keyno,fndval,pntr)) {
				ierr(uerr_cod,keyno);
				undo(ISRWT,datno,i,recptr,pntr);
				return(isam_err);
			}
			if (new_flg && ADDKEY(keyno,keyval,pntr,REGADD)) {
				ierr(uerr_cod,keyno);
				ADDKEY(keyno,fndval,pntr,REGADD);
				undo(ISRWT,datno,i,recptr,pntr);
				return(isam_err);
			}
		}
	}

	if (WRTREC(datno,pntr,recptr)) {
		ierr(uerr_cod,datno);
		undo(ISRWT,datno,i,recptr,pntr);
		return(isam_err);
	}

	cur_recno[datno] = pntr;
	cur_image[datno] = recptr;
	return(NO_ERROR);
}

COUNT DELREC(datno)

PFAST COUNT datno;

{
	TEXT      *recptr;
	POINTER    pntr;
	FAST COUNT i,keyno;

	if (!(pntr = chkism(datno)))
		return(isam_err);

	recptr = cur_image[datno];
	for (i = 0; i < MAX_DAT_KEY; i++) {
		if ((keyno = keymap[datno][i]) < 0)
			break;
		if (frmkey(keyno,recptr,keyval,DRNZERO))
			if (DELCHK(keyno,keyval,pntr)) {
				ierr(uerr_cod,keyno);
				undo(ISDEL,datno,i,recptr,pntr);
				return(isam_err);
			}
	}

	if (RETREC(datno,pntr)) {
		ierr(uerr_cod,datno);
		undo(ISDEL,datno,i,recptr,pntr);
		return(isam_err);
	}

	return(NO_ERROR);
}

COUNT EQLREC(keyno,target,recptr)

PFAST COUNT keyno;
PFAST TEXT *target;
PFAST TEXT *recptr;

{
#ifdef FPUTFGET
	cpybuf(fndval,target,MAXLEN);
#endif
	return(reset_cur(keyno,EQLKEY(keyno,target),recptr));
}

COUNT GTEREC(keyno,target,recptr)

PFAST COUNT keyno;
PFAST TEXT *target;
PFAST TEXT *recptr;

{
	return(reset_cur(keyno,GTEKEY(keyno,target,fndval),recptr));
}

COUNT NXTREC(keyno,recptr)

PFAST COUNT keyno;
TEXT       *recptr;

{
	FAST COUNT datno;
	POINTER    pntr;

	KEYFILE *tstknm();

	if (tstknm(keyno) == NULL)
		return(ierr(uerr_cod,keyno));
	if (!(pntr = cur_recno[datno = revmap(keyno)]))
		return(ierr(ICUR_ERR,datno));

	if (frmkey(keyno,cur_image[datno],keyval,pntr))
		return(reset_cur(keyno,GTKEY(keyno,keyval,fndval),recptr));
	else
		return(ierr(INOT_ERR,keyno));
}

COUNT PRVREC(keyno,recptr)

PFAST COUNT keyno;
TEXT       *recptr;

{
	COUNT    datno;
	POINTER  pntr;

	KEYFILE *tstknm();

	if (tstknm(keyno) == NULL)
		return(ierr(uerr_cod,keyno));
	if (!(pntr = cur_recno[datno = revmap(keyno)]))
		return(ierr(ICUR_ERR,datno));

	if (frmkey(keyno,cur_image[datno],keyval,pntr))
		return(reset_cur(keyno,LTKEY(keyno,keyval,fndval),recptr));
	else
		return(ierr(INOT_ERR,keyno));
}

COUNT FRSREC(keyno,recptr)

PFAST COUNT keyno;
PFAST TEXT *recptr;

{
	return(reset_cur(keyno,FRSKEY(keyno,fndval),recptr));
}

COUNT LSTREC(keyno,recptr)

PFAST COUNT keyno;
TEXT       *recptr;

{
	return(reset_cur(keyno,LSTKEY(keyno,fndval),recptr));
}

VOID undo(op_code,datno,i,recptr,pntr)

COUNT       op_code;
PFAST COUNT datno;
PFAST COUNT i;
TEXT       *recptr;
POINTER     pntr;
		
{
	FAST COUNT keyno;
	COUNT      old_flg,new_flg;

	if (op_code == ISADD)
		RETREC(datno,pntr);

	for (i--; i >= 0 ; i--) {
	    keyno = keymap[datno][i];
	    if (op_code != ISRWT) {
		if (frmkey(keyno,recptr,keyval,DRNZERO))
			if (op_code == ISADD)
				DELCHK(keyno,keyval,pntr);
			else
				ADDKEY(keyno,keyval,pntr,REGADD);
	    } else {
		old_flg = frmkey(keyno,cur_image[datno],fndval,pntr);
		new_flg = frmkey(keyno,recptr,keyval,pntr);
		if (compar(fndval,keyval,key + keyno)) {
			if (new_flg)
				DELCHK(keyno,keyval,pntr);
			if (old_flg)
				ADDKEY(keyno,fndval,pntr,REGADD);
		}
	    }
	}
}


/*
 *	isam routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 26, 1985 16:28
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
