/*
 *	isam open & close routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/
#include "ctisam.h"		/* c-tree isam header		*/

COUNT OPNFIL(),CLSFIL(),getintr(),getdatr(),getidxr(),getambr(),ierr();

COUNT OPNISAM(filnam)
TEXT *filnam;

{
	FILE      *ifd;
	FAST COUNT i,j,k;
	COUNT      nbufs,nkeys,nsecs,dkeys;
	COUNT      nomemb,datno,filemd,keyno,klen,ktyp,dflg;
	UCOUNT	   datlen,xtdsiz;
	TEXT       isam_nam[MAX_NAME];
	LOKS      *lp;

	FILE *fopen();

	isam_err = NO_ERROR;
	if ((ifd = fopen(filnam,"r")) == NULL)
		return(ierr(INOD_ERR,0));

	if (getintr(ifd,&nbufs,&nkeys,&nsecs,&isdats))
		return(isam_err);
	if (INTREE(nbufs,nkeys + isdats,nsecs))
		return(ierr(uerr_cod,0));

	for (i = 0; i < maxfil; ) {
		datmap[i]      = NO;
		keymap[i++][0] = -1;
	}

	for (i = 0; i < isdats; i++) {
		if (getdatr(ifd,&datno,isam_nam,&datlen,&dkeys,&xtdsiz,
		    &filemd))
			return(isam_err);

		if (OPNFIL(datno,isam_nam,filemd))
			return(ierr(uerr_cod,i));

		for (j = 0; j < dkeys; j++) {
			if (getidxr(ifd,datno,j,&keyno,isam_nam,&klen,&ktyp,
			    &dflg,&nomemb,&xtdsiz,&filemd))
				return(isam_err);

	    		if (OPNFIL(keyno,isam_nam,filemd))
				return(ierr(uerr_cod,keyno));

			for (k = 1; k <= nomemb; k++)
				if (getambr(ifd,datno,j + k,keyno + k,&klen,
				    &ktyp,&dflg))
					return(isam_err);
			j += nomemb;
		}
		if (j < MAX_DAT_KEY)
			keymap[datno][j] = -1;
	}
	fclose(ifd);
	for (i = 0,lp = locks; i < MAX_LOCKS; i++,lp++)
		lp->datfnm = -1;
	return(NO_ERROR);
}

COUNT CLISAM()

{
	COUNT i,err_flag;

	err_flag = NO_ERROR;
	for (i = 0; i < maxfil; i++)
		if (datmap[i])
			if (CLSFIL(i,(key + i)->flmode))
				if (!err_flag)
					err_flag = ierr(uerr_cod,i);

	mbfree(origin);
	mbfree(key);
	mbfree(btree);
	return(err_flag);
}

/*
 *	isam open & close routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
