/*
 *	isam utility routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/
#undef  EXTERN
#define EXTERN /* */
#include "ctisam.h"		/* c-tree isam header		*/

#ifdef PERC_H
#define IC1	"%h %h %h %h"
#define IC2	"%h %s %h %h %h %h"
#define IC3	"%h %h %h"
#define IC4	"%h %s %h %h %h %h %h %h %h %h %h"
#define IC5	"%h %h %h %h %h %h %h"
#endif
#ifdef PERC_D
#define IC1	"%d %d %d %d"
#define IC2	"%d %s %d %d %d %d"
#define IC3	"%d %d %d"
#define IC4	"%d %s %d %d %d %d %d %d %d %d %d"
#define IC5	"%d %d %d %d %d %d %d"
#endif
#ifdef PERC_HD
#define IC1	"%hd %hd %hd %hd"
#define IC2	"%hd %s %hd %hd %hd %hd"
#define IC3	"%hd %hd %hd"
#define IC4	"%hd %s %hd %hd %hd %hd %hd %hd %hd %hd %hd"
#define IC5	"%hd %hd %hd %hd %hd %hd %hd"
#endif


COUNT ierr(err_cod,file_no)

COUNT err_cod;
COUNT file_no;

{
	isam_fil = file_no;
	return(isam_err = err_cod);
}


COUNT addlok(pntr,datno)

POINTER pntr;
COUNT   datno;

{
	FAST COUNT   i,d;
	COUNT        is,tmpflg;
	FAST LOKS   *lp;

	tmpflg = nwrcfg;
	nwrcfg = NO;
	if (!isam_lok)
		return(NO_ERROR);
	for (i = 0, is = -1, lp = locks; i < MAX_LOCKS; i++,lp++)
		if ((d = lp->datfnm) < 0 && is < 0)
			is = i;
		else if (d == datno && lp->recnum == pntr)
			return(NO_ERROR);
	if (is < 0)
		return(ierr(INOL_ERR,datno));
	if (!tmpflg && DLOCK(pntr,dat + datno))
		return(ierr(uerr_cod,datno));
	(lp = locks + is)->datfnm = datno;
	lp->recnum = pntr;
	return(NO_ERROR);
}


TEXT ucase(t)
TEXT       t;
{
	if (t >= 'a' && t <= 'z')
		return((TEXT) (t + 'A' - 'a'));
	else
		return(t);
}


COUNT frmkey(keyno,recptr,txt,pntr)

COUNT       keyno;
TEXT       *recptr;
PFAST TEXT *txt;
POINTER	    pntr;

{
	FAST COUNT j;
	COUNT 	   i,k,len,slen;
	FAST TEXT *recpos;
	TEXT 	  *savtxt;

	savtxt = txt;
	for (i = len = 0; i < MAX_KEY_SEG; i++) {
		if ((k = segpos[keyno][i]) < 0)
			break;
		recpos = recptr + k;
		len   += (slen = seglen[keyno][i]);
		switch (segmod[keyno][i]) {
case REGSEG:
		for (j = 0; j++ < slen; )
			*txt++ = *recpos++;
		break;
case REVSEG:
		recpos += slen;
		for (j = 0; j++ < slen; )
			*txt++ = *(--recpos);
		break;
case UREGSEG:
		for (j = 0; j++ < slen; )
			*txt++ = ucase(*recpos++);
		break;
case UREVSEG:
		recpos += slen;
		for (j = 0; j++ < slen; )
			*txt++ = ucase(*(--recpos));
		break;
default:
		terr(226);
		}
	}

	slen = len;
	if ((key + keyno)->autodup) {
		recpos = (TEXT *) &pntr;
		len   += sizeof(POINTER);

#ifdef LOW_HIGH
		txt += sizeof(POINTER);
		for (j = 0; j < sizeof(POINTER); j++)
			*--txt = *recpos++;
#else
		for (j = 0; j < sizeof(POINTER); j++)
			*txt++ = *recpos++;
#endif
	}

	if (nulkey[keyno] == CHKNUL) {
		recpos = &nulchr[keyno];
		for (j = 0, txt = savtxt; j < slen; j++)
			if (*txt++ != *recpos)
				return(len);
		return(0);
	}
		
	return(len);
}

COUNT tstinm(filno)
COUNT filno;
{
	if (filno < 0 || filno >= maxfil)
		return(ierr(FNUM_ERR,filno));
	else if (datmap[filno])
		return(ierr(FUSE_ERR,filno));
	else {
		datmap[filno] = YES;
		return(NO_ERROR);
	}
}

COUNT getintr(ifd,pbufs,pkeys,psecs,pdats)
FILE  *ifd;
COUNT *pbufs,*pkeys,*psecs,*pdats;
{  
	if (fscanf(ifd,IC1,pbufs,pkeys,psecs,pdats) != 4)
		return(ierr(IGIN_ERR,0));
	else if ((*pdats + *pkeys) > MAXFIL)
		return(ierr(IFIL_ERR,0));
	else
		return(NO_ERROR);
}


COUNT getdatr(ifd,pdatno,pname,pdatln,pdkeys,pxtsiz,pfilmd)
FILE   *ifd;
COUNT  *pdatno;
TEXT   *pname;
UCOUNT *pdatln;
COUNT  *pdkeys;
UCOUNT *pxtsiz;
COUNT  *pfilmd;
{
	if (fscanf(ifd,IC2,pdatno,pname,pdatln,pxtsiz,pfilmd,pdkeys) != 6)
		return(ierr(IDRI_ERR,*pdatno));
	else if (*pdkeys > MAX_DAT_KEY)
		return(ierr(IDRK_ERR,*pdatno));
	else if (tstinm(*pdatno))
		return(isam_err);
	else 
		return(NO_ERROR);
}

COUNT setmap(datno,j,keyno,klen,ksegs,dflg,nchar,nulflg,ifd)
COUNT        datno,j,keyno,klen,ksegs,dflg,nchar,nulflg;
FILE						       *ifd;
{
	FAST COUNT k,totseg;

	keymap[datno][j] = keyno;
	nulchr[keyno]    = nchar;
	nulkey[keyno]    = nulflg;

	for (k = 0, totseg = klen; k < ksegs; k++) {
		if (fscanf(ifd,IC3,&segpos[keyno][k],
		    &seglen[keyno][k],&segmod[keyno][k]) != 3)
			return(ierr(ISRC_ERR,keyno));
		totseg -= seglen[keyno][k];
	}
	if ((dflg == DUPKEY && totseg != sizeof(POINTER)) ||
	    (dflg != DUPKEY && totseg))
		return(ierr(ISLN_ERR,keyno));

	if (k < MAX_KEY_SEG)
		segpos[keyno][k] = -1;
	return(NO_ERROR);
}


COUNT getidxr(ifd,datno,j,pkeyno,pname,pklen,pktyp,pdflg,pnmem,pxtsiz,pfilmd)
FILE   *ifd;
COUNT   datno,j,*pkeyno;
TEXT   *pname;
COUNT  *pklen,*pktyp,*pdflg,*pnmem;
UCOUNT *pxtsiz;
COUNT  *pfilmd;
{
	COUNT nulflg,nchar,ksegs;

	if (fscanf(ifd,IC4,pkeyno,pname,pklen,pktyp,pdflg,pnmem,pxtsiz,pfilmd,
	    &nulflg,&nchar,&ksegs)
	    != 11)
		return(ierr(IKRI_ERR,j));
	else if (ksegs > MAX_KEY_SEG)
		return(ierr(IKRS_ERR,*pkeyno));
	else if (tstinm(*pkeyno))
		return(isam_err);
	else
		return(setmap(datno,j,*pkeyno,*pklen,ksegs,*pdflg,
		    nchar,nulflg,ifd));
}

COUNT getambr(ifd,datno,j,keyno,pklen,pktyp,pdflg)
FILE   *ifd;
COUNT   datno,j,keyno,*pklen,*pktyp,*pdflg;
{
	COUNT impkey,nulflg,nchar,ksegs;

	if (fscanf(ifd,IC5,&impkey,pklen,pktyp,pdflg,&nulflg,
	    &nchar,&ksegs) != 7)
		return(ierr(IMRI_ERR,keyno));
	else if (impkey != keyno)
		return(ierr(IMKY_ERR,keyno));
	else if (ksegs > MAX_KEY_SEG)
		return(ierr(IKRS_ERR,keyno));
	else
		return(setmap(datno,j,keyno,*pklen,ksegs,*pdflg,
		    nchar,nulflg,ifd));
}


/*
 *	isam utility routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
