/*
 *	file creation
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 26, 1985 11:16
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/

COUNT  uerr();
UCOUNT inrfil();


/* CREDAT creates the data file with name pointed to by filnam, 
   and assigns datno to the data file.
 */

COUNT CREDAT(datno,filnam,datlen,xtdsiz,filmod)

COUNT  datno;  	/* data number temporary assigned to file 	*/
TEXT  *filnam; 	/* pointer to data file name 			*/
COUNT  datlen; 	/* minimum record length 			*/
UCOUNT xtdsiz;	/* how many bytes to extend file		*/
COUNT  filmod;	/* file mode parameter (VIRTUAL, VLENG or PERMANENT) 	*/

{
	FAST CTFILE *ctnum;
	COUNT mbclos();
	COUNT wrthdr();
	RNDFILE mbopen(),mbcrat();

	uerr_cod = 0;
	ctnum = vat + datno;
	if (datno < 0 || maxdat <= datno)
		uerr_cod = FNUM_ERR;
	else if (ctnum->datacs != 'n')
		uerr_cod = FUSE_ERR;
	else if (filmod >= VLENGTH) {
	  	ctnum->recsiz = nodsec * SECSIZ;
	  	ctnum->maxkvn = (ctnum->recsiz - STATUS) /
			(VARI_LEN + sizeof(POINTER));
	  	if (ctnum->maxkvn < 3)
			uerr_cod = KMIN_ERR;
	  	else if (VARI_LEN > MAXLEN)
			uerr_cod = KLEN_ERR;
	    	else
			ctnum->maxkvl = (ctnum->recsiz - STATUS) / VARI_LEN;
	} else if (datlen < (sizeof(POINTER) + 1))
		uerr_cod = DREC_ERR;

	if (!uerr_cod) {
	    ctnum->reclen = datlen;
	    ctnum->datnum = datno;
	    ctnum->flmode = filmod;
	    ctnum->usecnt = 0;
	    cpybuf(ctnum->flname,filnam,MAX_NAME);
	    if ((ctnum->vfd = mbopen(ctnum,filmod)) >= 0) {/* file exists */
		mbclos(ctnum,filmod);
		uerr_cod = DOPN_ERR;
	    } else if ((ctnum->vfd = mbcrat(ctnum)) < 0)
		uerr_cod = DCRAT_ERR;
	}

	if (uerr_cod)
		return(uerr_cod);
	else {
		ctnum->datacs  = 'y';
		ctnum->delstk  = DRNZERO;
		ctnum->nmem    = ctnum->kmem = 0;
		if (filmod >= VLENGTH) {
			ctnum->numrec = ctnum->recsiz - 1;
			ctnum->clstyp = VAT_CLOSE;
			ctnum->length = VARI_LEN;
		} else {
			ctnum->numrec = (((SECSIZ + datlen - 1) / datlen) *
				datlen) - 1;
			ctnum->clstyp = DAT_CLOSE;
			ctnum->recsiz = ctnum->length = 0;
		}
		ctnum->phyrec  = ctnum->numrec;
		ctnum->extsiz  = xtdsiz;
		ctnum->dupflg  = NO;
		ctnum->dversn  = ct_ver;
		ctnum->nodstk  = ctnum->root   = NODEZERO;
		ctnum->ktype   = 0;
		ctnum->nument  = DRNZERO;
		ctnum->autodup = 1;

		ctio(CTWRITE,ctnum,DRNZERO,btree,(UCOUNT) (ctnum->numrec + 1));
		if (wrthdr(ctnum))
			return(uerr_cod);

		ctnum->retelm = ctnum->lokcnt = 0;
		ctnum->retnod = NODEZERO;
		ctnum->usecnt = inrfil(ctnum);
		return(NO_ERROR);
	}
}


/* CREIDX creates the index file with name pointed to by filnam,
   assigns keyno to the index file
 */

COUNT CREIDX(keyno,filnam,keylen,keytyp,keydup,nomemb,xtdsiz,filmod)

COUNT  keyno;  	/* key number temporary assigned to index file 		*/
COUNT  keylen; 	/* key length 						*/
TEXT  *filnam; 	/* pointer index file name 				*/
COUNT  keytyp;  /* key type indicator ALPHAKEY => alphanumeric
				      INTKEY   => n byte integer 	*/
COUNT  keydup;  /* auto duplicate indicator DUPKEY/NODUPKEY 		*/
COUNT  nomemb;	/* number of additional indices in file			*/
UCOUNT xtdsiz;	/* file extension size					*/
COUNT  filmod;	/* file mode (VIRTUAL or PERMANENT)			*/

{
	FAST KEYFILE *knum;
	COUNT         i;

	COUNT mbclos();
	COUNT wrthdr();
	RNDFILE mbopen(),mbcrat();

	uerr_cod = 0;
	if (nomemb < 0 || nomemb > MAXMEMB)
		return(uerr(KMEM_ERR));
	if (keyno < 0 || maxkey <= (keyno + nomemb))
		return(uerr(FNUM_ERR));

	for (knum = key + keyno, i = 0; i <= nomemb; i++,knum++)
		if (knum->keyacs != 'n')
			return(uerr(FUSE_ERR));
		else {
			knum->keyacs = 'm';
			knum->kmem   = i;
		}

	knum         = key + keyno;
	knum->recsiz = nodsec * SECSIZ;
	knum->maxkvn = (knum->recsiz - STATUS) / (keylen + sizeof(POINTER));
	if (knum->maxkvn < 3)
		uerr_cod = KMIN_ERR;
	else if (keylen > MAXLEN)
		uerr_cod = KLEN_ERR;
	else {
	    if (keydup == DUPKEY)
		knum->maxkvl = (knum->recsiz - STATUS) / keylen;
	    else
		knum->maxkvl = knum->maxkvn;
	    knum->flmode = filmod;
	    knum->usecnt = 0;
	    cpybuf(knum->flname,filnam,MAX_NAME);
	    if ((knum->kfd = mbopen(knum,filmod)) >= 0) {/* file exists */
		mbclos(knum,filmod);
		uerr_cod = KOPN_ERR;
	    } else if ((knum->kfd = mbcrat(knum)) < 0)
		uerr_cod = KCRAT_ERR;
	}

	if (uerr_cod)
		return(uerr_cod);
	else {
		knum->nmem    = nomemb;
		knum->keyacs  = 'y';
		knum->keynum  = keyno;
		knum->nodstk  = knum->root   = NODEZERO;
		knum->length  = keylen;
		knum->ktype   = keytyp;
		knum->nument  = DRNZERO;
		knum->extsiz  = xtdsiz;
		knum->numrec  = knum->phyrec = ((((HDRSIZ * (nomemb + 1)) +
		    knum->recsiz - 1) / knum->recsiz) * knum->recsiz) - 1;

		knum->autodup = keydup;
		knum->updflg  = NO;
		knum->kversn  = ct_ver;
		knum->clstyp  = IDX_CLOSE;

		ctio(CTWRITE,knum,DRNZERO,btree,(UCOUNT) (knum->numrec + 1));
		if (wrthdr(knum))
			return(uerr_cod);

		knum->retelm = knum->lokcnt = 0;
		knum->retnod = NODEZERO;
		knum->usecnt = inrfil(knum);
		return(NO_ERROR);
	}
}

COUNT CREMEM(keyno,keylen,keytyp,keydup,membno)

COUNT  keyno;  	/* key number temporary to master index file 		*/
COUNT  keylen; 	/* key length 						*/
COUNT  keytyp;  /* key type indicator ALPHAKEY => alphanumeric
				      INTKEY   => n byte integer 	*/
COUNT  keydup;  /* auto duplicate indicator DUPKEY/NODUPKEY 		*/
COUNT  membno;	/* member number of index in master file		*/

{
	FAST KEYFILE *knum;

	COUNT   wrthdr();
	CTFILE *tstfnm();


	uerr_cod = 0;
	if ((knum = tstfnm(keyno)) == NULL)
		/* no action */ ;
	else if (knum->clstyp != IDX_CLOSE)
		uerr_cod = FMOD_ERR;
	else if (membno <= 0 || membno > knum->nmem)
		uerr_cod = KMEM_ERR;
	else if ((knum += membno)->keyacs != 'm')
		uerr_cod = FUSE_ERR;
	if (uerr_cod)
		return(uerr_cod);

	knum->nmem   = -1;
	knum->kmem   = membno;
	knum->fd     = -1;
	knum->recsiz = nodsec * SECSIZ;
	knum->maxkvn = (knum->recsiz - STATUS) / (keylen + sizeof(POINTER));

	if (knum->maxkvn < 3)
		return(uerr(KMIN_ERR));
	else if (keylen > MAXLEN)
		return(uerr(KLEN_ERR));

	if (keydup == DUPKEY)
		knum->maxkvl = (knum->recsiz - STATUS) / keylen;
	else
		knum->maxkvl = knum->maxkvn;

	knum->flmode  = -1;
	knum->usecnt  = 0;
	knum->keyacs  = 'y';
	knum->keynum  = keyno + membno;
	knum->nodstk  = knum->root   = NODEZERO;
	knum->length  = keylen;
	knum->ktype   = keytyp;
	knum->nument  = DRNZERO;
	knum->extsiz  = -1;
	knum->numrec  = knum->phyrec = - 1;
	knum->autodup = keydup;
	knum->updflg  = NO;
	knum->kversn  = ct_ver;
	knum->clstyp  = IDX_CLOSE;

	if (wrthdr(knum))
		return(uerr_cod);

	knum->retelm = knum->lokcnt = 0;
	knum->retnod = NODEZERO;
	return(NO_ERROR);
}

/*
 *	file creation
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 26, 1985 11:16
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
