/*
 *	index file kernel
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/


#ifdef FPUTFGET
	COUNT redhdr();
#endif

/* --------------------------------------------------------------------
   general purpose node search function. works with leaf and non-leaf nodes.
   returns relative position in node of key value satisfying search request
   as well as setting the global variable elemnt to this value. also sets
   the global variable tstkey which indicates the sense of the comparison
   between the target key value (pointed to by idxval) and the key values
   actually in the index structure. if search is not satisfied, nodser
   returns a value of -2. if idxval greater than high key, then nodser
   returns a value of -1.
 */

COUNT nodser(buffer,idxval,stratg)

PFAST TREEBUFF *buffer; /*pointer to buffer containing node */
TEXT *idxval; 		/* pointer to target key value */
TEXT stratg; 		/* search strategy: E == eq  L == le  S == le (from
			 * leaf node)
			 */

{
	COUNT compar();
	TEXT *valpnt();

	LOCAL COUNT begser,endser,size;
	FAST KEYFILE *knum;

	knum = key + buffer->keyid; /* determine key number pointer */

/* perform a binary search of node until there are less than 4 key values
   to be searched; but first check high key.
*/

	begser = 1;
	endser = buffer->nkv;

/* high key comparison
*/
	if ((buffer->leaf == LEAF && 
	    (compar(idxval,valpnt(buffer,knum->maxkvl),knum) > 0 ||
	    (stratg == 'S' && !endser && buffer->sucesr))) || 
	    (buffer->leaf == NOLEAF && 
	    compar(idxval,valpnt(buffer,endser),knum) > 0)) {
		/* target exceeds high key value for node */
		tstkey = 1;
		elemnt = 0;
		return(-1);
	}

/* check for empty (leaf) node
*/
	if (!endser) {
		elemnt = 0;
		tstkey = -1;
		return(-2);
	}

/* binary search of node
*/		

	while ((size = endser - begser + 1) > 3) {
		elemnt = begser + size / 2;
		tstkey = compar(idxval,valpnt(buffer,elemnt),knum);
		if (tstkey > 0)
			begser = elemnt + 1;
		else if (!tstkey)
			return (elemnt);
		else
			endser = elemnt;
	}
	if (begser > endser) /* then corrupt node */
		terr(207);

/* perform sequential search over remaining possibilities */

	for (elemnt = begser;elemnt <= endser;elemnt++) {
		tstkey = compar(idxval,valpnt(buffer,elemnt),knum);
		if (tstkey < 0 && stratg == 'E')
			return(-2);
		else if (tstkey <= 0)
			return(elemnt);
	}
	if (stratg == 'S' && buffer->sucesr) {
		tstkey = 1;
		elemnt = 0;
		return(-1);
	} else
		return(-2);
}

VOID setnul(s)

TEXT *s;

{
	*s = '\0';
	return;
}


/* --------------------------------------------------------------------
   getnod searches the buffer area for the requested b-tree node (specified
   by node number and key number (pointer)). if found, it returns pointer to
   buffer; else it pushes out the least recently used node and reads the
   requested node into the vacated buffer, passing back a pointer to this 
   buffer.
 */

TREEBUFF *getnod(node,knum)

NODEPTR node; 	/* node number requested */
KEYFILE *knum; 	/* key number pointer */

{
	TREEBUFF *lrubuf(); 	/* function returning pointer to least
				    recently used buffer */
	COUNT rednod(); 	/* function to read node */
	VOID inracs(); 		/* update buffer age & check for rollover */

	FAST TREEBUFF *getflg;
	FAST TREEBUFF *fndbuf; 
						/* pointers to buffers */
	FAST COUNT i; /* counter */
	LOCAL UCOUNT lstusd; /* store for finding node (buffer) with lowest
			 node access number; ie lru buffer */ 

	fndbuf = btree;
	lstusd = fndbuf->nodacs;
	for (i = 0; i++ < maxbuf; fndbuf++) {
		if (fndbuf->nodeid == node && fndbuf->keyid == knum->keynum) {

#ifdef FPUTFGET
			if (fndbuf->update == 'y') 
				terr(208);
			if (rednod(fndbuf,node,knum))
				return(NULL);
#endif

			inracs(fndbuf);            /* node found; update node
 						      access count and return
						      pointer to buffer
						    */
			return(fndbuf);
		}
		if (fndbuf->nodacs <= lstusd) /* set getflg to buffer pointer
						 with lowest nodacs */
			lstusd = (getflg = fndbuf)->nodacs;
	}


/* node not found in buffers. read node into lru buffer */

	if ((fndbuf = lrubuf(getflg)) == NULL) /* then error in lrubuf */
		return(NULL);
	if (rednod(fndbuf,node,knum))	/* then error in rednod */
		return(NULL);
	return(fndbuf);
}


/* --------------------------------------------------------------------
   return pointer to buffer containing lru buffer. if lru buffer contains
   an updated node, write out the node to appropriate index file
 */
  
TREEBUFF *lrubuf(getflg)

PFAST TREEBUFF *getflg; /* if non-zero, then pointer to buffer
			       containing lru buffer; ie, the lru buffer
			       has already been determined */

	
{
	COUNT wrtnod();		/* write updated node back to disk */
	FAST COUNT i;		/* counter */
	FAST TREEBUFF *fndbuf; 	/* pointer to buffer */
	LOCAL UCOUNT lstusd;    /* store to determine buffer with lowest
				   node access number */

	if (!getflg) {		/* lru buffer has not been determined yet */
		fndbuf = btree;
		lstusd = fndbuf->nodacs;
		for (i = 0; i++ < maxbuf; fndbuf++)
			if (fndbuf->nodacs <= lstusd)
				lstusd = (getflg = fndbuf)->nodacs;
	}

	if (getflg->update == 'y')  /* lru node has been updated. write it */
		if (wrtnod(getflg)) /* then write error */
			return(NULL);
	return(getflg);		    /* return lru buffer ptr */
}


/* --------------------------------------------------------------------
   increment buffer age & check for roll over
 */

VOID inracs(buffer)

PFAST TREEBUFF *buffer;

{
	FAST TREEBUFF *tmpbuf;
	FAST COUNT i;
	LOCAL UCOUNT minage;

	if (++lstacs)	/* then buffer age did not rollover */
		buffer->nodacs = lstacs;
	else {		/* buffer age rollover. must adjust all buffer ages */
		tmpbuf = btree;
		minage = MAXAGE;
		for (i = 0; i++ < maxbuf; tmpbuf++)
			if (tmpbuf->nodacs < minage && tmpbuf->nodacs)
				minage = tmpbuf->nodacs;
		--minage;
		lstacs = MAXAGE - minage + 1;
		tmpbuf = btree;
		for (i = 0; i++ < maxbuf; tmpbuf++)
			if (tmpbuf->nodacs)
				tmpbuf->nodacs -= minage;
		buffer->nodacs = lstacs;
	}
}


/* --------------------------------------------------------------------
   read b-tree node from the index file pointed to by knum into the
   b-tree buffer. returns non-zero value if error.
 */

COUNT rednod(buffer,node,knum)

PFAST TREEBUFF *buffer;
PFAST KEYFILE  *knum;
NODEPTR         node;

{

	TEXT      *sp,*dp;
	COUNT      i;
	CTFILE    *ctnum;

	VOID inracs();
	COUNT uerr();

/* update buffer status information */

	buffer->nodeid = node;
	buffer->keyid  = knum->keynum;
	buffer->update = 'n';
	buffer->klen   = knum->length;
	inracs(buffer);

/* read node into buffer */

	if (knum->kmem > 0)
		ctnum = knum - knum->kmem;
	else
		ctnum = knum;
	if (ctio(CTREAD,ctnum,node,buffer->nodorg,ctnum->recsiz))
		return(uerr_cod);

/* move node status info to TREEBUFF area */

	for (i = 0, dp = (TEXT *) &buffer->sucesr, sp = buffer->nodorg;
	    i++ < STATUS ; )
		*dp++ = *sp++;

/* check member number */

	if (buffer->bmem != knum->kmem)
		terr(231);

	if (buffer->leaf == LEAF) {
		buffer->maxkv = knum->maxkvl;
		if (knum->autodup == DUPKEY)
			buffer->confg = DUPLEAF;
		else
			buffer->confg = REGULAR;
	} else {
		buffer->maxkv = knum->maxkvn;
		buffer->confg = REGULAR;
	}

	return(NO_ERROR);
}


/* --------------------------------------------------------------------
   return the number of entries in the index file pointed to by knum 
 */

POINTER IDXENT(keyno)

PFAST COUNT keyno;

{
	KEYFILE *tstknm();
	KEYFILE *knum;

	uerr_cod = 0;
	if ((knum = tstknm(keyno)) == NULL) /* then error condition */
		return(0);

#ifdef FPUTFGET
	if (redhdr(knum - knum->kmem)) /* then error */
		return(0);
#endif

	return(knum->nument);
}



/* --------------------------------------------------------------------
   return root node #
*/

NODEPTR gtroot(knum)

PFAST KEYFILE *knum;

{
#ifdef FPUTFGET

	if (redhdr(knum - knum->kmem))
		return(0);
#endif

	return(knum->root);
}


/* --------------------------------------------------------------------
   return pointer to key value in designated position of buffer
 */

TEXT *valpnt(buffer,elemnt)

PFAST TREEBUFF *buffer;
PFAST COUNT elemnt;

{
	if (buffer->confg == REGULAR)
	    return(buffer->keyval + 
		(elemnt-1) * (buffer->klen + sizeof(POINTER)) +
		sizeof(POINTER));
	else
	    return(buffer->keyval + (elemnt-1) * buffer->klen);
}


/* --------------------------------------------------------------------
   return node pointer value
 */

NODEPTR nodpnt(buffer,elemnt)

TREEBUFF *buffer;
PFAST COUNT elemnt;

{
	LOCAL POINTER tp;

	if (buffer->confg == DUPLEAF)
		terr(209);
	cpybuf(&tp,valpnt(buffer,elemnt) - sizeof(POINTER),sizeof(POINTER));
	return((NODEPTR) tp);
}
	
/* --------------------------------------------------------------------
   return drn pointer value
 */

#ifdef LOW_HIGH

POINTER drnpnt(buffer,elemnt)

TREEBUFF *buffer;
COUNT elemnt;

{
	FAST TEXT *tp,*pp;
	FAST COUNT i;
	LOCAL POINTER pntr;

	pp = (TEXT *) &pntr;
	tp = valpnt(buffer,elemnt);
	if (buffer->confg == REGULAR)
		cpybuf(pp,tp - sizeof(POINTER),sizeof(POINTER));
	else {
		tp += buffer->klen;
		for (i = 0; i++ < sizeof(POINTER);)
			*pp++ = *--tp;
	}
	return(pntr);
}

#else

POINTER drnpnt(buffer,elemnt)

TREEBUFF *buffer;
PFAST COUNT elemnt;

{
	FAST TEXT    *tp;
	LOCAL POINTER pntr;

	tp = valpnt(buffer,elemnt) - sizeof(POINTER);
	if (buffer->confg != REGULAR)
		tp += buffer->klen;
	cpybuf(&pntr,tp,sizeof(POINTER));
	return(pntr);
}

#endif


/* --------------------------------------------------------------------
   sets the pointer value in node.  
 */

VOID stpntr(buffer,elemnt,pntval)

TREEBUFF   *buffer;
PFAST COUNT elemnt;
POINTER     pntval;

{
	LOCAL POINTER pntr;

	pntr = pntval;
	if (buffer->confg == REGULAR)
		cpybuf(valpnt(buffer,elemnt) - sizeof(POINTER),&pntr,
			sizeof(POINTER));
	/* else no separate pointer stored! */
}

/* --------------------------------------------------------------------
   routine to compar key values

   compar returns a value < 0  for *val1 < *val2
                          = 0  for *val1 = *val2
                          > 0  for *val1 > *val2
 */
   
COUNT compar(val1,val2,knum)

PFAST TEXT *val1;
PFAST TEXT *val2;
KEYFILE    *knum;

{
	FAST COUNT keylen;

	keylen = knum->length;
	switch (knum->ktype) {

	case ALPHAKEY: /* left to right key comparison */
		while (keylen-- > 0 && *val1++ == *val2++)
			;
		return(((COUNT) *--val1 & CMPMSK) - 
			((COUNT) *--val2 & CMPMSK));
		/* CMPMSK prevent sign extension problems */


	case INTKEY: /* right to left key comparison: no duplicate support */
		val1 += keylen;
		val2 += keylen;
		while (keylen-- > 0 && *--val1 == *--val2)
			;
		return(((COUNT) *val1 & CMPMSK) - ((COUNT) *val2 & CMPMSK));

	default:
		terr(113);
	}
}

/*
 *	index file kernel
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
