/*
 *	Multi-User example of the CTCLIB.C module
 *
 *	This sample is setup for the MS-DOS 3.1 Operating System
 *	and the MICROSOFT (Version 3) C Compiler. (It will also run in
 *	DOS 2 and DOS 3.0 environments.)
 *
 *	Due to the highly restrictive nature of the DOS 3.1 locking protocols
 *	(i.e., you cannot READ a region of a file locked by another process),
 *	we have provided a work-around which requires a dummy file as file
 *	number zero. In particular, the zeroth data file of each ISAM parameter
 *	file should be a dummy file, have a record length of 128 bytes, 
 * 	and file mode parameters indicating a SHARED, PERMANENT, FIXED length 
 *	file. Then, instead of actually locking the files in use, c-tree will
 *	place locks on corresponding regions of the dummy file. As set up,
 *	this approach will support up to 126 32MB files.
 *
 *	Due to the use of a dummy lock file, it is not necessary for the
 *	lock routines to increment and decrement the lokcnt member which
 *	is used for checking virtual files. See CTCLIB.C lock routines by
 *	comparison.
 *
 *	(MS-DOS is a trademark of Microsoft)
 *
 *      Copyright (c) 1985 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#undef   EXTERN
#define  EXTERN /* */
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/

#include <types.h>		/* **************************** */
#include <fcntl.h>		/* ----       FROM         ---- */
#include <share.h>		/* ----			   ---- */
#include <locking.h>		/* ----     MICROSOFT      ---- */
#include <stat.h>		/* **************************** */

#define	INFINITY	3000	/* loop termination count waiting for lock */
#define LEFT_SHIFT	25	/* controls dummy lock capacity */
				/* 24 => 254 16MB files		*/
				/* 25 => 126 32MB files		*/
				/* 26 => 62  64MB files		*/

LONG  lseek();
COUNT uerr();
   
RNDFILE mbopen(ctnum,opmode)

PFAST CTFILE *ctnum;
COUNT opmode;	/* EXCLUSIVE or SHARED */

{
	RNDFILE retval;
	int     shflag;

	COUNT vtclose();

	if (opmode & SHARED)
		shflag = SH_DENYNO;
	else
		shflag = SH_DENYRW;

	if (!(opmode & PERMANENT) && numvfil >= MAXVFIL)
		vtclose();

	if ((retval = sopen(ctnum->flname,(O_RDWR | O_BINARY),shflag)) < 0)
		if (vtclose() == YES)
			retval = sopen(ctnum->flname,(O_RDWR | O_BINARY),
				shflag);

	if (!(opmode & PERMANENT) && retval >= 0)
		numvfil++;

	return(retval);
}

/* ------------------------------------------------------------ */

RNDFILE mbcrat(ctnum)

PFAST CTFILE *ctnum;

{
	RNDFILE retval;

	COUNT vtclose();

	if (!(ctnum->flmode & PERMANENT) && numvfil >= MAXVFIL)
		vtclose();

	if ((retval = open(ctnum->flname,
	    (O_CREAT | O_TRUNC | O_BINARY | O_RDWR),(S_IREAD | S_IWRITE))) < 0)
		if (vtclose() == YES)
			retval = open(ctnum->flname,
			    (O_CREAT | O_TRUNC | O_BINARY | O_RDWR),
			    (S_IREAD | S_IWRITE));

	if (!(ctnum->flmode & PERMANENT) && retval >= 0)
		numvfil++;

	return(retval);
}


/* ------------------------------------------------------------ */

COUNT ctio(op_code,ctnum,recbyt,bufadr,iosize)

COUNT	op_code;	/* CTREAD or CTWRITE */
CTFILE *ctnum;
LONG	recbyt;
TEXT   *bufadr;
UCOUNT	iosize;

{
	if (lseek(ctnum->fd,recbyt,0) < 0L)
		return(uerr(SEEK_ERR));

	if (!iosize)
		iosize = ctnum->reclen;
	if (op_code == CTREAD) {
		if (read(ctnum->fd,bufadr,iosize) < iosize)
			return(uerr(READ_ERR));
	} else {
		if (write(ctnum->fd,bufadr,iosize) != iosize)
			return(uerr(WRITE_ERR));
	}
	return(NO_ERROR);
}


/* ------------------------------------------------------------ */

COUNT mbclos(ctnum,clmode)

PFAST CTFILE *ctnum;
COUNT clmode;	/* COMPLETE or PARTIAL */

{
	if (!(ctnum->flmode & PERMANENT))
		numvfil--;
	return((COUNT) close(ctnum->fd));
}


/* ------------------------------------------------------------ */

COUNT mbsave(ctnum)

PFAST CTFILE *ctnum;

{
	COUNT   mbclos();
	RNDFILE mbopen();

	if (mbclos(ctnum,ctnum->flmode))
		return(uerr(FSAV_ERR));
	else if ((ctnum->fd = mbopen(ctnum,ctnum->flmode)) < 0)
		return(uerr(FSAV_ERR));
	else
		return(NO_ERROR);
}

/* ------------------------------------------------------------ */

TEXT *mballc(numobj,sizobj)

COUNT numobj,sizobj;

{
	TEXT *calloc();

	return(calloc(numobj,sizobj));
}

/* ------------------------------------------------------------ */

VOID mbfree(objptr)
TEXT       *objptr;

{
	free(objptr);
}


/* --------------------------------------------------------------------
   LOCK index node
 */

COUNT LOCK(node,knum)	/* node == 0  => header */

NODEPTR node;
PFAST KEYFILE *knum;

{

/*
 * c-tree node locking protocol is guaranteed to be deadlock free. Therefore,
 * if a lock is unsucessful, this routine forces a short delay and then 
 * attempts the lock again.  The INFINITY parameter allows one to avoid
 * an infinite loop if there is a bug in the lock routines.  Theoretically,
 * the while loop should never run indefinitely.
 */


#ifdef FPUTFGET

	COUNT dummy,tries;

	tries = 0;
	knum -= knum->kmem;
/*
 * Notice how a lock region is converted to a phantom region of the dummy
 * file and the lock is applied to file zero (whose control structure is
 * pointed to by the global variable key).
 */
	node |= ((LONG) knum->filnum << LEFT_SHIFT);
	if (lseek(key->fd,node,0) < 0L)
		return(uerr(SEEK_ERR));
	while (locking(key->fd,LK_NBLCK,(LONG) knum->recsiz))
		if (tries++ > INFINITY)
			return(uerr(LNOD_ERR));
		else
			/* delay and try again */
			for (dummy = 0; dummy++ < INFINITY; )
				;
	return(NO_ERROR);
#else
	return(NO_ERROR);
#endif

}

/* --------------------------------------------------------------------
   UNLOCK index file node
*/

COUNT UNLOCK(node,knum)

NODEPTR node;
PFAST KEYFILE *knum;

{

#ifdef FPUTFGET
	knum -= knum->kmem;
	node |= ((LONG) knum->filnum << LEFT_SHIFT);
	if (lseek(key->fd,node,0) < 0L)
		return(uerr(SEEK_ERR));
	else if (locking(key->fd,LK_UNLCK,(LONG) knum->recsiz))
		return(uerr(UNOD_ERR));
	else
		return(NO_ERROR);
#else
	return(NO_ERROR);
#endif

}


/* --------------------------------------------------------------------
   LOCK data record
 */

COUNT DLOCK(recbyt,dnum)		/* recbyt == 0  => header record */

POINTER		recbyt;
PFAST DATFILE  *dnum;

{

/*
 * the data record locks are NOT guaranteed to be deadlock free.  Therefore,
 * except for the header record which is only locked by internal c-tree 
 * maintenance requests, the data record lock routine returns instead of
 * looping when a lock is denied because of a competing lock.  The application
 * program must deal with the appropriate action if a lock is denied to a
 * data record.
 */

#ifdef FPUTFGET
	COUNT dummy,tries,test;
	LONG  actbyt;

	actbyt  = recbyt;
	tries   = 0;
	recbyt |= ((LONG) dnum->filnum << LEFT_SHIFT);
	if (lseek(key->fd,recbyt,0) < 0L)
		return(uerr(SEEK_ERR));
	while ((test = locking(key->fd,LK_NBLCK,(LONG) dnum->reclen)) &&
	    actbyt == DRNZERO) /* i.e., the header record is locked */ 
		if (tries++ > INFINITY)
			return(uerr(DLOK_ERR));
		else
			/* delay and try again */
			for (dummy = 0; dummy++ < INFINITY; )
				;

	if (!test)			/* lock request is successful!  */
		return(NO_ERROR);
	else 
		return(uerr(DLOK_ERR));
#else
	return(NO_ERROR);
#endif

}

/* --------------------------------------------------------------------
   UNLOCK data record
*/

COUNT UDLOCK(recbyt,dnum)

POINTER		recbyt;
PFAST DATFILE  *dnum;

{

#ifdef FPUTFGET
	recbyt |= ((LONG) dnum->filnum << LEFT_SHIFT);
	if (lseek(key->fd,recbyt,0) < 0L)
		return(uerr(SEEK_ERR));
	else if (locking(key->fd,LK_UNLCK,(LONG) dnum->reclen))
		return(uerr(UDLK_ERR));
	else
		return(NO_ERROR);

#else
	return(NO_ERROR);
#endif

}


/*
 *	Mult-User example of CTCLIB.C
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
