/*
 *	build c-tree ISAM/REBUILD parameter file from V3.3 parm file
 *
 *      Copyright (c) 1985 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */


#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#undef  EXTERN
#define EXTERN /* */
#include "ctisam.h"		/* c-tree isam header		*/

#ifdef PERC_H
#define IC1	"%h %h %h %h %h"
#define IC2	"%s %h %h"
#define IC3	"%h %s %h %h %h %h %h %h"
#define IC4	"%h %h"
#endif
#ifdef PERC_D
#define IC1	"%d %d %d %d %d"
#define IC2	"%s %d %d"
#define IC3	"%d %s %d %d %d %d %d %d"
#define IC4	"%d %d"
#endif
#ifdef PERC_HD
#define IC1	"%hd %hd %hd %hd %hd"
#define IC2	"%s %hd %hd"
#define IC3	"%hd %s %hd %hd %hd %hd %hd %hd"
#define IC4	"%hd %hd"
#endif

FILE    *fopen();

#define  OLD	0
#define  NEW	1

FILE    *efp,*nfp;
COUNT	 nbufs,idxs,nsecs,dats,keycnt;

typedef struct ir {
	COUNT	idxn;
	TEXT	idxname[MAX_NAME];
	COUNT	idxl;
	COUNT	idxt;
	COUNT	idxd;
	COUNT	idxadd;
	UCOUNT	idxext;
	COUNT	idxmod;
	COUNT	idxnlf;
	COUNT	idxnlc;
	COUNT	idxseg;
	COUNT	segp[MAX_KEY_SEG];
	COUNT	segl[MAX_KEY_SEG];
	COUNT	segm[MAX_KEY_SEG];
	} IREC;

typedef struct dr {
	IREC   *datip;
	COUNT	datn;
	TEXT	datname[MAX_NAME];
	UCOUNT	datl;
	UCOUNT  datext;
	COUNT	datmod;
	COUNT	datidx;
	} DREC;

DREC ndv[MAXFIL],*d;
IREC nxv[MAXFIL],*x;
TEXT ename[MAX_NAME];

main (argc,argv)
int   argc;
TEXT *argv[];
{
	COUNT getparms();

	TEXT *em;

	printf("\n\nc-tree V3.3 Parameter File Conversion\n(c) 1985 FairCom\n");
	printf("\nVersion 4.1 Release C\n");

	printf(
"\n\nThis utility program converts V3.3 parameter files to V4.1 format.");
	printf(
"\nPlease note that the conversion is done in place. The old contents");
	printf(
"\nwill be destroyed. Also, the data and index files will be RENUMBERED.");
	printf(
"\nUse CTBLDP to examine the contents of the converted parameter file.");

	do {
	    if (argc > 1) {
		strcpy(ename,*++argv);
		printf("\n\nExisting parameter file >> %s\n",ename);
		argc = 0;
	    } else {
	    	printf("\n\nEnter name of existing parameter file >> ");
	    	fscanf(stdin,"%s",ename);
	    }
	    if ((efp = fopen(ename,"r")) == NULL)
		printf("\nCould not open %s.\n",ename);
	} while (efp == NULL);

	getparms();
	printf("\n\nEnd of Old Parameter File Data");
	if (isam_err) {
		printf(" - Error #%d (%d).\n",isam_err,isam_fil);
		switch (isam_err) {
case IGIN_ERR:
			em = 
"Could not read first record of existing parameter file.\nSEE STARTUP GUIDE.";
			break;
case IFIL_ERR:
			em = 
"Too many data files and indices.\nIncrease MAXFIL in CTOPTN.H and recompile.";
			break;
case IDRI_ERR:
			em =
"Could not read Data Description record of exisiting parameter file.";
			break;
case IDRK_ERR:
			em =
"Too many indices defined for data file.\nIncrease MAX_DAT_KEY in CTOPTN.H and recompile.";
			break;
case IKRS_ERR:
			em =
"Too many segments defined.\nIncrease MAX_KEY_SEG in CTOPTN.H and recompile.";
			break;
case ISRC_ERR:
			em =
"Could not read Segment Description record of exisiting parameter file.";
			break;
case IKRI_ERR:
			em =
"Could not read Index File Description record of existing parameter file.";
			break;
case ISLN_ERR:
			em =
"Sum of segment lengths does not match key length in existing parameter file.";
			break;
default:
			em = "";
		}
		printf("\n%s\n",em);
		exit(0);
	} else
		printf(".\n");
	repparms();
}


VOID repparms()
{
	COUNT i,j,k,l;

	if ((nfp = fopen(ename,"w")) == NULL) {
		printf("\nCould not reopen %s.\n",ename);
		exit(0);
	}

	fprintf(nfp,"%d %d %d %d\n",nbufs,idxs,nsecs,dats);
	for (i = 0; i < dats; i++) {
		d = ndv + i;
		fprintf(nfp,"\n\n%2d %14s %5u %5u %2d %2d\n",d->datn,
		    d->datname,d->datl,d->datext,d->datmod,d->datidx);
		for (j = 0; j < d->datidx; j++) {
			x = d->datip + j;
			fprintf(nfp,
"\n\t%2d %14s %3d %d %d %2d %5u %2d %d %3d %2d\n",
x->idxn,x->idxname,x->idxl,x->idxt,x->idxd,x->idxadd,x->idxext,x->idxmod,
x->idxnlf,x->idxnlc,x->idxseg);
			for (k = 0; k < x->idxseg; k++)
				fprintf(nfp,"\t\t%3d %3d %d\n",x->segp[k],
				    x->segl[k],x->segm[k]);
		}
	}
	fprintf(nfp,"\n\n");
	fclose(nfp);
}

COUNT ierr(er,fl)
COUNT      er,fl;
{
	isam_fil = fl;
	return(isam_err = er);
}

COUNT getparms()
{
    COUNT chk,keyno,datno,i,j,k,l,ismode,nxtfil,nulflg,nchar,ksegs;

	if (fscanf(efp,IC1,&nbufs,&idxs,&nsecs,&dats,
	    &ismode) != 5)
		return(ierr(IGIN_ERR,0));
	if ((idxs + dats) > MAXFIL)
		return(ierr(IFIL_ERR,0));
	for (i = 0; i < MAXFIL; ) {
		datmap[i]      = NO;
		keymap[i++][0] = -1;
	}
	keycnt = nxtfil = 0;
	for (i = 0; i < dats; i++) {
		d = ndv + i;
		if (fscanf(efp,IC2,d->datname,&d->datl,&d->datidx) != 3)
			return(ierr(IDRI_ERR,i));
		if (d->datidx > MAX_DAT_KEY)
			return(ierr(IDRK_ERR,i));
		d->datext = 0;
		d->datn   = nxtfil++;
		d->datmod = ismode;
		d->datip = nxv + keycnt;
	
		for (j = 0; j < d->datidx; j++) {
			x = nxv + keycnt++;
			if (fscanf(efp,IC3,&keyno,
			    x->idxname,&x->idxl,&x->idxt,&x->idxd,&nulflg,
			    &nchar,&ksegs) != 8)
				return(ierr(IKRI_ERR,j));
			if (ksegs > MAX_KEY_SEG)
				return(ierr(IKRS_ERR,keyno));

			x->idxn   = nxtfil++;
			x->idxnlf = nulflg;
			x->idxnlc = nchar;
			x->idxseg = ksegs;
			x->idxadd = 0;
			x->idxext = 0;
			x->idxmod = ismode;

			for (k = 0; k < ksegs; k++) {
				if (fscanf(efp,IC4,&x->segp[k],
				    &x->segl[k]) != 2)
					return(ierr(ISRC_ERR,keyno));
				x->segm[k] = 0;
			}
		}
	}
	fclose(efp);
}


/*
 *	build c-tree ISAM/REBUILD parameter file from V3.3 parm file
 *
 *      Copyright (c) 1985 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
