/*
 *	compile time options:	This header determines the fundamental
 *				characteristics of the c-tree data struc-
 *				tures and disk I/O model.
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

                /* Configuration Option Definitions */

/* ***  SELECT ONE OPTION FROM EACH OF THE FOLLOWING 4 CATEGORIES   *** */

/* CATGEORY I: disk I/O model						*/

/*	FPUTFGET  	MULTIUSER: force all puts & gets to & from disk */
/*	FPUTONLY  	SINGLE USER: force updates only to disk		*/
/*	NOTFORCE  	SINGLE USER: do not force updates to disk	*/



/* CATEGORY II: internal integer format					*/

/*	LOW_HIGH  	internal integer format LSB to MSB		*/
/*	HIGH_LOW  	   "       "       "    MSB to LSB		*/



/* CATEGORY III: variable length data record support			*/

/*	VARLDATA  	support variable length data records		*/
/*	NO_VARLD  	no variable length support			*/


/* CATEGORY IV: conversion character for input to short integer		*/

/*	PERC_H		use %h:  (K & R standard)			*/
/*	PERC_D		use %d:  works for all 8 and 16 bit compilers	*/
/*	PERC_HD		use %hd: used most commonly in 32 bit compilers	*/



/* ******************************************************************** */
/* ******************************************************************** */


/* ***        Place Your Configuration Option Selections Here       *** */

#define NOTFORCE
#define LOW_HIGH
#define VARLDATA
#define PERC_H

/* ***                      Capacity Constants                      *** */

#define MAXLEN		64	/* maximum key length			*/
#define	MAXVFIL		20	/* maximum virtual files open		*/
#define MAX_NAME	64	/* maximum file name length		*/

/*
 * The following capacity constants are used only by the ISAM routines and
 * the REBUILD routines.
 */

#define MAXFIL		40	/* maximum number of files		*/
#define MAX_DAT_KEY	10	/* maximum number of indices per data   */
				/* file					*/
#define MAX_KEY_SEG	3	/* maximum number of segments per key	*/
#define MAX_LOCKS	32	/* maximum number of locks		*/


/* ******************************************************************** */
/* ************************     S T O P    **************************** */
/* ****   D O   N O T   C H A N G E   T H E    F O L L O W I N G   **** */
/* ******************************************************************** */



#define MAXLEV		10	/* maximum height of B-Tree + 1		*/
#define	VARI_LEN	(sizeof(VRLEN) + sizeof(LONG))
#define STATUS	(sizeof(COUNT) + 2 * sizeof(NODEPTR) + 2 * sizeof(TEXT))
/* node info:	 nkv             sucesr & predsr       leaf & bmem    */

#define HDRSIZ   64
/* permanent header information */
#define DHDRSIZ  HDRSIZ


#ifdef  FPUTFGET
#define PRDRPEAT	10	/* # of times to retry predsr node	*/
#else
#define PRDRPEAT	0
#endif

#define	MAXMEMB		15	/* maximum additional index members	*/



/* ******************************************************************** */
/* ***                       SYMBOLIC CONSTANTS                    ***  */
/* ******************************************************************** */

#define	DRNZERO	 	(POINTER) 0
#define	NODEZERO	(NODEPTR) 0

#define CTREAD	 0
#define CTWRITE	 1

#define LEAF     '\1'
#define NOLEAF   '\0'

#define ALPHAKEY '\0'
#define INTKEY   '\1'

#define DUPKEY   '\1'
#define NODUPKEY '\0'

#define REGULAR  '\0'
#define DUPLEAF  '\1'

#define DAT_CLOSE '\0'
#define IDX_CLOSE '\1'
#define VAT_CLOSE '\2'

#define SECSIZ   128		/* logical sector size. DO NOT CHANGE.	*/
#define UPDATED  C255		/* C255 defined in ctcmpl.h */
#define DELFLG	 C255
#define COMPACT  '\143'		/* file compaction flag: must rebuild indices */
#define CMPMSK	 0x00ff

#define MAXAGE   0xffff		/* max age of lru counter before roll-over */

#define	LH_VER	 0x0001			/* LOW_HIGH option 		*/
#define	HL_VER	 0x0002			/* HIGH_LOW   "			*/
#define CT_V4	 0x0050			/* c-tree version 4		*/

/*	end of ctoptn.h		*/
