/*
 *	rebuild routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 28, 1985 11:23
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

/*
 * If the index entry count has been disabled as described in Section 6.2,
 * then add the following #define to this module before compiling it:
 *
 *	#define NO_IDXENT
 *
 */


#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/
#include "ctisam.h"		/* c-tree isam header		*/
#include "ctvrec.h"		/* variable length header	*/

#define MAX_REC_LEN	4096
#define SORT_SPACE	32768

LOCAL COUNT    rerr_cod,rerr_fil,redo_dat,redo_idx,fparm,slen;
LOCAL COUNT    fhdr,all_idx,redo_mem,nsecs;
LOCAL COUNT   *lbuf;
LOCAL TEXT     rbuf[MAX_REC_LEN],lenkey[VARI_LEN],lastky[MAXLEN];
LOCAL TEXT    *kbuf;
LOCAL POINTER *pbuf;
LOCAL KEYFILE *snum;
LOCAL COUNT    srtlev,maxsrt;

TEXT		*mballc();
RNDFILE		mbopen();
COUNT		compar(),ctio(),redhdr(),wrthdr(),mbclos(),frmkey(),frmlkey();
COUNT		getintr(),getdatr(),getidxr(),getambr(),getvhdr(),putvhdr();
COUNT		INTREE(),ADDKEY(),CREIDX(),OPNFIL(),CLSFIL();

#ifndef NO_IDXENT
	POINTER IDXENT();
#endif

main (argc,argv)
int   argc;
TEXT *argv[];
{
	COUNT rebuild(),yesno();

	TEXT  rbld_nam[MAX_NAME];

	printf("\n\nc-tree(TM) REBUILD VERSION 4.1\nRelease C\n");
	printf("\nCopyright 1984 FairCom");
	printf(
"\n\nPlease note that index files which must be rebuilt will be deleted first.");

	if (argc > 1) {
		cpybuf(rbld_nam,*++argv,MAX_NAME);
		printf("\n\nParameter File Name>> %s\n",rbld_nam);
	} else {
		printf("\n\nEnter Rebuild Parameter File Name>> ");
		fscanf(stdin,"%s",rbld_nam);
	}

	printf("\n\nDo you want to force rebuild? (y or n)>> ");
	fparm = yesno();

	printf("\n\n   ***  Wait While Rebuilding  ***\n\n");
	rerr_cod = rerr_fil = 0;
	rebuild(rbld_nam);

	printf("\n\nEnd Of Rebuild");
	if (rerr_cod)
		printf(" - Error Code %d  File %d\n",rerr_cod,rerr_fil);
	else
		printf(".\n");
	exit(0);
}

COUNT rerr(err_cod,file_no)

COUNT err_cod;
COUNT file_no;

{
	rerr_fil = file_no;
	return(rerr_cod = err_cod);
}

COUNT rebuild(rname)

TEXT *rname;

{
	COUNT      RBLDAT(),RBLIDX(),RBLMEM();
	FILE      *ifd;
	FAST COUNT i,j,k;
	COUNT      nbufs,nkeys,dkeys,nomemb;
	COUNT      datno,xtdsiz,filemd,datlen,keyno,klen,ktyp,dflg;
	TEXT       filname[MAX_NAME],idxname[MAX_NAME];

	FILE *fopen();

	if ((kbuf = mballc(1,SORT_SPACE)) == NULL)
		return(rerr(RSPC_ERR,0));
	if ((ifd = fopen(rname,"r")) == NULL)
		return(rerr(INOD_ERR,0));

	if (getintr(ifd,&nbufs,&nkeys,&nsecs,&isdats))
		return(rerr(isam_err,0));
	if (INTREE(nbufs,nkeys + isdats,nsecs))
		return(rerr(uerr_cod,0));

	for (i = 0; i < isdats; i++) {
		if (getdatr(ifd,&datno,filname,&datlen,&dkeys,&xtdsiz,&filemd))
			return(rerr(isam_err,isam_fil));
		if (datlen > MAX_REC_LEN)
			return(rerr(RRLN_ERR,i));
		if (RBLDAT(datno,filname,datlen,xtdsiz,filemd))
			return(rerr_cod);

		for (j = 0; j < dkeys; j++) {
			if (getidxr(ifd,datno,j,&keyno,
			    idxname,&klen,&ktyp,&dflg,&nomemb,&xtdsiz,&filemd))
				return(rerr(isam_err,isam_fil));

			if (RBLIDX(datno,filname,idxname,keyno,klen,ktyp,dflg,
			    nomemb,xtdsiz,filemd))
				return(rerr_cod);

			for (k = 1; k <= nomemb; k++) {
				if (getambr(ifd,datno,j + k,keyno + k,&klen,
				    &ktyp,&dflg))
					return(rerr(isam_err,isam_fil));
				if (redo_mem && RBLMEM(datno,filname,idxname,
				    keyno,klen,ktyp,dflg,k))
					return(rerr_cod);
			}
			j += nomemb;
		}
	}
	fclose(ifd);
	return(NO_ERROR);
}

COUNT yesno()

{
	TEXT input[2];

	for (;;) {
		fscanf(stdin,"%1s",input);
		switch (input[0]) {
case 'y':
case 'Y':
			return(YES);
case 'n':
case 'N':
			return(NO);
default:
			input[0] = '\0';
		}
		printf("Improper choice. Try again (y or n)>> ");
	}
}

COUNT vcparm(pp,rv,txt)

UCOUNT *pp;
UCOUNT  rv;
TEXT   *txt;

{
	COUNT prnprm();

	if (rv != *pp && prnprm(*pp,rv,txt)) {
		*pp = rv;
		return(NO);
	}
	return(YES);
}

COUNT vtparm(pp,rv,txt)

TEXT  *pp,*txt;
UCOUNT rv;

{
	COUNT prnprm();

	if (rv != *pp && prnprm((UCOUNT) *pp,rv,txt)) {
		*pp = rv;
		return(NO);
	}
	return(YES);
}

COUNT prnprm(hv,rv,txt)

UCOUNT hv,rv;
TEXT  *txt;

{
	COUNT yesno();

	printf("\n\nWARNING: %s discrepancy.",txt);
	printf("\nParameter file %s = %d",txt,rv);
	printf("\n        Header %s = %d",txt,hv);
	printf("\n\nUse parameter file value? (y or n)>> ");
	return(yesno());
}

COUNT RBLDAT(datno,datnam,datlen,xtdsiz,filemd)

COUNT  datno;  /* data number temporary assigned to file */
TEXT  *datnam; /* pointer to file name	*/
COUNT  datlen; /* data record length	*/
UCOUNT xtdsiz; /* file chunk size	*/
COUNT  filemd; /* file mode parameter	*/

{
	FAST DATFILE *dnum;

	COUNT scndat();

	printf("\n\nExamining data file %s.",datnam);
	uerr_cod = 0;
	dnum = dat + datno;
	if (dnum->datacs != 'n')
		return(rerr(FACS_ERR,datno));

	cpybuf(dnum->flname,datnam,MAX_NAME);
	if ((dnum->dfd = mbopen(dnum,(EXCLUSIVE | PERMANENT))) < 0)
		/* file does not exist */
		return(rerr(FNOP_ERR,datno));

	if (redhdr(dnum)) {
		mbclos(dnum,COMPLETE);
		return(rerr(uerr_cod,datno));
	}

	dnum->datacs = 'y';
	dnum->datnum = datno;
	fhdr         = NO;
	all_idx      = NO;
	redo_mem     = NO;

	if (dnum->dversn < CT_V4) /* V3.3 data file */
		dnum->length = dnum->recsiz = dnum->nmem = dnum->kmem = dnum->flmode = 0;

	if (!fparm && dnum->dversn != ct_ver) {
		printf("\nData file version incompatibility detected:");
		printf("\n\tDo you wish to continue? If so, data file and ");
		printf("\n\tindex files must be rebuilt. (y or n) >> ");
		if (yesno())
			fparm = YES;
		else
			return(rerr(FVER_ERR,datno));
	}

	if (dnum->dupflg == COMPACT) {
		printf(
"\nData File has been compacted. Associated indices must be rebuilt.");
		dnum->dupflg = NO;
		fhdr         = YES;
		all_idx      = YES;
		redo_mem     = YES;
	} else if (dnum->dupflg)
		printf("\nData File is corrupt (flag = %d).",dnum->dupflg);

	if (!vcparm(&dnum->reclen,datlen,"data record length"))
		fparm = YES;
	if (!vcparm(&dnum->extsiz,xtdsiz,"file extension size"))
		fhdr  = YES;
	if ((dnum->flmode & VLENGTH) != (filemd & VLENGTH))
		return(rerr(RMOD_ERR,datno));
	if (!vcparm(&dnum->flmode,filemd,"file mode"))
		fhdr  = YES;
	if (dnum->flmode & VLENGTH) {
		if (dnum->clstyp != VAT_CLOSE) {
			dnum->clstyp = VAT_CLOSE;
			fhdr         = YES;
		}
	} else
		if (dnum->clstyp != DAT_CLOSE) {
			dnum->clstyp = DAT_CLOSE;
			fhdr         = YES;
		}

	if (fhdr && wrthdr(dnum))
		return(uerr_cod);
	if (dnum->dupflg || fparm) {
		printf("\n\nRebuilding data file.\n");
		dnum->dversn = ct_ver;
		redo_dat = YES;
		dnum->dupflg = UPDATED;
		if (wrthdr(dnum))
			return(uerr_cod);
		if (scndat(dnum))
			return(rerr(uerr_cod,datno));
		printf("\nData file rebuild complete (%ld bytes).",
			dnum->numrec + 1);
	} else {
		printf("\n\nNo data file rebuild necessary.");
		redo_dat = NO;
	}

	return(rerr(CLSFIL(datno,COMPLETE),datno));
}

COUNT RBLIDX(datno,datname,idxname,keyno,klen,ktyp,dflg,nomemb,xtdsiz,filemd)

COUNT  datno;
TEXT  *datname,*idxname;
COUNT  keyno,klen,ktyp,dflg,nomemb;
UCOUNT xtdsiz;
COUNT  filemd;

{
	KEYFILE *knum;

	COUNT   chkpar(),getdat();

	printf("\n\nExamining index file %s.",idxname);

	fhdr = NO;
	if (!all_idx && !redo_dat) {
		if (OPNFIL(keyno,idxname,filemd) == NO_ERROR){
		    knum = key + keyno;
		    if (chkpar(knum,klen,ktyp,dflg,nomemb,xtdsiz,filemd)) 
			redo_idx = NO;
		    else {
			redo_idx = YES;
			CLSFIL(keyno,COMPLETE);
		    }
		} else
		    redo_idx = YES;
	} else
		redo_idx = YES;


	if (!redo_idx && fhdr && wrthdr(knum))
		return(rerr(uerr_cod,keyno));

	if (redo_idx) {
		printf("\n\nRebuilding index file ");
		unlink(idxname);
		if (CREIDX(keyno,idxname,klen,ktyp,dflg,nomemb,xtdsiz,filemd))
			return(rerr(uerr_cod,keyno));
		redo_mem = YES;
		if (getdat(keyno,datno,datname))
			return(rerr_cod);

#ifndef NO_IDXENT
		printf("\nIndex file rebuild complete (%ld entries).",
			IDXENT(keyno));
#else
		printf("\nIndex file rebuild complete.");
#endif

	} else {
		redo_mem = NO;
		printf("\nNo index file rebuild necessary.");
	}
	return(rerr(CLSFIL(keyno,COMPLETE),keyno));
}

COUNT RBLMEM(datno,datname,idxname,keyno,klen,ktyp,dflg,membno)
COUNT  datno;
TEXT  *datname,*idxname;
COUNT  keyno,klen,ktyp,dflg,membno;
{
	COUNT getdat();

	CTFILE *knum;

	printf("\n\nRebuilding additional index #%d ",membno);
	if (OPNFIL(keyno,idxname,(EXCLUSIVE | PERMANENT)))
		return(rerr(uerr_cod,keyno));
	knum = key + keyno;
	if (membno < 1 || membno > knum->nmem)
		return(rerr(KMEM_ERR,knum->nmem));
	(knum += membno)->chnacs = 'm';
	if (CREMEM(keyno,klen,ktyp,dflg,membno))
		return(rerr(uerr_cod,membno));
	if (getdat(keyno + membno,datno,datname))

		return(rerr_cod);
#ifndef NO_IDXENT
	printf("\nAdditional index member rebuild complete (%ld entries).",
		IDXENT(keyno + membno));
#else
	printf("\nAdditional index member rebuild complete.");
#endif

	return(rerr(CLSFIL(keyno,COMPLETE),keyno));
}


COUNT chkpar(knum,kl,kt,df,nm,xt,fm)

KEYFILE *knum;
COUNT    kl,kt,df,nm;
UCOUNT   xt;
COUNT    fm;

{
	COUNT result;

	result = vcparm(&knum->recsiz,nodsec * SECSIZ,"node size");
	result = (vcparm(&knum->length,kl,"key length") && result);
	result = (vtparm(&knum->ktype,kt,"key type") && result);
	result = (vtparm(&knum->autodup,df,"duplicate flag") && result);
	result = (vcparm(&knum->nmem,nm,"# of additional indices") && result);
	if (!vcparm(&knum->extsiz,xt,"file size extension"))
		fhdr = YES;
	if (!vcparm(&knum->flmode,fm,"file mode"))
		fhdr = YES;
	if (knum->kversn != ct_ver) {
		knum->kversn = ct_ver;
		result = NO;
	}
	return(result);
}

VOID updkey(knum)

PFAST KEYFILE *knum;

{
		knum->maxkvn = (knum->recsiz - STATUS) /
			(knum->length + sizeof(POINTER));
		if (knum->maxkvn < 3) {
			printf(
"\n\nKey length too long for node size. (KMIN_ERR)");
			exit(0);
		}
		if (knum->autodup == DUPKEY)
			knum->maxkvl = (knum->recsiz - STATUS) / knum->length;
		else
			knum->maxkvl = knum->maxkvn;
}


COUNT getdat(keyno,datno,datname)

COUNT keyno,datno;
TEXT *datname;

{
	COUNT addbat();

	DATFILE *dnum;
	KEYFILE *knum;
	POINTER  newbyt,curbyt;
	POINTER *pp;
	COUNT    batch,kl,delrec;
	UCOUNT   batsiz,bp;
	COUNT   *lp;
	TEXT    *kp;
	VHDR     vrhdr;

	dnum = dat + datno;
	knum = key + keyno;

	if (OPNFIL(datno,datname,(EXCLUSIVE | PERMANENT)))
		return(rerr(uerr_cod,datno));

	kl     = knum->length;
	batsiz = SORT_SPACE / (kl + sizeof(POINTER) + sizeof(COUNT)) - 1;

	if (dnum->clstyp == DAT_CLOSE)
		curbyt = ((SECSIZ + dnum->reclen - 1) / dnum->reclen) *
			dnum->reclen;
	else
		curbyt = (dnum->recsiz + SIZVHDR);

	pbuf   = (POINTER *) (kbuf + ((batsiz + 1) * kl));
	lbuf   = (COUNT *)   (pbuf + batsiz);

	printf("with Batch Size = %u.\n",batsiz);

	batch = 0;
	bp = batsiz - 1;
	while (curbyt < dnum->numrec) {
	    delrec = NO;
	    if (dnum->clstyp == DAT_CLOSE) {
		if (REDREC(datno,curbyt,rbuf))
			return(rerr(uerr_cod,datno));
		newbyt = curbyt + dnum->reclen;
		if (rbuf[0] == DELFLG)
			delrec = YES;
	    } else {
		if (getvhdr(dnum,curbyt,&vrhdr))
			return(rerr(uerr_cod,datno));
		if (vrhdr.recmrk == VDEL_FLAG || vrhdr.recmrk == VNOD_FLAG)
			delrec = YES;
		else if (vrhdr.recmrk != VACT_FLAG)
			return(rerr(RVHD_ERR,datno));
		else if (REDREC(datno,curbyt,rbuf))
			return(rerr(uerr_cod,datno));
		newbyt = curbyt + vrhdr.trclen + SIZVHDR;
	    }
	    if (!delrec && frmkey(keyno,rbuf,keyval,curbyt)) {
		    if (++bp == batsiz) {
			if (batch)
				if (addbat(keyno,kl,batch,bp - 1))
					return(rerr_cod);
			bp = 0;
			batch++;
			pp = pbuf;
			kp = kbuf;
			lp = lbuf;
		    }
		    cpybuf(kp,keyval,kl);
		    kp += kl;
		    *pp++ = curbyt;
		    *lp++ = bp;
	    }
	    curbyt = newbyt;
	}
	if (batch)
		if (addbat(keyno,kl,batch,bp))
			return(rerr_cod);
	return(rerr(CLSFIL(datno,COMPLETE),datno));
}
		
COUNT addbat(keyno,klen,batno,bs)

COUNT keyno,klen,batno,bs;

{
	LOCAL UCOUNT t;
	COUNT        i,j,add_mode;
	COUNT	    *lp;
	TEXT        *kp;
	POINTER     *pp;


	snum = key + keyno;
	slen = klen;
	srtlev = maxsrt = 0;
	sort(bs);

	if (batno == 1) {
		add_mode = INCADD;
		t = 0;
	} else if (compar(lastky,kbuf + (lbuf[0] * slen),snum) <= 0 &&
	    	    compar(lastky,kbuf + (lbuf[bs / 2] * slen),snum) <= 0 &&
	    	    compar(lastky,kbuf + (lbuf[bs] * slen),snum) <= 0)
			add_mode = INCADD;
		else
			add_mode = REGADD;
	if (batno == 1 || compar(lastky,kbuf + (lbuf[bs] * slen),snum) < 0)
		cpybuf(lastky,kbuf + (lbuf[bs] * klen),MAXLEN);

	lp = lbuf;
	for (i = 0; i <= bs; i++) {
		j  = *lp++;
		pp = pbuf + j;		
		kp = kbuf + (j * klen);
		switch (ADDKEY(keyno,kp,*pp,add_mode)) {

case NO_ERROR:
			break;
case KDUP_ERR:
			printf("\nDuplicate key rejected for record #%d\n",
				*pp);
			break;
default:
			printf("\nADDKEY terminating with code %d",uerr_cod);
			return(rerr(uerr_cod,keyno));
		}
		if (!(++t % 128))
			printf("i");
	}
	printf(" B%d ",batno);
	return(NO_ERROR);
}
			
VOID exchg(i,j)

COUNT i,j;

{
	COUNT temp;

	temp = lbuf[i];
	lbuf[i] = lbuf[j];
	lbuf[j] = temp;
}

COUNT comsrt(k,tp)

COUNT k;
TEXT *tp;

{
	TEXT *temp;

	temp = kbuf + (lbuf[k] * slen);
	return(compar(temp,tp,snum));
}

VOID sort(hi)
COUNT hi;
{
	COUNT     *lp,reverses;
	TEXT      *kp;
	FAST COUNT i,j,k;

	reverses = hi / 256; /* allowable number of reverses in sequence and *
			      * still skip sort step			     */
	if (hi >= 256) {
		lp = lbuf;
		for (i = 0, k = *lp; i < hi; i++) {
		    j  = k;
		    k  = *++lp;
		    if (compar(kbuf + (j * slen),kbuf + (k * slen),snum) > 0)
			if (--reverses < 1)
				break;
		}
	}

	if (reverses < 1)
		srtbat(0,hi);
}

VOID srtbat(lo,hi) /* recursive quick sort */

COUNT lo,hi;

{
    FAST COUNT  i,j;
    TEXT  *piv;

    if (++srtlev > maxsrt)
	maxsrt = srtlev;
    if ((i = lo) < (j = hi)) {
	piv = kbuf + (lbuf[(i + j) / 2] * slen);
	while (i < j) {
		while (i < j &&	comsrt(i,piv) <= 0)
			i++;
		while (j > i && comsrt(j,piv) >= 0)
			j--;
		if (i < j)
			exchg(i,j);
	}
	exchg(i,hi);
	if ((i - lo) < (hi - i)) {
		srtbat(lo,i - 1);
		srtbat(i + 1,hi);
	} else {
		srtbat(i + 1,hi);
		srtbat(lo,i - 1);
	}
    }
    --srtlev;
}

COUNT scndat(dnum)

DATFILE *dnum;

{
	POINTER curbyt,lstbyt;
	UCOUNT  t,lstmrk;
	VRLEN   savlen;
	VHDR    vrhdr;


	if (dnum->clstyp == DAT_CLOSE) {
	    curbyt       = ((SECSIZ + dnum->reclen - 1) /
				dnum->reclen) * dnum->reclen;
	    dnum->delstk = DRNZERO;
	    t = 0;
	    while (!ctio(CTREAD,dnum,curbyt,rbuf,0)) {
		if (rbuf[0] == DELFLG) {
			cpybuf(rbuf+1,&dnum->delstk,sizeof(POINTER));
			dnum->delstk = curbyt;
			if (ctio(CTWRITE,dnum,curbyt,rbuf,0))
				return(uerr_cod);
		}
		if (!(++t % 128))
			printf("d");
		curbyt += dnum->reclen;
	    }
	    dnum->numrec  = dnum->phyrec = curbyt - (POINTER) 1;
	    return(NO_ERROR);
	} else if (dnum->clstyp = VAT_CLOSE) {
	    curbyt        = dnum->recsiz + SIZVHDR;
	    t             = lstmrk = 0;

	    dnum->root    = dnum->nodstk = NODEZERO;
	    dnum->length  = VARI_LEN;
	    dnum->autodup = 1;
	    dnum->ktype   = 0;
	    dnum->nument  = DRNZERO;

	    if (dnum->recsiz > (nsecs * SECSIZ))
		return(uerr(KSIZ_ERR));
	    else if (dnum->length < 0 || dnum->length > MAXLEN)
		return(uerr(KLEN_ERR));
	    updkey(dnum);

/* all existing tree nodes are marked deleted */

	    while (!getvhdr(dnum,curbyt,&vrhdr)) {
		if (vrhdr.recmrk == VNOD_FLAG) {
			if (vrhdr.trclen != dnum->recsiz)
				return(uerr(KSIZ_ERR));
			vrhdr.urclen = 0;
			vrhdr.recmrk = VDEL_FLAG;
			if (putvhdr(dnum,curbyt,&vrhdr))
				return(uerr_cod);
		} else if (vrhdr.recmrk == VACT_FLAG) {
			if (vrhdr.urclen == 0) {
				vrhdr.recmrk = VDEL_FLAG;
				if (putvhdr(dnum,curbyt,&vrhdr))
					return(uerr_cod);
			}
		} else if (vrhdr.recmrk == VDEL_FLAG)
			/* no action necessary */ ;
		else	/* no recognizable header. truncate file */
			break;

		if (vrhdr.recmrk == VDEL_FLAG && lstmrk == VDEL_FLAG) {
			/* collapse consecutive deleted areas */
			savlen  = vrhdr.trclen;
			if (getvhdr(dnum,lstbyt,&vrhdr))
				return(uerr_cod);
			if (vrhdr.recmrk != VDEL_FLAG)
				terr(228);
			savlen += vrhdr.trclen + SIZVHDR;
			if (savlen < vrhdr.trclen)
				/* overflow: don't collapse space */
				lstbyt       = curbyt;
			else {
				vrhdr.trclen = savlen;
				if (putvhdr(dnum,lstbyt,&vrhdr))
					return(uerr_cod);
			}
		} else
			/* no consecutive deleted areas */
			lstbyt  = curbyt;

		lstmrk  = vrhdr.recmrk;
		curbyt  = lstbyt + (vrhdr.trclen + SIZVHDR);
		if (!(++t % 256))
			printf("d");
	    }
	    dnum->numrec = dnum->phyrec = curbyt - (SIZVHDR + 1);
	    curbyt       = dnum->recsiz + SIZVHDR;

/* create all new delete space nodes in variable length files */

	    while (curbyt < dnum->numrec) {
		if (getvhdr(dnum,curbyt,&vrhdr))
			return(uerr_cod);
		else if (vrhdr.recmrk == VDEL_FLAG) {
			frmlkey(lenkey,&vrhdr.trclen,DRNZERO);
			if (ADDKEY(dnum->filnum,lenkey,curbyt,REGADD))
				return(uerr_cod);
		}
		if (!(++t % 256))
			printf("d");
		curbyt += (vrhdr.trclen + SIZVHDR);
	    }
	    return(NO_ERROR);
	} else
	    return(RMOD_ERR);
}

/*
 *	rebuild routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 28, 1985 11:23
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
