/*
 *	index search routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 27, 1985 16:38
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/

COUNT compar();

/* --------------------------------------------------------------------
   returns the "pointer" (ie, data record number or whatever) associated
   with the key value pointed to by target for the index file specified by
   keyno
 */

POINTER EQLKEY(keyno,target)

PFAST COUNT keyno;
TEXT *target;

{
	FAST KEYFILE *knum;
	LOCAL POINTER temp;
	POINTER fndkey();
	KEYFILE *tstknm();

	uerr_cod = 0;
	if ((knum = tstknm(keyno)) == NULL)
		return(DRNZERO);

	if (temp = fndkey(knum,target,'E')) {
		knum->retelm = elemnt;
		knum->retnod = fnode;
	} else {
		knum->retelm = 0;
		knum->retnod = NODEZERO;
	}
	return(temp);
}


/* -------------------------------------------------------------------
   returns the "pointer" associated with the first key value in the index
   file specified by keyno which is equal to or greater than the key value
   pointed to by target. if such an entry exists, then the variable pointed
   to by idxval is set equal to the key value found in the index file
 */

POINTER GTEKEY(keyno,target,idxval)

PFAST COUNT keyno;
TEXT *target;
TEXT *idxval;

{
	FAST KEYFILE *knum;
	LOCAL POINTER temp;
	POINTER fndkey();
	KEYFILE *tstknm();

	uerr_cod = 0;
	if ((knum = tstknm(keyno)) == NULL)
		return(DRNZERO);

	if (temp = fndkey(knum,target,'G')) {
		knum->retelm = elemnt;
		knum->retnod = fnode;
		cpybuf(idxval,indkey,knum->length);
	} else {
		knum->retelm = 0;
		knum->retnod = NODEZERO;
		setnul(idxval);
	}
	return(temp);
}


/* --------------------------------------------------------------------
   returns the "pointer" associated with the next key value (in ascending
   key value order) and sets the variable pointed to by idxval to this
   key value. this function is used to access the key values (and their
   associated "pointers" in ascending key value order.
 */

POINTER NXTKEY(keyno,idxval)

COUNT keyno;
TEXT *idxval;

{
	FAST KEYFILE *knum;
	FAST COUNT temp;
	FAST TREEBUFF *ret;

	POINTER drnpnt();
	TEXT *valpnt();
	TREEBUFF *getnod();
	KEYFILE *tstknm();

	uerr_cod = 0;
	if ((knum = tstknm(keyno)) == NULL)
		return(DRNZERO);

again:
	if (!knum->retnod) {
		setnul(idxval);
		return(DRNZERO);
	}
	if ((ret = getnod(knum->retnod,knum)) == NULL) /* then error */
		return(DRNZERO);
	if ((temp = knum->retelm) < ret->nkv) {
		cpybuf(idxval,valpnt(ret,++temp),knum->length);
		knum->retelm = temp;
		return(drnpnt(ret,temp));
	} else {
		knum->retnod = ret->sucesr;
		knum->retelm = 0;
		goto again;
	}
}


/* --------------------------------------------------------------------
   returns the "pointer" associated with the previous key value and sets 
   the variable pointed to by idxval equal to this key value. this function
   is used to access the key values (and their associated "pointers") in
   descending key value order.
 */

POINTER PRVKEY(keyno,idxval)

COUNT keyno;
TEXT *idxval;

{
	FAST TREEBUFF *ret;
	FAST COUNT prdtst,temp;
	FAST KEYFILE *knum;
	NODEPTR oldnode;

	POINTER drnpnt();
	TEXT *valpnt();
	TREEBUFF *getnod();
	KEYFILE *tstknm();
	COUNT uerr();

	uerr_cod = 0;
	if ((knum = tstknm(keyno)) == NULL)
		return(DRNZERO);

	if(!knum->retnod) {
		setnul(idxval);
		return(DRNZERO);
	}

	prdtst = PRDRPEAT;

split:
	if ((ret = getnod((oldnode = knum->retnod),knum)) == NULL)
		return(DRNZERO); /* then error */
again2:
	if ((temp = knum->retelm) > 1) {
		cpybuf(idxval,valpnt(ret,--temp),knum->length);
		knum->retelm = temp;
		return(drnpnt(ret,temp));
	} else if (knum->retnod = ret->predsr) {
		if ((ret = getnod(knum->retnod,knum)) == NULL) /* then error */
			return(DRNZERO);
		if ((temp = ret->nkv) < 0)
			terr(211);
		if (oldnode != ret->sucesr) {
			if (!(prdtst--)) {
				uerr(PRDS_ERR);
				return(DRNZERO);
			}
			knum->retnod = oldnode;
			goto split;	/* node splitting at time of request */
		}
		knum->retelm = temp;
		if (!temp) {
			oldnode = knum->retnod;
			goto again2;
		}
		cpybuf(idxval,valpnt(ret,temp),knum->length);
		return(drnpnt(ret,temp));
	} else {
		setnul(idxval);
		return(DRNZERO);
	}
}

/* --------------------------------------------------------------------
   find first index entry.
 */

POINTER FRSKEY(keyno,idxval)

PFAST COUNT keyno;
TEXT *idxval;

{
	LOCAL NODEPTR node;
	FAST TREEBUFF *buffer;
	FAST KEYFILE *knum;

	TREEBUFF *getnod();
	COUNT uerr();
	KEYFILE *tstknm();
	NODEPTR gtroot(),nodpnt();
	TEXT *valpnt();
	POINTER drnpnt();

	uerr_cod = 0;
	if ((knum = tstknm(keyno)) == NULL)
		return(DRNZERO);

	if (!(node = gtroot(knum)))
		goto empty;

	while (node) {	/* walk down tree until leaf node found */
		if ((buffer = getnod(node,knum)) == NULL)
			return(DRNZERO);
		if (buffer->leaf == LEAF)
			break;
		node = nodpnt(buffer,1);
	}
	if (!node)	/* => no leaf node found */
		terr(212);

	while (!buffer->nkv) /* walk across empty left most leaf nodes */
		if (!(node = buffer->sucesr))
			goto empty;
		else if ((buffer = getnod(node,knum)) == NULL)
			return(DRNZERO);

	knum->retnod = node;
	knum->retelm = 1;
	cpybuf(idxval,valpnt(buffer,1),knum->length);
	return(drnpnt(buffer,1));

empty:
	setnul(idxval);
	knum->retelm = 0;
	knum->retnod = NODEZERO;
	return(DRNZERO);

}


/* --------------------------------------------------------------------
   find LAST index entry.
 */

POINTER LSTKEY(keyno,idxval)

FAST COUNT keyno;
TEXT *idxval;

{
	LOCAL NODEPTR node;
	FAST TREEBUFF *buffer;
	FAST KEYFILE *knum;
	FAST COUNT tmpsiz;

	TREEBUFF *getnod();
	TEXT *valpnt();
	KEYFILE *tstknm();
	NODEPTR gtroot(),nodpnt();
	POINTER drnpnt();

	uerr_cod = 0;
	if ((knum = tstknm(keyno)) == NULL)
		return(DRNZERO);

	if (!(node = gtroot(knum)))
		goto empty2;

	while (node) {	/* walk down or across tree until leaf node found */
		if ((buffer = getnod(node,knum)) == NULL)
			return(DRNZERO);
		if (buffer->leaf == LEAF)
			break;
		if (!(node = buffer->sucesr))
			node = nodpnt(buffer,buffer->nkv);
	}
	if (!node)	/* => no leaf node found */
		terr(213);

	while (!buffer->nkv) /* walk across empty rightmost leaf nodes */
		if(!(node = buffer->predsr))
			goto empty2;
		else if ((buffer = getnod(node,knum)) == NULL)
			return(DRNZERO);

	knum->retnod = node;
	knum->retelm = tmpsiz = buffer->nkv;
	cpybuf(idxval,valpnt(buffer,tmpsiz),knum->length);
	return(drnpnt(buffer,tmpsiz));

empty2:
	setnul(idxval);
	knum->retelm = 0;
	knum->retnod = NODEZERO;
	return(DRNZERO);
}

/* ---------------------------------------------------------------------
   returns entry after target value
 */

POINTER GTKEY(keyno,target,idxval)

PFAST COUNT keyno;
TEXT *target;
TEXT *idxval;


{
	KEYFILE *knum;
	POINTER GTEKEY(),NXTKEY();
	LOCAL POINTER temp;

	if (!(temp = GTEKEY(keyno,target,idxval))) 
		return(temp);

	knum = key + keyno;
	if (compar(target,idxval,knum))
		return(temp);

	return(NXTKEY(keyno,idxval));
}

/* ---------------------------------------------------------------------
   returns entry immediately before target
 */

POINTER LTKEY(keyno,target,idxval)

PFAST COUNT keyno;
TEXT *target;
TEXT *idxval;


{
	POINTER GTEKEY(),LSTKEY(),PRVKEY();

	if (!GTEKEY(keyno,target,idxval))
		return(LSTKEY(keyno,idxval));

	return(PRVKEY(keyno,idxval));
}	


/* --------------------------------------------------------------------
 general purpose search routine. ordinarily not called by application
   program; but called from other searches: rtriev, search, etc.
 */

POINTER fndkey(knum,idxval,stratg)

PFAST KEYFILE *knum; 	/* pointer to key structure (used like a key #) */
TEXT *idxval; 		/* pointer to target key value */
TEXT stratg; 		/* search strategy indicator 'E'== equality
			   'G' == greater than or equal to search */

{
	TREEBUFF *getnod();
	POINTER serlef();
	NODEPTR gtroot(),nodpnt();
	TEXT *valpnt();
	COUNT nodser();

	LOCAL NODEPTR node;
	LOCAL COUNT npoint;
	FAST TREEBUFF *buffer;


	lnode = 0;	/* global var tracking last node visited */
	setnul(indkey);	/* set return key value to null */
	if (!(node = gtroot(knum))) {	/* tree may be empty or error */
		elemnt = 0;
		return(DRNZERO);
	}

	while (node) {	/* walk down or across tree until leaf node found */
		lnode = node;
		if ((buffer = getnod(node,knum)) == NULL) /* then error */
		    return(DRNZERO);
		if (buffer->leaf == LEAF) /* then found bottom level of tree */
		    break;
		if ((npoint = nodser(buffer,idxval,'L')) != -1) {
		    if (npoint == -2) /* then corrupt tree */
			terr(214);
		    /* get child node */
		    node = nodpnt(buffer,npoint);
		} else
		    /* move right because of incomplete tree update */
		    node = buffer->sucesr;
	}

	if (!node)	/* then no leaf node found */
		terr(215);

	return(serlef(idxval,knum,buffer,stratg)); /* search leaf node */
}


/* --------------------------------------------------------------------
   search leaf node 
 */

POINTER serlef(idxval,knum,buffer,stratg)

TEXT *idxval; 		/* pointer to target key value */
PFAST KEYFILE *knum; 	/* key number pointer */
PFAST TREEBUFF *buffer; /* pointer to buffer containing leaf node */
TEXT stratg; 		/* 'E/G': see fndkey */

{
	LOCAL COUNT temp;

	COUNT nodser();
	POINTER drnpnt();
	TEXT *valpnt();
	TREEBUFF *getnod();

/* see if it is necessary to move right along leaf nodes */

	while ((temp = nodser(buffer,idxval,stratg == 'E' ? 'E' : 'S')) == -1)
		if ((buffer = getnod((lnode = buffer->sucesr),knum)) == NULL)
			return(DRNZERO); /* error in getnod */

	fnode = lnode;
	if (temp != -2) { /* then sucessful leaf search */
		cpybuf(indkey,valpnt(buffer,temp),
			knum->length); /* copy key value found into indkey. */
		return(drnpnt(buffer,temp));
	} else		  /* target not found */
		return(DRNZERO);
}

/*
 *	index search routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 27, 1985 16:38
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
