/*
 *	isam sequence set routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/
#include "ctisam.h"		/* c-tree isam header		*/

POINTER  GTEKEY(),GTKEY(),LTKEY();
COUNT    ierr(),reset_cur();
CTFILE  *tstfnm();

LOCAL TEXT  seqbuf[MAXLEN];	/* holds matching "partial" key */
LOCAL COUNT seqlen;		/* significant length of key	*/
LOCAL COUNT seqkey = -1;	/* current keyno		*/


COUNT chkset(keyno,recpos,recptr)
COUNT   keyno;
POINTER recpos;
TEXT   *recptr;
{
	FAST COUNT i;
	FAST TEXT *kp;

	if (recpos == DRNZERO) /* no match */ {
		seqkey = -1;
		return(reset_cur(keyno,DRNZERO,recptr));
	}
	for (i = 0,kp = fndval; i < seqlen; i++)
		if (seqbuf[i] != *kp++)	 {	/* no match */
			seqkey = -1;
			return(ierr(INOT_ERR,keyno));
		}

	seqkey = keyno;
	for ( ; i < (key + keyno)->length; i++)
		seqbuf[i] = *kp++;
	return(reset_cur(keyno,recpos,recptr));
}

COUNT FRSSET(keyno,target,recptr,siglen)
COUNT keyno;
TEXT       *target,*recptr;
PFAST COUNT siglen;
{
	CTFILE    *cnum;
	FAST TEXT *kp;

	seqkey = -1;
	if ((cnum = tstfnm(keyno)) == NULL)
		return(ierr(uerr_cod,keyno));
	else if (cnum->ktype)
		return(ierr(SKTY_ERR,keyno));

	if (siglen >= cnum->length)
		seqlen = cnum->length;
	else
		seqlen = siglen;
	for (siglen = 0,kp = seqbuf; siglen++ < seqlen; )
		*kp++ = *target++;
	while (siglen++ < cnum->length)
		*kp++ = '\0';

	return(chkset(keyno,GTEKEY(keyno,seqbuf,fndval),recptr));
}


COUNT NXTSET(keyno,recptr)
COUNT keyno;
TEXT *recptr;
{
	if (tstfnm(keyno) == NULL)
		return(ierr(uerr_cod,keyno));
	else if (keyno != seqkey)
		return(ierr(SKEY_ERR,keyno));
	else
		return(chkset(keyno,GTKEY(keyno,seqbuf,fndval),recptr));
}


COUNT PRVSET(keyno,recptr)
COUNT keyno;
TEXT *recptr;
{
	if (tstfnm(keyno) == NULL)
		return(ierr(uerr_cod,keyno));
	else if (keyno != seqkey)
		return(ierr(SKEY_ERR,keyno));
	else
		return(chkset(keyno,LTKEY(keyno,seqbuf,fndval),recptr));
}


/*
 *	isam sequence set routines
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
