/*
 *	standard header:	Permits multiple compiler set-up. By changing
 *				contents of ctcmpl.h, different compilers 
 *				can be used with little or no changes to the
 *				code modules.
 *				
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctcmpl.h"	/* defines compiler environment 	*/
#include "ctport.h"	/* defines portable specifications 	*/

#ifdef LC		/* lattice c */
#include "lcstdio.h"
#endif

#ifdef DR		/* digital research c */
#include "drstdio.h"
#endif

#ifdef CI		/* computer innovations c */
#include "cistdio.h"
#endif

#ifdef QC		/* code works q/c c */
#include "qcstdio.h"
#endif

#ifdef AZ		/* manx aztec c */
#include "azstdio.h"
#endif

#ifdef DS		/* desmet c */
#include "dsstdio.h"
#endif

#ifdef MC		/* consulair MAC c */
#include "mcstdio.h"
#endif

#ifdef SW		/* softworks macintosh C (based on whitesmiths C) */
#define key ckey	/* avoid duplicate global variable name		  */
#include "swstdio.h"
#endif

#ifdef MW		/* Mark Williams C				*/
#include "mwstdio.h"
#endif

#ifdef MS		/* Microsoft C V3.0				*/
#include "msstdio.h"
#endif

#ifdef AT		/* AT&T UNIX V C */
#include "atstdio.h"
#endif

#ifdef NULL
#undef NULL
#endif
#define NULL	((char *) 0)

#ifndef min
#define min(a,b) ((a)=(b)?(a):(b))
#endif

/* end of ctstdr.h */
