/*
 *	data structures
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */


                       /* Data Structures */

typedef struct trebuf {	/* B-Tree Buffer			*/
	NODEPTR nodeid;	/* node number 				*/
	COUNT   keyid;	/* key number 				*/
	UCOUNT  nodacs;	/* access counter for LRU routine	*/
	COUNT   klen;	/* key length 				*/
	COUNT   maxkv;	/* maximum key values per node		*/
	TEXT    update;	/* node update indicator 'y/n' 		*/
	TEXT   *keyval;	/* pointer to key values for node	*/
	TEXT   *nodorg;	/* pointer to node origin for I/O	*/
	TEXT    confg;	/* regular or duplicate key leaf	*/

/* beginning of permanent node */

	NODEPTR sucesr;	/* right sibling 			*/
	NODEPTR predsr;	/* left sibling 			*/
	COUNT   nkv;	/* number of key values 		*/
	TEXT    leaf;	/* leaf indicator LEAF/NOLEAF		*/
	TEXT	bmem;	/* member number			*/
} TREEBUFF;

typedef struct wfils {	/* File Control Structure 		*/
	COUNT	verson;	/* configuartion options at create	*/
	UCOUNT	recsiz;	/* node record size			*/
	UCOUNT	reclen;	/* data record length			*/
	UCOUNT	extsiz;	/* extend file (chunk) size		*/
	COUNT	flmode;	/* file mode (virtual, etc)		*/
	COUNT	clstyp;	/* flag for type of virtual close	*/
	COUNT	resrv1;	/* reserved for future			*/
	COUNT	resrv2;	/* reserved for future			*/
	TEXT	updflg;	/* update (corrupt) flag		*/
	TEXT	ktype;	/* file type flag			*/
	TEXT	autodup;/* duplicate flag			*/
	TEXT	resrv3;	/* reserved for future			*/
	POINTER nument;	/* index entries			*/
	POINTER	delstk;	/* top of delete stack: fixed len data	*/
	POINTER	numrec;	/* last byte offset written		*/
	POINTER	phyrec;	/* last byte offset of file		*/
	POINTER	resrv4;	/* reserved for future			*/
	NODEPTR root;	/* B-Tree root 				*/
	NODEPTR	nodstk;	/* node delete stack (unused)		*/
	NODEPTR	resrv5;	/* reserved for future			*/
	COUNT	resrv6;	/* reserved for future			*/
	COUNT   maxkvl;	/* max key values per leaf node		*/
	COUNT   maxkvn;	/* max key values per non-leaf node	*/
	COUNT   length;	/* key length 				*/
	COUNT	nmem;	/* number of members			*/
	COUNT	kmem;	/* member number			*/

	/* end of permanent information */

	TEXT	flname[MAX_NAME];	/* file name		*/
	RNDFILE	fd;	/* file descritor			*/
	COUNT	filnum;	/* file number assigned by user		*/
	UCOUNT	usecnt;	/* lru age				*/
	UCOUNT  lokcnt; /* keep track of pending locks		*/
	NODEPTR	retnod;	/* current node				*/
	COUNT	retelm;	/* current node element			*/
	TEXT	chnacs;	/* 'y' 'n' 'v'				*/
} CTFILE;

#define	DATFILE		CTFILE
#define	KEYFILE		CTFILE
#define	VATFILE		CTFILE

typedef struct lok {	/* Lock Table Entry			*/
	COUNT   datfnm;	/* data file number			*/
	POINTER recnum;	/* record number			*/
} LOKS;



/* given pointer defined as

      TREEBUFF *buffer;

   and an integer defined as

      COUNT n;

   then the construct to reference the nth key value stored in the b-tree
   node is

		valpnt(buffer,n)

   which evaluates to a TEXT pointer; and the constructs to return the nth
   pointer stored in the b-tree node are

		nodpnt(buffer,n), drnpnt(buffer,n)
  
   which evaluate to typedef's NODEPTR and POINTER, respectively.

   To assign a pointer value, use the routine

		stpntr(buffer,n,pointer_value)

   where

	POINTER pointer_value;

***	end of ctstrc.h		***/
