/* 	c-tree(TM) Setup Test Program:
 *
 *	CTTEST generates information on constant C255, and on input 
 *	control characters for short integers used in CTOPTN.H.
 *
 *	July 15, 1985	16:10
 */

#include <ctstdr.h>

#define CTF	"CTTEST.D"

main ()
{
	TEXT  buffer[128];
	TEXT  t255;
	COUNT i,done,d[4];
	int   c;
	FILE *fp,*fopen();

	t255 = '\377';
	printf("\n\nC255 Test for CTCMPL.H:\n\t#define C255\t%d",t255);

	printf("\n\nShort Integer Input Test for CTOPTN.H:");
	if ((fp = fopen(CTF,"r")) == NULL) {
		printf(
"\n\nMAKE SURE %s IS ON YOUR CURRENT DRIVE AND REPEAT THE TEST\n",CTF);
		done = YES;
	} else
		done = NO;
	
	if (!done) {
		d[1] = d[3] = 5;
		if (fscanf(fp,"%h %h",d,d+2) == 2 &&
		    d[0] == 1 && d[2] == 3 && d[1] == 5 && d[3] == 5) {
			printf(
"\n\tUse the PERC_H option in CTOPTN.H.\n");
			done = YES;
		}
		if (!done) {
			fclose(fp);
			fp = fopen(CTF,"r");
			d[1] = d[3] = 5;
			if (fscanf(fp,"%d %d",d,d+2) == 2 &&
			    d[0] == 1 && d[2] == 3 && d[1] == 5 && d[3] == 5) {
				printf(
"\n\tUse the PERC_D option in CTOPTN.H.\n");
				done = YES;
			}
		}
		if (!done) {
			fclose(fp);
			fp = fopen(CTF,"r");
			d[1] = d[3] = 5;
			if (fscanf(fp,"%hd %hd",d,d+2) == 2 &&
			    d[0] == 1 && d[2] == 3 && d[1] == 5 && d[3] == 5) {
				printf(
"\n\tUse the PERC_HD option in CTOPTN.H.\n");
				done = YES;
			}
		}
		if (!done)
			printf(
"\n\n*** COMPILER DOES NOT CONFORM TO KNOWN CONVENTIONS ***\n");
	}


}
