/*
 *	update support routines (used in ctaddk & ctdelk)
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/

/*
 * If the index entry count has been disabled as described in Section 6.2,
 * then add the following #define to this module before compiling it:
 *
 *	#define NO_IDXENT
 *
 */


#ifdef FPUTFGET
	COUNT LOCK(),UNLOCK();
#endif

/* --------------------------------------------------------------------
   hdrupd updates header information, either on disk or in memory
*/

COUNT hdrupd(knum,chgnum)

KEYFILE *knum;
POINTER chgnum;

{
#ifndef NO_IDXENT
	COUNT redhdr(),wrthdr();

#ifdef FPUTFGET
	if (LOCK(NODEZERO,knum) || redhdr(knum - knum->kmem))
		return(uerr_cod);
#endif

	knum->nument += chgnum;

#ifdef NOTFORCE
	/* no action */
#else
	if (wrthdr(knum))
		return(uerr_cod);
#endif

#ifdef FPUTFGET
	if (UNLOCK(NODEZERO,knum))
		return(uerr_cod);
#endif
#endif
	return(NO_ERROR);
}

	
/* --------------------------------------------------------------------
   routine to update node size and note that node has been updated
 */

COUNT putnod(buf,nodsiz)

PFAST TREEBUFF *buf;
PFAST COUNT     nodsiz;

{
	VOID  inracs();
	COUNT wrtnod();

	if (nodsiz < 0)
		terr(216);
	inracs(buf);
	buf->update = 'y';
	buf->nkv = nodsiz;

#ifdef NOTFORCE
	/* no action */
#else
	if (wrtnod(buf))
		return(uerr_cod);
#endif

	return(NO_ERROR);
}


/* -------------------------------------------------------------------
   routine to shift key values and associated pointers caused
   by additions and deletions to node in buffer area
 */

VOID updnod(frmbuf,tobuf,ascnd,fel,lel,offset)

TREEBUFF *frmbuf,*tobuf;
COUNT fel,lel,offset;
BOOL ascnd;

{
	FAST TEXT *fp,*tp;
	FAST UCOUNT blksiz;
	TEXT *valpnt();

	if (lel < fel)
		return;
	if (frmbuf->keyid != tobuf->keyid)
		terr(217);

	tp = valpnt(tobuf,fel);
	fp = valpnt(frmbuf,fel+offset);
	blksiz = (lel - fel + 1);
	if (tobuf->confg == REGULAR) {
		tp -= sizeof(POINTER);
		fp -= sizeof(POINTER);
		blksiz *= (sizeof(POINTER) + tobuf->klen);
	} else  
		blksiz *= tobuf->klen;
		

	if (ascnd)
		cpybuf(tp,fp,blksiz);
	else {
		tp += (--blksiz);
		fp += (blksiz++);
		while (blksiz--)
			*tp-- = *fp--;
	}
}

	
/* ---------------------------------------------------------------------
   setup duplicate key entry for ADDKEY & DELKEY
 */

VOID prpdup(ip,knum,pntrp)

TEXT *ip;
KEYFILE *knum;
POINTER *pntrp;

{
	FAST COUNT kl;
	FAST TEXT *suffix,*tp;

	suffix = ip + knum->length - sizeof(POINTER);
	tp = (TEXT *) pntrp;

#ifdef LOW_HIGH
	tp += sizeof(POINTER);
	for (kl = 0; kl < sizeof(POINTER); kl++)
		*suffix++ = *--tp;
#else
	for (kl = 0; kl < sizeof(POINTER); kl++)
		*suffix++ = *tp++;
#endif

}

/* --------------------------------------------------------------------
   move right with left-to-right locking
*/

TREEBUFF *movrgt(idxval,knum,buffer)

TEXT *idxval; /* pointer to target key value */
PFAST KEYFILE *knum; /* key number pointer */
PFAST TREEBUFF *buffer; /* pointer to buffer containing leaf node */

{
	LOCAL NODEPTR node;

	COUNT nodser();
	TREEBUFF *getnod();
						/* NOTE: nodser sets elemnt */
	while (buffer != NULL && nodser(buffer,idxval,'L') == -1) {
		if (LOCK((node = buffer->sucesr),knum))
			return(NULL);
		if (UNLOCK(buffer->nodeid,knum))
			return(NULL);
		buffer = getnod(node,knum);
	}
	return(buffer);
}

/*
 *	update support routines (used in ctaddk & ctdelk)
 *
 *      Copyright (c) 1984 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 22, 1985 14:10
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
