/*
 *	variable record length routines
 *
 *      Copyright (c) 1985 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 27, 1985 09:59
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */

#include "ctstdr.h"		/* standard i/o header 		*/
#include "ctoptn.h"		/* c-tree configuration options */
#include "cterrc.h"		/* c-tree error codes		*/
#include "ctstrc.h"		/* c-tree data structures	*/
#include "ctgvar.h"		/* c-tree global variables	*/
#include "ctisam.h"		/* c-tree isam header		*/
#include "ctvrec.h"		/* var length header		*/

EXTERN COUNT   isam_err,isam_fil,uerr_cod;

COUNT          tstupd(),ctio(),ierr(),uerr(),frmkey(),ADDKEY(),DELCHK();
COUNT          getvhdr(),putvhdr(),compar();
CTFILE	      *tstfnm();
POINTER        GTKEY(),EQLKEY();
#ifdef FPUTFGET
COUNT	       DLOCK(),UDLOCK();
#endif

LOCAL TEXT     lenkey[VARI_LEN],idxkey[VARI_LEN];

POINTER chkvsm(datno)
COUNT datno;

{
	VATFILE *vnum;
	POINTER  pntr;

	COUNT addlok();

	isam_err = NO_ERROR;

	if ((vnum = tstfnm(datno)) == NULL)
		ierr(uerr_cod,datno);
	else if (vnum->clstyp != VAT_CLOSE)
		ierr(FMOD_ERR,datno);
	else if (!(pntr = cur_recno[datno]))
		ierr(ICUR_ERR,datno);
	else
		addlok(pntr,datno);

	if (!isam_err)
		return(pntr);
	else
		return(DRNZERO);
}


VOID vundo(op_code,datno,i,recptr,pntr,old_pntr)

COUNT       op_code;
PFAST COUNT datno;
PFAST COUNT i;
TEXT       *recptr;
POINTER     pntr,old_pntr;
		
{
	COUNT RETVREC();

	FAST COUNT keyno;
	COUNT      old_flg,new_flg;

	if (op_code == ISADD || (op_code == ISRWT && pntr != old_pntr))
		RETVREC(datno,pntr);

	for (i--; i >= 0 ; i--) {
	    keyno = keymap[datno][i];
	    if (op_code != ISRWT) {
		if (frmkey(keyno,recptr,keyval,DRNZERO))
			if (op_code == ISADD)
				DELCHK(keyno,keyval,pntr);
			else
				ADDKEY(keyno,keyval,old_pntr,REGADD);
	    } else {
		old_flg = frmkey(keyno,cur_image[datno],fndval,old_pntr);
		new_flg = frmkey(keyno,recptr,keyval,pntr);
		if (old_pntr != pntr || compar(fndval,keyval,key + keyno)) {
			if (new_flg)
				DELCHK(keyno,keyval,pntr);
			if (old_flg)
				ADDKEY(keyno,fndval,old_pntr,REGADD);
		}
	    }
	}
}


VRLEN GETVLEN(datno)
COUNT         datno;
{
	VHDR          vrhdr;
	FAST VATFILE *vnum;
	POINTER       pntr;

	isam_err = 0;
	if ((vnum = tstfnm(datno)) == NULL)
		ierr(uerr_cod,datno);
	else if (vnum->clstyp != VAT_CLOSE)
		ierr(FMOD_ERR,datno);
	else if ((pntr = cur_recno[datno]) == DRNZERO)
		ierr(ICUR_ERR,datno);
	else if (getvhdr(vnum,pntr,&vrhdr))
		ierr(uerr_cod,datno);
	if (isam_err)
		return(0);
	else
		return(vrhdr.urclen);
}	


LONG NEWVREC(datno,varlen)
COUNT        datno;
VRLEN              varlen;
{
	LONG     pntr,rpntr;
	VATFILE *vnum;
	VHDR	 vrhdr;

	POINTER GTEKEY(),extfil();

	uerr_cod = 0;
	if ((vnum = tstfnm(datno)) == NULL)
		return(DRNZERO);
	if (vnum->clstyp != VAT_CLOSE) {
		uerr(FMOD_ERR);
		return(DRNZERO);
	}
	frmlkey(lenkey,&varlen,DRNZERO);
	isam_err = 0;
	rpntr    = DRNZERO;

#ifndef FPUTFGET
	if (pntr = GTEKEY(datno,lenkey,idxkey)) {
#else
	pntr = GTEKEY(datno,lenkey,idxkey);
	while (pntr)
		if (DLOCK(pntr,vnum)) {
			cpybuf(lenkey,idxkey,VARI_LEN);
			pntr = GTKEY(datno,lenkey,idxkey);
		} else {
			if (EQLKEY(datno,idxkey) != DRNZERO)
				break; /* ok to reuse this space */
			else { /* already used by someone else */
				UDLOCK(pntr,vnum);
				cpybuf(lenkey,idxkey,VARI_LEN);
				pntr = GTKEY(datno,lenkey,idxkey);
			}
		}
	if (pntr) {
#endif
		if (getvhdr(vnum,pntr,&vrhdr))
			/* no action */ ;
		else if (vrhdr.recmrk != VDEL_FLAG)
			uerr(VDLFLG_ERR);
		else if (DELCHK(datno,idxkey,pntr))
			uerr(VDLK_ERR);
		else
			rpntr = pntr;

		if (tstupd(vnum))
			return(DRNZERO);
		return(rpntr);
	}


	if ((varlen + SIZVHDR) < varlen) {
		uerr(VMAX_ERR);
		return(DRNZERO);
	}

#ifdef FPUTFGET
	if (DLOCK(DRNZERO,vnum) || redhdr(vnum))
		return(DRNZERO);
#endif

	pntr = extfil(vnum,varlen + SIZVHDR);

#ifdef FPUTFGET
	if (DLOCK(pntr + SIZVHDR,vnum)) {
		UDLOCK(DRNZERO,vnum);
		return(DRNZERO);
	}
#endif

#ifdef NOTFORCE
	if (tstupd(vnum))
		return(DRNZERO);
#else
	if (wrthdr(vnum)) {
#ifdef FPUTFGET
		UDLOCK(DRNZERO,vnum);
#endif
		return(DRNZERO);
	}

#ifdef FPUTFGET
	if (UDLOCK(DRNZERO,vnum))
		return(DRNZERO);
#endif
#endif

	if (!pntr)
		return(DRNZERO);

	pntr += SIZVHDR;
	vrhdr.recmrk = VACT_FLAG;
	vrhdr.trclen = varlen;
	vrhdr.urclen = 0;
	if (putvhdr(vnum,pntr,&vrhdr))
		return(DRNZERO);

	return(pntr);
}


COUNT RETVREC(datno,recbyt)
COUNT         datno;
LONG                recbyt;
{
	VATFILE *vnum;
	VHDR     vrhdr,nrhdr;
	LONG	 nrecbyt;
	VRLEN	 test;

	uerr_cod = 0;
	if ((vnum = tstfnm(datno)) == NULL || getvhdr(vnum,recbyt,&vrhdr))
		return(uerr_cod);

	if ((nrecbyt = recbyt + vrhdr.trclen + SIZVHDR) > recbyt &&
	    getvhdr(vnum,nrecbyt,&nrhdr) == NO_ERROR &&
#ifndef FPUTFGET
	    nrhdr.recmrk == VDEL_FLAG)
#else
	    nrhdr.recmrk == VDEL_FLAG && DLOCK(nrecbyt,vnum) == NO_ERROR) {
		frmlkey(lenkey,&nrhdr.trclen,nrecbyt); /* see if really avail */
		if (EQLKEY(datno,lenkey) != DRNZERO) /* then next if */
#endif
		  if ((test = vrhdr.trclen + SIZVHDR + nrhdr.trclen) >
		    vrhdr.trclen) { /* combine consecutive deleted areas */
			vrhdr.trclen = test;
			frmlkey(lenkey,&nrhdr.trclen,DRNZERO);
			if (DELCHK(datno,lenkey,nrecbyt))
				return(uerr(VDLK_ERR));
		}
#ifdef FPUTFGET
		UDLOCK(nrecbyt,vnum);
	}
#endif

	frmlkey(lenkey,&vrhdr.trclen,DRNZERO);
	vrhdr.recmrk = VDEL_FLAG;
	vrhdr.urclen = 0;
	if (putvhdr(vnum,recbyt,&vrhdr))
		return(uerr_cod);

#ifdef FPUTFGET
	UDLOCK(recbyt,vnum);	/* assumes no error if record not locked */
#endif

	return(ADDKEY(datno,lenkey,recbyt,REGADD));
}

COUNT WRTVREC(datno,recbyt,recptr,varlen)
COUNT         datno;
LONG                recbyt;
VRLEN                    varlen;
TEXT                           *recptr;
{
	VATFILE *vnum;
	VHDR     vrhdr;
	VRLEN    unused;

	uerr_cod = 0;
	if ((vnum = tstfnm(datno)) == NULL)
		return(uerr_cod);
	if (!recbyt)
		return(uerr(VPNT_ERR));
	if (recptr == NULL)
		return(uerr(DNUL_ERR));
	if (getvhdr(vnum,recbyt,&vrhdr))
		return(uerr_cod);
	if (vrhdr.trclen < varlen)
		return(uerr(VLEN_ERR));
	vrhdr.urclen = varlen;
	vrhdr.recmrk = VACT_FLAG;
	unused       = vrhdr.trclen - varlen;
	if (unused > (vnum->reclen + SIZVHDR))
		vrhdr.trclen = varlen;
	if (putvhdr(vnum,recbyt,&vrhdr))
		return(uerr_cod);
	if (ctio(CTWRITE,vnum,recbyt,recptr,varlen))
		return(uerr_cod);
	if (unused > (vnum->reclen + SIZVHDR)) { 	/* reclaim space */
		recbyt         += (varlen + SIZVHDR);
		vrhdr.recmrk  = VDEL_FLAG;
		vrhdr.trclen  = unused - SIZVHDR;
		vrhdr.urclen  = 0;
		if (putvhdr(vnum,recbyt,&vrhdr))
			return(uerr_cod);
		return(RETVREC(datno,recbyt));
	}
	return(NO_ERROR);
}

	
COUNT ADDVREC(datno,recptr,varlen)

PFAST COUNT datno;
TEXT       *recptr;
VRLEN       varlen;

{
	POINTER    pntr;
	FAST COUNT i,keyno;
	VATFILE   *vnum;

	isam_err = NO_ERROR;
	if ((vnum = tstfnm(datno)) == NULL)
		return(ierr(uerr_cod,datno));
	else if (vnum->clstyp != VAT_CLOSE)
		return(ierr(FMOD_ERR,datno));
	else if (varlen < vnum->reclen)
		return(ierr(VRLN_ERR,datno));
	else if (!(pntr = NEWVREC(datno,varlen)))
		return(ierr(uerr_cod,datno));

	nwrcfg = YES;
	if (addlok(pntr,datno))
		return(isam_err);

	if (WRTVREC(datno,pntr,recptr,varlen)) {
		ierr(uerr_cod,datno);
		vundo(ISADD,datno,0,recptr,pntr,DRNZERO);
		return(isam_err);
	}

	for (i = 0; i < MAX_DAT_KEY; i++) {
		if ((keyno = keymap[datno][i]) < 0 )
			break;
		if (frmkey(keyno,recptr,keyval,DRNZERO))
			if (ADDKEY(keyno,keyval,pntr,REGADD)) {
				ierr(uerr_cod,keyno);
				vundo(ISADD,datno,i,recptr,pntr,DRNZERO);
				return(isam_err);
			}
	}

	cur_recno[datno] = pntr;
	cur_image[datno] = recptr;
	return(NO_ERROR);
}
	

COUNT DELVREC(datno)

PFAST COUNT datno;

{
	TEXT      *recptr;
	POINTER    pntr;
	FAST COUNT i,keyno;

	POINTER chkvsm();

	if (!(pntr = chkvsm(datno)))
		return(isam_err);

	recptr = cur_image[datno];
	for (i = 0; i < MAX_DAT_KEY; i++) {
		if ((keyno = keymap[datno][i]) < 0)
			break;
		if (frmkey(keyno,recptr,keyval,DRNZERO))
			if (DELCHK(keyno,keyval,pntr)) {
				ierr(uerr_cod,keyno);
				vundo(ISDEL,datno,i,recptr,DRNZERO,pntr);
				return(isam_err);
			}
	}

	if (RETVREC(datno,pntr)) {
		ierr(uerr_cod,datno);
		vundo(ISDEL,datno,i,recptr,DRNZERO,pntr);
		return(isam_err);
	}

	return(NO_ERROR);
}

COUNT RWTVREC(datno,recptr,varlen)
COUNT         datno;
TEXT               *recptr;
VRLEN                      varlen;
{
	VHDR    vrhdr,nrhdr;
	CTFILE *vnum;
	LONG    pntr,old_pntr,nrecbyt;
	VRLEN   old_totlen,test;
	COUNT   i,keyno,new_flg,old_flg;
#ifdef FPUTFGET
	LOKS   *lp;
	COUNT	tstlok;
#endif	

	POINTER chkvsm();

#ifdef FPUTFGET
	tstlok = DLOK_ERR;
#endif
	vnum = vat + datno;
	if (!(old_pntr = chkvsm(datno)))
		return(isam_err);
	else if (getvhdr(vnum,old_pntr,&vrhdr))
		return(ierr(uerr_cod,datno));

	old_totlen = vrhdr.trclen;

	if (varlen > old_totlen) {
		if ((nrecbyt = old_pntr + old_totlen + SIZVHDR) > old_pntr &&
		    getvhdr(vnum,nrecbyt,&nrhdr) == NO_ERROR &&
		    nrhdr.recmrk == VDEL_FLAG && (test = old_totlen + SIZVHDR +
#ifndef FPUTFGET
		    nrhdr.trclen) >= varlen) {
			frmlkey(lenkey,&nrhdr.trclen,DRNZERO);
#else
		    nrhdr.trclen) >= varlen && (tstlok = DLOCK(nrecbyt,vnum))
		    == NO_ERROR && frmlkey(lenkey,&nrhdr.trclen,nrecbyt) &&
		    EQLKEY(datno,lenkey) != DRNZERO) {
#endif
			/* enlarge current space */
			vrhdr.trclen = test;
			if (putvhdr(vnum,old_pntr,&vrhdr) ||
			    DELCHK(datno,lenkey,nrecbyt))
				/* no UDLOCK here (FPUTFGET) since VDLK_ERR *
				 * should "never" arise here		    */
				return(uerr(VDLK_ERR));
			pntr = old_pntr;
#ifdef FPUTFGET
			UDLOCK(nrecbyt,vnum);
		} else {
			if (tstlok == NO_ERROR)
				UDLOCK(nrecbyt,vnum);
			if (!(pntr = NEWVREC(datno,varlen)))
				return(ierr(uerr_cod,datno));
		}
#else
		} else if (!(pntr = NEWVREC(datno,varlen)))
			return(ierr(uerr_cod,datno));
#endif
	} else
		pntr = old_pntr;

	for (i = 0; i < MAX_DAT_KEY; i++) {
		if ((keyno = keymap[datno][i]) < 0 )
			break;
		old_flg = frmkey(keyno,cur_image[datno],fndval,old_pntr);
		new_flg = frmkey(keyno,recptr,keyval,pntr);
		if (old_pntr != pntr || compar(fndval,keyval,key + keyno))  {
			/* old <> new */
			if (old_flg && DELCHK(keyno,fndval,old_pntr)) {
				ierr(uerr_cod,keyno);
				vundo(ISRWT,datno,i,recptr,pntr,old_pntr);
				return(isam_err);
			}
			if (new_flg && ADDKEY(keyno,keyval,pntr,REGADD)) {
				ierr(uerr_cod,keyno);
				ADDKEY(keyno,fndval,pntr,REGADD);
				vundo(ISRWT,datno,i,recptr,pntr,old_pntr);
				return(isam_err);
			}
		}
	}

	if (WRTVREC(datno,pntr,recptr,varlen)) {
		ierr(uerr_cod,datno);
		vundo(ISRWT,datno,i,recptr,pntr,old_pntr);
		return(isam_err);
	}

	cur_recno[datno] = pntr;
	cur_image[datno] = recptr;

	if (pntr != old_pntr) {
#ifdef FPUTFGET	
		for (i = 0, lp = locks; i++ < MAX_LOCKS; lp++)
			if (lp->datfnm == datno && lp->recnum == old_pntr) {
				lp->recnum = pntr;
				DLOCK(pntr,vnum);
				break;
			}
#endif
		return(ierr(RETVREC(datno,old_pntr),datno));
	} else
		return(NO_ERROR);
}

COUNT REDVREC(datno,recptr,bufsiz)
COUNT         datno;
TEXT               *recptr;
VRLEN                      bufsiz;
{
	VHDR         vrhdr;
	FAST CTFILE *vnum;
	POINTER      pntr;

	isam_err = 0;
	if ((vnum = tstfnm(datno)) == NULL)
		return(ierr(uerr_cod,datno));
	else if ((pntr = cur_recno[datno]) == DRNZERO)
		return(ierr(ICUR_ERR,datno));
	else if (recptr == NULL)
		return(ierr(DNUL_ERR,datno));
	else if (getvhdr(vnum,pntr,&vrhdr))
		return(ierr(uerr_cod,datno));
	else if (vrhdr.urclen > bufsiz)
		return(ierr(VBSZ_ERR,datno));
	else if (vrhdr.urclen == 0)
#ifdef FPUTFGET
		return(ierr(ITIM_ERR,datno));
#else
		return(ierr(VRCL_ERR,datno));
#endif
	else if (vrhdr.recmrk != VACT_FLAG)
		return(ierr(VFLG_ERR,datno));

	if (ierr(ctio(CTREAD,vnum,pntr,recptr,vrhdr.urclen),datno) == NO_ERROR)
		cur_image[datno] = recptr;
	return(isam_err);
}

/*
 *	variable record length routines
 *
 *      Copyright (c) 1985 FairCom
 *	2606 Johnson Drive
 *	Columbia, MO 65201
 *
 *	ALL RIGHTS RESERVED.
 *
 *	c-tree(TM)	Version 4.1
 *			Release C
 *			August 27, 1985 09:59
 *
 *	Unauthorized distribution, adaptation or use may be 
 *	subject to civil and criminal penalties.
 *
 */
