/*
 * public domain example Ver 4.1 Release C 08/03/85 10:56
 *
 * variable record length example	
 *
 * ISAM Parameter File named CTVXAM.P
 *
 */

#include "ctstdr.h"
				/* automatically includes necessary
				 * header files (including compiler's
				 * "stdio.h")
				 */
#include "ctoptn.h"
#include "ctstrc.h"

COUNT OPNISAM(),CLISAM(),ADDVREC(),GTEREC(),NXTREC(),PRVREC(),RWTVREC();
COUNT DELVREC(),REDVREC(),FRSSET(),NXTSET(),PRVSET(),LKISAM();
				
EXTERN COUNT   isam_err,isam_fil;	/* ISAM error code variables */
EXTERN CTFILE *key;

#define	CUSTDAT	0		/* customer data file		*/
#define	NAMEKEY 1		/* name key			*/
#define	NUMBKEY	2		/* customer number key		*/
#define	ZIPCKEY	3		/* zip code key			*/

#define NO_FLD	7		/* number of data record fields */
#define VARFLD  '\2'		/* variable length field	*/
#define INTFLD	'\1'		/* integer field designator     */
#define CHRFLD	'\0'		/* character field designator	*/

#define NEW	0		/* new versus old record image	*/
#define OLD	1

#define NEXT	2		/* scan direction indicators	*/
#define PREV	3


TEXT *fldnam[NO_FLD];		/* field descriptions		*/
TEXT  fldtyp[NO_FLD];		/* field type: INTFLD, CHRFLD,	*
				 * or VARFLD			*/
COUNT fldord[NO_FLD];		/* screen i/o order		*/
COUNT fldlen[NO_FLD];		/* (max) field length		*/
COUNT minlen[NO_FLD];		/* min var field length		*/
TEXT *fldptr[NO_FLD];		/* new image field pointer	*/
TEXT *oldptr[NO_FLD];		/* old image field pointer	*/
TEXT  inpbuf[128];		/* input buffer			*/


#define CNUML	4		/* field lengths in bytes	*/
#define LNAML	36
#define FNAML	36
#define ADRSL	48
#define CITYL	36
#define STATL	2
#define ZIPCL	9

LONG  numtar;			/* input variable for integer key value */
TEXT  namtar[LNAML + 1];	/* input variable for character key	*/

struct CUST_IMAGE {		/* data record format			*/
	LONG	cnum;		/* customer number			*/
	TEXT	zipc[ZIPCL];	/* zip code				*/
	TEXT	stat[STATL];	/* state abreviation			*/
	TEXT	lnam[LNAML+1];	/* last name				*/
	TEXT	fnam[FNAML+1];	/* first name				*/
	TEXT	adrs[ADRSL+1];	/* street address			*/
	TEXT	city[CITYL+1];	/* city					*/
	} image,old_image;	/* contains the record image with fields*/
				/* at max lengths & known locations	*/

#define MAX_CUST sizeof(image)

TEXT  cust[MAX_CUST],old_cust[MAX_CUST];

				/* old_cust is the record buffer for
				 * existing data. cust is the record buffer
				 * for new and/or updated data
				 */

/* ************************************************************************* */
/* ************************************************************************* */

main () {
	if (OPNISAM("CTVXAM.P")) {
		printf("\n\nCould not open isam. Error codes %d %d",
			isam_err,isam_fil);
		exit(0);
	} else
		printf(
		"\nc-tree(TM) V4.1 Release C\n\nVariable Length Example\n\n");

/*
 * assign field characteristics
 */
	fldord[0] = 0;
	fldord[1] = 3;
	fldord[2] = 4;
	fldord[3] = 5;
	fldord[4] = 6;
	fldord[5] = 2;
	fldord[6] = 1;

	fldnam[0] = "Number";
	fldtyp[0] = INTFLD;
	fldlen[0] = CNUML;
	fldptr[0] = (TEXT *) &image.cnum;
	oldptr[0] = (TEXT *) &old_image.cnum;

	fldnam[1] = "Zip Code";
	fldtyp[1] = CHRFLD;
	fldlen[1] = ZIPCL;
	fldptr[1] = image.zipc;
	oldptr[1] = old_image.zipc;

	fldnam[2] = "State Abrev";
	fldtyp[2] = CHRFLD;
	fldlen[2] = STATL;
	fldptr[2] = image.stat;
	oldptr[2] = old_image.stat;

	fldnam[3] = "Last Name";
	fldtyp[3] = VARFLD;
	fldlen[3] = LNAML;
	minlen[3] = 20;
	fldptr[3] = image.lnam;
	oldptr[3] = old_image.lnam;
	
	fldnam[4] = "First Name";
	fldtyp[4] = VARFLD;
	fldlen[4] = FNAML;
	minlen[4] = 0;
	fldptr[4] = image.fnam;
	oldptr[4] = old_image.fnam;

	fldnam[5] = "Address";
	fldtyp[5] = VARFLD;
	fldlen[5] = ADRSL;
	minlen[5] = 0;
	fldptr[5] = image.adrs;
	oldptr[5] = old_image.adrs;

	fldnam[6] = "City";
	fldtyp[6] = VARFLD;
	fldlen[6] = CITYL;
	minlen[6] = 0;
	fldptr[6] = image.city;
	oldptr[6] = old_image.city;

/*
 * call the main database routine
 */

	database();

/*
 * close the ISAM files
 */

	if (CLISAM())
		printf("\n\nCould not close isam. Error codes %d %d",
			isam_err,isam_fil);
	exit(0);
}

/* ************************************************************************* */
/* ************************************************************************* */


/*
 * routine to pad, set to upper case & set duplicate suffix to zero
 */

VOID zrosfx(tp,kl)
PFAST TEXT *tp;
PFAST COUNT    kl;
{
	for ( ; kl-- > 0; tp++)
		if (*tp >= 'a' && *tp <= 'z')
			*tp = *tp + 'A' - 'a';
		else if (*tp == '\0')
			*tp = ' ';
	for (kl = 0; kl++ < sizeof(LONG); )
		*tp++  = '\0';
}

/*
 * routine to convert string to long integer
 */

LONG getnum(tp)
TEXT *tp;
{
	LONG retval;

	retval = 0L;
	do {
		if (*tp >= '0' && *tp <= '9') {
			retval *= 10;
			retval += (*tp - '0');
		}
	} while (*tp++);
	return(retval);
}

/*
 * routines to pack and unpack variable length records
 */

UCOUNT putimage() 	/* puts image into cust and returns length */
{
	COUNT  i,len;
	UCOUNT tlen;
	TEXT  *dp,*sp;

	dp     = cust;
	tlen   = 0;
	for (i = 0; i < NO_FLD; i++) {
		len = fldlen[i];
		sp  = fldptr[i];
		if (fldtyp[i] != VARFLD) {
			tlen += len;
			while (len-- > 0)
				*dp++ = *sp++;
		} else
			while (++tlen && (*dp++ = *sp++))
				;
	}
	return(tlen);
}

VOID getimage()		/* fills old image from old_cust */
{
	COUNT i,len;
	TEXT *dp,*sp; 

	sp     = old_cust;
	for (i = 0; i < NO_FLD; i++) {
		len = fldlen[i];
		dp  = oldptr[i];
		if (fldtyp[i] != VARFLD)
			while (len-- > 0)
				*dp++ = *sp++;
		else {
			while (*dp++ = *sp++)
				len--;
			while (--len > 0)
				*dp++ = '\0';
		}
	}
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * main data base routine
 */
		
VOID database()

{
    TEXT choice[2];

    choice[0] = '\0';

    while (choice[0] != 'q' && choice[0] != 'Q') {
	printf("\n\nA)dd   U)pdate   S)equence Set   Q)uit:");
	gets(inpbuf);
	choice[0] = inpbuf[0];
	switch (choice[0]) {

case 'A':
case 'a':
		datadd();	/* add new entry to customer data base */
		break;

case 'U':
case 'u':
		datscan();	/* scan/update existing entries */
		break;

case 'S':
case 's':
		seqscan();	/* scan/update sequence set */
		break;

default:
		break;
	}
    }
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to add new customer
 */

VOID datadd()

{
	COUNT  i;
	UCOUNT varlen;

	printf("\nADD NEW DATA\n\n");

/*
 * enter data for each field
 */

	for (i = 0; i < NO_FLD; i++)
		getfld(i,NEW);			

/*
 * enable locks and add data
 */

	varlen = putimage(); 
	if (LKISAM(ENABLE) || ADDVREC(CUSTDAT,cust,varlen))
		printf("\n\nError during addition. Codes %d %d",isam_err,
			isam_fil);
	else
		printf("\nSuccessful Addition.");
	LKISAM(FREE);
}


/* ************************************************************************* */
/* ************************************************************************* */

/*
 * print field name and get field input
 */

VOID getfld(pos,typ)

COUNT pos,typ;

{
	COUNT fldno;

	fldno = fldord[pos++];
	if (typ == OLD) {
		printf("\n\nCurrent value for %-15s: ",fldnam[fldno]);
		putfld(fldno);
		printf("\nEnter new value   %-15s: ","");
		inpfld(fldno);
	} else {
		printf("\n%d. %-15s :",pos,fldnam[fldno]);
		inpfld(fldno);
	}
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * field input routine handles character and (long) integer fields
 */

VOID inpfld(fldno)

COUNT fldno;

{
	LONG *intdat;

	if (fldtyp[fldno] == INTFLD) {
		intdat = (LONG *) fldptr[fldno];
		gets(inpbuf);
		*intdat = getnum(inpbuf);
	} else {
		gets(inpbuf);
		if (fldtyp[fldno] == CHRFLD)
			cpychr(fldptr[fldno],inpbuf,fldlen[fldno]);
		else
			cpyvar(fldptr[fldno],inpbuf,fldlen[fldno],
			    minlen[fldno]);
	}
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to scan existing customers
 */

VOID datscan()
{
	COUNT update();

	COUNT i,fldno,action,keyno;
	TEXT *tarval;		/* pointer to target key value	*/
	TEXT  choice[2];

	printf("\nSCAN DATA\n");
	keyno = -1;

/*
 * select which key to order scan by  and  starting key value
 */

	while (keyno < NAMEKEY || keyno > ZIPCKEY) {
		printf("\nScan by  N)ame  #(number)  Z)ip Code   or Q)uit>> ");
		gets(inpbuf);
		choice[0] = inpbuf[0];
		switch (choice[0]) {
case 'n':
case 'N':
			keyno = NAMEKEY;
			fldno = 3;
			break;
case '#':
			keyno = NUMBKEY;
			fldno = 0;
			break;

case 'z':
case 'Z':
			keyno = ZIPCKEY;
			fldno = 1;
			break;

case 'q':
case 'Q':
			return;
default:
			printf("\nImproper selection (%.1s). Try again.\n",
				choice);
		}
	}

	printf("\nEnter %s: ",fldnam[fldno]);
	for (i = 0; i++ < 128; )
		inpbuf[i] = '\0';
	gets(inpbuf);
	if (keyno != NUMBKEY) {
		zrosfx(inpbuf,(key + keyno)->length - 4);
		tarval = inpbuf;
	} else {
		numtar = getnum(inpbuf);
		tarval = (TEXT *) &numtar;
	}


/*
 * scan data acquiring a lock on each record and then freeing lock before
 * going on to next record
 */
		
	action = 0;
	if (LKISAM(ENABLE) || GTEREC(keyno,tarval,old_cust) ||
		REDVREC(CUSTDAT,old_cust,MAX_CUST)) {
		printf("\n\nSCAN failed at start with codes %d %d",isam_err,
			isam_fil);
		LKISAM(FREE);
		return;
	}
	while (action > -1 && !isam_err) {
		action = update();	/* update data and determine 
					 * direction of scan
					 */
		LKISAM(RESET);
		if (action == NEXT)
			NXTREC(keyno,old_cust);
		else if (action == PREV)
			PRVREC(keyno,old_cust);
		if (!isam_err && (action == NEXT || action == PREV))
			REDVREC(CUSTDAT,old_cust,MAX_CUST);
	}
	if (isam_err)
		printf("\n\nScan ending (code %d  file %d).",isam_err,
			isam_fil);
	LKISAM(FREE);
}


VOID seqscan()
{
	COUNT update();

	COUNT i,fldno,action,keyno;
	TEXT *tarval;		/* pointer to target key value	*/
	TEXT  choice[2];

	printf("\nSCAN SEQUENCE SET\n");
	keyno = -1;

/*
 * select which key to order scan by  and  starting key value
 */

	while (keyno < NAMEKEY || keyno > ZIPCKEY) {
		printf("\nScan by  N)ame  Z)ip Code   or Q)uit>> ");
		gets(inpbuf);
		choice[0] = inpbuf[0];
		switch (choice[0]) {
case 'n':
case 'N':
			keyno = NAMEKEY;
			fldno = 3;
			break;
case 'z':
case 'Z':
			keyno = ZIPCKEY;
			fldno = 1;
			break;

case 'q':
case 'Q':
			return;
default:
			printf("\nImproper selection (%.1s). Try again.\n",
				choice);
		}
	}

	printf("\nEnter %s: ",fldnam[fldno]);
	for (i = 0; i++ < 128; )
		inpbuf[i] = '\0';
	gets(inpbuf);
	for (tarval = inpbuf; *tarval; tarval++)
		if (*tarval >= 'a' && *tarval <= 'z')
			*tarval = *tarval + 'A' - 'a';
	tarval = inpbuf;

/*
 * scan data acquiring a lock on each record and then freeing lock before
 * going on to next record
 */
		
	action = 0;
	if (LKISAM(ENABLE) || FRSSET(keyno,tarval,old_cust,strlen(tarval)) ||
		REDVREC(CUSTDAT,old_cust,MAX_CUST)) {
		printf("\n\nSCAN failed at start with codes %d %d",isam_err,
			isam_fil);
		LKISAM(FREE);
		return;
	}
	while (action > -1 && !isam_err) {
		action = update();	/* update data and determine 
					 * direction of scan
					 */
		LKISAM(RESET);
		if (action == NEXT)
			NXTSET(keyno,old_cust);
		else if (action == PREV)
			PRVSET(keyno,old_cust);
		if (!isam_err && (action == NEXT || action == PREV))
			REDVREC(CUSTDAT,old_cust,MAX_CUST);
	}
	if (isam_err)
		printf("\n\nScan ending (code %d  file %d).",isam_err,
			isam_fil);
	LKISAM(FREE);
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to update customer records. note that the scan routine reads the
 * customer records into the "old_cust" buffer and this routine creates
 * an updated version in the "cust" buffer.
 */

COUNT update()

{
	COUNT  i,fldno;
	TEXT   choice[2];

	getimage();
	for (i = 0; i < NO_FLD; i++) {
		fldno = fldord[i];
		cpydat(fldptr[fldno],oldptr[fldno],fldlen[fldno]);
		printf("\n%d. %-15s: ",i + 1,fldnam[fldno]);
		putfld(fldno);
	}

	for(;;) {
		printf(
"\n\nEnter field # to change data or N)ext, P)revious D)elete or E)nd scan>> ");
		gets(inpbuf);
		choice[0] = inpbuf[0];
		switch (choice[0]) {

/*
 * since this data base has only one data file defined in the ISAM parameter
 * file CTVXAM.P, all the data file references are to file number zero
 */

case 'n':
case 'N':
case 'p':
case 'P':
case 'e':
case 'E':
			if (RWTVREC(CUSTDAT,cust,putimage()))
				return(-1);
			switch (choice[0]) {
	case 'n':
	case 'N':
				return(NEXT);
			
	case 'p':
	case 'P':
				return(PREV);

	case 'e':
	case 'E':
				return(-1);
			}
case 'd':
case 'D':
			if(!DELVREC(CUSTDAT))
				printf("\nSuccessful Deletion.\n");
			return(NEXT);

case '1':
case '2':
case '3':
case '4':
case '5':
case '6':
case '7':
			getfld((choice[0] - '1'),OLD);
			break;
default:
			printf("\nImproper selection (%.1s). Try again.\n",
				choice);
		}
	}
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to output customer field
 */

VOID putfld(fldno)

COUNT fldno;

{
	LONG      *intdat;
	FAST COUNT i;
	FAST TEXT *tp;

	if (fldtyp[fldno] == INTFLD) {
		intdat = (LONG *) fldptr[fldno];
		printf("%ld",*intdat);
	} else
		for (i = 0, tp = fldptr[fldno]; i++ < fldlen[fldno];)
			printf("%c",*tp++);
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to copy character data, padding with blanks
 * if the data does not fill the field
 */

VOID cpychr(dp,sp,len)

PFAST TEXT *dp,*sp;
PFAST COUNT len;

{
	while (*sp && len-- > 0 )	/* loop terminates either when 
					 * complete field filled in, or
					 * when a null termination byte
					 * encountered
					 */
		*dp++ = *sp++;

	while (len-- > 0)		/* if field not filled in, pad
					 * with blanks
					 */
		*dp++ = ' ';
}

VOID cpyvar(dp,sp,len,minl)
PFAST TEXT *dp,*sp;
COUNT       len,minl;
{
	while (*sp && len-- > 0) {
		*dp++ = *sp++;
		minl--;
	}
	while (minl-- > 0) {
		*dp++ = ' ';
		len--;
	}
	while (len-- > 0)
		*dp++ = '\0';
	*dp = '\0';
}

/* ************************************************************************* */
/* ************************************************************************* */

/*
 * routine to copy data without padding
 */

VOID cpydat(dp,sp,len)

PFAST TEXT *dp,*sp;
PFAST COUNT len;

{
	while (len-- > 0)
		*dp++ = *sp++;
}

/*
 * end of CTVXMG.C example program
 */
