         TITLE    'FKEY2.ASM: Tastenbelegung fr F6, Abfangen von INT 9h'
; Dieses Programm kann durch nochmaliges Aufrufen wieder entladen werden.
; Es hat die Aufgabe, nach Drcken von F6 den String DIR *.COM auszugeben.
; Es arbeitet auf sehr niedrigem DOS-Level, indem es den von der Tastatur
; bei Drcken einer Taste erzeugten Interrupt abfngt.
; Dadurch wird auch der deutsche Tastaturtreiber KEYBGR bersprungen; die
; Tastatur wirkt als "amerikanische" (Y - Z, Sonderzeichen verndert).
BiosRom  SEGMENT  AT 0F000h
         ASSUME   CS:BiosRom
         ORG      0E9A6h     ; Einsprungstelle in Tastaturroutine
RomJump  LABEL    FAR        ; reserviert hier 2 Wrter mit Sprungadresse
BiosRom  ENDS
;
DataSeg  SEGMENT  AT 40h     ; Variablen laut BIOS-Listing ab hier
         ORG      1Ah
BufHead  DW       ?          ; Pointer auf erstes Byte im Tastaturpuffer
BufTail  DW       ?          ; Pointer auf letztes Byte im Tastaturpuffer
Buffer   DW       16 DUP (?) ; Tastaturpuffer
DataSeg  ENDS
;
CodeSeg  SEGMENT  PARA PUBLIC 'Code'
         ASSUME   CS:CodeSeg,SS:CodeSeg
         ASSUME   DS: CodeSeg,ES:CodeSeg
         ORG      100h
KbdInt   EQU      09h            ; ROM-BIOS-Interrupt Keyboard
KbdData  EQU      60h            ; Datenkanal der Tastatur
KbdCtrl  EQU      61h            ; Kontrollkanal der Tastatur
Begin:   JMP      Start          ; Daten berspringen
;**** Variablen-Definitionen
String   DB       'DIR *.COM'
KbdIntI  DW       0              ; IP des Keyboard-Interrupt
KbdIntS  DW       0              ; Segmentadresse dazu
TestWort DW       1234h          ; Wort, von dem angenommen werden kann, da
                                 ; es im ROM-BIOS nicht gerade an der Stelle
                                 ; ES:TestWort mit gleichem Wert vorkommt
EnvAdr   DW       0              ; zum Sichern der Environment-Adresse
Logo     DB       10,13,'FKEY2 geladen',10,13,"$"
Meldg    DB       10,13,'Soll FKEY2 entladen werden ? J/N: $'
BelMeldg DB       10,13,'Ersatz-Interrupt schon belegt$'
SysErMdg DB       10,13,'Fehler beim Speicher-Freimachen: System neu booten$'
;**** Beginn des Hauptprogramms
Start:   MOV      AH,35h         ; Interruptvektor erfragen
         MOV      AL,KbdInt      ; zu Interrupt KbdInt
         INT      21h            ; ES:BX ist jetzt alte Interruptadresse
         MOV      AX,ES:TestWort ; dort steht entweder ein Wort im ROM-Bios
                                 ; (wenn KbdInt noch der umzulenkende
                                 ; Interrupt war) oder der Wert des TestWorts
                                 ; im bereits geladenen Modul
         MOV      DX,CS:TestWort ; dort steht jedenfalls der Wert des TestWorts
                                 ; in diesem Modul
         CMP      AX,DX          ; wenn gleich, dann ist das Programm schon
                                 ; geladen ist, also KbdInt schon umgelenkt
         JZ       Geladen        ; gleich
         MOV      KbdIntI,BX     ; nicht gleich: alte Interruptadresse
         MOV      KbdIntS,ES     ;               sichern
         PUSH     ES
         PUSH     BX             ; alte Interrupt-Adresse auf Stack
         LEA      DX,IntRout     ; Einsprungstelle bei Interrupt
         MOV      AH,25h         ; Interruptadresse fr KbdInt auf die
         MOV      AL,KbdInt      ; Interrupt-Routine dieses Programms setzen
         INT      21h
         MOV      AX,CS:[2Ch]    ; Environment-Adresse sichern
         MOV      EnvAdr,AX
         LEA      DX,Logo
         MOV      AH,9
         INT      21h             ; Logo ausgeben
         MOV      DX,OFFSET Letzt ; letzte Adresse in diesem Programm
         MOV      CL,04           ; Zhler fr Shift
         SHR      DX,CL           ; DIV 16, wird dadurch Segmentadresse
         INC      DX              ; + 1, daher sicher nicht vom Programm belegt
         MOV      AH,31h          ; Programm beenden, resident bleiben
         INT      21h
;
Geladen: LEA      DX,Meldg       ; Programm schon geladen. Frage "Entfernen ?"
         MOV      AH,9
         INT      21h
         MOV      AH,1           ; Zeichen (J/N) lesen
         INT      21h
         OR       AL,20h         ; Bit 5 setzen (macht aus "J" ein "j")
         CMP      AL,6Ah         ; "j" ?
         JZ       Entfern        ; ja
Exit:    MOV      AH,4Ch         ; nein: dieses (nochmals geladene)
         INT      21h            ; Programm beenden. Programm bleibt geladen
Belegt:  MOV      DX,OFFSET BelMeldg
         MOV      AH,9
         INT      21h
         JMP      Exit
Entfern: MOV      DX,ES:KbdIntI  ; Interrupt-Vektor wieder laden
         MOV      DS,ES:KbdIntS
         MOV      AH,25h
         MOV      AL,KbdInt
         INT      21h
         MOV      AH,49h         ; Speicher freigeben
         INT      21h            ; wenn Carry Flag gesetzt: Fehler
         JC       SysErr         ; Fehler: System-Error
         JMP      Exit           ; kein Fehler
         MOV      ES,ES:EnvAdr   ; Environmentadresse wiederherstellen
         MOV      AH,49h
         INT      21h            ; Environment-Block wieder frei machen
         JNC      Exit           ; kein Fehler: exit; sonst: System-Error
SysErr:  MOV      AH,9
         LEA      DX,SysErMdg
         INT      21h            ; Fehlermeldung ausgeben
         JMP      Exit           ; Programm beenden
; **** Interrupt-Handler
IntRout: PUSH     AX             ; hier beginnt Kopie des ROM-Codes zu INT 9h
         PUSH     BX             ; Dieser Interrupt wird abgefangen. Nach der
         PUSH     CX             ; individuellen Bearbeitung wird in den
         PUSH     DX             ; restlichen ROM-Code gesprungen, der dort
         PUSH     SI             ; fortgesetzt wird, wo diese Code-Kopie
         PUSH     DI             ; ihn verlassen hat.
         PUSH     DS             ; Daher mssen auch in diesem Programm nicht
         PUSH     ES             ; verwendete Register auf den Stack
         CLD                     ; links nach rechts
         MOV      AX,DataSeg
         MOV      DS,AX          ; Daten mit DS adressierbar
         STI
         IN       AL,KbdData     ; Scancode holen
         PUSH     AX
         IN       AL,KbdCtrl     ; Kontrollcode holen
         MOV      AH,AL
         OR       AL,80h         ; Bit fr Keyboard wieder setzen
         OUT      KbdCtrl,AL
         XCHG     AH,AL          ; ursprngliches Kontrollbyte holen
         OUT      KbdCtrl,AL     ; Tastatur wiederhergestellt
         POP      AX             ; jetzt Scancode wieder in AL
         MOV      AH,AL          ; auch in AH
                                 ; hier endet der kopierte ROM-Code. Weiter
                                 ; ginge er auf Adresse RomJump (0E9A6h)
         CMP      AL,40h         ; Sondertaste F6 ?
         JE       IR5            ; ja
IR0:     JMP     FAR PTR RomJump ; nein: nichts weiter tun
IR5:     CMP      AL,40h         ; Scan-Code fr F6 ?
         JNE      IR0            ; nein: nichts tun
         CALL     HolString      ; ja: String in Tastaturpuffer schreiben
         MOV      AL,20h         ; EOI (End Of Interrupt) fr Programmable
                                 ; Interrupt Controller 8259A
         MOV      DX,20h         ; Control Port fr 8259A
         OUT      DX,AL          ; verhindert Blockieren von Interrupts bis zum
                                 ; Level des letzten bearbeiteten Interrupts,
                                 ; sofern dieser durch den PIC gekommen ist
                                 ; (dies trifft zu fr Hardware-Interrupts,
                                 ; insbesondere daher auch fr solche von der
                                 ; Tastatur)
         POP      ES             ; Register wiederherstellen
         POP      DS
         POP      DI
         POP      SI
         POP      DX
         POP      CX
         POP      BX
         POP      AX
         IRET                    ; zurck aus der Interrupt-Routine
;
; **** Kontroll-String in den Tastaturpuffer schreiben
HolString:
         PUSH     DS
         ASSUME   DS:DataSeg ; alle Variablen im DataSeg werden adressiert
         CLI                 ; Interrupt sperren
         MOV      AX,DataSeg
         MOV      DS,AX      ; jetzt DataSeg ber DS adressiert
         STI                 ; Interrupt wieder zulassen
         MOV      AX,BufHead
         MOV      BufTail,AX ; jetzt ist Puffer leer
         MOV      AX,CS
         MOV      ES,AX      ; Quellstring ber ES adressiert
         MOV      SI,OFFSET String ;       und SI
         MOV      BP,BufHead
         SUB      BP,OFFSET Buffer
         SHR      BP,1       ; BP enthlt jetzt Index (0 .. 15) des Worts
                             ; im Puffer, das mit BufHead adressiert ist
         MOV      CX,9       ; Zhler: 9 Bytes bertragen
Schleif: MOV      DI,BP
         SHL      DI,1       ; * 2
         ADD      DI,OFFSET Buffer
         MOV      AL,ES:[SI] ; Zeichen bertragen
         MOV      AH,0Fh     ; Scan-Code bertragen (Reihenfolge umgekehrt)
         MOV      [DI],AX    ; jetzt im Puffer
         INC      DI
         INC      DI         ; DI um 2 erhhen (eine Wortlnge)
         INC      BP         ; Index erhhen
         AND      BP,0Fh     ; modulo 16 wegen Ringpuffer
         INC      SI         ; nchstes Zeichen im Quellstring
         LOOP     Schleif
         SHL      BP,1       ; Index * 2
         ADD      BP,OFFSET Buffer
         MOV      BufTail,BP ; jetzt zeigt BufTail auf das Ende des Strings
                             ; im Puffer
         POP      DS
Return:  RET
;
         ASSUME DS:CodeSeg
Letzt:   NOP
;
CodeSeg  ENDS
         END      Begin

