(*$R+*)  (* Dieses Programm ist als COM-File aufzurufen, z.B. KB kommando.
            Es bertrgt das angegebene DOS-Kommando in den Tastaturpuffer, von
            wo aus es nach Beendigen von KB ausgefhrt wird. *)
PROGRAM KeyBoardBuffer;
CONST CR = $0D;                     (* Carriage Return *)
TYPE WorkStr = STRING(.16.);        (* ist in den Tastaturpuffer zu bringen *)
     Word = RECORD Zeichen,         (* Struktur eines Worts im Tastaturpuffer *)
                   ScanCode : CHAR
            END;
VAR I: INTEGER;
    CommandLine: WorkStr;
    Head: INTEGER ABSOLUTE $0040:$001A;    (* Pointer auf erstes gltiges
                                              Zeichen im Tastaturpuffer *)
    Tail: INTEGER ABSOLUTE $0040:$001C;    (* Pointer auf letztes gltiges
                                              Zeichen im Tastaturpuffer *)
    Buffer: ARRAY (. 0 .. 15 .) OF Word ABSOLUTE $0040:$001E;
    Index: BYTE;                   (* zum Adressieren im Tastaturpuffer *)
PROCEDURE IntoBuffer (Str: WorkStr);
BEGIN IF Str (.LENGTH(Str).) <> CHR(CR) THEN Str:=Str+CHR(CR);
      Tail := Head;  (* stellt Puffer auf "leer" *)
      Index:=(Head-$1E) DIV 2;  (* zeigt auf Wort im Puffer, Index 0 .. 15 *)
      FOR I := 1 TO LENGTH(Str) DO
          BEGIN Buffer (.Index.).Zeichen := Str(.I.);
                Buffer (.Index.).ScanCode := CHR($0F);
                Index:=Index+1;       (* nchstes Wort im Tastaturpuffer *)
                Index:=Index AND $0F  (* bewirkt modulo 16 (Ringpuffer)  *)
          END;
      Tail := 2*Index + $1E (* stellt auf das Ende des Eingabestrings im Puffer *)
END;
BEGIN CommandLine := '';
      IF PARAMCOUNT > 0                (* Anzahl Parameter in der Kommandozeile *)
         THEN FOR I:=1 TO PARAMCOUNT DO  (* Parameter in Kommandozeile kopieren *)
                  CommandLine := CommandLine + PARAMSTR (I) + ' ';
      IntoBuffer (CommandLine)         (* in den Tastaturpuffer kopieren *)
END.
