         TITLE    'LPDRV.ASM: Codebersetzer fr Laser-Drucker'
; Dieses Programm kann durch nochmaliges Aufrufen wieder entladen werden.
; Es hat die Aufgabe, den IBM-Zeichencode in den Zeichencode des HP-Laserjet +
; zu bersetzen, soweit die gleichen Zeichen enthalten sind. Zeichen, die in
; einem der Zeichenstze nicht enthalten sind, werden nicht bersetzt.
; Der Drucker-Interrupt 17h wird abgefangen, der Code in Al wird bersetzt.
; Dann wird in die BIOS-Interruptroutine zurckgesprungen.
CodeSeg  SEGMENT  PARA PUBLIC 'Code'
         ASSUME   CS:CodeSeg,SS:CodeSeg
         ASSUME   DS: CodeSeg,ES:CodeSeg
         ORG      100h
DruInt   EQU      17h            ; ROM-BIOS-Interrupt Drucker
Begin:   JMP      Start          ; Daten berspringen
;**** Variablen-Definitionen
JumpFar: DB       0EAh           ; Operationscode fr Jump Far
DruIntI  DW       0              ; IP des Drucker-Interrupt
DruIntS  DW       0              ; Segmentadresse dazu
TestWort DW       1234h          ; Wort, von dem angenommen werden kann, da
                                 ; es im ROM-BIOS nicht gerade an der Stelle
                                 ; ES:TestWort mit gleichem Wert vorkommt
EnvAdr   DW       0              ; zum Sichern der Environment-Adresse
Logo     DB       10,13,'LPDRV geladen',10,13,"$"
Meldg    DB       10,13,'Soll LPDRV entladen werden ? J/N: $'
BelMeldg DB       10,13,'Ersatz-Interrupt schon belegt$'
SysErMdg DB       10,13,'Fehler beim Speicher-Freimachen: System neu booten$'
Tab      DB       0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19
         DB       20
         DB       189            ; Paragraphenzeichen
         DB       22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39
         DB       40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59
         DB       60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79
         DB       80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99
         DB       100,101,102,103,104,105,106,107,108,109
         DB       110,111,112,113,114,115,116,117,118,119
         DB       120,121,122,123,124,125,126,127
         DB       180            ; 
         DB       207            ; 
         DB       197            ; 
         DB       192            ; 
         DB       204            ; 
         DB       200            ; 
         DB       212            ; 
         DB       181            ; 
         DB       193            ; 
         DB       205            ; 
         DB       201            ; 
         DB       221            ; 
         DB       209            ; 
         DB       217            ; 
         DB       216            ; 
         DB       208            ; 
         DB       220            ; 
         DB       215            ; 
         DB       211            ; 
         DB       194            ; 
         DB       206            ; 
         DB       202            ; 
         DB       195            ; 
         DB       203            ; 
         DB       239            ; 
         DB       218            ; 
         DB       219            ; 
         DB       191            ; 
         DB       187            ; 
         DB       188            ; 
         DB       32             ;  nicht bersetzbar
         DB       190            ; 
         DB       196            ; 
         DB       213            ; 
         DB       198            ; 
         DB       199            ; 
         DB       183            ; 
         DB       182            ; 
         DB       249            ; 
         DB       250            ; 
         DB       185            ; 
         DB       32             ;  nicht bersetzbar
         DB       32             ;  nicht bersetzbar
         DB       248            ; 
         DB       247            ; 
         DB       184            ; 
         DB       251            ; 
         DB       253            ; 
         DB       176,177,178,179
         DB       180,181,182,183,184,185,186,187,188,189
         DB       190,191,192,193,194,195,196,197,198,199
         DB       200,201,202,203,204,205,206,207,208,209
         DB       210,211,212,213,214,215,216,217,218,219
         DB       220,221,222,223,224
         DB       222            ; 
         DB       226,227,228,229
         DB       230,231,232,233,234,235,236
         DB       210            ; 
         DB       238,239
         DB       240
         DB       254            ; 
         DB       242,243,244,245,246,247,248,249
         DB       250,251,252,253,254,255
;**** Beginn des Hauptprogramms
Start:   MOV      AH,35h         ; Interruptvektor erfragen
         MOV      AL,DruInt      ; zu Interrupt DruInt
         INT      21h            ; ES:BX ist jetzt alte Interruptadresse
         MOV      AX,ES:TestWort ; dort steht entweder ein Wort im ROM-Bios
                                 ; (wenn DruInt noch der umzulenkende
                                 ; Interrupt war) oder der Wert des TestWorts
                                 ; im bereits geladenen Modul
         MOV      DX,CS:TestWort ; dort steht jedenfalls der Wert des TestWorts
                                 ; in diesem Modul
         CMP      AX,DX          ; wenn gleich, dann ist das Programm schon
                                 ; geladen ist, also DruInt schon umgelenkt
         JZ       Geladen        ; gleich
         MOV      DruIntI,BX     ; nicht gleich: alte Interruptadresse
         MOV      DruIntS,ES     ;               sichern
         PUSH     ES
         PUSH     BX             ; alte Interrupt-Adresse auf Stack
         LEA      DX,IntRout     ; Einsprungstelle bei Interrupt
         MOV      AH,25h         ; Interruptadresse fr DruInt auf die
         MOV      AL,DruInt      ; Interrupt-Routine dieses Programms setzen
         INT      21h
         MOV      AX,CS:[2Ch]    ; Environment-Adresse sichern
         MOV      EnvAdr,AX
         LEA      DX,Logo
         MOV      AH,9
         INT      21h             ; Logo ausgeben
         MOV      DX,OFFSET Letzt ; letzte Adresse in diesem Programm
         MOV      CL,04           ; Zhler fr Shift
         SHR      DX,CL           ; DIV 16, wird dadurch Segmentadresse
         INC      DX              ; + 1, daher sicher nicht vom Programm belegt
         MOV      AH,31h          ; Programm beenden, resident bleiben
         INT      21h
;
Geladen: LEA      DX,Meldg       ; Programm schon geladen. Frage "Entfernen ?"
         MOV      AH,9
         INT      21h
         MOV      AH,1           ; Zeichen (J/N) lesen
         INT      21h
         OR       AL,20h         ; Bit 5 setzen (macht aus "J" ein "j")
         CMP      AL,6Ah         ; "j" ?
         JZ       Entfern        ; ja
Exit:    MOV      AH,4Ch         ; nein: dieses (nochmals geladene)
         INT      21h            ; Programm beenden. Programm bleibt geladen
Entfern: MOV      DX,ES:DruIntI  ; Interrupt-Vektor wieder laden
         MOV      DS,ES:DruIntS
         MOV      AH,25h
         MOV      AL,DruInt
         INT      21h
         MOV      AH,49h         ; Speicher freigeben
         INT      21h            ; wenn Carry Flag gesetzt: Fehler
         JC       SysErr         ; Fehler: System-Error
         JMP      Exit           ; kein Fehler
         MOV      ES,ES:EnvAdr   ; Environmentadresse wiederherstellen
         MOV      AH,49h
         INT      21h            ; Environment-Block wieder frei machen
         JNC      Exit           ; kein Fehler: exit; sonst: System-Error
SysErr:  MOV      AH,9
         LEA      DX,SysErMdg
         INT      21h            ; Fehlermeldung ausgeben
         JMP      Exit           ; Programm beenden
; **** Interrupt-Handler
IntRout: PUSH     DS
         PUSH     BX
         PUSH     CS
         POP      DS             ; DS auf dieses Programm setzen
         MOV      BX,OFFSET Tab  ; bersetzungstabelle
         XLAT     Tab            ; Code in AL bersetzen
         POP      BX
         POP      DS
         JMP      JumpFar
;
         ASSUME DS:CodeSeg
Letzt:   NOP
;
CodeSeg  ENDS
         END      Begin
