
;  ***** ESC SI (1B 0F hex) (ALT 27,15)  ****
;    ***** Drucker auf Engschrift schalten ****
;
PAGE 70,132	;ASSEMBLER-FORMATIERUNG FUER AUSDRUCK DES LISTINGS xxx.LST
		;
		;70 ZEILEN JE SEITE, 132 ZEICHEN JE ZEILE
		;BEI A4-FORMAT --> DRUCKER AUF ENGSCHRIFT SCHALTEN !
;
;
;
;
CSEG SEGMENT PUBLIC PARA 'CODE'
;
ASSUME CS:CSEG,DS:CSEG,SS:STACK,ES:NOTHING	;CS und SS setzt der Linker
;
;
	CR EQU 0Dh		;Definition von Carriage Return
	LF EQU 0Ah		;Definition von Line Feed
;
SCREEN	MACRO TXT		;MACRO fr Bildschirmausgabe
;
	MOV  DX,OFFSET TXT	;(DS:)DX zeigt auf Beginn des STRINGS
	MOV  AH,09h		;Bildschirmausgabe - $ beendet den STRING
	INT  21h		;DOS - Interrupt
;
	ENDM
;
;
;
PUTZEN	 PROC  FAR		;FAR weil fr Rcksprung zu DOS sowohl
				;OFFSET als auch SEGMENT vom STACK notwendig
;
;
	MOV  AX,SEG STACK   ;STACK - SEGMENT laden
	MOV  SS,AX
	MOV  AX,OFFSET SS:STAPELEND
	MOV  SP,AX	    ;STACK - Pointer laden
;
	PUSH DS 	;PSP - SEGMENT Adresse sichern
	XOR  AX,AX
	PUSH AX 	;PSP - OFFSET Adresse (=Rcksprung) sichern
	PUSH CS
	POP  DS 	;DS auf CSEG setzen
;
;
	JMP  BEGINN	;zum berspringen eines allfll. Datenbereiches
;
;
;DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
;
;			 D A T E N B E R E I C H
;
	COUNT	DB  0		;Zhler fr das "Putzen"
;
	LAUFW	DB  1		;Voreinstellung 1 = B
;
	INIT	 DB  CR,LF,   "*** PUTZEN.EXE *** SYROVATKA-TGM/N *** 1988 ***$"
;
	MELDUNG1 DB  CR,LF,LF,"BITTE LAUFWERKNAMEN ANGEBEN (A/B) $"
;
	WARTEN	 DB  CR,LF,"BITTE WARTEN, ""PUTZEN"" WIRD AUSGEFHRT    $"
;
	MELDUNG2 DB  CR,LF,"LAUFWERK "
;
	EINGABE  DB  0," $"
;
	OK	 DB  "ERFOLGREICH GEPUTZT !",CR,LF,LF,"$"
;
	ERR	 DB  "OHNE ERFOLG GEPUTZT !",CR,LF,LF,"$"
;
;DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
;
BEGINN:
	SCREEN INIT		;Meldung .. SIGNATUR .. ausgeben
	SCREEN MELDUNG1 	;Meldung .. LAUFWERK ANGEBEN .. ausgeben
;
   B1:	MOV  AH,08h		;Zeichen von CON einlesen mit (CTL-C Abfrage)
	INT  21h		;Zeichen wird in AL zurckgegeben
	MOV  EINGABE,AL 	;wegen Erfolgsmeldung nach EINGABE schreiben
;
	OR   AL,20h		;Grobuchst. in Kleinbuchst. umwandeln
	CMP  AL,"b"             ;ist Zeichen B oder b ?
	JE   B2 		;LAUFW mit B = 1 voreingestellt !
;
	CMP  AL,"a"             ;ist Zeichen A oder a ?
	JNE  B1 		;andere Eingabe als A oder B unzulssig
	MOV  LAUFW,0
;
   B2:	SCREEN WARTEN		;Meldung .. WARTEN .. ausgeben
;
	PUSHF			;Flags auf den Stack schreiben
				;hier nur wegen REPEAT-SChleife notwendig
;
REPEAT: POPF			;Flags wieder vom Stack holen
;
	MOV  CH,27h		;Track 27h = 39 dez
	MOV  CL,1		;Sektor 1
	MOV  DH,0		;Kopf 0
	MOV  DL,LAUFW		;Laufwerk 0 = A , 1 = B
	MOV  AL,1		;Anzahl der zu lesenden Sektoren
;
	MOV  AH,04h		;Sektoren berprfen (verify)
;
	INT  13h		;BIOS - Disketten - Interrupt
;
	MOV  CH,0		;Track 0
	MOV  CL,1		;Sektor 1
	MOV  DH,0		;Kopf 0
	MOV  DL,LAUFW		;Laufwerk 0 = A , 1 = B
	MOV  AL,1		;Anzahl der zu lesenden Sektoren
;
	MOV  AH,04h		;Sektoren berprfen (verify)
;
	INT  13h		;BIOS - Disketten - Interrupt
;
	PUSHF			;Flags am Stack sichern
;
	ADD  COUNT,1		;Zhler um 1 erhhen
	CMP  COUNT,11		;Bereits 10 mal "geputzt" ?
	JNZ  REPEAT		;.. wenn nicht gleich noch einmal...
;
;
	SCREEN MELDUNG2 	;Erfolgsmeldung ausgeben
;
	POPF			;Flags wieder vom Stack holen und Carry-Flag ab-
				;fragen: wenn Carry gesetzt, Fehler aufgetreten
	JC   FEHLER
	SCREEN OK		;...ERFOLGREICH....
;
	RET		;Return zu DOS ... mu Ende einer FAR-Procedur sein !!
;
FEHLER: SCREEN ERR		;...OHNE ERFOLG....
;
	RET		;Return zu DOS ... mu Ende einer FAR-Procedur sein !!
;
PUTZEN	ENDP
;
;
;
CSEG	ENDS
;
;
;
	;---------------------------------;
	;STACK- BEREICH DEFINIEREN	  ;
	;---------------------------------;
;
STACK SEGMENT STACK 'STACK'
;
	STAPEL	DB	50 DUP ("STACK")
;
	STAPELEND DB	0
;
STACK	ENDS
;
;
;
END	PUTZEN	;Angabe des Programmstarts (hier START ) ist bei
		; .EXE - Programmen UNBEDINGT NOTWENDIG !!!
;
;
;
;  DC2  (ALT 18) (12 hex) Drucker von Eng- auf Normalschrift schalten
;
