	PAGE	60,132
	TITLE	Watchdog - resets machine when carrier is lost
;------------------------------------------------------------------------------
;
; WATCHDOG.COM	8/15/84  by James R. Reinders
;
;	The IBM Macro Assembler and Link will produce WATCHDOG.EXE
;	which must be converted to a .COM program by the DOS
;	EXE2BIN command:
;
;	C\> EXE2BIN WATCHDOG.EXE WATCHDOG.COM
;
;  Update/Modification History (reverse order):
;
; 10/31/84 - Set up equate for COM port addressing.	- Steve Freeman
; 08/29/84 - Revised for COM1:				- Jim Kovalsky
;
;------------------------------------------------------------------------------
COMPORT EQU	1			;set this to your port number (1 or 2)
;					 --------------------------------------
TRUE	EQU	1
FALSE	EQU	0

PORTBASE EQU	2F8H+256*(2-COMPORT)	;COMx: base address
RESETVEC EQU	0FFFFH:0

CSEG	SEGMENT 'CODE'
	ASSUME	CS:CSEG
	ORG	100H		; SET UP FOR .COM CONVERSION

INIT	PROC	FAR		; WE'RE AN INTERRUPT ROUTINE
	JMP	SHORT INITIAL	; SO WE HAVE TO SET UP FIRST

START	PROC	FAR	; Start of main routine - Timer (18.2 times per second)
	ASSUME	CS:CSEG,DS:CSEG

	PUSH	AX
	MOV	AL,CS:101H
	OR	AL,AL
	JZ	NOWAY
	PUSH	DX

	MOV	DX,PORTBASE+6	;check port to Carrier Detect
	IN	AL,DX
	RCL	AL,1
	JNC	LOSTCARR

	POP	DX
NOWAY:	POP	AX

	DB	0EAH		; JMP old timer routine
WAS1Co	DW	0
WAS1Cs	DW	0

LOSTCARR:
	DB	0EAH		;jump to reset vector
	DW	0
	DW	0FFFFH

START	ENDP

BUFFER	DB	'Watchdog version 1.2 as of 10/31/84',13,10
	DB	'  by James R. Reinders',13,10,'$'

INITIAL:
	MOV	AX,CS
	MOV	DS,AX

	MOV	DX,OFFSET BUFFER
	MOV	AH,9
	INT	21H	; PRINT GREETING

	MOV	AX,351CH
	INT	21H

DOWHAT: XOR	AL,AL
	MOV	SI,05DH
	CMP	BYTE PTR [SI],'O'
	JNZ	ONONON
	CMP	BYTE PTR [SI+1],'F'
	JNZ	ONONON
	CMP	BYTE PTR [SI+2],'F'
	JNZ	ONONON
	CMP	BYTE PTR [SI+3],' '
	JZ	OFFOFF

ONONON: INC	AL
	CMP	WORD PTR ES:[BX],2E50H
	JNZ	PUTIN
OFFOFF: CMP	WORD PTR ES:[BX],2E50H
	MOV	DX,OFFSET NODOG
	JNZ	PBYE

	DEC	BX
	MOV	ES:[BX],AL

	MOV	DX,OFFSET ACTIVE
	OR	AL,AL
	JNZ	PBYE
	MOV	DX,OFFSET NACTIVE

PBYE:	MOV	AH,9
	INT	21H
	INT	20H

PUTIN:	MOV	AX,ES
	MOV	WAS1Cs,AX
	MOV	CS:WAS1Co,BX

	MOV	AX,CS
	MOV	DS,AX

	MOV	DX,OFFSET START
	MOV	AX,251CH  ; DOS ROUTINE TO RESET INT. VECTOR
	INT	21H

	MOV	DX,OFFSET INSTAL
	MOV	AH,9
	INT	21H
;
	MOV	DX,OFFSET BUFFER ; LAST ADDRESS HERE
	INT	27H	; TERMINATE BUT STAY RESIDENT
INIT	ENDP


INSTAL	DB	'Watchdog installed and activated.',13,10,'$'
ACTIVE	DB	'Watchdog activated.',13,10,'$'
NACTIVE DB	'Watchdog deactivated.',13,10,'$'
NODOG	DB	'Watchdog not present OR'
	DB	' another time utility loaded since watchdog.'
	DB	13,10,'$'

CSEG	ENDS
	END	INIT
NODOG	DB	'Watchdog not present OR'
	DB	' another time utility loaded since watchdog.'
	DB	13,10,'$'

CSEG