(*-------------------------------------------------------------------------*)
(********* UNIT Graph_IO: Ein/Ausgabe von Variablen im Graphikmodus ********)
(********* (c) 9.7-17.7 1988 by eh                      Ernst HUBER ********)
(*-------------------------------------------------------------------------*)
UNIT Graph_IO;
INTERFACE
USES CRT, GRAPH;

(*-------------------------------------------------------------------------*)
(******************** Typendefinitionen fuer Unit Graph_IO *****************)
(*-------------------------------------------------------------------------*)
TYPE Whole_Set = SET OF  #0..#255;

(*-------------------------------------------------------------------------*)
(***************** Konstantendefinitionen fuer Unit Graph_IO ***************)
(*-------------------------------------------------------------------------*)
CONST To_Less  : INTEGER = 1;
      To_Big   : INTEGER = 2;
      Esc      : INTEGER = 3;
      Crs_Down : INTEGER = 4;
      Crs_Up   : INTEGER = 5;
      Crs_Left : INTEGER = 6;
      Crs_Right: INTEGER = 7;
      Back_Step: INTEGER = 8;
      Return   : INTEGER = 9;

      Number   : SET OF '+'..'E'=['+','-','.','0'..'9','E'];
      Character: SET OF '!'..''=['!'..''];

      Min_W    : WORD = 0;
      Max_W    : WORD = 65535;
      Min_I    : INTEGER = -32768;
      Max_I    : INTEGER = 32767;
      Min_LI   : LONGINT = -2147483647;
      Max_LI   : LONGINT = 2147483647;
      Min_R    : REAL = -1.5E+38;
      Max_R    : REAL = 1.5E+38;

(*-------------------------------------------------------------------------*)
(********** oeffentliche Proceduredefinitionen fuer Unit Graph_IO **********)
(*-------------------------------------------------------------------------*)
PROCEDURE Wr_String (X, Y, BARCol, Digits: WORD; V: STRING);
PROCEDURE Wr_Int (X, Y, BARCol: WORD; V: INTEGER);
PROCEDURE Wr_Long (X, Y, BARCol: WORD; V: LONGINT);
PROCEDURE Wr_Word (X, Y, BARCol, V: WORD);
PROCEDURE Wr_Floati (X, Y, BARCol, Digits: WORD; V: REAL);
PROCEDURE Wr_Fix (X, Y, BARCol, Digits: WORD; V: REAL);

PROCEDURE Rd_String (X, Y, BARCol, Digits: Word; CharSet: Whole_Set;
                       VAR Status: BYTE; VAR V: STRING);
PROCEDURE Rd_Int (X, Y, BARCol: WORD; MinV, MaxV: INTEGER;
                    VAR Status: BYTE; VAR V: INTEGER);
PROCEDURE Rd_Long (X, Y, BARCol: WORD; MinV, MaxV: LONGINT;
                    VAR Status: BYTE; VAR V: LONGINT);
PROCEDURE Rd_Word (X, Y, BARCol, MinV, MaxV: Word;
                     VAR Status: BYTE; VAR V: Word);
PROCEDURE Rd_Floati (X, Y, BARCol, Digits: WORD; MinV, MaxV: REAL;
                     VAR Status: BYTE; VAR V: REAL);
PROCEDURE Rd_Fix (X, Y, BARCol, Digits: WORD; MinV, MaxV: REAL;
                    VAR Status: BYTE; VAR V: REAL);


IMPLEMENTATION
(*-------------------------------------------------------------------------*)
(***************** Interne Procedures des Units Graph_IO *******************)
(*-------------------------------------------------------------------------*)

(*-------------------------------------------------------------------------*)
(* Check_Key: prueft die Tastatur und liefert den entsprechenden Returncode*)
(*-------------------------------------------------------------------------*)
PROCEDURE Check_Key (VAR Ch: CHAR; CharSet: Whole_Set; VAR Status: BYTE);
VAR OK: BOOLEAN;

BEGIN
REPEAT
  OK:=TRUE;
  REPEAT UNTIL KeyPressed;
  Ch:=ReadKey;
  IF Ch IN CharSet THEN Status:=0;
  CASE Ch OF
      #00: BEGIN
           Ch:=ReadKey;
           CASE Ch OF
                #80: Status:=4;
                #72: Status:=5;
                #75: Status:=6;
                #77: Status:=7;
           ELSE OK:=FALSE
           END; (* Case *)
           END;
      #08: Status:=8;
      #13: Status:=9;
      #27: Status:=3;
  ELSE OK:=FALSE
  END; (* CASE *)
UNTIL (Ch IN CharSet) OR OK;
END; (* PROC Check_Key *)

(*-------------------------------------------------------------------------*)
(* FixPoint: gibt eine Real-Var. als String in Fixkommadarstellung zurueck *)
(*-------------------------------------------------------------------------*)
FUNCTION FixPoint (VAR r: Real; Digits: Byte): STRING;
VAR x, y, Po, code      : INTEGER;
    Vstring, Lsg, FixStr: STRING [45];
    Vzp, Vz, s1         : STRING [1];
    PoStr               : STRING [4];
    lE                  : BYTE;

BEGIN
  Vstring:=''; Lsg:=''; FixStr:=''; Vzp:=''; Vz:=''; s1:=''; PoStr:='';
  x:=0; y:=0; Po:=0; code:=0; lE:=0;
  Str (r,Vstring);
  Vz:=Vstring[1];
  REPEAT
    Inc (lE);
    s1:=Copy (Vstring, lE, 1);
  UNTIL s1 = 'E';
  Vzp:=Vstring[lE+1];
  FixStr:=Copy (Vstring,2,lE-1);
  PoStr:=Copy (Vstring,lE+2,Length (Vstring)-(lE+1)); Val (PoStr,Po,code);
  Delete(FixStr,2,1);
  IF Vzp='-' THEN BEGIN
    Insert('.',Lsg,1);
    FOR x:=2 TO Po DO Insert('0',Lsg,x);
    Lsg:=Concat(Lsg,FixStr)
  END
  ELSE BEGIN
    Lsg:=Copy(FixStr,1,Po+1);
    Insert('.',Lsg,Po+2);
    FOR y:=Po+3 TO (Length(FixStr)+1) DO Insert(FixStr[y-1],Lsg,y);
  END;

  FixPoint:=Copy(Concat(Vz,Lsg),1,Digits);

END; (* FUNC FixPoint *)

(*-------------------------------------------------------------------------*)
(******************** Beginn der Output (Write) Routinen *******************)
(*-------------------------------------------------------------------------*)

(*-------------------------------------------------------------------------*)
(********* Wr_String: gibt eine Stringvariable im Graphikmodus aus *********)
(*-------------------------------------------------------------------------*)
(* Eingabeparameter: X, Y  : Start der Ausgabe                             *)
(*                   BarCol: Hintergrundfarbe fuer Stringausgabe           *)
(*                   Digits: Balken der Laenge Digits mit BarCol           *)
(*                   V     : Stringvariable die ausgegeben werden soll     *)
(*-------------------------------------------------------------------------*)

PROCEDURE Wr_String;
VAR DX, DY: WORD;
    DFont : INTEGER;
    Txt   : TextSettingsType;

BEGIN
DX:=TextWidth ('9');
DY:=TextHeight ('Y');
SetFillStyle (1,BARCol);
GetTextSettings (Txt);
IF (Txt.Font=DefaultFont) THEN DFont:=1+Txt.CharSize DIV 2
ELSE IF (Txt.Font=SmallFont) THEN DFont:=-(Txt.CharSize DIV 2)
ELSE DFont:=-1-(Txt.CharSize DIV 2);

BAR (X,Y,X+(Digits+1)*DX,Y+DY);
MoveTo (X+(Digits+1)*DX-TextWidth(V)-(DX DIV 2)+1,Y+DFont);
OutText (V);

END; (* Wr_String *)

(*-------------------------------------------------------------------------*)
(********* Wr_Int: gibt eine Integervariable im Graphikmodus aus ***********)
(*-------------------------------------------------------------------------*)
(* Eingabeparameter: X, Y  : Start der Ausgabe                             *)
(*                   BarCol: Hintergrundfarbe fuer Variablengausgabe       *)
(*                   V     : Integervariable die ausgegeben werden soll    *)
(*                           (Feldlaenge fix, 6 Zeichen)                   *)
(*-------------------------------------------------------------------------*)
PROCEDURE Wr_Int;
VAR Result: STRING [6];

BEGIN
Result:='';
Str (V, Result);
Wr_String (X, Y, BARCol, 6, Result);
END; (* Wr_Int *)

(*-------------------------------------------------------------------------*)
(**** Wr_Long: gibt eine Variable der Type LONGINT im Graphikmodus aus *****)
(*-------------------------------------------------------------------------*)
(* Eingabeparameter: X, Y  : Start der Ausgabe                             *)
(*                   BarCol: Hintergrundfarbe fuer Variablenausgabe        *)
(*                   V     : Stringvariable die ausgegeben werden soll     *)
(*                           (Feldlaenge fix, 11 Zeichen)                  *)
(*-------------------------------------------------------------------------*)
PROCEDURE Wr_Long;
VAR Result: STRING [11];

BEGIN
Result:='';
Str (V,Result);
Wr_String (X,Y,BARCol,11,Result);
END; (* Wr_Long *)

(*-------------------------------------------------------------------------*)
(****** Wr_Word: gibt eine Variable der Type WORD im Graphikmodus aus ******)
(*-------------------------------------------------------------------------*)
(* Eingabeparameter: X, Y  : Start der Ausgabe                             *)
(*                   BarCol: Hintergrundfarbe fuer Variabelnausgabe        *)
(*                   V     : Stringvariable die ausgegeben werden soll     *)
(*                           (Feldlaenge fix, 5 Zeichen)                   *)
(*-------------------------------------------------------------------------*)
PROCEDURE Wr_Word;
VAR Result: STRING [5];

BEGIN
Result:='';
Str (V,Result);
Wr_String (X,Y,BARCol,5,Result);
END; (* Wr_Word *)

(*-------------------------------------------------------------------------*)
(******** Wr_Floati: gibt eine realvariable in Flieszkommaformat aus *******)
(*-------------------------------------------------------------------------*)
(* Eingabeparameter: X, Y  : Start der Ausgabe                             *)
(*                   BarCol: Hintergrundfarbe fuer Stringausgabe           *)
(*                   Digits: Ausgabevariable hat die Laenge Digits         *)
(*                   V     : Stringvariable die ausgegeben werden soll     *)
(*-------------------------------------------------------------------------*)
PROCEDURE Wr_Floati;
VAR Result, VStr, Potenz, Mantisse: STRING;
    MaxDig, MinDig, cnt, l, NoVz  : BYTE;
    s, Vz                         : STRING [1];

BEGIN
Result:=''; VStr:=''; Potenz:=''; Mantisse:=''; s:=''; Vz:='';
cnt:=0; MinDig:=0; MaxDig:=0; NoVz:=1; l:=0;
Str (V,VStr);
l:=Length (VStr);
cnt:=Pos('E',VStr);
Mantisse:=Copy (VStr,1,cnt-1);
Vz:=Copy (Mantisse,1,1);
IF Vz <> '-' THEN BEGIN
   Delete (Mantisse,1,1);
   NoVz:=0;
END;
Potenz:=Copy (VStr,cnt+1,l-cnt);
Vz:=Copy (Potenz,1,1);
IF Vz='+' THEN BEGIN
   Delete (Potenz,1,1);
   REPEAT
     s:=Copy (Potenz,1,1);
     IF s='0' THEN Delete (Potenz,1,1);
   UNTIL (s<>'0') OR (Length (Potenz)=1);
END
ELSE BEGIN
   REPEAT
     s:=Copy (Potenz,2,1);
     IF s='0' THEN Delete (Potenz,2,1);
   UNTIL (s<>'0') OR (Length (Potenz)=1);
END;

MinDig:=Length (Potenz)+2+NoVz;
MaxDig:=l;

IF (Digits >= MinDig) AND (Digits < MaxDig) THEN BEGIN
   REPEAT
     l:=Length (Mantisse);
     Delete (Mantisse, L, 1);
   UNTIL (Length (Mantisse))=(Digits-Length (Potenz)-1);
   Result:=Concat (Mantisse,'E',Potenz);
END
ELSE Result:='lD';
IF Digits >= MaxDig THEN Result:=VStr;

Wr_String (X, Y, BarCol, Digits, Result);

END; (* Wr_Floati *)

(*-------------------------------------------------------------------------*)
(******* Wr_Fix: gibt eine Realvariable in Fixkommadarstellung aus *********)
(*-------------------------------------------------------------------------*)
(* Eingabeparameter: X, Y  : Start der Ausgabe                             *)
(*                   BarCol: Hintergrundfarbe fuer Stringausgabe           *)
(*                   Digits: Ausgabvariable hat die Laenge Digits          *)
(*                   V     : Stringvariable die ausgegeben werden soll     *)
(*-------------------------------------------------------------------------*)
PROCEDURE Wr_Fix;
VAR Result: STRING;

BEGIN
Result:='';
IF ((V>(1E-11)) AND (V<(1E11))) OR ((V<(-1E-11)) AND (V>(-1E+11))) OR (V=0.0)
THEN BEGIN
   Result:=FixPoint (V, (Digits));
   Wr_String (X, Y, BARCol, Digits, Result);
END
ELSE Wr_Floati (X,Y,BarCol,Digits,V);
END; (* Wr_Fix *)

(*-------------------------------------------------------------------------*)
(******************* Beginn der Input (Read) Routinen **********************)
(*-------------------------------------------------------------------------*)

(*-------------------------------------------------------------------------*)
(******* Rd_String: liest ein Stringvariable im Graphikmodus ein ***********)
(*-------------------------------------------------------------------------*)
(* Eingabeparameter: X, Y   : Start des Balkens fuer Eingabe               *)
(*                   BarCol : Hintergrundfarbe fuer Stringeingabe          *)
(*                   Digits : gibt die Laenge der einzulesenden Variable an*)
(*                   CharSet: gibt die Menge der gueltigen Zeichen an      *)
(* Ausgabeparameter: Status : gibt einen Returncode ob eine gueltige Ein-  *)
(*                            gabe oder eine 'Sondertaste' gedrueckt wurde *)
(*                   V      : Stringvariable die eingelesen werden soll    *)
(*-------------------------------------------------------------------------*)
PROCEDURE Rd_String;
VAR St                : BYTE;
    Ch                : CHAR;
    DX, DY, BkCol, cnt: WORD;
    Result            : STRING;
    DFont             : INTEGER;
    Txt               : TextSettingsType;

BEGIN
Result:=''; cnt:=0; St:=0;
BkCol:=GetBkColor;
DX:=TextWidth ('9');
DY:=TextHeight ('!');
GetTextSettings (Txt);
SetFillStyle (1,BARCol);
IF (Txt.Font=DefaultFont) THEN DFont:=1+Txt.CharSize DIV 2
ELSE IF (Txt.Font=SmallFont) THEN DFont:=-(Txt.CharSize DIV 2)
ELSE DFont:=-1-(Txt.CharSize DIV 2);

REPEAT
  Bar (X,Y,X+(Digits+1)*DX,Y+DY);
  MoveTo (X+(Digits+1)*DX-(DX DIV 2)-TextWidth(Result)+1,Y+DFont);
  OutText (Result);
  Check_Key (Ch, CharSet, St);
  IF (cnt < Digits) AND (St=0) THEN BEGIN
     Inc (cnt);
     Result:=Concat (Result,Ch);
  END;
  IF St=Back_Step THEN BEGIN
     Delete (Result,Length (Result),1);
     IF cnt > 0 THEN Dec (cnt);
  END;
UNTIL (St=Esc) OR (St=Return) OR
      (St=Crs_Left) OR (St=Crs_Right) OR (St=Crs_Up) OR (St=Crs_Down);

IF St = Return THEN V:=Result;
Status:=St;

Wr_String (X,Y,BkCol,Digits,V);

END; (* Rd_String *)

(*-------------------------------------------------------------------------*)
(******** Rd_Int: liest eine Integervariable im Graphikmodus ein ***********)
(*-------------------------------------------------------------------------*)
(* Eingabeparameter: X, Y   : Start des Balkens fuer Eingabe               *)
(*                   BarCol : Hintergrundfarbe fuer Integereingabe         *)
(*                   MinV   : min. zul. Wert d. Var. d. eingeg. werden soll*)
(*                   MaxV   : max. zul. Wert d. Var. d. eingeg. werden soll*)
(* Ausgabeparameter: Status : gibt einen Returncode ob eine gueltige Ein-  *)
(*                            gabe oder eine 'Sondertaste' gedrueckt wurde *)
(*                   V      : Integervariable die eingelesen werden soll   *)
(*-------------------------------------------------------------------------*)
PROCEDURE Rd_Int;
VAR BkCol : WORD;
    Result: STRING;
    Code  : INTEGER;
    TestV : REAL;

BEGIN
Result:=''; Code:=0; TestV:=0.0;
BkCol:=GetBkColor;

Rd_String (X,Y,BarCol,6,Number,Status,Result);

IF Status = Return THEN BEGIN
   Val (Result, TestV, Code);
   IF TestV < MinV THEN Status:=To_Less;
   IF TestV > MaxV THEN Status:=To_Big;
   IF Status = Return THEN Val (Result, V, Code);
END;

Wr_Int (X,Y,BkCol,V);

END; (* Rd_Int *)

(*-------------------------------------------------------------------------*)
(**** Rd_Long: liest eine Variable des Typs LONGINT im Graphikmodus ein ****)
(*-------------------------------------------------------------------------*)
(* Eingabeparameter: X, Y   : Start des Balkens fuer Eigabe                *)
(*                   BarCol : Hintergrundfarbe fuer LongInteingabe         *)
(*                   MinV   : min. zul. Wert d. Var. d. eingeg. werden soll*)
(*                   MaxV   : max. zul. Wert d. Var. d. eingeg. werden soll*)
(* Ausgabeparameter: Status : gibt einen Returncode ob eine gueltige Ein-  *)
(*                            gabe oder eine 'Sondertaste' gedrueckt wurde *)
(*                   V      : 'Long'Integervar. die eingelesen werden soll *)
(*-------------------------------------------------------------------------*)
PROCEDURE Rd_Long;
VAR BkCol : WORD;
    Result: STRING;
    Code  : INTEGER;
    TestV : REAL;

BEGIN
Result:=''; Code:=0; TestV:=0.0;
BkCol:=GetBkColor;

Rd_String (X,Y,BarCol,11,Number,Status,Result);

IF Status = Return THEN BEGIN
   Val (Result, TestV, Code);
   IF TestV < MinV THEN Status:=To_Less;
   IF TestV > MaxV THEN Status:=To_Big;
   IF Status = Return THEN Val (Result, V, Code);
END;

Wr_Long (X,Y,BkCol,V);

END; (* Rd_Long *)

(*-------------------------------------------------------------------------*)
(****** Rd_Word: liest eine Variable des Typs WORD im Graphikmodus ein *****)
(*-------------------------------------------------------------------------*)
(* Eingabeparameter: X, Y   : Start des Balkens fuer Einageb               *)
(*                   BarCol : Hintergrundfarbe fuer Wordeingabe            *)
(*                   MinV   : min. zul. Wert d. Var. d. eingeg. werden soll*)
(*                   MaxV   : max. zul. Wert d. Var. d. eingeg. werden soll*)
(* Ausgabeparameter: Status : gibt einen Returncode ob eine gueltige Ein-  *)
(*                            gabe oder eine 'Sondertaste' gedrueckt wurde *)
(*                   V      : Var. des Typs WORD die eingelesen werden soll*)
(*-------------------------------------------------------------------------*)
PROCEDURE Rd_Word;
VAR BkCol : WORD;
    Result: STRING;
    Code  : INTEGER;
    TestV : REAL;

BEGIN
Result:=''; Code:=0; TestV:=0.0;
BkCol:=GetBkColor;

Rd_String (X,Y,BarCol,5,Number,Status,Result);

IF Status = Return THEN BEGIN
   Val (Result, TestV, Code);
   IF TestV < MinV THEN Status:=To_Less;
   IF TestV > MaxV THEN Status:=To_Big;
   IF Status = Return THEN Val (Result, V, Code);
END;

Wr_Word (X,Y,BkCol,V);

END; (* Rd_Word *)

(*-------------------------------------------------------------------------*)
(** Rd_Floati: liest eine Variable des Typs REAL im Flieszkommaformat ein **)
(*-------------------------------------------------------------------------*)
(* Eingabeparameter: X, Y   : Start des Balkens fuer Eingabe               *)
(*                   BarCol : Hintergrundfarbe fuer Realausgabe            *)
(*                   Digits : gibt die Laenge der einzulesenden Variable an*)
(*                   MinV   : min. zul. Wert d. Var. d. eingeg. werden soll*)
(*                   MaxV   : max. zul. Wert d. Var. d. eingeg. werden soll*)
(* Ausgabeparameter: Status : gibt einen Returncode ob eine gueltige Eing- *)
(*                            gabe  oder eine 'Sondertaste' gedrueckt wurde*)
(*                   V      : Var. des Typs REAL die eingelesen werden soll*)
(*-------------------------------------------------------------------------*)
PROCEDURE Rd_Floati;
VAR OK                      : BOOLEAN;
    cnt, PtPos, l, EPos     : BYTE;
    BkCol                   : WORD;
    Code, d, Pot, p1        : INTEGER;
    Vk_Teil, Nk_Teil, TestV : REAL;
    s, Vz                   : STRING [1];
    Result, Mantisse, Potenz: STRING;

BEGIN
OK:=TRUE;
s:=''; Vz:=''; Result:=''; Mantisse:=''; Potenz:='';
cnt:=0; PtPos:=0; l:=0; EPos:=0; Code:=0; d:=0; Pot:=0; p1:=0;
Vk_Teil:=0.0; Nk_Teil:=0.0; TestV:=0.0;
BkCol:=GetBkColor;

Rd_String (X,Y,BarCol,Digits,Number,Status,Result);

s:=Copy (Result,1,1);
IF (s='+') OR (s='-') THEN BEGIN
   Delete (Result,1,1);
   Vz:=s;
END;

IF Status = Return THEN BEGIN
   PtPos:=Pos ('.',Result);
   EPos:=Pos ('E',Result);
   l:=Length (Result);
   IF EPos=0 THEN EPos:=l+1;
   Mantisse:=Copy (Result,1,EPos-1);
   Potenz:=Copy (Result,EPos+1,l-EPos);
   VAL (Potenz, p1, Code);

   l:=Length (Mantisse);
   IF PtPos=0 THEN PtPos:=l+1;
   Pot:=PtPos-2+p1;
   cnt:=0;

   IF (PtPos>1) AND OK THEN BEGIN
      REPEAT
        Inc (cnt);
        s:=Copy (Mantisse, cnt, 1);
        Val (s, d, Code);
        IF (Code <> 0) THEN OK:=FALSE;
        Vk_Teil:=Vk_Teil+d*EXP(Pot*Ln(10));
        Dec (Pot);
      UNTIL (cnt >= (PtPos-1)) OR NOT OK;
   END;
   IF OK AND (PtPos < l) THEN BEGIN
      cnt:=PtPos;
      REPEAT
        Inc (cnt);
        s:=Copy (Mantisse, cnt, 1);
        Val (s, d, Code);
        IF (Code <> 0) THEN OK:=FALSE;
        Nk_Teil:=Nk_Teil+d*EXP(Pot*Ln(10));
        Dec (Pot);
      UNTIL (cnt = l) OR NOT OK;
   END;

   IF OK THEN BEGIN
      TestV:=Vk_Teil+Nk_Teil;
      IF Vz='-' THEN TestV:=TestV*(-1);
      IF TestV < MinV THEN Status:=To_Less
      ELSE IF TestV > MaxV THEN Status:=To_Big
      ELSE V:=TestV
      END
   ELSE TestV:=V;
END; (* IF Status = Return *)

Wr_Floati (X, Y, BkCol, Digits, V);

END; (* PROC Rd_Floati *)

(*-------------------------------------------------------------------------*)
(***** Rd_Fix: liest eine Variable des Typs REAL im Fixkommaformat ein *****)
(*-------------------------------------------------------------------------*)
(* Eingabeparameter: X, Y   : Start des Balkens fuer Eingabe               *)
(*                   BarCol : Hintergrundfarbe fuer Realausgabe            *)
(*                   Digits : gibt die Laenge der einzulesenden Variable an*)
(*                   MinV   : min. zul. Wert d. Var. d. eingeg. werden soll*)
(*                   MaxV   : max. zul. Wert d. Var. d. eingeg. werden soll*)
(* Ausgabeparameter: Status : gibt einen Returncode ob eine gueltige Ein-  *)
(*                            gabe oder eine 'Sondertaste' gedrueckt wurde *)
(*                   V      : Var. des Typs REAL die eingelesen werden soll*)
(*-------------------------------------------------------------------------*)
PROCEDURE Rd_Fix;
VAR OK                     : BOOLEAN;
    cnt, PtPos, l          : BYTE;
    BkCol                  : WORD;
    Code, d, Pot           : INTEGER;
    Vk_Teil, Nk_Teil, TestV: REAL;
    s, Vz                  : STRING [1];
    Result                 : STRING;

BEGIN
OK:=TRUE;
s:=''; Vz:=''; Result:='';
cnt:=0; PtPos:=0; l:=0; Code:=0; d:=0; Pot:=0;
Vk_Teil:=0.0; Nk_Teil:=0.0; TestV:=0.0;
BkCol:=GetBkColor;

Rd_String (X,Y,BarCol,Digits,Number,Status,Result);

s:=Copy (Result,1,1);
IF (s='+') OR (s='-') THEN BEGIN
   Delete (Result,1,1);
   Vz:=s;
END;

IF Status = Return THEN BEGIN
   PtPos:=Pos ('.',Result);
   l:=Length (Result);
   IF PtPos=0 THEN PtPos:=l+1;
   Pot:=PtPos-2;
   cnt:=0;

   IF PtPos > 1 THEN BEGIN
      REPEAT
        Inc (cnt);
        s:=Copy (Result, cnt, 1);
        Val (s, d, Code);
        IF Code <> 0 THEN OK:=FALSE;
        Vk_Teil:=Vk_Teil+d*EXP(Pot*Ln(10));
        Dec (Pot);
      UNTIL (cnt = (PtPos-1)) OR NOT OK;
   END;

   IF OK AND (PtPos < l) THEN BEGIN
      cnt:=PtPos;
      REPEAT
        Inc (cnt);
        s:=Copy (Result, cnt, 1);
        Val (s, d, Code);
        IF Code <> 0 THEN OK:=FALSE;
        Nk_Teil:=Nk_Teil+d*EXP(Pot*Ln(10));
        Dec (Pot);
      UNTIL (cnt = l) OR NOT OK;
   END;

   IF OK THEN BEGIN
      TestV:=Vk_Teil+Nk_Teil;
      IF Vz='-' THEN TestV:=TestV*(-1);
      IF TestV < MinV THEN Status:=To_Less
      ELSE IF TestV > MaxV THEN Status:=To_Big
      ELSE V:=TestV
      END
   ELSE TestV:=V;
END; (* IF St = Return *)

Wr_Fix (X, Y, BkCol, Digits, V);

END; (* PROC Rd_Fix *)

END. (* UNIT Graph_IO *)