PROGRAM griotest;
USES CRT, GRAPH, GRAPH_IO;

VAR x, dx, dy                     : WORD;
    GraphDriver, GraphMode, Result: INTEGER;

    TestStatus: BYTE;
    TestInt   : INTEGER;
    TestLong  : LONGINT;
    TestWord  : WORD;
    TestReal  : REAL;
    TestStr   : STRING;

(*************************************************************************)
(************************** Beginn der Test-Routine **********************)
(*************************************************************************)

BEGIN
(*-------------------- Initialisierung des Graphiktreibers --------------*)
GraphDriver:=Detect;
DetectGraph (GraphDriver, GraphMode);
IF (GraphDriver = CGA) THEN GraphMode:=CGAHi;
InitGraph (GraphDriver, GraphMode, '');
IF GraphResult<>0 THEN HALT;

(*----- Ermitteln der max. Anzahl Pixel fr 25*80 Format pro Zeichen ----*)
dx:=((GetmaxX+1) DIV 80);
IF GetMaxY<=200 THEN dy:=8
ELSE dy:=14;

(*- Wenn andere Grafikkarte als CGA, dann zeichne ein Netz (80+1)*(25+1) *)
IF (GraphDriver <> CGA) THEN BEGIN
  SetColor (Cyan);
  SetLineStyle (1,1,1);
  FOR x:=1 TO 25 DO Line (0,x*dy,GetMaxX,x*dy);
  Rectangle (0,0,GetMaxX,GetMaxY);
  SetLineStyle (0,1,1);
  FOR X:=1 TO 80 DO Line (x*dx,0,x*dx,GetMaxY);
END;

(*------------------- Initialisierung der TestVariablen -----------------*)
IF GraphDriver = CGA THEN SetColor (White)
ELSE SetColor (Magenta);
TestReal:=0.0;
TestInt:=27;
TestLong:=07;
TestWord:=1988;
TestStr:='e.huber';

(*------------------------ Titelzeile ausgeben --------------------------*)
SetTextStyle (SansSerifFont, HorizDir, 2);
Wr_String (dx,dy,Black,45,'Graph-IO Test-Routine    (c) Juli 88 e. huber');

(*------------ 30 Kreise schraeg versetzt ('Rohr') ausgeben -------------*)
SetTextStyle (DefaultFont, HorizDir, 1);
IF GraphDriver = CGA THEN SetColor (White)
ELSE SetColor (Yellow);
FOR X:=1 TO 30 DO Circle (12*dx+X, 14*dy+X, 40);

(*------------ 15 Rechtecke schrgversetzt ('Tunnel') ausgeben ----------*)
IF GraphDriver = CGA THEN SetColor (White)
ELSE SetColor (LightGreen);
FOR X:=1 TO 30 DO BEGIN
    IF ODD (X) THEN Rectangle (37*dx+X,14*dy+X,62*dx+X,21*dy+X);
END;

(*------------------------ Blue Box ausgeben ----------------------------*)
IF GraphDriver = CGA THEN SetColor (White)
ELSE SetColor (LightBlue);
Bar3D (12*dx,12*dy,62*dx,9*dy,50,TRUE);

(*-------------------- Pseudo Pacman tritt in Aktion --------------------*)
FOR X:=1 TO 10 DO BEGIN
    IF ODD (X) THEN BEGIN
       IF GraphDriver = CGA THEN SetColor (White)
       ELSE SetColor (Red);
       PieSlice (12*dx+x*dx,5*dy,30,330,40);
       Delay (100);
       PieSlice (12*dx+x*dx,5*dy,15,345,40);
       Delay (100);
       PieSlice (12*dx+x*dx,5*dy,5,355,40);
       Delay (100);
       Sound (50);
       PieSlice (12*dx+x*dx,5*dy,0,361,40);
       Delay (100);
       NoSound;
       Wr_String (12*dx+x*dx+8,5*dy,Black,13,'Was soll das?')
    END;
END;

(* Das Programm erreicht seinen Hhepunkt - die Read/Write Demo beginnt -*)
IF GraphDriver = CGA THEN SetColor (White)
ELSE SetColor (Cyan);

(*-------------- Abschnitt fuer Integerzahl einlesen --------------------*)
Wr_String (dx,4*dy,White,15,'INTEGER-Eingabe');
Rd_Int (18*dx,4*dy,Yellow,Min_I,Max_I,TestStatus,TestInt);
Wr_String (31*dx,4*dy,White,15,'INTEGER-Ausgabe');
Wr_Int (50*dx,4*dy,Yellow,TestInt);
Wr_String (64*dx,4*dy,White,6,'Status');
Wr_Int (73*dx,4*dy,Red,TestStatus);

(*-------------- Abschnitt fuer LongIntzahl einlesen --------------------*)
Wr_String (dx,5*dy,White,15,'LONGINT-Eingabe');
Rd_Long (18*dx,5*dy,Yellow,Min_LI,Max_LI,TestStatus,TestLong);
Wr_String (31*dx,5*dy,White,15,'LONGINT-Ausgabe');
Wr_Long (50*dx,5*dy,Yellow,TestLong);
Wr_String (64*dx,5*dy,White,6,'Status');
Wr_Int (73*dx,5*dy,Red,TestStatus);

(*----------------- Abschnitt fuer Wordzahl einlesen --------------------*)
Wr_String (dx,6*dy,White,15,'WORD-Eingabe   ');
Rd_Word (18*dx,6*dy,Yellow,Min_W,Max_W,TestStatus,TestWord);
Wr_String (31*dx,6*dy,White,15,'WORD-Ausgabe   ');
Wr_Word (50*dx,6*dy,Yellow,TestWord);
Wr_String (64*dx,6*dy,White,6,'Status');
Wr_Int (73*dx,6*dy,Red,TestStatus);

(*--------- Abschnitt fuer Realzahl im Fixkommaformat einlesen ----------*)
Wr_String (dx,7*dy,White,15,'Fixkom.-Eingabe');
Rd_Fix (18*dx,7*dy,Yellow,7,Min_R,Max_R,TestStatus,TestReal);
Wr_String (31*dx,7*dy,White,15,'Fixkom.-Ausgabe');
Wr_Fix (50*dx,7*dy,Yellow,10,TestReal);
Wr_String (64*dx,7*dy,White,6,'Status');
Wr_Int (73*dx,7*dy,Red,TestStatus);

(*-------- Abschnitt fuer Realzahl im Flieszkommaformat einlesen --------*)
Wr_String (dx,8*dy,White,15,'Float.-Eingabe ');
Rd_Floati (18*dx,8*dy,Yellow,7,Min_R,Max_R,TestStatus,TestReal);
Wr_String (31*dx,8*dy,White,15,'Float.-Ausgabe ');
Wr_Floati (50*dx,8*dy,Yellow,10,TestReal);
Wr_String (64*dx,8*dy,White,6,'Status');
Wr_Int (73*dx,8*dy,Red,TestStatus);

(*------------------- Abschnitt fuer String einlesen --------------------*)
Wr_String (dx,9*dy,White,15,'STRING-Eingabe ');
Rd_String (18*dx,9*dy,Yellow,7,Character,TestStatus,TestStr);
Wr_String (31*dx,9*dy,White,15,'STRING-Ausgabe ');
Wr_String (50*dx,9*dy,Yellow,7,TestStr);
Wr_String (64*dx,9*dy,White,6,'Status');
Wr_Int (73*dx,9*dy,Red,TestStatus);

(*------------------- letzte Grafikausgaben -----------------------------*)
SetTextStyle (TriplexFont, HorizDir,2);
SetColor (White);
Wr_String (6*dx,18*dy,Green,36,'Klar, was gemischte Text-Ein/Ausgabe');
SetColor (Magenta);
Wr_String (12*dx,21*dy,LightGreen,22,'im Grafikmodus ist ?!!');
SetTextStyle (SmallFont, HorizDir, 4);
TestStr:='P.S.: Das Unterlaengen tw. zu lang sind, habe ich auch gesehen!';
Wr_String (dx,24*dy,Black,62,TestStr);
TestStr:='Soll sich doch wer anderer spielen!';
Wr_String (50*dx,24*dy,Black,34,TestStr);

REPEAT UNTIL KeyPressed;
CloseGraph;
END. (* PROGRAM GRIOTEST *)