(*--------------------------------------------------------------------------*)
(***** UNIT List_Man: Verwaltung beliebieger doppelt verketteter Listen *****)
(***** (c) Juli/August 1988 by eh                           Ernst Huber *****)
(*--------------------------------------------------------------------------*)
UNIT List_Man;
INTERFACE
USES DOS;

(*--------------------------------------------------------------------------*)
(********* oeffentliche Konstantendefinitionen der UNIT List_Man ************)
(*--------------------------------------------------------------------------*)
CONST MaxList = 101;

(*--------------------------------------------------------------------------*)
(************* oeffentliche Typdefinitionen der UNIT List_Man ***************)
(*--------------------------------------------------------------------------*)
TYPE STR08 = STRING [8];
     STR12 = STRING [12];

     List = ^ListElement;
     ListElement = RECORD
       Next, Prev: List;
       DataPtr   : POINTER;
     END; (* RECORD ListElement *)

     ListenName = RECORD
       LName: STR08;
       FPtr, LPtr, Cur      : List;
       FNo, LNo, CurNo, ObjS: WORD;
     END; (* RECORD ListenName *)

(*--------------------------------------------------------------------------*)
(************ oeffentliche Variablendefinitionen der UNIT List_Man **********)
(*--------------------------------------------------------------------------*)
VAR CurrentNo, LastNo, FirstNo, ObjectSize, IORes: WORD;
    NotExist                                     : BOOLEAN;
    SysPtr                                       : POINTER;
    Current                                      : List;
    ActiveListNo, TopOfList                      : BYTE;

(*--------------------------------------------------------------------------*)
(********** oeffentliche Proceduredefinitionen fuer Unit List_Man ***********)
(*--------------------------------------------------------------------------*)
PROCEDURE SetFirstNode;                (* Setzt erstes Listenel als akt.El. *)
PROCEDURE SetLastNode;                 (* Setzt letztes Listenel als akt.El.*)
FUNCTION Next: List;                   (* lft Pointer auf das naechste El.  *)
FUNCTION Prev: List;                   (* lft Pointer auf das vorige El     *)
FUNCTION ListSize: LONGINT;            (* lft Listengroesze in Bytes        *)
FUNCTION DataSize: LONGINT;            (* lft Bytes gebraucht fuer Daten    *)
FUNCTION ListName: STR08;              (* lft Listennamen                   *)
PROCEDURE SetActiveList (Name: STR08); (* Setzt ein Liste auf aktiv         *)
PROCEDURE ML (VAR Data; Name: STR08);  (* Legt eine Liste an                *)
PROCEDURE KillMem;                     (* Loescht komplette Liste           *)
PROCEDURE LPut (VAR Data);             (* fuegt ein El. a.d. Listenende     *)
PROCEDURE FPut (VAR Data);             (* fuegt ein El. a.d. Listenanf.     *)
PROCEDURE InsCur (VAR Data);           (* Efg eines El nach akt. Position   *)
PROCEDURE DelCur;                      (* loescht El. an akt. Position      *)
PROCEDURE GetNext (VAR Data);          (* gibt das naechst El. zurueck      *)
PROCEDURE GetPrev (VAR Data);          (* gibt das vorherg. El. zurueck     *)
PROCEDURE GetData (VAR Data);          (* gibt das akt El. zurueck          *)
PROCEDURE PutData (VAR Data);          (* berschreibt den akt. Datensatz   *)
PROCEDURE SeekNo (No: WORD);           (* Sucht das Listenel. mit No        *)
PROCEDURE SaveList (VAR Buf; FileName: STR12); (* Speichern auf akt. Disk   *)
PROCEDURE LoadList (VAR Buf; FileName: STR12; ListName: STR08); (* Laden    *)
PROCEDURE KillDisk (FileName: STR12);  (* Loescht bel. File von akt. Lw     *)

IMPLEMENTATION
(*--------------------------------------------------------------------------*)
(******************** Interne Variablendefinitionen *************************)
(*--------------------------------------------------------------------------*)
VAR FirstPtr, LastPtr: List;
    ListField        : ARRAY [0..MaxList] OF ListenName;

(*--------------------------------------------------------------------------*)
(**************** Beginn der Listenverarbeitenden Routinen ******************)
(*--------------------------------------------------------------------------*)

(*--------------------------------------------------------------------------*)
(* Last: weist Pointer auf das letzte Listenelement zu, setzt CurrentNo neu *)
(*--------------------------------------------------------------------------*)
(* glob. Var (oeffentl): CurrentNo: Nr. des akt. Listenel.                  *)
(*--------------------------------------------------------------------------*)
PROCEDURE SetLastNode;
BEGIN
  IF NOT (NotExist) THEN BEGIN
     Current:=LastPtr;
     CurrentNo:=LastNo;
  END; (* IF *)
END; (* PROC SetLastNode *)

(*--------------------------------------------------------------------------*)
(* First: weist Pointer auf das erste Listenelement zu, setzt CurrentNo neu *)
(*--------------------------------------------------------------------------*)
(* glob. Var (oeffentl): CurrentNo: Nr. des akt. Listenel.                  *)
(*--------------------------------------------------------------------------*)
PROCEDURE SetFirstNode;
BEGIN
  IF NOT (NotExist) THEN BEGIN
     Current:=FirstPtr;
     CurrentNo:=FirstNo;
  END; (* IF *)
END; (* PROC SetFirstNode *)

(*--------------------------------------------------------------------------*)
(* Next: gibt den Pointer auf das naechste Listenelement zurueck            *)
(*--------------------------------------------------------------------------*)
FUNCTION Next: List;
BEGIN
  IF NOT (NotExist) THEN Next:=Current^.Next;
END; (* FUNC Next *)

(*--------------------------------------------------------------------------*)
(* Prev: gibt den Pointer auf das vorhergehende Listenelement zurueck       *)
(*--------------------------------------------------------------------------*)
FUNCTION Prev: List;
BEGIN
  IF NOT (NotExist) THEN Prev:=Current^.Prev;
END; (* FUNC Prev *)

(*--------------------------------------------------------------------------*)
(* ListSize: liefert den Speicherplatzbedarf einer gesamten Liste in Bytes  *)
(*--------------------------------------------------------------------------*)
FUNCTION ListSize: LONGINT;
BEGIN
  IF NOT (NotExist) THEN ListSize:=(12+ObjectSize)*LastNo;
END;

(*--------------------------------------------------------------------------*)
(* DataSize: liefert den effektiven Speicherplatzbedarf der von den Daten   *)
(*           benoetigt wird;                                                *)
(*--------------------------------------------------------------------------*)
FUNCTION DataSize: LONGINT;            (* lft Bytes gebraucht fuer Daten *)
BEGIN
  IF NOT (NotExist) THEN DataSize:=ObjectSize*LastNo;
END;

(*--------------------------------------------------------------------------*)
(* ListName: liefert den Namen der gerade aktiven Liste                     *)
(*--------------------------------------------------------------------------*)
FUNCTION ListName: STR08;              (* lft Listennamen *)
BEGIN
  IF NOT (NotExist) THEN ListName:=ListField [ActiveListNo].LName;
END;

(*--------------------------------------------------------------------------*)
(* SetActiveList: Aktiviert die Liste mit ang. Namen, all Op. beziehen sich *)
(*                auf diese Liste                                           *)
(*--------------------------------------------------------------------------*)
(* Eingabeparameter: Name : gibt den Namen der neuen List an                *)
(* glob. Var (oeffentl): Current  : Pointer auf das aktuelle Listenel.      *)
(*                       FirstNo  : Nr. des ersten Listenel.                *)
(*                       LastNo   : Nr. des letzten Listenel.               *)
(*                       CurrentNo: Nr. des akt. Listenel.                  *)
(*                       NotExist : TRUE wenn Liste mit ang. Namen nicht ex.*)
(*                       ObjectSize: gibt d. Groesze d. akt. Var. in Byte an*)
(*                       ActiveListNo: Nr. der gerade akt. Liste.           *)
(* glob. Var (intern): FirstPtr    : Pointer auf das erste Listenel.        *)
(*                     LastPtr     :  Pointer auf das letzte Listenel.      *)
(*--------------------------------------------------------------------------*)
PROCEDURE SetActiveList (Name: STR08);
VAR x : BYTE;

BEGIN
  NotExist:= TRUE; x:=0;
  WITH ListField [ActiveListNo] DO BEGIN
       FPtr:=FirstPtr; FNo:=FirstNo;
       LPtr:=LastPtr;  LNo:=LastNo;
       Cur:=Current;   CurNo:=CurrentNo;
  END; (* WITH *)
  WHILE ((x < MaxList) AND (ListField [x].LName <> Name)) DO Inc (x);
  IF (x < MaxList) THEN BEGIN
     WITH ListField [x] DO BEGIN
          FirstPtr:=FPtr; FirstNo:=Fno;
          LastPtr:=LPtr;  LastNo:=LNo;
          Current:=Cur;   CurrentNo:=CurNo;
                          ObjectSize:=ObjS;
     END; (* WITH *)
     ActiveListNo:=x;
     NotExist:=FALSE;
  END; (* WITH *)
END; (* PROC SetActiveList *)

(*--------------------------------------------------------------------------*)
(**** ML: (Make List) gen. eine neue einel. Liste, mit XPut erweiterbar *****)
(*--------------------------------------------------------------------------*)
(* Eingabeparameter: Data : Datenteil des ersten Listenel.                  *)
(*                   Name : gibt den Namen der neuen List an                *)
(* glob. Var (oeffentl): Current  : Pointer auf das aktuelle Listenel.      *)
(*                       FirstNo  : Nr. des ersten Listenel.                *)
(*                       LastNo   : Nr. des letzten Listenel.               *)
(*                       CurrentNo: Nr. des akt. Listenel.                  *)
(*                       ObjectSize: gibt d. Groesze d. akt. Var. in Byte an*)
(*                       ActiveListNo: Nr. der gerade akt. Liste.           *)
(* glob. Var (intern): FirstPtr    : Pointer auf das erste Listenel.        *)
(*                     LastPtr     :  Pointer auf das letzte Listenel.      *)
(*--------------------------------------------------------------------------*)
PROCEDURE ML (VAR Data; Name: STR08);
VAR p: List;

BEGIN
WITH ListField [ActiveListNo] DO BEGIN
     FPtr:=FirstPtr; FNo:=FirstNo;
     LPtr:=LastPtr;  LNo:=LastNo;
     Cur:=Current;   CurNo:=CurrentNo;
END; (* WITH *)
IF (TopOfList < (MaxList-1)) THEN BEGIN
   Inc (TopOfList);
   New (p);
   FirstPtr:=p;
   LastPtr:=p;
   Current:=p;
   GetMem (Current^.DataPtr, ObjectSize);
   Move (Data, Current^.DataPtr^, ObjectSize);
   p^.Prev:=NIL;
   p^.Next:=NIL;
   CurrentNo:=1;
   FirstNo:=1;
   LastNo:=1;
   WITH ListField [TopOfList] DO BEGIN
        LName:=Name;
        FPtr:=FirstPtr; FNo:=FirstNo;
        LPtr:=LastPtr;  LNo:=LastNo;
        Cur:=Current;   CurNo:=CurrentNo;
                        ObjS:=ObjectSize;
   END; (* WITH *)
   ActiveListNo:=TopOfList;
END; (* IF *)
SetActiveList (Name);
END; (* PROC MakeList *)

(*--------------------------------------------------------------------------*)
(* KillMem: Loescht eine kompl. Liste aus dem Speicher (auch aus Liststack) *)
(*--------------------------------------------------------------------------*)
(* glob. Var (oeffentl): Current  : Pointer auf das aktuelle Listenel.      *)
(*                       FirstNo  : Nr. des ersten Listenel.                *)
(*                       LastNo   : Nr. des letzten Listenel.               *)
(*                       CurrentNo: Nr. des akt. Listenel.                  *)
(*                       ObjectSize: gibt d. Groesze d. akt. Var. in Byte an*)
(*                       ActiveListNo: Nr. der gerade akt. Liste.           *)
(* glob. Var (intern): FirstPtr    : Pointer auf das erste Listenel.        *)
(*                     LastPtr     :  Pointer auf das letzte Listenel.      *)
(*--------------------------------------------------------------------------*)
PROCEDURE KillMem;
VAR p: List;
    x: BYTE;

BEGIN
IF NOT (NotExist) THEN BEGIN
  Current:=FirstPtr;
  REPEAT
    p:=Current^.Next;
    FreeMem (Current^.DataPtr, ObjectSize);
    Dispose (Current);
    Current:=p;
  UNTIL p=NIL;
  FirstNo:=0; LastNo:=0; CurrentNo:=0;
  FirstPtr:=NIL; LastPtr:=NIL; Current:=NIL;
  FOR x:=ActiveListNo TO (TopOfList+1) DO BEGIN
      ListField [x]:=ListField [x+1];
  END;
  NotExist:=TRUE;
  ActiveListNo:=0;
  Dec (TopOfList);
  ObjectSize:=0;
END;
END; (* PROC KillMem *)

(*--------------------------------------------------------------------------*)
(****** LPut: fuegt ein Element an das Listenende an (nicht mit InsXXX) *****)
(*--------------------------------------------------------------------------*)
(* Eingabeparameter: Data : Datenteil des letzten Listenel.                 *)
(* glob. Var (oeffentl): LastNo   : Nr. des letzten Listenel.               *)
(* glob. Var (intern): LastPtr    : Pointer auf das letzte Listenel.        *)
(*--------------------------------------------------------------------------*)
PROCEDURE LPut (VAR Data);
VAR p: List;

BEGIN
  IF NOT(NotExist) THEN BEGIN
     New (p);
     GetMem (p^.DataPtr, ObjectSize);
     Move (Data, p^.DataPtr^, ObjectSize);
     p^.Next:=NIL;
     p^.Prev:=LastPtr;
     LastPtr^.Next:=p;
     LastPtr:=p;
     Inc (LastNo);
  END; (* IF *)
END; (* PROC LPut *)

(*--------------------------------------------------------------------------*)
(***** FPut: fuegt ein Element an den Listenanfang an (nicht mit InsXXX) ****)
(*--------------------------------------------------------------------------*)
(* Eingabeparameter: Data : Datenteil des neuen ersten Listenel.            *)
(* glob. Var (oeffentl): CurrentNo: Nummer das aktuelle Listenel.           *)
(*                       FirstNo  : Nr. des ersten Listenel.                *)
(* glob. Var (intern): FirstPtr   : Pointer auf das erste Listenel.         *)
(*--------------------------------------------------------------------------*)
PROCEDURE FPut (VAR Data);
VAR p: List;

BEGIN
  IF Not(NotExist) THEN BEGIN
     New (p);
     GetMem (p^.DataPtr, ObjectSize);
     Move (Data, p^.DataPtr^, ObjectSize);
     p^.Next:=FirstPtr;
     p^.Prev:=NIL;
     FirstPtr^.Prev:=p;
     FirstPtr:=p;
     Inc (CurrentNo);
     Inc (LastNo);
  END;
END; (* PROC FPut *)

(*--------------------------------------------------------------------------*)
(* InsCur: Efg eines El. nach der augenblickl. Pos. der glob. Var. Current  *)
(*         Bedingung: Current darf nicht auf das letzte El. zeigen (LPut)   *)
(*--------------------------------------------------------------------------*)
(* Eingabeparameter: Data : Datenteil des einzufuegenden El.                *)
(* glob. Var (oeffentl): Current  : Pointer auf das aktuelle Listenel.      *)
(*                       LastNo   : Nr. des letzten Listenel.               *)
(*                       CurrentNo: Nr. des akt. Listenel.                  *)
(*--------------------------------------------------------------------------*)
PROCEDURE InsCur (VAR Data);
VAR p1, p2: List;

BEGIN
  IF NOT (NotExist) THEN BEGIN
     IF (Current <> NIL) AND (Current <> LastPtr) THEN BEGIN
        New (p1);
        p2:=Current^.Next;
        GetMem (p1^.DataPtr, ObjectSize);
        Move (Data, p1^.DataPtr^, ObjectSize);
        p1^.Next:=p2;
        p1^.Prev:=Current;
        Current^.Next:=p1;
        p2^.Prev:=p1;
        Current:=p1;
        Inc (LastNo);
        Inc (CurrentNo);
     END; (* IF *)
  END; (*  IF *)
END; (* PROC InsCur*)

(*--------------------------------------------------------------------------*)
(*DelCur: loescht d. El. auf d. d. glob. Zeiger Current augenblicklich zeigt*)
(*--------------------------------------------------------------------------*)
(* glob. Var (oeffentl): Current  : Pointer auf das aktuelle Listenel.      *)
(*                       LastNo   : Nr. des letzten Listenel.               *)
(*                       CurrentNo: Nr. des akt. Listenel.                  *)
(*--------------------------------------------------------------------------*)
PROCEDURE DelCur;
VAR p1, p2, p3: List;

BEGIN
  IF NOT (NotExist) THEN BEGIN
     IF Current <> NIL THEN BEGIN
        p1:=Current;
        Dec (LastNo);
        IF (FirstPtr = LastPtr) THEN KillMem      (* einelementige Liste *)
        ELSE IF (p1 <> FirstPtr) AND (p1 <> LastPtr) THEN BEGIN
           p3:=p1^.Next;
           p2:=p1^.Prev;
           p2^.Next:=p3;
           p3^.Prev:=p2;
           Current:=p2;
           FreeMem (p1^.DataPtr, ObjectSize); (* auf jeden Fall loeschen *)
           Dispose (p1);
           WriteLn ('->');
        END
        ELSE IF (p1 = FirstPtr) THEN BEGIN
           p3:=p1^.Next;   (* Next existiert, Prev musz NIL sein *)
           p3^.Prev:=NIL;
           FirstPtr:=p3;
           Current:=p3;
           FreeMem (p1^.DataPtr, ObjectSize); (* auf jeden Fall loeschen *)
           Dispose (p1);
           WriteLn ('-->');
        END
        ELSE IF (p1 = LastPtr) THEN BEGIN
           p3:=Current^.Prev;
           p3^.Next:=NIL;
           LastPtr:=p3;
           Current:=p3;
           FreeMem (p1^.DataPtr, ObjectSize); (* auf jeden Fall loeschen *)
           Dispose (p1);
           WriteLn ('--->');
        END; (* IF ELSE IF *)
     END; (* IF Current *)
  END; (* IF NOT NotExist *)
END; (* PROC DelCur*)

(*--------------------------------------------------------------------------*)
(* GetNext: lft das naechste Listenel. als Erg., setzt Ptr. Current darauf  *)
(*--------------------------------------------------------------------------*)
(* Ausgabeparameter: Data : Datenteil des naechsten Listenel.               *)
(* glob. Var (oeffentl): Current  : Pointer wird auf das naechste El.gesetzt*)
(*                       CurrentNo: Nr. des akt. Listenel.                  *)
(*--------------------------------------------------------------------------*)
PROCEDURE GetNext (VAR Data);
BEGIN
  IF NOT (NotExist) AND (Current <> LastPtr) THEN BEGIN
     Current:=Current^.Next;
     Move (Current^.DataPtr^, Data, ObjectSize);
     Inc (CurrentNo);
  END; (* IF *)
END; (* PROC GetNext *)

(*--------------------------------------------------------------------------*)
(* GetPrev: lft das vorherg. Listenel. als Erg., setzt Ptr. Current darauf  *)
(*--------------------------------------------------------------------------*)
(* Ausgabeparameter: Data : Datenteil des vorhergehende Listenel.           *)
(*                   Name : gibt den Namen der neuen List an                *)
(* glob. Var (oeffentl): Current  : Pointer wird auf das vorherg. El.gesetzt*)
(*                       CurrentNo: Nr. des akt. Listenel.                  *)
(*--------------------------------------------------------------------------*)
PROCEDURE GetPrev (VAR Data);
BEGIN
  IF NOT (NotExist) AND (Current <> FirstPtr) THEN BEGIN
     Current:=Current^.Prev;
     Move (Current^.DataPtr^, Data, ObjectSize);
     Dec (CurrentNo);
  END; (* IF *)
END; (* PROC GetPrev *)

(*--------------------------------------------------------------------------*)
(********* GetData: lft den Datenteil des akt. Listenel. als Erg. ***********)
(*--------------------------------------------------------------------------*)
(* Ausgabeparameter: Data : Datenteil des lauf. Listenel.                   *)
(*--------------------------------------------------------------------------*)
PROCEDURE GetData (VAR Data);
BEGIN
  IF NOT (NotExist) THEN Move (Current^.DataPtr^, Data, ObjectSize);
END; (* PROC GetData *)

(*--------------------------------------------------------------------------*)
(************* PutData: berschreibt den aktuellen Datensatz ****************)
(*--------------------------------------------------------------------------*)
(* Eingabeparameter: Data : Datenteil des lauf. Listenel.                   *)
(*--------------------------------------------------------------------------*)
PROCEDURE PutData (VAR Data);
BEGIN
  IF NOT (NotExist) THEN Move (Data, Current^.DataPtr^, ObjectSize);
END; (* PROC PutData *)

(*--------------------------------------------------------------------------*)
(************** SeekNo: Sucht das Element mit der angeg. Nummer *************)
(*--------------------------------------------------------------------------*)
(* Eingabeparameter: No: Nummer des Elementes                               *)
(* Ausgabeparameter: Data: Datenteil des gefundenen El.                     *)
(* glob. Var (oeffentl): Current  : Pointer auf das aktuelle Listenel.      *)
(*                       CurrentNo: Nr. des akt. Listenel.                  *)
(*--------------------------------------------------------------------------*)
PROCEDURE SeekNo (No: WORD);
VAR Delta1, Delta2, Delta3: WORD;
    Backward              : BOOLEAN;

BEGIN
IF ((No >= FirstNo) AND (No <= LastNo)) THEN BEGIN
  IF NOT (NotExist) THEN BEGIN
     Delta1:=No;
     Delta2:=LastNo-No;
     IF ((No-CurrentNo) > 0) THEN Delta3:=No-CurrentNo
     ELSE Delta3:=CurrentNo-No;
     IF ((Delta1 <= Delta2) AND (Delta1 <= Delta3)) THEN BEGIN
	Current:=FirstPtr;
        Backward:=FALSE;
     END
     ELSE IF ((Delta2 <= Delta1) AND (Delta2 <= Delta3)) THEN BEGIN
        Current:=LastPtr;
        Backward:=TRUE;
     END
     ELSE IF ((Delta3 <= Delta1) AND (Delta3 <= Delta2)) THEN BEGIN
        IF ((No-CurrentNo) <= 0) THEN Backward:=TRUE
        ELSE Backward:=FALSE;
     END;
     WHILE ((Current <> NIL) AND (CurrentNo <> No)) DO BEGIN
       IF Backward THEN BEGIN
          Current:=Current^.Prev;
          Dec (CurrentNo);
       END
       ELSE BEGIN
          Current:=Current^.Next;
          Inc (CurrentNo);
       END; (* IF *)
     END; (* WHILE *)
  END; (* IF *)
END; (* IF *)
END; (* PROC SeekNo *)

(*--------------------------------------------------------------------------*)
(* SaveList: Speichert die gerade akt. Liste auf dem akt. Lw, eine eventuell*)
(*       vorhandene Liste gleichen Namens wird ueberschrieben.              *)
(*--------------------------------------------------------------------------*)
(* Eingabeparameter: Buf     : Listenvariable aus der aufrufenden Routine   *)
(*                   FileName: Name des Files in der Form 'NAME.EXT'        *)
(* glob. Var (oeffentl): Current  : Pointer auf das aktuelle Listenel.      *)
(*--------------------------------------------------------------------------*)

PROCEDURE SaveList (VAR Buf; FileName: STR12);
VAR ok      : BOOLEAN;
    result  : WORD;
    f       : FILE;

BEGIN
  ok:=FALSE; result:=0;
  IF NOT(NotExist) THEN BEGIN
     ASSIGN (f,FileName);
     {$I-} RESET (f,ObjectSize); {$I+}
     IORes:=IOResult;
     IF (IORes = 0) THEN BEGIN
        CLOSE (f);
        ERASE (f);
     END;
     IF ((IORes >= 0) AND (IORes <= 2)) THEN BEGIN
        IF (DataSize < DiskFree(0)) THEN ok:=TRUE;
     END;
     ok:=TRUE;
     IF ok THEN BEGIN
        REWRITE (f,ObjectSize);
        Current:=FirstPtr;
        REPEAT
          GetData (Buf);
          BlockWrite (f,Buf,1,result);
          Current:=Current^.Next;
        UNTIL (Current = NIL);
        CLOSE (f);
      END;
  END;
END; (* PROC SaveList *)

(*--------------------------------------------------------------------------*)
(* LoadList: Ladet eine Liste von der Diskette u.legt sie neu an (ListStack)*)
(*           ist eine Liste gl. Namens im Hauptspeicher vorhanden, so wird  *)
(*           keine neue Liste geladen (Achtung: ObjectSize initialisieren!).*)
(*--------------------------------------------------------------------------*)
(* Eingabeparameter: Buf     : Listenvariable aus der aufrufenden Routine   *)
(*                   FileName: Name des Files in der Form 'NAME.EXT'        *)
(*                   Listname: Name der Liste die geladen werden soll       *)
(* beeinflussung der glob. Variablen durch die Routinen 'ML' und 'LPut'     *)
(*--------------------------------------------------------------------------*)

PROCEDURE LoadList (VAR Buf; FileName: STR12; ListName: STR08);
VAR ok      : BOOLEAN;
    result  : WORD;
    Size    : LONGINT;
    f       : FILE;

BEGIN
  ok:=FALSE; Size:=0; result:=0;
  SetActiveList (ListName);
  IF NotExist THEN BEGIN
     ASSIGN (f,FileName);
     {$I-} RESET (f,ObjectSize); {$I+}
     IORes:=IOResult;
     IF (IORes=0) THEN BEGIN
        Size:=(12*(FileSize(f))+FileSize(f)*ObjectSize);
        CLOSE (f);
        IF (Size < MemAvail) THEN ok:=TRUE;
     END;
     IF ok THEN BEGIN
        RESET (f,ObjectSize);
        BlockRead (f,Buf,1,result);
        ML (Buf,ListName);
        WHILE NOT(Eof(f)) DO BEGIN
              BlockRead (f,Buf,1,result);
              LPut (Buf);
        END;
        CLOSE (f);
     END;
  END;
END; (* PROC LoadList *)

(*--------------------------------------------------------------------------*)
(* KillDisk: loescht ein bel. File von dem akt. Laufwerk                    *)
(*--------------------------------------------------------------------------*)
(* Eingabeparameter: FileName: Name des Files in der Form 'NAME.EXT'        *)
(*--------------------------------------------------------------------------*)
PROCEDURE KillDisk (FileName: STR12);
VAR f: FILE;
BEGIN
  ASSIGN (f,FileName);
  {$I-} RESET (f,ObjectSize); {$I+}
  IORes:=IOResult;
  IF (IORes = 0) THEN BEGIN
     CLOSE (f);
     ERASE (f);
  END;
END; (* PROC KillDisk *)

(*--------------------------------------------------------------------------*)
(*********************** Variablenintialisierung ****************************)
(*--------------------------------------------------------------------------*)
BEGIN
  FirstNo:=0; LastNo:=0; CurrentNo:=0; IORes:=0;
  FirstPtr:=NIL; LastPtr:=NIL; Current:=NIL;
  ObjectSize:=0;
  FOR ActiveListNo:=0 TO MaxList DO BEGIN
      WITH ListField [ActiveListNo] DO BEGIN
           LName:='';
           FPtr:=NIL;  FNo:=0;
           LPtr:=NIL;  LNo:=0;
           Cur:=NIL;   CurNo:=0;
                       ObjS:=0;
      END; (* WITH *)
  END; (* FOR *)
  ActiveListNo:=0;
  TopOfList:=0;
  Mark (SysPtr);
END. (* UNIT List_Man *)