Program Lingl;               (* Lsen eines linearen Gleichungssystems            *)

(*$I GAUSS.SYS *)            (* Definition der Typen fr Gauss                    *)

Var Koeffmat:      Koeff;    (* Koeffizientenmatrix fr Gauss                     *)
    Rechte:        Spalte;   (* rechte Seite fr Gauss                             *)
    Koeffmat2:     Koeff;    (* original Koeffizientenmatrix fr Defektberechnung *)
    Rechte2:       Spalte;   (* original rechte Seite fr Defektberechnung         *)
    Steuer:        ISpalte;  (* Steuervektor                                      *)
    Dim:           Integer;  (* Dimension des Gleichungssystems                   *)
    X:             Spalte;   (* Ergebnisvektor des Gleichungssystems              *)
    Differenz:     Spalte;   (* Defekt des Gleichungssystems                      *)
    DeltaX:        Spalte;   (* Fehler des Ergebnisvektors                        *)
    OK:            Boolean;  (* Hilfsvariable, ob die letzten Operationen         *)
                             (* ordnungsgem abliefen                            *)
    I:             Integer;  (* Zhlervariable zum allgemeinen Gebrauch           *)
    Dummy:         Char;     (* Dummychar zum Bremsen des Programms               *)

(*$I GAUSS.SBR *)            (* Prozeduren und Funktionen fr Gauss               *)

Procedure Eingabe (Var Matrix: Koeff;Var LSpalte: Spalte; Var Nbr: Integer; Var EingabeOK: Boolean);

(* Procedure zum Einlesen des Gleichungssystemes

   Die Eingabe kann wahlweise von einem Textfile oder der Tastatur erfolgen.

   Das Textfile mu dabei alle Informationene beinhalten, die sonst vom Benutzer
   abgefragt wrden:

   o) Dimension des Gleichungssystems
   o) Koeffizientenmatrix
   o) rechte Seite

   Aufbau des Textfiles:

   Dimension
   a11   a12    b1
   a21   a22    b2                                                           *)

Var Eing_File:     Text;     (* File, von dem gelesen werden kann       *)
    Eing_Filenam:  String (.11.);
                             (* Name des Eingabefiles                   *)
    I, J:          Integer;  (* Zhlervariablen                         *)
    Eing_Quelle:   Char;     (* Single Char fr div. Abfragen           *)
    E_File:        Boolean;  (* true, wenn vom File gelesen werden soll *)

Begin (* Eingabe *)
      EingabeOK := true;
      Write ('Eingabe von File oder von Tastatur (F/T): ');
      Readln (Eing_Quelle);
      If (Eing_Quelle in (.'F','f'.)) then E_File := true
                                      else E_File := false;
      If E_File then Begin Repeat Write ('Eingabefilename:                          ');
                                  Readln (Eing_Filenam);
                                  Writeln;
                                  Assign (Eing_File, Eing_Filenam);
                                  (*$I-*) Reset (Eing_File);(*$I+*)
                           Until (IOResult = 0);
                           Readln (Eing_File,Dim);
                           If Dim > MaxN then Begin Writeln ('Dimension des Gleichungssystems zu gro');
                                                    EingabeOK := false;
                                                    Delay (10000);
                                              End;
                     End
                else Begin Repeat Write ('Dimension des Gleichungssystems:          ');
                                  Readln (Nbr);
                                  Writeln;
                           Until Nbr <= MaxN;
                     End;
      For I := 1 to Dim do
          Begin For J := 1 to Dim do If E_File then Read (Eing_File,Matrix (.I,J.))
                                               else Begin Write ('A [',I:1,',',J:1,'] = ');
                                                          Readln (Matrix (.I,J.));
                                                    End;
                If E_File then Readln (Eing_File, LSpalte (.I.))
                          else Begin Write ('B [',I:1,'] = ');
                                     Readln (LSpalte (.I.));
                                     Writeln;
                               End;
          End;
      If E_File then Close (Eing_File);
End;  (* Eingabe *)

Begin (* Lingl *)
      ClrScr;
      Eingabe (Koeffmat, Rechte, Dim, OK);
      ClrScr;
      If OK then
         Begin Koeffmat2 := Koeffmat;
               Rechte2 := Rechte;
                             (* sichern der ursprnglichen Daten fr sptere *)
                             (* Verwendung                                   *)
               Gauss_Init (Steuer,Dim);
               Writeln ('Eingegebenes Gleichungssystem');
               Gauss_Druck (Koeffmat, Rechte, Steuer, Dim);
               Writeln;
                             (* Ausgabe der ursprnglichen Matrix                *)
               Gauss_Elim  (Koeffmat, Rechte, Steuer, Dim, OK);
                             (* berechnen eines ersten Ergebnisses               *)
               If OK then    (* nur, wenn Elimination ordnungsgem              *)
                  Begin Writeln ('Gleichungssystem nach der Elimination:');
                        Gauss_Druck (Koeffmat, Rechte, Steuer, Dim);
                             (* Rcktransformation des Systems                   *)
                        Gauss_Rueck (Koeffmat, Rechte, Steuer, Dim, OK, X);
                        Writeln;
                        Writeln ('Ergebnis unmittelbar nach Gleichungslsung');
                        Writeln;
                        Writeln ('Ergebnisvektor:');
                        Writeln;
                        For I := 1 to Dim do Writeln ('X',I:1,' = ',X (.I.));
                             (* Berechnung des Defekts mit ursprnglicher        *)
                             (* Koeffizientenmatrix                              *)
                        Gauss_Defekt (Koeffmat2, Rechte2, Steuer, Dim, X, Differenz);
                             (* Ausgabe des Defekts                              *)
                        Writeln;
                        Writeln ('Defekt:');
                        Writeln;
                        For I := 1 to Dim do Writeln ('Defekt',I:1,' = ',Differenz (.I.));
                             (* Aufbau eines neuen Gleichungssystems mit Fehlern *)
                             (* als rechter Seite und Berechnung desselben       *)
                             (* Elimination nicht mehr ntig, da sich die        *)
                             (* Koeffizientenmatrix nicht gendert hat           *)
                        Gauss_neue_Rechte (Koeffmat, Differenz, Steuer, Dim);
                             (* Ruecktransformation -> DeltaX                    *)
                        Gauss_Rueck (Koeffmat, Differenz, Steuer, Dim, OK, DeltaX);
                        Writeln;
                        Writeln ('Fehler des Ergebnisvektors:');
                        Writeln;
                        For I := 1 to Dim do Begin Writeln ('DeltaX',I:1,' = ',DeltaX (.I.));
                                                   X(.I.) := X(.I.) + DeltaX (.I.);
                                             End;
                        Writeln;
                        Writeln;
                        Writeln ('Weiter mit Return');
                        Read (Dummy);
                        Writeln ('Ergebnis nach 1 Iteration:');
                        Writeln;
                        For I := 1 to Dim do Writeln ('X',I:1,' = ',X (.I.));
                        Gauss_Defekt (Koeffmat2, Rechte2, Steuer, Dim, X, Differenz);
                        Writeln;
                        Writeln ('Defekt:');
                        Writeln;
                        For I := 1 to Dim do Writeln ('Defekt',I:1,' = ',Differenz (.I.));
                        Gauss_neue_Rechte (Koeffmat, Differenz, Steuer, Dim);
                        Gauss_Rueck (Koeffmat, Differenz, Steuer, Dim, OK, DeltaX);
                        Writeln;
                        Writeln ('Fehler des Ergebnisvektors');
                        Writeln;
                        For I := 1 to Dim do Writeln ('DeltaX',I:1,' = ',DeltaX (.I.));
                        Writeln;
                        Writeln ('Weiter mit Return');
                        Read (Dummy);
                  End
               else Begin Writeln;
                          Writeln ('Fehler: singulre Matrix');
                          Writeln;
                          Writeln ('Berechnung abgebrochen');
                    End;
         End;
End.  (* Lingl *)