
/* eprom.c */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

#define BUF_S 2048    /* Die Datei wird in 4k-Portionen bearbeitet */
#define BUF_0 BUF_S/2 /* Die Datei wird in 4k-Portionen bearbeitet */

FILE *fs,*f0,*f1;
char BufferS [BUF_S];
char Buffer0 [BUF_0];
char Buffer1 [BUF_0];


char DateiS [50]; /* Dateiname ohne Pfadangabe */
char Datei0 [50]; /* Dateiname ohne Pfadangabe */
char Datei1 [50]; /* Dateiname ohne Pfadangabe */



void Namenbildung (char *Name)
{
  int i;
  
  if (Name[0]==0)
  {
    printf ("Kein Dateiname angegeben\n");
    exit (0);
  }
  if (strlen(Name)>8)
  {
    printf ("Dateiname zu lang\n");
    exit (0);
  }
  for (i=0;i<strlen(Name);i++)
    if (!( isalnum (Name[i]) || (Name[i]=='_') || (Name[i]=='-')))
    {
      printf ("%c ist nicht erlaubt\n",Name[i]);
      exit (0);
    }
  strcpy (DateiS,Name);
  strcpy (Datei0,Name);
  strcpy (Datei1,Name);
  strcat (DateiS,".08");
  strcat (Datei0,".160");
  strcat (Datei1,".161");
}



void spalt ()
{
  unsigned gelesen,gelesen0,gelesen1,i;
  unsigned long anzahl,anzahl0,anzahl1;
  unsigned long summe,summe0,summe1;
  
  fs=fopen (DateiS,"rb");
  if (fs==0) 
  {
    printf ("Datei %s nicht gefunden \n",DateiS);
    exit (0);
  }

  f0=fopen (Datei0,"wb");
  if (f0==0) 
  {
    printf ("Datei %s kann nicht erffnet werden \n",Datei0);
    exit (0);
  }
  
  f1=fopen (Datei1,"wb");
  if (f1==0) 
  {
    printf ("Datei %s kann nicht erffnet werden \n",Datei1);
    exit (0);
  }

  anzahl=0;anzahl0=0;anzahl1=0;
  summe=0;summe0=0;summe1=0;
  while ((gelesen=(unsigned)fread (BufferS,1,BUF_S,fs))!=0) /* Jeweils 1 k wird aus der Datei gelesen */
  {
    i=0;
    while (i<gelesen)
    {
      Buffer0[i/2]=BufferS[i];
      summe0=summe0+(unsigned long)BufferS[i];
      summe=summe+(unsigned long)BufferS[i];
      i++;
      Buffer1[i/2]=BufferS[i];
      summe1=summe1+(unsigned long)BufferS[i];
      summe=summe+(unsigned long)BufferS[i];
      i++;
    }
    gelesen0=(gelesen/2)+(((gelesen%2)==0)?0:1); 
    gelesen1=(gelesen/2); 
    anzahl=anzahl+(unsigned long)gelesen;
    anzahl0=anzahl0+(unsigned long)gelesen0;
    anzahl1=anzahl1+(unsigned long)gelesen1;
    fwrite (Buffer0,1,gelesen0,f0); 
    fwrite (Buffer1,1,gelesen1,f1); 
  }
  printf ("%17s = %17s + %17s : Dateinamen \n",DateiS,Datei0,Datei1);
  printf ("%7lu(%8lx) = %7lu(%8lx) + %7lu(%8lx) : Byteanzahl dez(hex)\n",
          anzahl,anzahl,anzahl0,anzahl0,anzahl1,anzahl1);
  printf ("%7lu(%8lx) = %7lu(%8lx) + %7lu(%8lx) : Prfsummen dez(hex)\n",
          summe,summe,summe0,summe0,summe1,summe1);

  if (fs) fclose (fs);
  if (f0) fclose (f0);
  if (f1) fclose (f1);
}




void kombi ()
{
  unsigned gelesen0,gelesen1,i;
  unsigned long anzahl,anzahl0,anzahl1;
  unsigned long summe,summe0,summe1;
  
  f0=fopen (Datei0,"rb");
  if (f0==0) 
  {
    printf ("Datei %s nicht gefunden \n",Datei0);
    exit (0);
  }

  f1=fopen (Datei1,"rb");
  if (f1==0) 
  {
    printf ("Datei %s nicht gefunden \n",Datei1);
    exit (0);
  }

  fs=fopen (DateiS,"wb");
  if (fs==0) 
  {
    printf ("Datei %s kann nicht erffnet werden \n",Datei0);
    exit (0);
  }
  
  
  anzahl=0;anzahl0=0;anzahl1=0;
  summe=0;summe0=0;summe1=0;
  while ((gelesen0=(unsigned)fread (Buffer0,1,BUF_0,f0))!=0)
  {
    gelesen1=fread (Buffer1,1,BUF_0,f1);
    
    if ( abs ((gelesen0-gelesen1)<2) )
    {
      i=0;
      while (i<gelesen0)
      {
        BufferS[2*i]=Buffer0[i];
        summe=summe+(unsigned long)Buffer0[i];
        summe0=summe0+(unsigned long)Buffer0[i];
        if (i<gelesen1) 
        {
          BufferS[2*i+1]=Buffer1[i];
          summe=summe+(unsigned long)Buffer1[i];
          summe1=summe1+(unsigned long)Buffer1[i];
        }
        i++;
      }
      fwrite (BufferS,1,gelesen0+gelesen1,fs); 
      anzahl=anzahl+(unsigned long)gelesen0+(unsigned long)gelesen1;
      anzahl0=anzahl0+(unsigned long)gelesen0;
      anzahl1=anzahl1+(unsigned long)gelesen1;
    }
    else
    {
      printf ("Dateien %s und %s sind verschieden lang!\n",Datei0,Datei1);
      exit (0);
    }
  }
  printf ("%15s + %15s = %15s : Dateinamen\n",Datei0,Datei1,DateiS);
  printf ("%7lu(%6lx) + %7lu(%6lx) = %7lu(%6lx) : Byteanzahl dez(hex)\n",
          anzahl0,anzahl0,anzahl1,anzahl1,anzahl,anzahl);
  printf ("%7lu(%6lx) + %7lu(%6lx) = %7lu(%6lx) : Prfsummen dez(hex)\n",
          summe0,summe0,summe1,summe1,summe,summe);

  if (fs) fclose (fs);
  if (f0) fclose (f0);
  if (f1) fclose (f1);
}

void Hilfe ()
{
  printf ("\nAufspaltung einer Datei 'name.08' in zwei Dateien, \n");
  printf ("mit den geraden Adressen 'name.160' \n");
  printf ("und ungeraden Adressen 'name.161' \n");
  printf ("'ERPOM -2 name'  : name.08 -> name.160 + name.161\n");
  printf ("\nVereinigung zweier Dateien \n");
  printf ("'name.160' mit den geraden Adressen und \n");
  printf ("'name.161' mit den ungeraden Adressen zu \n");
  printf ("einer Datei 'name.08' \n");
  printf ("'ERPOM -1 name'  : name.160 + name.161 -> name.08\n");
}


void main (int argc,char *argv[])
{
  printf ("\nBINRDATEIEN fr 8/16-Bit Bus SPLITEN/KOMBINIEREN\n");
  printf ("=================================================\n");
  
  switch (argc)
  {
    case 1:
      printf ("Zuwenig Argumente\n");
      goto Fehler;
    case 2:
      if ( (argv[1][0]=='-') && (toupper (argv[1][1])=='H') )
      {
        Hilfe ();
        break;
      }
      else
      {
        printf ("Falsche Option %s, zuwenig Argumente\n");
        goto Fehler;
      }
    case 3:
      if (argv[1][0]=='-') /* Option angegeben */
      switch (toupper (argv[1][1]))
      {
        case 'H': Hilfe ();
                  break;
        case '1': Namenbildung (argv[2]);
                  kombi ();
                  break;
        case '2': Namenbildung (argv[2]);
                  spalt ();
                  break;
        default:  printf ("Falsche Option \n");
                  goto Fehler;
      }
      break;
    default:
      printf ("Zuviele Argumente\n");
    Fehler:
      printf ("EPROM -{h12} name     -h..Hilfe, -1 kombi, -2 spalt\n");
      break;;
  }
}

